/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import b.a.lb;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final ValuesList d;
    private final ConditionChecker c;
    private final FilteringTaskCallback a;
    private volatile boolean b;
    private static final long e = lb.a(5588214544037557801L, -6406614706973077343L, MethodHandles.lookup().lookupClass()).a(106536471210452L);

    public FilteringTask(@NotNull String className, @NotNull DebugProcessImpl debugProcess, @NotNull XExpression expression, @NotNull ValuesList values, @NotNull FilteringTaskCallback callback) {
        if (className == null) {
            FilteringTask.a(0);
        }
        if (debugProcess == null) {
            FilteringTask.a(1);
        }
        if (expression == null) {
            FilteringTask.a(2);
        }
        if (values == null) {
            FilteringTask.a(3);
        }
        if (callback == null) {
            FilteringTask.a(4);
        }
        this.b = false;
        this.c = StringUtil.isEmptyOrSpaces((String)expression.getExpression()) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcess, expression, className);
        this.d = values;
        this.a = callback;
    }

    public void cancel() {
        this.b = true;
    }

    public boolean isCancelled() {
        return this.b;
    }

    @Override
    public void run() {
        Object object;
        int n2;
        this.a.started(this.d.size());
        for (n2 = 0; n2 < this.d.size() && !this.b; ++n2) {
            object = this.d.get(n2);
            CheckingResult checkingResult = this.c.check((Value)object);
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            switch (checkingResult.getResult()) {
                case MATCH: {
                    action = this.a.matched((Value)object);
                    break;
                }
                case NO_MATCH: {
                    action = this.a.notMatched((Value)object);
                    break;
                }
                case ERROR: {
                    action = this.a.error((Value)object, checkingResult.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        object = this.b ? FilteringResult.INTERRUPTED : (n2 == this.d.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.a.completed((FilteringResult)((Object)object));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = e ^ 0x4DDD2DC4795CL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/memory/filtering/FilteringTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ValuesList {
        public int size();

        public Value get(int var1);
    }
}

