/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import b.a.lb;
import com.intellij.Patches;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.attach.SAJDWPRemoteConnection;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StringReferenceProxy;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger E;
    private final DebugProcessImpl l;
    private final VirtualMachine D;
    private int k;
    private int G;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> i;
    private final Map<String, StringReference> e;
    @NotNull
    private final Map<ThreadReference, ThreadReferenceProxyImpl> s;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> u;
    private boolean t;
    private List<ReferenceType> a;
    private Map<ReferenceType, List<ReferenceType>> r;
    public final Throwable mySuspendLogger;
    private final boolean m;
    private final boolean q;
    private final Capability h;
    private final Capability o;
    private final Capability w;
    private final Capability x;
    private final Capability F;
    private final Capability b;
    private final Capability p;
    private final Capability z;
    private final Capability n;
    private final Capability g;
    private final Capability c;
    private final Capability B;
    private final Capability H;
    private final Capability j;
    private final Capability C;
    private final Capability f;
    private final Capability A;
    private final Capability v;
    private final Capability d;
    private final Capability y;
    private static final long I;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcess, @NotNull VirtualMachine virtualMachine) {
        long l2 = I ^ 0xB77C9FEA50CL;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(0);
        }
        this.k = 0;
        this.G = 0;
        this.i = new HashMap<ObjectReference, ObjectReferenceProxyImpl>();
        this.e = new HashMap<String, StringReference>();
        this.s = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
        this.u = new HashMap<ThreadGroupReference, ThreadGroupReferenceProxyImpl>();
        this.t = true;
        this.r = new HashMap<ReferenceType, List<ReferenceType>>();
        this.mySuspendLogger = new Throwable();
        this.h = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canWatchFieldModification();
            }
        };
        this.o = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canWatchFieldAccess();
            }
        };
        this.w = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.isJ2ME();
            }
        };
        this.x = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetBytecodes();
            }
        };
        this.F = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetConstantPool();
            }
        };
        this.b = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetSyntheticAttribute();
            }
        };
        this.p = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetOwnedMonitorInfo();
            }
        };
        this.z = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetMonitorFrameInfo();
            }
        };
        this.n = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetCurrentContendedMonitor();
            }
        };
        this.g = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canGetMonitorInfo();
            }
        };
        this.c = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canUseInstanceFilters();
            }
        };
        this.B = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canRedefineClasses();
            }
        };
        this.H = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canAddMethod();
            }
        };
        this.j = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canUnrestrictedlyRedefineClasses();
            }
        };
        this.C = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canPopFrames();
            }
        };
        this.f = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.D.canForceEarlyReturn();
            }
        };
        this.A = new Capability(){
            private static final long b = lb.a(-427285352187747875L, 8739250787925242910L, MethodHandles.lookup().lookupClass()).a(42002400355557L);

            @Override
            protected boolean calcValue() {
                long l2 = b ^ 0x3058AA95A1BL;
                if (!VirtualMachineProxyImpl.this.m) {
                    return false;
                }
                try {
                    Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                    return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.D, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    E.error((Throwable)reflectiveOperationException);
                }
                return false;
            }
        };
        this.v = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canGetSourceDebugExtension();
            }
        };
        this.d = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.q && VirtualMachineProxyImpl.this.D.canRequestVMDeathEvent();
            }
        };
        this.y = new Capability(){
            private static final long b = lb.a(987210342315892566L, -7248968948072530729L, MethodHandles.lookup().lookupClass()).a(26540507236634L);

            @Override
            protected boolean calcValue() {
                long l2 = b ^ 0x36D3E9216D51L;
                if (VirtualMachineProxyImpl.this.m) {
                    try {
                        Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                        Boolean bl2 = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.D, new Object[0]);
                        return bl2;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        this.D = virtualMachine;
        this.l = debugProcess;
        this.m = DebuggerUtils.isAndroidVM((VirtualMachine)this.D) || this.versionHigher("1.5");
        this.q = this.m || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        if (this.canBeModified()) {
            try {
                virtualMachine.allClasses();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw vMDisconnectedException;
            }
            catch (Throwable throwable) {
                E.info(throwable);
            }
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    @NotNull
    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = this.D;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(1);
        }
        return virtualMachine;
    }

    public ClassesByNameProvider getClassesByNameProvider() {
        return this::classesByName;
    }

    public List<ReferenceType> classesByName(@NotNull String s2) {
        if (s2 == null) {
            VirtualMachineProxyImpl.a(2);
        }
        return this.D.classesByName(s2);
    }

    public List<ReferenceType> nestedTypes(ReferenceType refType) {
        List<Object> list2 = this.r.get(refType);
        if (list2 == null) {
            List<Object> list3 = Collections.emptyList();
            try {
                list3 = refType.nestedTypes();
            }
            catch (Throwable throwable) {
                E.info(throwable);
            }
            if (!list3.isEmpty()) {
                HashSet<Object> hashSet = new HashSet<Object>();
                ClassLoaderReference classLoaderReference = refType.classLoader();
                for (Object object : list3) {
                    try {
                        if (!(classLoaderReference == null ? object.classLoader() == null : classLoaderReference.equals(object.classLoader()))) continue;
                        hashSet.add(object);
                    }
                    catch (ObjectCollectedException objectCollectedException) {}
                }
                if (!hashSet.isEmpty()) {
                    HashSet hashSet2 = new HashSet();
                    for (ReferenceType referenceType : hashSet) {
                        hashSet2.addAll(this.nestedTypes(referenceType));
                    }
                    hashSet.removeAll(hashSet2);
                }
                list2 = hashSet.isEmpty() ? Collections.emptyList() : new ArrayList(hashSet);
            } else {
                list2 = Collections.emptyList();
            }
            this.r.put(refType, list2);
        }
        return list2;
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> list2 = this.a;
        if (list2 == null) {
            this.a = list2 = this.D.allClasses();
        }
        return list2;
    }

    public String toString() {
        return this.D.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.D.redefineClasses(map2);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.t) {
            this.t = false;
            for (ThreadReference threadReference : this.D.allThreads()) {
                this.getThreadReferenceProxy(threadReference);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.s.values());
    }

    public void threadStarted(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.getThreadReferenceProxy(thread);
    }

    public void threadStopped(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.s.remove(thread);
    }

    public void suspend() {
        if (!this.canBeModified()) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.G;
        this.D.suspend();
        this.clearCaches();
    }

    public void resume() {
        long l2 = I ^ 0x52D39387EDDBL;
        if (!this.canBeModified()) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.G > 0) {
            --this.G;
        }
        this.clearCaches();
        E.debug("before resume VM");
        try {
            this.D.resume();
        }
        catch (InternalException internalException) {
            E.info((Throwable)internalException);
        }
        E.debug("VM resumed");
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        return StreamEx.of(this.getVirtualMachine().topLevelThreadGroups()).map(this::getThreadGroupReferenceProxy).toList();
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.u.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
    }

    public boolean isJ2ME() {
        return VirtualMachineProxyImpl.a(this.getVirtualMachine());
    }

    private static boolean a(VirtualMachine virtualMachine) {
        long l2 = I ^ 0x3691051BBC93L;
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.u.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.D.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.D.eventRequestManager();
    }

    @Deprecated
    public VoidValue mirrorOf() throws EvaluateException {
        return this.mirrorOfVoid();
    }

    public VoidValue mirrorOfVoid() {
        return this.D.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean b10) {
        return this.D.mirrorOf(b10);
    }

    public ByteValue mirrorOf(byte b10) {
        return this.D.mirrorOf(b10);
    }

    public CharValue mirrorOf(char c10) {
        return this.D.mirrorOf(c10);
    }

    public ShortValue mirrorOf(short i10) {
        return this.D.mirrorOf(i10);
    }

    public IntegerValue mirrorOf(int i10) {
        return this.D.mirrorOf(i10);
    }

    public LongValue mirrorOf(long l2) {
        return this.D.mirrorOf(l2);
    }

    public FloatValue mirrorOf(float v2) {
        return this.D.mirrorOf(v2);
    }

    public DoubleValue mirrorOf(double v2) {
        return this.D.mirrorOf(v2);
    }

    public StringReference mirrorOf(String s2) {
        return this.D.mirrorOf(s2);
    }

    public StringReference mirrorOfStringLiteral(String s2, ThrowableComputable<StringReference, EvaluateException> generator) throws EvaluateException {
        StringReference stringReference = this.e.get(s2);
        if (stringReference != null && !stringReference.isCollected()) {
            return stringReference;
        }
        stringReference = (StringReference)generator.compute();
        this.e.put(s2, stringReference);
        return stringReference;
    }

    public Process process() {
        return this.D.process();
    }

    public void dispose() {
        long l2 = I ^ 0x37AA01223FD9L;
        try {
            this.D.dispose();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            E.info((Throwable)unsupportedOperationException);
        }
        finally {
            Thread thread;
            Object object;
            if (Patches.JDK_BUG_EVENT_CONTROLLER_LEAK && (object = ReflectionUtil.getField(this.D.getClass(), (Object)this.D, null, (String)"target")) != null && (thread = (Thread)ReflectionUtil.getField(object.getClass(), (Object)object, Thread.class, (String)"eventController")) != null) {
                thread.stop();
            }
        }
    }

    public void exit(int i10) {
        this.D.exit(i10);
    }

    public boolean canWatchFieldModification() {
        return this.h.isAvailable();
    }

    public boolean canWatchFieldAccess() {
        return this.o.isAvailable();
    }

    public boolean canInvokeMethods() {
        return !this.w.isAvailable();
    }

    public boolean canGetBytecodes() {
        return this.x.isAvailable();
    }

    public boolean canGetConstantPool() {
        return this.F.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.b.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.p.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.z.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.n.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.g.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.c.isAvailable();
    }

    public boolean canRedefineClasses() {
        return this.B.isAvailable();
    }

    public boolean canAddMethod() {
        return this.H.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.j.isAvailable();
    }

    public boolean canPopFrames() {
        return this.C.isAvailable();
    }

    public boolean canForceEarlyReturn() {
        return this.f.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.A.isAvailable();
    }

    public boolean canBeModified() {
        return !(this.l.getConnection() instanceof SAJDWPRemoteConnection) && this.D.canBeModified();
    }

    public final boolean versionHigher(String version) {
        return this.D.version().compareTo(version) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.v.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.d.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.y.isAvailable();
    }

    public String getDefaultStratum() {
        return this.q ? this.D.getDefaultStratum() : null;
    }

    public String description() {
        return this.D.description();
    }

    public String version() {
        return this.D.version();
    }

    public String name() {
        return this.D.name();
    }

    public void setDebugTraceMode(int i10) {
        this.D.setDebugTraceMode(i10);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread == null) {
            return null;
        }
        return this.s.computeIfAbsent(thread, threadReference -> new ThreadReferenceProxyImpl(this, (ThreadReference)threadReference));
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference group2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (group2 == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = this.u.get(group2);
        if (threadGroupReferenceProxyImpl == null && !this.w.isAvailable()) {
            threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, group2);
            this.u.put(group2, threadGroupReferenceProxyImpl);
        }
        return threadGroupReferenceProxyImpl;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                return this.getThreadReferenceProxy((ThreadReference)objectReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                return this.getThreadGroupReferenceProxy((ThreadGroupReference)objectReference);
            }
            ObjectReferenceProxyImpl objectReferenceProxyImpl = this.i.get(objectReference);
            if (objectReferenceProxyImpl == null) {
                objectReferenceProxyImpl = objectReference instanceof StringReference ? new StringReferenceProxy(this, (StringReference)objectReference) : new ObjectReferenceProxyImpl(this, objectReference);
                this.i.put(objectReference, objectReferenceProxyImpl);
            }
            return objectReferenceProxyImpl;
        }
        return null;
    }

    public boolean equals(Object obj) {
        E.assertTrue(obj instanceof VirtualMachineProxyImpl);
        return this.D.equals(((VirtualMachineProxyImpl)obj).getVirtualMachine());
    }

    public int hashCode() {
        return this.D.hashCode();
    }

    public void clearCaches() {
        long l2 = I ^ 0x4C6020E54936L;
        E.debug("VM cleared");
        this.a = null;
        if (!this.r.isEmpty()) {
            this.r = new HashMap<ReferenceType, List<ReferenceType>>(this.r.size());
        }
        ++this.k;
    }

    @Override
    public int getCurrentTime() {
        return this.k;
    }

    public DebugProcess getDebugProcess() {
        return this.l;
    }

    public static boolean isCollected(ObjectReference reference) {
        try {
            return !VirtualMachineProxyImpl.a(reference.virtualMachine()) && reference.isCollected();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            E.info((Throwable)unsupportedOperationException);
            return false;
        }
    }

    public String getResumeStack() {
        return StringUtil.getThrowableText((Throwable)this.mySuspendLogger);
    }

    public boolean isPausePressed() {
        return this.G > 0;
    }

    public boolean isSuspended() {
        return this.allThreads().stream().anyMatch(threadReferenceProxyImpl -> threadReferenceProxyImpl.getSuspendCount() != 0);
    }

    public void logThreads() {
        long l2 = I ^ 0x63C4276A0990L;
        if (E.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl threadReferenceProxyImpl : this.allThreads()) {
                if (threadReferenceProxyImpl.isCollected()) continue;
                E.debug("suspends " + threadReferenceProxyImpl + " " + threadReferenceProxyImpl.getSuspendCount() + " " + threadReferenceProxyImpl.isSuspended());
            }
        }
    }

    static {
        I = lb.a(-103856122152904189L, -1984123363183393884L, MethodHandles.lookup().lookupClass()).a(184736811499322L);
        long l2 = I ^ 0x7B88C959116AL;
        E = Logger.getInstance((String)"#com.intellij.debugger.jdi.VirtualMachineProxyImpl");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = I ^ 0x98AC4FDEA65L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class Capability {
        private ThreeState a = ThreeState.UNSURE;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.a == ThreeState.UNSURE) {
                try {
                    this.a = ThreeState.fromBoolean((boolean)this.calcValue());
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    E.info((Throwable)vMDisconnectedException);
                    this.a = ThreeState.NO;
                }
            }
            return this.a.toBoolean();
        }

        protected abstract boolean calcValue();
    }

    static final class JNITypeParserReflect {
        static final Method typeNameToSignatureMethod;
        private static final long a;

        JNITypeParserReflect() {
        }

        @Nullable
        static String typeNameToSignature(@NotNull String name2) {
            if (name2 == null) {
                JNITypeParserReflect.a(0);
            }
            if (typeNameToSignatureMethod != null) {
                try {
                    return (String)typeNameToSignatureMethod.invoke(null, name2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            a = lb.a(8612837358406933558L, -7852504794290143882L, MethodHandles.lookup().lookupClass()).a(257389688265489L);
            long l2 = a ^ 0x4F6F67FD02C0L;
            Method method = null;
            try {
                method = ReflectionUtil.getDeclaredMethod(Class.forName("com.sun.tools.jdi.JNITypeParser"), (String)"typeNameToSignature", (Class[])new Class[]{String.class});
            }
            catch (ClassNotFoundException classNotFoundException) {
                E.warn((Throwable)classNotFoundException);
            }
            typeNameToSignatureMethod = method;
            if (typeNameToSignatureMethod == null) {
                E.warn("Unable to find JNITypeParser.typeNameToSignature method");
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0xC0BB7C5032EL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/jdi/VirtualMachineProxyImpl$JNITypeParserReflect", "typeNameToSignature"));
        }
    }
}

