/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HotSwapManager {
    private final Map<DebuggerSession, Long> c = new HashMap<DebuggerSession, Long>();
    private static final String b = ".class";
    private final Project a;
    private static final long d = lb.a(2640879807798688081L, 679361936693039029L, MethodHandles.lookup().lookupClass()).a(276721668276827L);

    public HotSwapManager(Project project2, DebuggerManagerEx manager) {
        this.a = project2;
        manager.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session) {
                HotSwapManager.this.c.put(session, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession session) {
                HotSwapManager.this.c.remove(session);
            }
        });
    }

    private long b(DebuggerSession debuggerSession) {
        Long l2 = this.c.get(debuggerSession);
        return l2 != null ? l2 : 0L;
    }

    void setTimeStamp(DebuggerSession session, long tStamp) {
        this.c.put(session, tStamp);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(DebuggerSession session, HotSwapProgress progress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long l2 = this.b(session);
        HashMap<String, HotSwapFile> hashMap = new HashMap<String, HotSwapFile>();
        List list2 = (List)ReadAction.compute(() -> JBIterable.of((Object[])OrderEnumerator.orderEntries((Project)this.a).classes().getRoots()).filterMap(virtualFile -> virtualFile.isDirectory() && !virtualFile.getFileSystem().isReadOnly() ? virtualFile.getPath() : null).toList());
        for (String string : list2) {
            String string2 = FileUtil.toCanonicalPath((String)string);
            HotSwapManager.a(new File(string), string2, string2 + "/", hashMap, progress, l2);
        }
        return hashMap;
    }

    private static boolean a(File file, String string, String string2, Map<String, HotSwapFile> map2, HotSwapProgress hotSwapProgress, long l2) {
        long l3 = d ^ 0x4C2ED6111FD0L;
        if (hotSwapProgress.isCancelled()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (HotSwapManager.a(file2, string + "/" + file2.getName(), string2, map2, hotSwapProgress, l2)) continue;
                return false;
            }
        } else if ((SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)string, (CharSequence)b) : StringUtil.endsWithIgnoreCase((String)string, (String)b)) && file.lastModified() > l2) {
            hotSwapProgress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{string}));
            String string3 = string.substring(string2.length(), string.length() - b.length()).replace('/', '.');
            map2.put(string3, new HotSwapFile(file));
        }
        return true;
    }

    public static HotSwapManager getInstance(Project project2) {
        return (HotSwapManager)project2.getComponent(HotSwapManager.class);
    }

    private void a(DebuggerSession debuggerSession, Map<String, HotSwapFile> map2, HotSwapProgress hotSwapProgress) {
        long l2 = System.currentTimeMillis();
        new ReloadClassesWorker(debuggerSession, hotSwapProgress).reloadClasses(map2);
        if (hotSwapProgress.isCancelled()) {
            debuggerSession.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(debuggerSession, l2);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<? extends DebuggerSession> sessions, Map<String, List<String>> generatedPaths) {
        long l2 = d ^ 0x31665C10CB9L;
        HashMap<DebuggerSession, Map<String, HotSwapFile>> hashMap = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (DebuggerSession object : sessions) {
            arrayList.add(new Pair((Object)object, (Object)HotSwapManager.getInstance(object.getProject()).b(object)));
        }
        for (Map.Entry entry : generatedPaths.entrySet()) {
            File file = new File((String)entry.getKey());
            for (String string : (List)entry.getValue()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)string, (CharSequence)b) : StringUtil.endsWithIgnoreCase((String)string, (String)b))) continue;
                String string2 = string.substring(0, string.length() - b.length()).replace('/', '.');
                HotSwapFile hotSwapFile = new HotSwapFile(new File(file, string));
                long l3 = hotSwapFile.file.lastModified();
                for (Pair pair2 : arrayList) {
                    DebuggerSession debuggerSession2 = (DebuggerSession)pair2.first;
                    if (l3 <= (Long)pair2.second) continue;
                    hashMap.computeIfAbsent(debuggerSession2, debuggerSession -> new HashMap()).put(string2, hotSwapFile);
                }
            }
        }
        return hashMap;
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(List<? extends DebuggerSession> sessions, final HotSwapProgress swapProgress) {
        long l2 = d ^ 0x4AB1ADE98975L;
        final HashMap<DebuggerSession, Map<String, HotSwapFile>> hashMap = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        MultiProcessCommand multiProcessCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(() -> multiProcessCommand.cancel());
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            multiProcessCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    swapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> map2 = HotSwapManager.getInstance(swapProgress.getProject()).scanForModifiedClasses(debuggerSession, swapProgress);
                    if (!map2.isEmpty()) {
                        hashMap.put(debuggerSession, map2);
                    }
                }
            });
        }
        swapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        multiProcessCommand.run();
        if (swapProgress.isCancelled()) {
            for (DebuggerSession debuggerSession : sessions) {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
            return new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        }
        return hashMap;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgress reloadClassesProgress) {
        long l2 = d ^ 0x174249D3EF6CL;
        MultiProcessCommand multiProcessCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(() -> multiProcessCommand.cancel());
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            multiProcessCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).a(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        reloadClassesProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        multiProcessCommand.run();
        ActionsCollector.getInstance().record("Reload Classes", HotSwapManager.class);
    }
}

