/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUtilsImpl
extends DebuggerUtilsEx {
    public static final Key<PsiType> PSI_TYPE_KEY;
    private static final Logger g;
    private static final long i;

    public PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue, StackFrameContext context) throws EvaluateException {
        return DebuggerTreeNodeExpression.substituteThis((PsiElement)expressionWithThis, howToEvaluateThis, howToEvaluateThisValue);
    }

    @Override
    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    @Override
    public DebuggerTreeNode getSelectedNode(DataContext context) {
        return DebuggerAction.getSelectedNode(context);
    }

    public DebuggerContextImpl getDebuggerContext(DataContext context) {
        return DebuggerAction.getDebuggerContext(context);
    }

    public Element writeTextWithImports(TextWithImports text2) {
        long l2 = i ^ 0x52634EB9C42L;
        Element element = new Element("TextWithImports");
        element.setAttribute("text", text2.toExternalForm());
        element.setAttribute("type", text2.getKind() == CodeFragmentKind.EXPRESSION ? "expression" : "code fragment");
        return element;
    }

    public TextWithImports readTextWithImports(Element element) {
        long l2 = i ^ 0x4025387CBACL;
        g.assertTrue("TextWithImports".equals(element.getName()));
        String string = element.getAttributeValue("text");
        if ("expression".equals(element.getAttributeValue("type"))) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string);
        }
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, string);
    }

    public void writeTextWithImports(Element root2, String name2, TextWithImports value) {
        if (value.getKind() == CodeFragmentKind.EXPRESSION) {
            JDOMExternalizerUtil.writeField((Element)root2, (String)name2, (String)value.toExternalForm());
        } else {
            Element element = JDOMExternalizerUtil.writeOption((Element)root2, (String)name2);
            XExpression xExpression = TextWithImportsImpl.toXExpression(value);
            if (xExpression != null) {
                XmlSerializer.serializeInto((Object)new XExpressionState(xExpression), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
            }
        }
    }

    public TextWithImports readTextWithImports(Element root2, String name2) {
        String string = JDOMExternalizerUtil.readField((Element)root2, (String)name2);
        if (string != null) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string);
        }
        Element element = JDOMExternalizerUtil.readOption((Element)root2, (String)name2);
        if (element != null) {
            XExpressionState xExpressionState = new XExpressionState();
            XmlSerializer.deserializeInto((Object)xExpressionState, (Element)element);
            return TextWithImportsImpl.fromXExpression(xExpressionState.toXExpression());
        }
        return null;
    }

    public TextWithImports createExpressionWithImports(String expression) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression);
    }

    public PsiElement getContextElement(StackFrameContext context) {
        return PositionUtil.getContextElement(context);
    }

    @NotNull
    public static Pair<PsiElement, PsiType> getPsiClassAndType(@Nullable String className, Project project2) {
        PsiClass psiClass = null;
        PsiPrimitiveType psiPrimitiveType = null;
        if (!StringUtil.isEmpty((String)className)) {
            PsiPrimitiveType psiPrimitiveType2 = PsiJavaParserFacadeImpl.getPrimitiveType((String)className);
            if (psiPrimitiveType2 != null) {
                psiClass = JavaPsiFacade.getInstance((Project)project2).findClass(psiPrimitiveType2.getBoxedTypeName(), GlobalSearchScope.allScope((Project)project2));
                psiPrimitiveType = psiPrimitiveType2;
            } else {
                psiClass = DebuggerUtilsImpl.findClass((String)className, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
                if (psiClass != null) {
                    psiClass = psiClass.getNavigationElement();
                }
                if (psiClass instanceof PsiCompiledElement) {
                    psiClass = ((PsiCompiledElement)psiClass).getMirror();
                }
                psiPrimitiveType = DebuggerUtilsImpl.getType((String)className, (Project)project2);
            }
            if (psiClass != null) {
                psiClass.putUserData(PSI_TYPE_KEY, (Object)psiPrimitiveType);
            }
        }
        Pair pair2 = Pair.create(psiClass, psiPrimitiveType);
        if (pair2 == null) {
            DebuggerUtilsImpl.b(0);
        }
        return pair2;
    }

    public PsiClass chooseClassDialog(String title, Project project2) {
        TreeClassChooser treeClassChooser = TreeClassChooserFactory.getInstance((Project)project2).createAllProjectScopeChooser(title);
        treeClassChooser.showDialog();
        return treeClassChooser.getSelected();
    }

    public String findAvailableDebugAddress(boolean useSockets) throws ExecutionException {
        long l2 = i ^ 0x703DFB94B125L;
        if (useSockets) {
            int n2;
            try {
                n2 = NetUtils.findAvailableSocketPort();
            }
            catch (IOException iOException) {
                throw new ExecutionException(DebugProcessImpl.processError(iOException));
            }
            return Integer.toString(n2);
        }
        ListeningConnector listeningConnector = (ListeningConnector)DebugProcessImpl.findConnector(false, true);
        try {
            return DebuggerUtilsImpl.a(listeningConnector, "");
        }
        catch (Exception exception) {
            int n3 = 0;
            while (true) {
                try {
                    return DebuggerUtilsImpl.a(listeningConnector, "javadebug_" + (int)(Math.random() * 1000.0));
                }
                catch (Exception exception2) {
                    if (n3++ <= 10) continue;
                    throw new ExecutionException(DebugProcessImpl.processError(exception2));
                }
                break;
            }
        }
    }

    private static String a(ListeningConnector listeningConnector, String string) throws IOException, IllegalConnectorArgumentsException {
        long l2 = i ^ 0x486D0ABA63C7L;
        Map<String, Connector.Argument> map2 = listeningConnector.defaultArguments();
        map2.get("name").setValue(string);
        string = listeningConnector.startListening(map2);
        listeningConnector.stopListening(map2);
        return string;
    }

    public static boolean isRemote(DebugProcess debugProcess) {
        return Boolean.TRUE.equals(debugProcess.getUserData(BatchEvaluator.REMOTE_SESSION_KEY));
    }

    public static <T, E extends Exception> T suppressExceptions(ThrowableComputable<? extends T, ? extends E> supplier, T defaultValue) throws E {
        return DebuggerUtilsImpl.suppressExceptions(supplier, defaultValue, true, null);
    }

    public static <T, E extends Exception> T suppressExceptions(ThrowableComputable<? extends T, ? extends E> supplier, T defaultValue, boolean ignorePCE, Class<E> rethrow) throws E {
        try {
            return (T)supplier.compute();
        }
        catch (ProcessCanceledException processCanceledException) {
            if (!ignorePCE) {
                throw processCanceledException;
            }
        }
        catch (ObjectCollectedException | VMDisconnectedException runtimeException) {
            throw runtimeException;
        }
        catch (InternalException internalException) {
            g.info((Throwable)internalException);
        }
        catch (AssertionError | Exception object) {
            if (rethrow != null && rethrow.isInstance(object)) {
                throw object;
            }
            g.error((Throwable)object);
        }
        return defaultValue;
    }

    public static <T> T runInReadActionWithWriteActionPriorityWithRetries(@NotNull Computable<T> action) {
        if (action == null) {
            DebuggerUtilsImpl.b(1);
        }
        if (ApplicationManagerEx.getApplicationEx().holdsReadLock()) {
            return (T)action.compute();
        }
        Ref ref = Ref.create();
        while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (action == null) {
                DebuggerUtilsImpl.b(4);
            }
            ref.set(action.compute());
        })) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return (T)ref.get();
    }

    public static String getConnectionDisplayName(RemoteConnection connection) {
        long l2 = i ^ 0x6ACCCD748B44L;
        if (connection instanceof PidRemoteConnection) {
            return "pid " + ((PidRemoteConnection)connection).getPid();
        }
        String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
        String string2 = DebuggerBundle.getTransportName((RemoteConnection)connection);
        return DebuggerBundle.message((String)"string.connection", (Object[])new Object[]{string, string2});
    }

    public static boolean instanceOf(@Nullable ReferenceType type, @NotNull ReferenceType superType) {
        if (superType == null) {
            DebuggerUtilsImpl.b(2);
        }
        if (type == null) {
            return false;
        }
        if (superType.equals(type)) {
            return true;
        }
        return DebuggerUtilsImpl.supertypes(type).anyMatch(referenceType2 -> {
            if (superType == null) {
                DebuggerUtilsImpl.b(3);
            }
            return DebuggerUtilsImpl.instanceOf(referenceType2, superType);
        });
    }

    public static Stream<? extends ReferenceType> supertypes(ReferenceType type) {
        if (type instanceof InterfaceType) {
            return ((InterfaceType)type).superinterfaces().stream();
        }
        if (type instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type).superclass()).prepend(((ClassType)type).interfaces());
        }
        return StreamEx.empty();
    }

    static {
        i = lb.a(5677853394917411777L, -3914856786792143388L, MethodHandles.lookup().lookupClass()).a(15161893994498L);
        long l2 = i ^ 0x7C2CADA655BDL;
        PSI_TYPE_KEY = Key.create((String)"PSI_TYPE_KEY");
        g = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsImpl");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x3E898768B34CL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassAndType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriorityWithRetries";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$instanceOf$1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runInReadActionWithWriteActionPriorityWithRetries$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

