/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.NameMapper;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DebuggerManagerImpl
extends DebuggerManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger d;
    public static final String LOCALHOST_ADDRESS_FALLBACK = "127.0.0.1";
    private final Project i;
    private final HashMap<ProcessHandler, DebuggerSession> b;
    private final BreakpointManager a;
    private final List<NameMapper> h;
    private final List<Function<DebugProcess, PositionManager>> g;
    private final EventDispatcher<DebuggerManagerListener> c;
    private final MyDebuggerStateManager e;
    private final DebuggerContextListener f;
    private static final long j;

    public void addClassNameMapper(NameMapper mapper) {
        this.h.add(mapper);
    }

    public void removeClassNameMapper(NameMapper mapper) {
        this.h.remove(mapper);
    }

    public String getVMClassQualifiedName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            DebuggerManagerImpl.a(0);
        }
        for (NameMapper nameMapper : this.h) {
            String string = nameMapper.getQualifiedName(aClass);
            if (string == null) continue;
            return string;
        }
        return aClass.getQualifiedName();
    }

    @Override
    public void addDebuggerManagerListener(DebuggerManagerListener listener) {
        this.c.addListener((EventListener)listener);
    }

    @Override
    public void removeDebuggerManagerListener(DebuggerManagerListener listener) {
        this.c.removeListener((EventListener)listener);
    }

    public DebuggerManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            DebuggerManagerImpl.a(1);
        }
        this.b = new HashMap();
        this.h = ContainerUtil.createLockFreeCopyOnWriteList();
        this.g = new SmartList();
        this.c = EventDispatcher.create(DebuggerManagerListener.class);
        this.e = new MyDebuggerStateManager();
        this.f = new DebuggerContextListener(){
            private static final long a = lb.a(-8793926704892889144L, 7915840941463770440L, MethodHandles.lookup().lookupClass()).a(160407510463168L);

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    1.a(0);
                }
                DebuggerSession debuggerSession = newContext.getDebuggerSession();
                if (event == DebuggerSession.Event.PAUSE && DebuggerManagerImpl.this.e.b != debuggerSession) {
                    DebuggerManagerImpl.this.e.setState(newContext, debuggerSession != null ? debuggerSession.getState() : DebuggerSession.State.DISPOSED, event, null);
                    return;
                }
                if (DebuggerManagerImpl.this.e.b == debuggerSession) {
                    DebuggerManagerImpl.this.e.fireStateChanged(newContext, event);
                }
                if (event == DebuggerSession.Event.ATTACHED) {
                    ((DebuggerManagerListener)DebuggerManagerImpl.this.c.getMulticaster()).sessionAttached(debuggerSession);
                } else if (event == DebuggerSession.Event.DETACHED) {
                    ((DebuggerManagerListener)DebuggerManagerImpl.this.c.getMulticaster()).sessionDetached(debuggerSession);
                } else if (event == DebuggerSession.Event.DISPOSE) {
                    DebuggerManagerImpl.this.a(debuggerSession);
                    if (DebuggerManagerImpl.this.e.b == debuggerSession) {
                        DebuggerManagerImpl.this.e.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.DISPOSE, null);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7FF6A58C041FL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/impl/DebuggerManagerImpl$1", "changeEvent"));
            }
        };
        this.i = project2;
        this.a = new BreakpointManager(this.i, this);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect();
        if (!project2.isDefault()) {
            messageBusConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme scheme) {
                    DebuggerManagerImpl.this.getBreakpointManager().updateBreakpointsUI();
                }
            });
        }
        this.a.addListeners(messageBusConnection);
    }

    @Override
    @Nullable
    public DebuggerSession getSession(DebugProcess process2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSessions().stream().filter(debuggerSession -> process2 == debuggerSession.getProcess()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<DebuggerSession> getSessions() {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.b;
        // MONITORENTER : hashMap
        Collection<DebuggerSession> collection = this.b.values();
        ArrayList<DebuggerSession> arrayList = collection.isEmpty() ? Collections.emptyList() : new ArrayList<DebuggerSession>(collection);
        // MONITOREXIT : hashMap
        if (arrayList != null) return arrayList;
        DebuggerManagerImpl.a(2);
        return arrayList;
    }

    @Nullable
    public Element getState() {
        long l2 = j ^ 0x2B3EE138AF4AL;
        Element element = new Element("state");
        this.a.writeExternal(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DebuggerManagerImpl.a(3);
        }
        this.a.readExternal(state);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.a.writeExternal(element);
    }

    @Deprecated
    public Stream<Function<DebugProcess, PositionManager>> getCustomPositionManagerFactories() {
        return this.g.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DebuggerSession attachVirtualMachine(@NotNull DebugEnvironment environment) throws ExecutionException {
        if (environment == null) {
            DebuggerManagerImpl.a(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessEvents debugProcessEvents = new DebugProcessEvents(this.i);
        DebuggerSession debuggerSession = DebuggerSession.create(debugProcessEvents, environment);
        ExecutionResult executionResult = debuggerSession.getProcess().getExecutionResult();
        if (executionResult == null) {
            return null;
        }
        debuggerSession.getContextManager().addListener(this.f);
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(debuggerSession, debuggerSession.getContextManager().getContext().getSuspendContext()), debuggerSession.getState(), DebuggerSession.Event.CONTEXT, null);
        ProcessHandler processHandler = executionResult.getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.b;
        synchronized (hashMap) {
            this.b.put(processHandler, debuggerSession);
        }
        if (!(processHandler instanceof RemoteDebugProcessHandler)) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                private static final long a = lb.a(1845958230302407267L, 8551542019771842513L, MethodHandles.lookup().lookupClass()).a(136703136491L);

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    ProcessHandler processHandler;
                    DebugProcessImpl debugProcessImpl;
                    long l2 = a ^ 0x345A159E2101L;
                    if (event == null) {
                        3.a(0);
                    }
                    if ((debugProcessImpl = DebuggerManagerImpl.this.getDebugProcess(processHandler = event.getProcessHandler())) != null) {
                        debugProcessImpl.stop(willBeDestroyed && (!(processHandler instanceof KillableColoredProcessHandler) || !((KillableColoredProcessHandler)processHandler).shouldKillProcessSoftly()));
                        if (!DebuggerManagerThreadImpl.isManagerThread()) {
                            if (SwingUtilities.isEventDispatchThread()) {
                                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                                    debugProcessImpl.waitFor(10000L);
                                }, "Waiting For Debugger Response", false, debugProcessImpl.getProject());
                            } else {
                                debugProcessImpl.waitFor(10000L);
                            }
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x6A0AAB8482EDL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$3", "processWillTerminate"));
                }
            });
        }
        ((DebuggerManagerListener)this.c.getMulticaster()).sessionCreated(debuggerSession);
        if (debugProcessEvents.isDetached() || debugProcessEvents.isDetaching()) {
            debuggerSession.dispose();
            return null;
        }
        if (environment.isRemote()) {
            debugProcessEvents.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        return debuggerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcessImpl getDebugProcess(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.b;
        synchronized (hashMap) {
            DebuggerSession debuggerSession = this.b.get(processHandler);
            return debuggerSession != null ? debuggerSession.getProcess() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DebuggerSession getDebugSession(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.b;
        synchronized (hashMap) {
            return this.b.get(processHandler);
        }
    }

    public void addDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess(processHandler);
        if (debugProcessImpl != null) {
            debugProcessImpl.addDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                private static final long a = lb.a(1469551611077249098L, -2943070004416896872L, MethodHandles.lookup().lookupClass()).a(161133516888590L);

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcessImpl;
                    if (event == null) {
                        4.a(0);
                    }
                    if ((debugProcessImpl = DebuggerManagerImpl.this.getDebugProcess(processHandler)) != null) {
                        debugProcessImpl.addDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x492CAE63E20DL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$4", "startNotified"));
                }
            });
        }
    }

    public void removeDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess(processHandler);
        if (debugProcessImpl != null) {
            debugProcessImpl.removeDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                private static final long a = lb.a(-5059658611068478392L, 8938254972318888645L, MethodHandles.lookup().lookupClass()).a(79790098745587L);

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcessImpl;
                    if (event == null) {
                        5.a(0);
                    }
                    if ((debugProcessImpl = DebuggerManagerImpl.this.getDebugProcess(processHandler)) != null) {
                        debugProcessImpl.removeDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x736F486A9A52L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$5", "startNotified"));
                }
            });
        }
    }

    public boolean isDebuggerManagerThread() {
        return DebuggerManagerThreadImpl.isManagerThread();
    }

    @Override
    @NotNull
    public BreakpointManager getBreakpointManager() {
        BreakpointManager breakpointManager = this.a;
        if (breakpointManager == null) {
            DebuggerManagerImpl.a(5);
        }
        return breakpointManager;
    }

    @Override
    @NotNull
    public DebuggerContextImpl getContext() {
        DebuggerContextImpl debuggerContextImpl = this.getContextManager().getContext();
        if (debuggerContextImpl == null) {
            DebuggerManagerImpl.a(6);
        }
        return debuggerContextImpl;
    }

    @Override
    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.e;
        if (myDebuggerStateManager == null) {
            DebuggerManagerImpl.a(7);
        }
        return myDebuggerStateManager;
    }

    public void registerPositionManagerFactory(Function<DebugProcess, PositionManager> factory2) {
        this.g.add(factory2);
    }

    @Deprecated
    public static RemoteConnection createDebugParameters(JavaParameters parameters, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters, debuggerInServerMode, transport, debugPort, checkValidity, true);
    }

    @Deprecated
    public static RemoteConnection createDebugParameters(JavaParameters parameters, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity, boolean addAsyncDebuggerAgent) throws ExecutionException {
        return new RemoteConnectionBuilder(debuggerInServerMode, transport, debugPort).checkValidity(checkValidity).asyncAgent(addAsyncDebuggerAgent).create(parameters);
    }

    public static RemoteConnection createDebugParameters(JavaParameters parameters, GenericDebuggerRunnerSettings settings, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters, settings.LOCAL, settings.getTransport(), settings.getDebugPort(), checkValidity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(DebuggerSession debuggerSession) {
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.b;
        synchronized (hashMap) {
            DebuggerSession debuggerSession2 = this.b.remove(processHandler);
            d.assertTrue(debuggerSession2 != null);
            ((DebuggerManagerListener)this.c.getMulticaster()).sessionRemoved(debuggerSession);
        }
    }

    static {
        j = lb.a(6372105979122325988L, -8002295133135468421L, MethodHandles.lookup().lookupClass()).a(198799596188083L);
        long l2 = j ^ 0x235E61A3E188L;
        d = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerManagerImpl");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x61B122C96B74L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVMClassQualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerSession b;
        private static final long c = lb.a(1138303739365800264L, 70021154640638646L, MethodHandles.lookup().lookupClass()).a(212995710658971L);

        private MyDebuggerStateManager() {
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.b == null ? DebuggerContextImpl.EMPTY_CONTEXT : this.b.getContextManager().getContext();
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.b(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(@NotNull DebuggerContextImpl context, DebuggerSession.State state, DebuggerSession.Event event, String description) {
            if (context == null) {
                MyDebuggerStateManager.b(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.b = context.getDebuggerSession();
            if (this.b != null) {
                this.b.getContextManager().setState(context, state, event, description);
            } else {
                this.fireStateChanged(context, event);
            }
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x566C5D260F7EL;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerManagerImpl$MyDebuggerStateManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerManagerImpl$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

