/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.ContinueException;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.util.Comparing;

public abstract class LoopEvaluator
implements Evaluator {
    private final String b;
    private final Evaluator a;

    public LoopEvaluator(String labelName, Evaluator bodyEvaluator) {
        this.b = labelName;
        this.a = bodyEvaluator != null ? DisableGC.create(bodyEvaluator) : null;
    }

    protected boolean body(EvaluationContextImpl context) throws EvaluateException {
        block4: {
            try {
                this.evaluateBody(context);
            }
            catch (BreakException breakException) {
                if (Comparing.equal((String)breakException.getLabelName(), (String)this.b)) {
                    return true;
                }
                throw breakException;
            }
            catch (ContinueException continueException) {
                if (Comparing.equal((String)continueException.getLabelName(), (String)this.b)) break block4;
                throw continueException;
            }
        }
        return false;
    }

    public String getLabelName() {
        return this.b;
    }

    protected void evaluateBody(EvaluationContextImpl context) throws EvaluateException {
        if (this.a != null) {
            this.a.evaluate(context);
        }
    }
}

