/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class LocalVariableEvaluator
implements Evaluator {
    private static final Logger c;
    private final String f;
    private EvaluationContextImpl d;
    private LocalVariableProxyImpl e;
    private DecompiledLocalVariable a;
    private final boolean b;
    private static final long g;

    LocalVariableEvaluator(String localVariableName, boolean canScanFrames) {
        this.f = localVariableName;
        this.b = canScanFrames;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        long l2 = g ^ 0x4CD6456F00E2L;
        StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.stackframe", (Object[])new Object[0]));
        }
        try {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = null;
            int n2 = -1;
            Object object = null;
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            boolean bl2 = true;
            while (true) {
                int n3;
                try {
                    LocalVariableProxyImpl localVariableProxyImpl = stackFrameProxyImpl.visibleVariableByName(this.f);
                    if (localVariableProxyImpl != null && (bl2 || object.equals(LocalVariableEvaluator.a(stackFrameProxyImpl, this.f, context.getProject(), debugProcessImpl)))) {
                        this.e = localVariableProxyImpl;
                        this.d = context;
                        return stackFrameProxyImpl.getValue(localVariableProxyImpl);
                    }
                }
                catch (EvaluateException evaluateException) {
                    if (!(evaluateException.getCause() instanceof AbsentInformationException)) {
                        throw evaluateException;
                    }
                    try {
                        Map<DecompiledLocalVariable, Value> map2 = LocalVariablesUtil.fetchValues(stackFrameProxyImpl, debugProcessImpl, true);
                        for (Map.Entry<DecompiledLocalVariable, Value> entry : map2.entrySet()) {
                            DecompiledLocalVariable decompiledLocalVariable = entry.getKey();
                            if (!decompiledLocalVariable.getMatchedNames().contains(this.f) && !decompiledLocalVariable.getDefaultName().equals(this.f)) continue;
                            this.a = decompiledLocalVariable;
                            this.d = context;
                            return entry.getValue();
                        }
                    }
                    catch (Exception exception) {
                        c.info((Throwable)exception);
                    }
                }
                if (!this.b || bl2 && (object = LocalVariableEvaluator.a(stackFrameProxyImpl, this.f, context.getProject(), debugProcessImpl)) == null) break;
                if (threadReferenceProxyImpl == null) {
                    threadReferenceProxyImpl = stackFrameProxyImpl.threadProxy();
                    n2 = threadReferenceProxyImpl.frameCount() - 1;
                }
                if ((n3 = stackFrameProxyImpl.getFrameIndex()) >= n2 || (stackFrameProxyImpl = threadReferenceProxyImpl.frame(n3 + 1)) == null) break;
                bl2 = false;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.local.variable.missing", (Object[])new Object[]{this.f}));
        }
        catch (EvaluateException evaluateException) {
            this.e = null;
            this.d = null;
            throw evaluateException;
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if ((this.e != null || this.a != null) && this.d != null) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    StackFrameProxyImpl stackFrameProxyImpl = LocalVariableEvaluator.this.d.getFrameProxy();
                    try {
                        assert (stackFrameProxyImpl != null);
                        if (LocalVariableEvaluator.this.e != null) {
                            stackFrameProxyImpl.setValue(LocalVariableEvaluator.this.e, value);
                        } else {
                            LocalVariablesUtil.setValue(stackFrameProxyImpl.getStackFrame(), LocalVariableEvaluator.this.a.getSlot(), value);
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        c.error((Throwable)evaluateException);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    try {
                        return LocalVariableEvaluator.this.e.getType();
                    }
                    catch (EvaluateException evaluateException) {
                        c.error((Throwable)evaluateException);
                        return null;
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    return new LocalVariableDescriptorImpl(project2, LocalVariableEvaluator.this.e);
                }
            };
        }
        return modifier;
    }

    @Nullable
    private static PsiVariable a(StackFrameProxy stackFrameProxy, String string, Project project2, DebugProcess debugProcess) {
        PsiElement psiElement = ContextUtil.getContextElement(new SimpleStackFrameContext(stackFrameProxy, debugProcess));
        if (psiElement == null) {
            return null;
        }
        return (PsiVariable)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(string, psiElement));
    }

    public String toString() {
        return this.f;
    }

    static {
        g = lb.a(935114755585287743L, 882255523683832919L, MethodHandles.lookup().lookupClass()).a(192362988014292L);
        long l2 = g ^ 0x3EFE9FF6F808L;
        c = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator");
    }
}

