/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

class BinaryExpressionEvaluator
implements Evaluator {
    private static final Logger c;
    private final Evaluator d;
    private final Evaluator e;
    private final IElementType b;
    private final String a;
    private static final long f;

    BinaryExpressionEvaluator(@NotNull Evaluator leftOperand, @NotNull Evaluator rightOperand, @NotNull IElementType opType, String expectedType) {
        if (leftOperand == null) {
            BinaryExpressionEvaluator.a(0);
        }
        if (rightOperand == null) {
            BinaryExpressionEvaluator.a(1);
        }
        if (opType == null) {
            BinaryExpressionEvaluator.a(2);
        }
        this.d = DisableGC.create(leftOperand);
        this.e = DisableGC.create(rightOperand);
        this.b = opType;
        this.a = expectedType;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value value = (Value)this.d.evaluate(context);
        return BinaryExpressionEvaluator.evaluateOperation(value, this.b, this.e, this.a, context);
    }

    static Object evaluateOperation(Value leftResult, IElementType opType, Evaluator rightOperand, String expectedType, EvaluationContextImpl context) throws EvaluateException {
        long l2 = f ^ 0x78CEAC338159L;
        VirtualMachineProxyImpl virtualMachineProxyImpl = context.getDebugProcess().getVirtualMachineProxy();
        if (leftResult instanceof BooleanValue) {
            boolean bl2 = ((PrimitiveValue)leftResult).booleanValue();
            if (opType == JavaTokenType.OROR && bl2) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, true);
            }
            if (opType == JavaTokenType.ANDAND && !bl2) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, false);
            }
        }
        Value value = (Value)rightOperand.evaluate(context);
        if (opType == JavaTokenType.PLUS) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l3 = ((PrimitiveValue)leftResult).longValue();
                long l5 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l3 + l5);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d10 = ((PrimitiveValue)leftResult).doubleValue();
                double d11 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d10 + d11);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c10 = ((CharValue)leftResult).charValue();
                char c11 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c10 + c11);
            }
            if (leftResult instanceof StringReference || value instanceof StringReference) {
                String string = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)leftResult);
                String string2 = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)value);
                return DebuggerUtilsEx.mirrorOfString(string + string2, virtualMachineProxyImpl, context);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"+"}));
        }
        if (opType == JavaTokenType.MINUS) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l6 = ((PrimitiveValue)leftResult).longValue();
                long l7 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l6 - l7);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d12 = ((PrimitiveValue)leftResult).doubleValue();
                double d13 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d12 - d13);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c12 = ((CharValue)leftResult).charValue();
                char c13 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c12 - c13);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"-"}));
        }
        if (opType == JavaTokenType.ASTERISK) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l8 = ((PrimitiveValue)leftResult).longValue();
                long l9 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l8 * l9);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d14 = ((PrimitiveValue)leftResult).doubleValue();
                double d15 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d14 * d15);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c14 = ((CharValue)leftResult).charValue();
                char c15 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c14 * c15);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"*"}));
        }
        if (opType == JavaTokenType.DIV) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l10 = ((PrimitiveValue)leftResult).longValue();
                long l11 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l10 / l11);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d16 = ((PrimitiveValue)leftResult).doubleValue();
                double d17 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d16 / d17);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c16 = ((CharValue)leftResult).charValue();
                char c17 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c16 / c17);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"/"}));
        }
        if (opType == JavaTokenType.PERC) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l12 = ((PrimitiveValue)leftResult).longValue();
                long l13 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l12 % l13);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d18 = ((PrimitiveValue)leftResult).doubleValue();
                double d19 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d18 % d19);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c18 = ((CharValue)leftResult).charValue();
                char c19 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c18 % c19);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"%"}));
        }
        if (opType == JavaTokenType.LTLT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l14 = ((PrimitiveValue)value).longValue();
                if (leftResult instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((ByteValue)leftResult).byteValue() << (int)l14);
                }
                if (leftResult instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((ShortValue)leftResult).shortValue() << (int)l14);
                }
                if (leftResult instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((IntegerValue)leftResult).intValue() << (int)l14);
                }
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((PrimitiveValue)leftResult).longValue() << (int)l14);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((CharValue)leftResult).charValue() << ((CharValue)value).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<<"}));
        }
        if (opType == JavaTokenType.GTGT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l15 = ((PrimitiveValue)value).longValue();
                if (leftResult instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((ByteValue)leftResult).byteValue() >> (int)l15);
                }
                if (leftResult instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((ShortValue)leftResult).shortValue() >> (int)l15);
                }
                if (leftResult instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((IntegerValue)leftResult).intValue() >> (int)l15);
                }
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((PrimitiveValue)leftResult).longValue() >> (int)l15);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((CharValue)leftResult).charValue() >> ((CharValue)value).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">>"}));
        }
        if (opType == JavaTokenType.GTGTGT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l16 = ((PrimitiveValue)value).longValue();
                if (leftResult instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((ByteValue)leftResult).byteValue() >>> (int)l16);
                }
                if (leftResult instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((ShortValue)leftResult).shortValue() >>> (int)l16);
                }
                if (leftResult instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((IntegerValue)leftResult).intValue() >>> (int)l16);
                }
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((PrimitiveValue)leftResult).longValue() >>> (int)l16);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, ((CharValue)leftResult).charValue() >>> ((CharValue)value).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">>>"}));
        }
        if (opType == JavaTokenType.AND) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l17 = ((PrimitiveValue)leftResult).longValue();
                long l18 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l17 & l18);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c20 = ((CharValue)leftResult).charValue();
                char c21 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c20 & c21);
            }
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl3 = ((PrimitiveValue)leftResult).booleanValue();
                boolean bl4 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl3 & bl4);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"&"}));
        }
        if (opType == JavaTokenType.OR) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l19 = ((PrimitiveValue)leftResult).longValue();
                long l20 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l19 | l20);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c22 = ((CharValue)leftResult).charValue();
                char c23 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c22 | c23);
            }
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl5 = ((PrimitiveValue)leftResult).booleanValue();
                boolean bl6 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl5 | bl6);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"|"}));
        }
        if (opType == JavaTokenType.XOR) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l21 = ((PrimitiveValue)leftResult).longValue();
                long l22 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l21 ^ l22);
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c24 = ((CharValue)leftResult).charValue();
                char c25 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c24 ^ c25);
            }
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl7 = ((PrimitiveValue)leftResult).booleanValue();
                boolean bl8 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl7 ^ bl8);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"^"}));
        }
        if (opType == JavaTokenType.EQEQ) {
            if (leftResult == null && value == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, true);
            }
            if (leftResult == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, value.equals(null));
            }
            if (value == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, leftResult.equals(null));
            }
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l23;
                long l24 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l24 == (l23 = ((PrimitiveValue)value).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d20;
                double d21 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d21 == (d20 = ((PrimitiveValue)value).doubleValue()));
            }
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl9;
                boolean bl10 = ((PrimitiveValue)leftResult).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl10 == (bl9 = ((PrimitiveValue)value).booleanValue()));
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c26;
                char c27 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c27 == (c26 = ((CharValue)value).charValue()));
            }
            if (leftResult instanceof ObjectReference && value instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)leftResult;
                ObjectReference objectReference2 = (ObjectReference)value;
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, objectReference.uniqueID() == objectReference2.uniqueID());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"=="}));
        }
        if (opType == JavaTokenType.OROR) {
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl11 = ((PrimitiveValue)leftResult).booleanValue();
                boolean bl12 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl11 || bl12);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"||"}));
        }
        if (opType == JavaTokenType.ANDAND) {
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl13 = ((PrimitiveValue)leftResult).booleanValue();
                boolean bl14 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl13 && bl14);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"&&"}));
        }
        if (opType == JavaTokenType.NE) {
            if (leftResult == null && value == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, false);
            }
            if (leftResult == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, !value.equals(null));
            }
            if (value == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, !leftResult.equals(null));
            }
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l25;
                long l26 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l26 != (l25 = ((PrimitiveValue)value).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d22;
                double d23 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d23 != (d22 = ((PrimitiveValue)value).doubleValue()));
            }
            if (leftResult instanceof BooleanValue && value instanceof BooleanValue) {
                boolean bl15;
                boolean bl16 = ((PrimitiveValue)leftResult).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, bl16 != (bl15 = ((PrimitiveValue)value).booleanValue()));
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c28;
                char c29 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c29 != (c28 = ((CharValue)value).charValue()));
            }
            if (leftResult instanceof ObjectReference && value instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)leftResult;
                ObjectReference objectReference3 = (ObjectReference)value;
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, objectReference.uniqueID() != objectReference3.uniqueID());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"!="}));
        }
        if (opType == JavaTokenType.LT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l27;
                long l28 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l28 < (l27 = ((PrimitiveValue)value).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d24;
                double d25 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d25 < (d24 = ((PrimitiveValue)value).doubleValue()));
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c30;
                char c31 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c31 < (c30 = ((CharValue)value).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<"}));
        }
        if (opType == JavaTokenType.GT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l29;
                long l30 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l30 > (l29 = ((PrimitiveValue)value).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d26;
                double d27 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d27 > (d26 = ((PrimitiveValue)value).doubleValue()));
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c32;
                char c33 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c33 > (c32 = ((CharValue)value).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">"}));
        }
        if (opType == JavaTokenType.LE) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l31;
                long l32 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l32 <= (l31 = ((PrimitiveValue)value).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d28;
                double d29 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d29 <= (d28 = ((PrimitiveValue)value).doubleValue()));
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c34;
                char c35 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c35 <= (c34 = ((CharValue)value).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<="}));
        }
        if (opType == JavaTokenType.GE) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)value)) {
                long l33;
                long l34 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, l34 >= (l33 = ((PrimitiveValue)value).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)value)) {
                double d30;
                double d31 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, d31 >= (d30 = ((PrimitiveValue)value).doubleValue()));
            }
            if (leftResult instanceof CharValue && value instanceof CharValue) {
                char c36;
                char c37 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, expectedType, c37 >= (c36 = ((CharValue)value).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">="}));
        }
        c.assertTrue(false);
        return null;
    }

    static {
        f = lb.a(-8181416869857587372L, -1291654336510544680L, MethodHandles.lookup().lookupClass()).a(272991965417274L);
        long l2 = f ^ 0x16AF2A194248L;
        c = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = f ^ 0x7333F0CE7CDEL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rightOperand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "opType";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/BinaryExpressionEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

