/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.concurrency.JobScheduler;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadBlockedMonitor {
    private static final Logger c;
    private final Collection<ThreadReferenceProxy> a = new HashSet<ThreadReferenceProxy>();
    private ScheduledFuture<?> b;
    private final DebugProcessImpl d;
    private static final long e;

    public ThreadBlockedMonitor(DebugProcessImpl process2, Disposable disposable) {
        this.d = process2;
        Disposer.register((Disposable)disposable, this::a);
    }

    public void startWatching(@Nullable ThreadReferenceProxy thread) {
        long l2 = e ^ 0x2EA137B2D75BL;
        if (!Registry.is((String)"debugger.monitor.blocked.threads")) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.a.add(thread);
            if (this.b == null) {
                this.b = JobScheduler.getScheduler().scheduleWithFixedDelay(this::b, 5L, 5L, TimeUnit.SECONDS);
            }
        }
    }

    public void stopWatching(@Nullable ThreadReferenceProxy thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.a.remove(thread);
        } else {
            this.a.clear();
        }
        if (this.a.isEmpty()) {
            this.a();
        }
    }

    private void a() {
        if (this.b != null) {
            this.b.cancel(true);
            this.b = null;
        }
    }

    private static void a(@NotNull ThreadReference threadReference, final @NotNull ThreadReference threadReference2, final DebugProcessImpl debugProcessImpl) {
        long l2 = e ^ 0x31148FEE101AL;
        if (threadReference == null) {
            ThreadBlockedMonitor.a(0);
        }
        if (threadReference2 == null) {
            ThreadBlockedMonitor.a(1);
        }
        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.thread.blocked.by", (Object[])new Object[]{threadReference.name(), threadReference2.name()}), DebuggerBundle.message((String)"status.thread.blocked.by.resume", (Object[])new Object[]{threadReference2.name()}), NotificationType.INFORMATION, (notification, hyperlinkEvent) -> {
            if (threadReference2 == null) {
                ThreadBlockedMonitor.a(2);
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                notification.expire();
                debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        ThreadReferenceProxyImpl threadReferenceProxyImpl = debugProcessImpl.getVirtualMachineProxy().getThreadReferenceProxy(threadReference2);
                        SuspendContextImpl suspendContextImpl = SuspendManagerUtil.getSuspendingContext(debugProcessImpl.getSuspendManager(), threadReferenceProxyImpl);
                        debugProcessImpl.getManagerThread().invoke(debugProcessImpl.createResumeThreadCommand(suspendContextImpl, threadReferenceProxyImpl));
                    }
                });
            }
        }).notify(debugProcessImpl.getProject());
    }

    private ThreadReference c() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.d.getDebuggerContext().getThreadProxy();
        return threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
    }

    private void b() {
        this.d.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                if (ThreadBlockedMonitor.this.a.isEmpty()) {
                    return;
                }
                VirtualMachineProxyImpl virtualMachineProxyImpl = ThreadBlockedMonitor.this.d.getVirtualMachineProxy();
                virtualMachineProxyImpl.getVirtualMachine().suspend();
                try {
                    for (ThreadReferenceProxy threadReferenceProxy : ThreadBlockedMonitor.this.a) {
                        try {
                            ThreadReference threadReference;
                            ObjectReference objectReference = virtualMachineProxyImpl.canGetCurrentContendedMonitor() ? threadReferenceProxy.getThreadReference().currentContendedMonitor() : null;
                            if (objectReference == null || !virtualMachineProxyImpl.canGetMonitorInfo() || (threadReference = objectReference.owningThread()) == null || threadReference.suspendCount() <= 1 || ThreadBlockedMonitor.this.c() == threadReference) continue;
                            ThreadBlockedMonitor.a(threadReferenceProxy.getThreadReference(), threadReference, ThreadBlockedMonitor.this.d);
                        }
                        catch (ObjectCollectedException objectCollectedException) {}
                    }
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    c.info((Throwable)incompatibleThreadStateException);
                }
                finally {
                    virtualMachineProxyImpl.getVirtualMachine().resume();
                }
            }
        });
    }

    static {
        e = lb.a(-681841172423802753L, 248923231709595794L, MethodHandles.lookup().lookupClass()).a(107097956079321L);
        c = Logger.getInstance(ThreadBlockedMonitor.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x7237DBE19801L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockedThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockingThread";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/ThreadBlockedMonitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onThreadBlocked";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$onThreadBlocked$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

