/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.event.EventSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class SuspendManagerImpl
implements SuspendManager {
    private static final Logger c;
    private final Deque<SuspendContextImpl> e;
    private final Deque<SuspendContextImpl> a;
    private final Set<ThreadReferenceProxyImpl> d;
    private final DebugProcessImpl b;
    public int suspends;
    private static final long f;

    public SuspendManagerImpl(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            SuspendManagerImpl.a(0);
        }
        this.e = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.a = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.d = Collections.synchronizedSet(new HashSet());
        this.suspends = 0;
        this.b = debugProcess;
        this.b.addDebugProcessListener(new DebugProcessAdapterImpl(){

            @Override
            public void processDetached(DebugProcessImpl process2, boolean closedByUser) {
                SuspendManagerImpl.this.e.clear();
                SuspendManagerImpl.this.a.clear();
                SuspendManagerImpl.this.d.clear();
            }
        });
    }

    @Override
    @NotNull
    public SuspendContextImpl pushSuspendContext(int suspendPolicy, int nVotes) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.b, suspendPolicy, nVotes, null){
            private static final long o = lb.a(7722573191244709570L, -8751406882549981126L, MethodHandles.lookup().lookupClass()).a(81082931047862L);

            @Override
            protected void resumeImpl() {
                long l2 = o ^ 0x7982F12831ECL;
                c.debug("Start resuming...");
                SuspendManagerImpl.this.b.logThreads();
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        int n2 = 5;
                        while (--n2 > 0) {
                            try {
                                SuspendManagerImpl.this.b.getVirtualMachineProxy().resume();
                            }
                            catch (InternalException internalException) {
                                if (internalException.errorCode() == 13) continue;
                                c.error((Throwable)internalException);
                            }
                            break;
                        }
                        c.debug("VM resumed ");
                        break;
                    }
                    case 1: {
                        SuspendManagerImpl.this.d.remove(this.getThread());
                        this.getThread().resume();
                        if (!c.isDebugEnabled()) break;
                        c.debug("Thread resumed : " + this.getThread().toString());
                        break;
                    }
                    case 0: {
                        c.debug("None resumed");
                    }
                }
                if (c.isDebugEnabled()) {
                    c.debug("Suspends = " + SuspendManagerImpl.this.suspends);
                }
                SuspendManagerImpl.this.b.logThreads();
            }
        };
        this.b(suspendContextImpl);
        SuspendContextImpl suspendContextImpl2 = suspendContextImpl;
        if (suspendContextImpl2 == null) {
            SuspendManagerImpl.a(1);
        }
        return suspendContextImpl2;
    }

    @Override
    @NotNull
    public SuspendContextImpl pushSuspendContext(final EventSet set) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.b, set.suspendPolicy(), set.size(), set){
            private static final long o = lb.a(-1960573329271161466L, -674730325982340477L, MethodHandles.lookup().lookupClass()).a(253066536915461L);

            @Override
            protected void resumeImpl() {
                long l2 = o ^ 0x4B76DDEC5A83L;
                if (c.isDebugEnabled()) {
                    c.debug("Start resuming eventSet " + set.toString() + " suspendPolicy = " + set.suspendPolicy() + ",size = " + set.size());
                }
                SuspendManagerImpl.this.b.logThreads();
                int n2 = 5;
                while (--n2 > 0) {
                    try {
                        set.resume();
                        break;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        c.info((Throwable)objectCollectedException);
                    }
                    catch (InternalException internalException) {
                        if (internalException.errorCode() == 13 && set.suspendPolicy() == 2) continue;
                        c.error((Throwable)internalException);
                        break;
                    }
                }
                c.debug("Set resumed ");
                SuspendManagerImpl.this.b.logThreads();
            }
        };
        this.b(suspendContextImpl);
        SuspendContextImpl suspendContextImpl2 = suspendContextImpl;
        if (suspendContextImpl2 == null) {
            SuspendManagerImpl.a(2);
        }
        return suspendContextImpl2;
    }

    private void b(SuspendContextImpl suspendContextImpl) {
        long l2 = f ^ 0x19426DA8DEACL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.e.addFirst(suspendContextImpl);
        ++this.suspends;
        if (c.isDebugEnabled()) {
            c.debug("Push context : Suspends = " + this.suspends);
        }
    }

    @Override
    public void resume(SuspendContextImpl context) {
        SuspendManagerUtil.prepareForResume(context);
        this.b.logThreads();
        this.popContext(context);
        context.resume();
        this.b.clearCashes(context.getSuspendPolicy());
    }

    @Override
    public void popFrame(SuspendContextImpl suspendContext) {
        this.popContext(suspendContext);
        SuspendContextImpl suspendContextImpl = this.pushSuspendContext(suspendContext.getSuspendPolicy(), 0);
        suspendContextImpl.setThread(suspendContext.getThread().getThreadReference());
        this.notifyPaused(suspendContextImpl);
    }

    @Override
    public SuspendContextImpl getPausedContext() {
        return this.a.peekFirst();
    }

    public void popContext(SuspendContextImpl suspendContext) {
        long l2 = f ^ 0x9083C3F5146L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        --this.suspends;
        if (c.isDebugEnabled()) {
            c.debug("popContext, suspends = " + this.suspends);
        }
        this.e.remove((Object)suspendContext);
        this.a.remove((Object)suspendContext);
    }

    void pushPausedContext(SuspendContextImpl suspendContext) {
        if (c.isDebugEnabled()) {
            c.assertTrue(this.e.contains((Object)suspendContext));
        }
        this.a.addFirst(suspendContext);
    }

    public boolean hasEventContext(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.e.contains((Object)suspendContext);
    }

    @Override
    public List<SuspendContextImpl> getEventContexts() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new ArrayList<SuspendContextImpl>(this.e);
    }

    @Override
    public boolean isFrozen(ThreadReferenceProxyImpl thread) {
        return this.d.contains(thread);
    }

    @Override
    public boolean isSuspended(ThreadReferenceProxyImpl thread) throws ObjectCollectedException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean bl2 = this.isFrozen(thread) ? true : this.e.stream().anyMatch(suspendContextImpl -> suspendContextImpl.suspends(thread));
        return bl2 && (thread == null || thread.isSuspended());
    }

    @Override
    public void suspendThread(SuspendContextImpl context, ThreadReferenceProxyImpl thread) {
        long l2 = f ^ 0x1FAA9413BD87L;
        c.assertTrue(thread != context.getThread(), (Object)"Thread is already suspended at the breakpoint");
        if (context.isExplicitlyResumed(thread)) {
            context.myResumedThreads.remove(thread);
            thread.suspend();
        }
    }

    @Override
    public void resumeThread(SuspendContextImpl context, @NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            SuspendManagerImpl.a(3);
        }
        c.assertTrue(!context.isExplicitlyResumed(thread));
        if (context.myResumedThreads == null) {
            context.myResumedThreads = new HashSet<ThreadReferenceProxyImpl>();
        }
        context.myResumedThreads.add(thread);
        thread.resume();
    }

    @Override
    public void freezeThread(ThreadReferenceProxyImpl thread) {
        if (this.d.add(thread)) {
            thread.suspend();
        }
    }

    @Override
    public void unfreezeThread(ThreadReferenceProxyImpl thread) {
        if (this.d.remove(thread)) {
            thread.resume();
        }
    }

    private void c(@NotNull SuspendContextImpl suspendContextImpl) {
        long l2 = f ^ 0x1F72B919373AL;
        if (suspendContextImpl == null) {
            SuspendManagerImpl.a(4);
        }
        c.assertTrue(suspendContextImpl.myVotesToVote > 0);
        --suspendContextImpl.myVotesToVote;
        if (c.isDebugEnabled()) {
            c.debug("myVotesToVote = " + suspendContextImpl.myVotesToVote);
        }
        if (suspendContextImpl.myVotesToVote == 0) {
            if (suspendContextImpl.myIsVotedForResume) {
                this.b.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> {
                    if (suspendContextImpl == null) {
                        SuspendManagerImpl.a(6);
                    }
                    this.resume(suspendContextImpl);
                });
            } else {
                c.debug("vote paused");
                this.b.logThreads();
                this.b.cancelRunToCursorBreakpoint();
                if (!Registry.is((String)"debugger.keep.step.requests")) {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                    this.b.deleteStepRequests(threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null);
                }
                this.notifyPaused(suspendContextImpl);
            }
        }
    }

    public void notifyPaused(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SuspendManagerImpl.a(5);
        }
        this.pushPausedContext(suspendContext);
        ((DebugProcessListener)this.b.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContext);
    }

    @Override
    public void voteResume(SuspendContextImpl suspendContext) {
        long l2 = f ^ 0x24A8760A1CD5L;
        c.debug("Resume voted");
        this.c(suspendContext);
    }

    @Override
    public void voteSuspend(SuspendContextImpl suspendContext) {
        suspendContext.myIsVotedForResume = false;
        this.c(suspendContext);
    }

    public List<SuspendContextImpl> getPausedContexts() {
        return new ArrayList<SuspendContextImpl>(this.a);
    }

    static {
        f = lb.a(-441896515609220064L, 1262904937377476538L, MethodHandles.lookup().lookupClass()).a(73913621141117L);
        long l2 = f ^ 0x6483F6592E9EL;
        c = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManager");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x29F8A6390419L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pushSuspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resumeThread";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processVote";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyPaused";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVote$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

