/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.actions.JumpToObjectAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.frame.XValueWithInlinePresentation;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class JavaValue
extends XNamedValue
implements NodeDescriptorProvider,
XValueTextProvider,
XValueWithInlinePresentation {
    private static final Logger g;
    private final JavaValue d;
    private final ValueDescriptorImpl c;
    private final EvaluationContextImpl b;
    private final NodeManagerImpl f;
    private final boolean a;
    private int e;
    private volatile XExpression h;
    private static final long l;

    protected JavaValue(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            JavaValue.a(0);
        }
        if (evaluationContext == null) {
            JavaValue.a(1);
        }
        this(parent, valueDescriptor.calcValueName(), valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    protected JavaValue(JavaValue parent, String name2, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            JavaValue.a(2);
        }
        if (evaluationContext == null) {
            JavaValue.a(3);
        }
        super(name2);
        this.e = -1;
        this.h = null;
        this.d = parent;
        this.c = valueDescriptor;
        this.b = evaluationContext;
        this.f = nodeManager;
        this.a = contextSet;
    }

    public static JavaValue create(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            JavaValue.a(4);
        }
        if (evaluationContext == null) {
            JavaValue.a(5);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new JavaValue(parent, valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    static JavaValue create(@NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        if (valueDescriptor == null) {
            JavaValue.a(6);
        }
        if (evaluationContext == null) {
            JavaValue.a(7);
        }
        return JavaValue.create(null, valueDescriptor, evaluationContext, nodeManager, false);
    }

    public JavaValue getParent() {
        return this.d;
    }

    @Override
    @NotNull
    public ValueDescriptorImpl getDescriptor() {
        ValueDescriptorImpl valueDescriptorImpl = this.c;
        if (valueDescriptorImpl == null) {
            JavaValue.a(8);
        }
        return valueDescriptorImpl;
    }

    @NotNull
    public EvaluationContextImpl getEvaluationContext() {
        EvaluationContextImpl evaluationContextImpl = this.b;
        if (evaluationContextImpl == null) {
            JavaValue.a(9);
        }
        return evaluationContextImpl;
    }

    public NodeManagerImpl getNodeManager() {
        return this.f;
    }

    private boolean c() {
        return OnDemandRenderer.ON_DEMAND_CALCULATED.isIn((UserDataHolder)this.c);
    }

    private boolean a() {
        return OnDemandRenderer.isCalculated(this.c);
    }

    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        long l2 = l ^ 0x5E8AD2D34362L;
        if (node == null) {
            JavaValue.a(10);
        }
        if (place == null) {
            JavaValue.a(11);
        }
        if (this.c() && !this.a()) {
            node.setFullValueEvaluator(OnDemandRenderer.createFullValueEvaluator(DebuggerBundle.message((String)"message.node.evaluate", (Object[])new Object[0])));
            node.setPresentation(AllIcons.Debugger.Db_watch, (XValuePresentation)new XRegularValuePresentation("", null, ""), false);
            return;
        }
        this.b.getManagerThread().schedule(new SuspendContextCommandImpl(this.b.getSuspendContext()){
            private static final long e = lb.a(-927479022077406857L, -4113660875232660641L, MethodHandles.lookup().lookupClass()).a(17702835954352L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                long l2 = e ^ 0x650DDD0601D7L;
                node.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0])), false);
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.b(0);
                }
                if (node.isObsolete()) {
                    return;
                }
                if (!JavaValue.this.a) {
                    JavaValue.this.c.setContext(JavaValue.this.b);
                }
                JavaValue.this.c.updateRepresentation(JavaValue.this.b, new DescriptorLabelListener(){

                    @Override
                    public void labelChanged() {
                        Icon icon = DebuggerTreeRenderer.getValueIcon(JavaValue.this.c, JavaValue.this.d != null ? JavaValue.this.d.getDescriptor() : null);
                        String string = JavaValue.this.getValueString();
                        EvaluateException evaluateException = JavaValue.this.c.getEvaluateException();
                        JavaValuePresentation javaValuePresentation = new JavaValuePresentation(string, JavaValue.this.c.getIdLabel(), evaluateException != null ? evaluateException.getMessage() : null, JavaValue.this.c);
                        Renderer renderer = JavaValue.this.c.getLastRenderer();
                        boolean bl2 = this.a(renderer);
                        if (!bl2 && renderer instanceof CompoundNodeRenderer) {
                            bl2 = this.a(((CompoundNodeRenderer)renderer).getLabelRenderer());
                        }
                        if (!bl2 && string.length() > 1000) {
                            node.setFullValueEvaluator((XFullValueEvaluator)new JavaFullValueEvaluator(JavaValue.this.b){
                                private static final long a = lb.a(3415743561431984867L, 9135722038684813250L, MethodHandles.lookup().lookupClass()).a(172173015471438L);

                                @Override
                                public void evaluate(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                    if (callback == null) {
                                        1.b(0);
                                    }
                                    final ValueDescriptorImpl valueDescriptorImpl = JavaValue.this.c.getFullValueDescriptor();
                                    valueDescriptorImpl.updateRepresentation(this.myEvaluationContext, new DescriptorLabelListener(){

                                        @Override
                                        public void labelChanged() {
                                            callback.evaluated(valueDescriptorImpl.getValueText());
                                        }
                                    });
                                }

                                private static /* synthetic */ void b(int n2) {
                                    long l2 = a ^ 0x5268BCADF82BL;
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$1$1$1", "evaluate"));
                                }
                            });
                        }
                        node.setPresentation(icon, (XValuePresentation)javaValuePresentation, JavaValue.this.c.isExpandable());
                    }

                    private boolean a(Renderer renderer) {
                        XFullValueEvaluator xFullValueEvaluator;
                        if (renderer instanceof FullValueEvaluatorProvider && (xFullValueEvaluator = ((FullValueEvaluatorProvider)((Object)renderer)).getFullValueEvaluator(JavaValue.this.b, JavaValue.this.c)) != null) {
                            node.setFullValueEvaluator(xFullValueEvaluator);
                            return true;
                        }
                        return false;
                    }
                });
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x3EEE65A2DBFCL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$1", "contextAction"));
            }
        });
    }

    private static String a(@NotNull String string) {
        if (string == null) {
            JavaValue.a(12);
        }
        return string.substring(0, Math.min(string.length(), 1000));
    }

    @NotNull
    String getValueString() {
        String string = this.c.getValueText();
        if (string == null) {
            JavaValue.a(13);
        }
        return string;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaValue.a(14);
        }
        JavaValue.scheduleCommand(this.b, node, new SuspendContextCommandImpl(this.b.getSuspendContext()){
            private static final long e = lb.a(4910239740378421798L, -4900037032960414167L, MethodHandles.lookup().lookupClass()).a(184841205111895L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.b(0);
                }
                JavaValue.this.c.getChildrenRenderer(JavaValue.this.b.getDebugProcess()).buildChildren(JavaValue.this.c.getValue(), new ChildrenBuilder(){
                    private static final long a = lb.a(-4360469655025293290L, 5066276613322384309L, MethodHandles.lookup().lookupClass()).a(97956892943578L);

                    @Override
                    public NodeDescriptorFactory getDescriptorManager() {
                        return JavaValue.this.f;
                    }

                    @Override
                    public NodeManager getNodeManager() {
                        return JavaValue.this.f;
                    }

                    @Override
                    public ValueDescriptor getParentDescriptor() {
                        return JavaValue.this.c;
                    }

                    @Override
                    public void initChildrenArrayRenderer(ArrayRenderer renderer, int arrayLength) {
                        renderer.START_INDEX = 0;
                        if (JavaValue.this.e >= 0) {
                            renderer.START_INDEX = Math.max(0, arrayLength - JavaValue.this.e);
                        }
                    }

                    @Override
                    public void addChildren(List<DebuggerTreeNode> nodes, boolean last) {
                        XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
                        if (!nodes.isEmpty()) {
                            xValueChildrenList = new XValueChildrenList(nodes.size());
                            for (DebuggerTreeNode debuggerTreeNode : nodes) {
                                NodeDescriptor nodeDescriptor = debuggerTreeNode.getDescriptor();
                                if (nodeDescriptor instanceof ValueDescriptorImpl) {
                                    xValueChildrenList.add((XNamedValue)JavaValue.create(JavaValue.this, (ValueDescriptorImpl)nodeDescriptor, JavaValue.this.b, JavaValue.this.f, false));
                                    continue;
                                }
                                if (!(nodeDescriptor instanceof MessageDescriptor)) continue;
                                xValueChildrenList.add((XNamedValue)new JavaStackFrame.DummyMessageValueNode(nodeDescriptor.getLabel(), DebuggerTreeRenderer.getDescriptorIcon(nodeDescriptor)));
                            }
                        }
                        node.addChildren(xValueChildrenList, last);
                    }

                    @Override
                    public void setChildren(List<DebuggerTreeNode> nodes) {
                        this.addChildren(nodes, true);
                    }

                    public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
                        if (message == null) {
                            1.a(0);
                        }
                        if (attributes == null) {
                            1.a(1);
                        }
                        node.setMessage(message, icon, attributes, link);
                    }

                    public void addChildren(@NotNull XValueChildrenList children2, boolean last) {
                        if (children2 == null) {
                            1.a(2);
                        }
                        node.addChildren(children2, last);
                    }

                    public void tooManyChildren(int remaining) {
                        JavaValue.this.e = remaining;
                        node.tooManyChildren(remaining);
                    }

                    public void setAlreadySorted(boolean alreadySorted) {
                        node.setAlreadySorted(alreadySorted);
                    }

                    public void setErrorMessage(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            1.a(3);
                        }
                        node.setErrorMessage(errorMessage);
                    }

                    public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
                        if (errorMessage == null) {
                            1.a(4);
                        }
                        node.setErrorMessage(errorMessage, link);
                    }

                    public boolean isObsolete() {
                        return node.isObsolete();
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        long l2 = a ^ 0x3B1BF0C18151L;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attributes";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "children";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/debugger/engine/JavaValue$2$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setMessage";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "addChildren";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setErrorMessage";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, JavaValue.this.b);
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x776753814A9BL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$2", "contextAction"));
            }
        });
    }

    protected static boolean scheduleCommand(EvaluationContextImpl evaluationContext, final @NotNull XCompositeNode node, final SuspendContextCommandImpl command) {
        if (node == null) {
            JavaValue.a(15);
        }
        if (node.isObsolete()) {
            return false;
        }
        evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(command.getSuspendContext()){
            private static final long e = lb.a(7443664267969904158L, -4360217843570263068L, MethodHandles.lookup().lookupClass()).a(247320205198586L);

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                if (suspendContext == null) {
                    3.b(0);
                }
                if (node.isObsolete()) {
                    return;
                }
                command.contextAction(suspendContext);
            }

            @Override
            protected void commandCancelled() {
                long l2 = e ^ 0x65E89BE29E54L;
                node.setErrorMessage(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x6EF239F92FC6L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$3", "contextAction"));
            }
        });
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            JavaValue.a(16);
        }
        this.a(navigatable, false);
    }

    private void a(final @NotNull XNavigatable xNavigatable, final boolean bl2) {
        if (xNavigatable == null) {
            JavaValue.a(17);
        }
        this.b.getManagerThread().schedule(new SuspendContextCommandImpl(this.b.getSuspendContext()){
            private static final long e = lb.a(6750895899308013623L, -8504756361081518130L, MethodHandles.lookup().lookupClass()).a(260285044793292L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return bl2 ? PrioritizedTask.Priority.LOWEST : PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                xNavigatable.setSourcePosition(null);
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    4.b(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition sourcePosition;
                    if (xNavigatable == null) {
                        4.b(1);
                    }
                    if ((sourcePosition = SourcePositionProvider.getSourcePosition(JavaValue.this.c, JavaValue.this.getProject(), JavaValue.this.b(), false)) != null) {
                        xNavigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                    }
                    if (bl2 && (sourcePosition = SourcePositionProvider.getSourcePosition(JavaValue.this.c, JavaValue.this.getProject(), JavaValue.this.b(), true)) != null) {
                        xNavigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                    }
                });
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = e ^ 0x2479DB891738L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "navigatable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/engine/JavaValue$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contextAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$contextAction$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            JavaValue.a(18);
        }
        this.a(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0), true);
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            JavaValue.a(19);
        }
        return threeState;
    }

    private DebuggerContextImpl b() {
        return this.b.getDebugProcess().getDebuggerContext();
    }

    public Project getProject() {
        return this.c.getProject();
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            JavaValue.a(20);
        }
        if (this.b.getSuspendContext().isResumed()) {
            return;
        }
        DebugProcessImpl debugProcessImpl = this.b.getDebugProcess();
        debugProcessImpl.getManagerThread().schedule(new JumpToObjectAction.NavigateCommand(this.b(), this.c, debugProcessImpl, null){
            private static final long f = lb.a(4617147308603369564L, -1009703465906795237L, MethodHandles.lookup().lookupClass()).a(188747875941513L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void doAction(@Nullable SourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (navigatable == null) {
                            5.c(0);
                        }
                        navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                    });
                }
            }

            private static /* synthetic */ void c(int n2) {
                long l2 = f ^ 0x85C047A317EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/debugger/engine/JavaValue$5", "lambda$doAction$0"));
            }
        });
    }

    @Nullable
    public XValueModifier getModifier() {
        return this.c.canSetValue() ? this.c.getModifier(this) : null;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        if (this.h != null) {
            Promise promise = Promise.resolve((Object)this.h);
            if (promise == null) {
                JavaValue.a(21);
            }
            return promise;
        }
        final AsyncPromise asyncPromise = new AsyncPromise();
        this.b.getManagerThread().schedule(new SuspendContextCommandImpl(this.b.getSuspendContext()){
            private static final long e = lb.a(8091312799638823733L, 1993045296182758829L, MethodHandles.lookup().lookupClass()).a(230342138965202L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    6.b(0);
                }
                JavaValue.this.h = (XExpression)ReadAction.compute(() -> {
                    try {
                        PsiElement psiElement = JavaValue.this.getDescriptor().getTreeEvaluation(JavaValue.this, JavaValue.this.b());
                        if (psiElement != null) {
                            XExpression xExpression = TextWithImportsImpl.toXExpression(new TextWithImportsImpl(psiElement));
                            Set set = (Set)psiElement.getUserData(DebuggerTreeNodeExpression.ADDITIONAL_IMPORTS_KEY);
                            if (set != null && xExpression != null) {
                                if (xExpression.getCustomInfo() != null) {
                                    set.add(xExpression.getCustomInfo());
                                }
                                xExpression = new XExpressionImpl(xExpression.getExpression(), xExpression.getLanguage(), StringUtil.join((Collection)set, (String)","), xExpression.getMode());
                            }
                            return xExpression;
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        g.info((Throwable)evaluateException);
                    }
                    return null;
                });
                asyncPromise.setResult((Object)JavaValue.this.h);
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x30F6A0D71ACAL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$6", "contextAction"));
            }
        });
        AsyncPromise asyncPromise2 = asyncPromise;
        if (asyncPromise2 == null) {
            JavaValue.a(22);
        }
        return asyncPromise2;
    }

    public String getValueText() {
        return this.c.getValueText();
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                return new JavaReferringObjectsValue(JavaValue.this, false);
            }
        };
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return new XInstanceEvaluator(){
            private static final long a = lb.a(-326230977215367758L, -6485318730724132097L, MethodHandles.lookup().lookupClass()).a(157584818996482L);

            public void evaluate(final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @NotNull XStackFrame frame) {
                if (callback == null) {
                    8.a(0);
                }
                if (frame == null) {
                    8.a(1);
                }
                JavaValue.this.b.getManagerThread().schedule(new DebuggerCommandImpl(){
                    private static final long c = lb.a(4071262545816857235L, 828466154260870410L, MethodHandles.lookup().lookupClass()).a(226729884140205L);

                    @Override
                    protected void commandCancelled() {
                        long l2 = c ^ 0x7A553E644B1FL;
                        callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                    }

                    @Override
                    protected void action() {
                        NodeDescriptor nodeDescriptor;
                        Object object;
                        long l2 = c ^ 0x7FD5F53CE9B9L;
                        ValueDescriptorImpl valueDescriptorImpl = JavaValue.this.c;
                        if (JavaValue.this.c instanceof WatchItemDescriptor && (object = ((WatchItemDescriptor)JavaValue.this.c).getModifier()) != null && (nodeDescriptor = object.getInspectItem(JavaValue.this.getProject())) != null) {
                            valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptor;
                        }
                        if ((object = ((JavaStackFrame)frame).getFrameDebuggerContext(null).createEvaluationContext()) != null) {
                            callback.evaluated((XValue)JavaValue.create(valueDescriptorImpl, (EvaluationContextImpl)object, JavaValue.this.f));
                        } else {
                            callback.errorOccurred("Context is not available");
                        }
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x303940D7CCD9L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "frame";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/JavaValue$8";
                objectArray[2] = "evaluate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void setRenderer(NodeRenderer nodeRenderer, XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.c.setRenderer(nodeRenderer);
        this.reBuild(node);
    }

    public void reBuild(XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.e = -1;
        node.invokeNodeUpdate(() -> {
            node.clearChildren();
            this.computePresentation((XValueNode)node, XValuePlace.TREE);
        });
    }

    @Nullable
    public String computeInlinePresentation() {
        ValueDescriptorImpl valueDescriptorImpl = this.getDescriptor();
        return valueDescriptorImpl.isNull() || valueDescriptorImpl.isPrimitive() ? valueDescriptorImpl.getValueText() : null;
    }

    static {
        l = lb.a(-2787904264889430082L, 8248010645579806428L, MethodHandles.lookup().lookupClass()).a(75634399207223L);
        g = Logger.getInstance(JavaValue.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x3E851B1AFAE0L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 21: 
            case 22: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaValue";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateEvaluationExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "truncateToMaxLength";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCommand";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaValuePresentation
    extends XValueExtendedPresentation
    implements XValueCompactPresentation {
        private final String a;
        private final String c;
        private final String b;
        private final ValueDescriptorImpl d;
        private static final long e = lb.a(323372209694224198L, -5315961005739799398L, MethodHandles.lookup().lookupClass()).a(112984954299338L);

        JavaValuePresentation(@NotNull String value, @Nullable String type, @Nullable String error, ValueDescriptorImpl valueDescriptor) {
            if (value == null) {
                JavaValuePresentation.a(0);
            }
            this.a = value;
            this.c = type;
            this.b = error;
            this.d = valueDescriptor;
        }

        @Nullable
        public String getType() {
            return StringUtil.nullize((String)this.c);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                JavaValuePresentation.a(1);
            }
            this.renderValue(renderer, null);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
            boolean bl2;
            long l2 = e ^ 0x69FD62EA47D6L;
            if (renderer == null) {
                JavaValuePresentation.a(2);
            }
            boolean bl3 = bl2 = node != null;
            if (this.b != null) {
                if (this.a.endsWith(this.b)) {
                    renderer.renderValue(this.a.substring(0, this.a.length() - this.b.length()));
                }
                renderer.renderError(this.b);
            } else {
                Object object;
                Object object2;
                if (bl2 && node.getValueContainer() instanceof JavaValue && ((JavaValue)(object2 = (JavaValue)node.getValueContainer())).getDescriptor().isArray()) {
                    String string;
                    object = (ArrayReference)((JavaValue)object2).getDescriptor().getValue();
                    ArrayType arrayType = (ArrayType)((JavaValue)object2).getDescriptor().getType();
                    if (arrayType != null && (TypeConversionUtil.isPrimitive((String)(string = arrayType.componentTypeName())) || "java.lang.String".equals(string))) {
                        int n2 = object.length();
                        int n3 = Math.min(n2, "java.lang.String".equals(string) ? 5 : 10);
                        List<Value> list2 = object.getValues(0, n3);
                        ArrayList<String> arrayList = new ArrayList<String>(n3);
                        for (int i10 = 0; i10 < list2.size(); ++i10) {
                            arrayList.add(StringUtil.first((String)list2.get(i10).toString(), (int)15, (boolean)true));
                        }
                        String string2 = "";
                        if (arrayList.size() < n2) {
                            string2 = ", + " + (n2 - arrayList.size()) + " more";
                        }
                        renderer.renderValue("{" + StringUtil.join(arrayList, (String)", ") + string2 + "}");
                        return;
                    }
                }
                if (this.d.isString()) {
                    renderer.renderStringValue(this.a, "\"", 1000);
                    return;
                }
                object2 = JavaValue.a(this.a);
                object = this.d.getLastRenderer();
                if (object instanceof CompoundTypeRenderer) {
                    object = ((CompoundTypeRenderer)object).getLabelRenderer();
                }
                if (object instanceof ToStringRenderer) {
                    if (!((ToStringRenderer)object).isShowValue(this.d, this.d.getStoredEvaluationContext())) {
                        return;
                    }
                    object2 = StringUtil.wrapWithDoubleQuote((String)object2);
                }
                renderer.renderValue((String)object2);
            }
        }

        @NotNull
        public String getSeparator() {
            long l2 = e ^ 0x40CC379BEAECL;
            boolean bl2 = !this.d.isShowIdLabel() && this.a();
            String string = this.d.getDeclaredTypeLabel();
            if (!StringUtil.isEmpty((String)string)) {
                String string2 = bl2 ? string : string + " " + " = ";
                if (string2 == null) {
                    JavaValuePresentation.a(3);
                }
                return string2;
            }
            String string3 = bl2 ? "" : " = ";
            if (string3 == null) {
                JavaValuePresentation.a(4);
            }
            return string3;
        }

        public boolean isModified() {
            return this.d.isDirty();
        }

        private boolean a() {
            MyEmptyContainerChecker myEmptyContainerChecker = new MyEmptyContainerChecker();
            this.renderValue((XValuePresentation.XValueTextRenderer)new XValueTextRendererImpl((ColoredTextContainer)myEmptyContainerChecker));
            return myEmptyContainerChecker.isEmpty;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x4A605A67A567L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaValue$JavaValuePresentation";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaValue$JavaValuePresentation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparator";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "renderValue";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyEmptyContainerChecker
        implements ColoredTextContainer {
            boolean isEmpty = true;
            private static final long a = lb.a(555333906068023951L, -732245213805475867L, MethodHandles.lookup().lookupClass()).a(142908469847707L);

            private MyEmptyContainerChecker() {
            }

            public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
                if (fragment == null) {
                    MyEmptyContainerChecker.a(0);
                }
                if (attributes == null) {
                    MyEmptyContainerChecker.a(1);
                }
                if (!fragment.isEmpty()) {
                    this.isEmpty = false;
                }
            }

            public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
                if (fragment == null) {
                    MyEmptyContainerChecker.a(2);
                }
                if (attributes == null) {
                    MyEmptyContainerChecker.a(3);
                }
                this.append(fragment, attributes);
            }

            public void setIcon(@Nullable Icon icon) {
            }

            public void setToolTipText(@Nullable String text2) {
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x5C6BBF895DEL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fragment";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/JavaValue$JavaValuePresentation$MyEmptyContainerChecker";
                objectArray[2] = "append";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static abstract class JavaFullValueEvaluator
    extends XFullValueEvaluator {
        protected final EvaluationContextImpl myEvaluationContext;
        private static final long b = lb.a(1510051263651516933L, -4763879345181291529L, MethodHandles.lookup().lookupClass()).a(26896837484663L);

        public JavaFullValueEvaluator(@NotNull String linkText, EvaluationContextImpl evaluationContext) {
            if (linkText == null) {
                JavaFullValueEvaluator.a(0);
            }
            super(linkText);
            this.myEvaluationContext = evaluationContext;
        }

        public JavaFullValueEvaluator(EvaluationContextImpl evaluationContext) {
            this.myEvaluationContext = evaluationContext;
        }

        public abstract void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback var1) throws Exception;

        protected EvaluationContextImpl getEvaluationContext() {
            return this.myEvaluationContext;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                JavaFullValueEvaluator.a(1);
            }
            if (callback.isObsolete()) {
                return;
            }
            this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){
                private static final long e = lb.a(6237636858686046886L, 6891561040562371221L, MethodHandles.lookup().lookupClass()).a(173118042877398L);

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                protected void commandCancelled() {
                    long l2 = e ^ 0x4DFCA83DB0A0L;
                    callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    if (suspendContext == null) {
                        1.b(0);
                    }
                    if (callback.isObsolete()) {
                        return;
                    }
                    this.evaluate(callback);
                }

                private static /* synthetic */ void b(int n2) {
                    long l2 = e ^ 0x2EFF2BD9CCE8L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator$1", "contextAction"));
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x2467DCB8F57EL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startEvaluation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

