/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.Patches;
import com.intellij.ProjectTopics;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.jdi.EmptyConnectorArgument;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugProcessImpl
extends UserDataHolderBase
implements DebugProcess {
    private static final Logger k;
    @NonNls
    private static final String q = "com.sun.jdi.SocketAttach";
    @NonNls
    private static final String i = "com.sun.jdi.SharedMemoryAttach";
    @NonNls
    private static final String s = "com.sun.jdi.SocketListen";
    @NonNls
    private static final String u = "com.sun.jdi.SharedMemoryListen";
    private final Project y;
    private final RequestManagerImpl r;
    private volatile VirtualMachineProxyImpl x = null;
    protected final EventDispatcher<DebugProcessListener> myDebugProcessDispatcher = EventDispatcher.create(DebugProcessListener.class);
    protected final EventDispatcher<EvaluationListener> myEvaluationDispatcher = EventDispatcher.create(EvaluationListener.class);
    private final List<ProcessListener> d = ContainerUtil.createLockFreeCopyOnWriteList();
    private final StringBuilder j = new StringBuilder();
    protected final AtomicReference<State> myState = new AtomicReference<State>(State.INITIAL);
    private volatile ExecutionResult c;
    private RemoteConnection m;
    private JavaDebugProcess l;
    private volatile Map<String, Connector.Argument> w;
    private final List<NodeRenderer> b = new ArrayList<NodeRenderer>();
    private final Map<Type, NodeRenderer> f = new HashMap<Type, NodeRenderer>();
    private final SuspendManagerImpl n = new SuspendManagerImpl(this);
    protected CompoundPositionManager myPositionManager = CompoundPositionManager.EMPTY;
    private final DebuggerManagerThreadImpl t;
    private final Semaphore o = new Semaphore();
    private final AtomicBoolean e = new AtomicBoolean(false);
    private final AtomicBoolean h = new AtomicBoolean(false);
    protected DebuggerSession mySession;
    @Nullable
    protected MethodReturnValueWatcher myReturnValueWatcher;
    protected final Disposable myDisposable = Disposer.newDisposable();
    private final Alarm a = new Alarm();
    private final ThreadBlockedMonitor p = new ThreadBlockedMonitor(this, this.myDisposable);
    private static final int g;
    private volatile RunToCursorBreakpoint v;
    private static final long E;

    protected DebugProcessImpl(Project project2) {
        this.y = project2;
        this.t = new DebuggerManagerThreadImpl(this.myDisposable, this.y);
        this.r = new RequestManagerImpl(this);
        NodeRendererSettings.getInstance().addListener(this::a, this.myDisposable);
        this.a();
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){
            private static final long a = lb.a(-1930225956086754448L, -2014563383798453695L, MethodHandles.lookup().lookupClass()).a(264046069346475L);

            public void paused(@NotNull SuspendContext suspendContext) {
                if (suspendContext == null) {
                    1.a(0);
                }
                DebugProcessImpl.this.p.stopWatching(suspendContext.getSuspendPolicy() != 2 ? suspendContext.getThread() : null);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x26EA7ECD83CBL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$1", "paused"));
            }
        });
    }

    private void a() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

            @Override
            protected void action() {
                DebugProcessImpl.this.f.clear();
                DebugProcessImpl.this.b.clear();
                try {
                    NodeRendererSettings.getInstance().getAllRenderers().stream().filter(NodeRenderer::isEnabled).forEachOrdered(DebugProcessImpl.this.b::add);
                }
                finally {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.y, () -> {
                        DebuggerSession debuggerSession = DebugProcessImpl.this.mySession;
                        if (debuggerSession != null && debuggerSession.isAttached()) {
                            DebuggerAction.refreshViews(DebugProcessImpl.this.mySession.getXDebugSession());
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public Pair<Method, Value> getLastExecutedMethod() {
        MethodReturnValueWatcher methodReturnValueWatcher = this.myReturnValueWatcher;
        if (methodReturnValueWatcher == null) {
            return null;
        }
        Method method = methodReturnValueWatcher.getLastExecutedMethod();
        if (method == null) {
            return null;
        }
        return Pair.create((Object)method, (Object)methodReturnValueWatcher.getLastMethodReturnValue());
    }

    public void setWatchMethodReturnValuesEnabled(boolean enabled) {
        MethodReturnValueWatcher methodReturnValueWatcher = this.myReturnValueWatcher;
        if (methodReturnValueWatcher != null) {
            methodReturnValueWatcher.setEnabled(enabled);
        }
    }

    public boolean canGetMethodReturnValue() {
        return this.myReturnValueWatcher != null;
    }

    public NodeRenderer getAutoRenderer(ValueDescriptor descriptor2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = descriptor2.getType();
        if (!this.isEvaluationPossible()) {
            return DebugProcessImpl.getDefaultRenderer(type);
        }
        try {
            return this.f.computeIfAbsent(type, type2 -> this.b.stream().filter(nodeRenderer -> DebuggerUtilsImpl.suppressExceptions(() -> nodeRenderer.isApplicable(type), false, true, ClassNotPreparedException.class)).findFirst().orElseGet(() -> DebugProcessImpl.getDefaultRenderer(type)));
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            k.info((Throwable)classNotPreparedException);
            return DebugProcessImpl.getDefaultRenderer(type);
        }
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Value value) {
        NodeRenderer nodeRenderer = DebugProcessImpl.getDefaultRenderer(value != null ? value.type() : null);
        if (nodeRenderer == null) {
            DebugProcessImpl.a(0);
        }
        return nodeRenderer;
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Type type) {
        NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
        PrimitiveRenderer primitiveRenderer = nodeRendererSettings.getPrimitiveRenderer();
        if (primitiveRenderer.isApplicable(type)) {
            PrimitiveRenderer primitiveRenderer2 = primitiveRenderer;
            if (primitiveRenderer2 == null) {
                DebugProcessImpl.a(1);
            }
            return primitiveRenderer2;
        }
        ArrayRenderer arrayRenderer = nodeRendererSettings.getArrayRenderer();
        if (arrayRenderer.isApplicable(type)) {
            ArrayRenderer arrayRenderer2 = arrayRenderer;
            if (arrayRenderer2 == null) {
                DebugProcessImpl.a(2);
            }
            return arrayRenderer2;
        }
        ClassRenderer classRenderer = nodeRendererSettings.getClassRenderer();
        k.assertTrue(classRenderer.isApplicable(type), (Object)type.name());
        ClassRenderer classRenderer2 = classRenderer;
        if (classRenderer2 == null) {
            DebugProcessImpl.a(3);
        }
        return classRenderer2;
    }

    protected void commitVM(VirtualMachine vm) {
        long l2 = E ^ 0x5E911FFAC94AL;
        if (!this.isInInitialState()) {
            k.error("State is invalid " + (Object)((Object)this.myState.get()));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager = new CompoundPositionManager(new PositionManagerImpl(this));
        this.y.getMessageBus().connect(this.myDisposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private static final long a = lb.a(365226534244129150L, -6494564156821266001L, MethodHandles.lookup().lookupClass()).a(167705679866664L);

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.a(0);
                }
                DumbService.getInstance((Project)DebugProcessImpl.this.y).runWhenSmart(() -> DebugProcessImpl.this.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> {
                    DebugProcessImpl.this.myPositionManager.clearCache();
                    DebuggerUIUtil.invokeLater(() -> DebugProcessImpl.this.mySession.refresh(true));
                }));
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xB541CA4E355L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/DebugProcessImpl$3", "rootsChanged"));
            }
        });
        k.debug("*******************VM attached******************");
        this.a(vm);
        this.x = new VirtualMachineProxyImpl(this, vm);
        vm.setDebugTraceMode(g);
    }

    private void c() {
        long l2 = E ^ 0x7E803E9EF2B4L;
        Map<String, Connector.Argument> map2 = this.w;
        try {
            if (map2 == null) {
                return;
            }
            if (this.m.isServerMode()) {
                ((ListeningConnector)DebugProcessImpl.findConnector(s)).stopListening(map2);
            }
        }
        catch (IllegalConnectorArgumentsException | IOException | IllegalArgumentException exception) {
            k.debug((Throwable)exception);
        }
        catch (ExecutionException executionException) {
            k.error((Throwable)executionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToConsole(String text2) {
        List<ProcessListener> list2 = this.d;
        synchronized (list2) {
            if (this.c == null) {
                this.j.append(text2);
            } else {
                this.c(text2);
            }
        }
    }

    private void c(String string) {
        this.c.getProcessHandler().notifyTextAvailable(string, ProcessOutputTypes.SYSTEM);
    }

    public ProcessHandler getProcessHandler() {
        return this.c != null ? this.c.getProcessHandler() : null;
    }

    protected void doStep(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, int size, int depth, RequestHint hint) {
        long l2 = E ^ 0x6E88C2D73AAAL;
        if (stepThread == null) {
            return;
        }
        try {
            ThreadReference threadReference = stepThread.getThreadReference();
            if (k.isDebugEnabled()) {
                k.debug("DO_STEP: creating step request for " + threadReference);
            }
            this.deleteStepRequests(threadReference);
            EventRequestManager eventRequestManager = this.getVirtualMachineProxy().eventRequestManager();
            StepRequest stepRequest = eventRequestManager.createStepRequest(threadReference, size, depth);
            if (hint == null || !hint.isIgnoreFilters()) {
                this.checkPositionNotFiltered(stepThread, (Consumer<List<ClassFilter>>)((Consumer)list2 -> list2.forEach(classFilter -> stepRequest.addClassExclusionFilter(classFilter.getPattern()))));
            }
            stepRequest.setSuspendPolicy(suspendContext.getSuspendPolicy() == 1 ? 1 : 2);
            stepRequest.addCountFilter(1);
            if (hint != null) {
                stepRequest.putProperty("hint", hint);
            }
            try {
                stepRequest.enable();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                eventRequestManager.deleteEventRequest(stepRequest);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public void checkPositionNotFiltered(ThreadReferenceProxyImpl thread, Consumer<List<ClassFilter>> action) {
        String string;
        List<ClassFilter> list2 = DebugProcessImpl.f();
        if (!(list2.isEmpty() || (string = DebugProcessImpl.getCurrentClassName(thread)) != null && DebuggerUtilsEx.isFiltered(string, list2))) {
            action.consume(list2);
        }
    }

    @NotNull
    private static List<ClassFilter> f() {
        DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        StreamEx streamEx = StreamEx.of((Collection)DebuggerClassFilterProvider.EP_NAME.getExtensionList()).flatCollection(DebuggerClassFilterProvider::getFilters);
        if (debuggerSettings.TRACING_FILTERS_ENABLED) {
            streamEx = streamEx.prepend((Object[])debuggerSettings.getSteppingFilters());
        }
        List list2 = ((StreamEx)streamEx.filter(ClassFilter::isEnabled)).toList();
        if (list2 == null) {
            DebugProcessImpl.a(4);
        }
        return list2;
    }

    void deleteStepRequests(@Nullable ThreadReference stepThread) {
        EventRequestManager eventRequestManager = this.getVirtualMachineProxy().eventRequestManager();
        for (StepRequest stepRequest : new ArrayList<StepRequest>(eventRequestManager.stepRequests())) {
            if (stepThread != null && !stepThread.equals(stepRequest.thread())) continue;
            try {
                eventRequestManager.deleteEventRequest(stepRequest);
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw vMDisconnectedException;
            }
            catch (Exception exception) {
                k.error((Throwable)exception);
            }
        }
    }

    @Nullable
    static String getCurrentClassName(ThreadReferenceProxyImpl thread) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl;
            if (thread != null && thread.frameCount() > 0 && (stackFrameProxyImpl = thread.frame(0)) != null) {
                ReferenceType referenceType;
                Location location = stackFrameProxyImpl.location();
                ReferenceType referenceType2 = referenceType = location == null ? null : location.declaringType();
                if (referenceType != null) {
                    return referenceType.name();
                }
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return null;
    }

    private VirtualMachine b() throws ExecutionException {
        long l2 = E ^ 0x2BA52899D22BL;
        try {
            Object object;
            Connector.Argument argument;
            if (this.w != null) {
                throw new IOException(DebuggerBundle.message((String)"error.debugger.already.listening", (Object[])new Object[0]));
            }
            String string = this.m.getAddress();
            if (this.m instanceof PidRemoteConnection && !((PidRemoteConnection)this.m).isFixedAddress()) {
                PidRemoteConnection pidRemoteConnection = (PidRemoteConnection)this.m;
                Connector connector = pidRemoteConnection.getConnector(this);
                String string2 = pidRemoteConnection.getPid();
                if (StringUtil.isEmpty((String)string2)) {
                    throw new CantRunException(DebuggerBundle.message((String)"error.no.pid", (Object[])new Object[0]));
                }
                this.w = connector.defaultArguments();
                Connector.Argument argument2 = this.w.get("pid");
                if (argument2 != null) {
                    argument2.setValue(string2);
                }
                if (connector instanceof AttachingConnector) {
                    VirtualMachine virtualMachine = this.a((AttachingConnector)connector);
                    return virtualMachine;
                }
                VirtualMachine virtualMachine = this.a(string, (ListeningConnector)connector);
                return virtualMachine;
            }
            if (this.m.isServerMode()) {
                ListeningConnector listeningConnector = (ListeningConnector)DebugProcessImpl.findConnector(this.m.isUseSockets(), true);
                this.w = listeningConnector.defaultArguments();
                if (this.w == null) {
                    throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
                }
                VirtualMachine virtualMachine = this.a(string, listeningConnector);
                return virtualMachine;
            }
            AttachingConnector attachingConnector = (AttachingConnector)DebugProcessImpl.findConnector(this.m.isUseSockets(), false);
            this.w = attachingConnector.defaultArguments();
            if (this.m.isUseSockets()) {
                argument = this.w.get("hostname");
                if (argument != null && this.m.getHostName() != null) {
                    argument.setValue(this.m.getHostName());
                }
                if (string == null) {
                    throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.attach.port", (Object[])new Object[0]));
                }
                object = this.w.get("port");
                if (object != null) {
                    object.setValue(string);
                }
            } else {
                if (string == null) {
                    throw new CantRunException(DebuggerBundle.message((String)"error.no.shmem.address", (Object[])new Object[0]));
                }
                argument = this.w.get("name");
                if (argument != null) {
                    argument.setValue(string);
                }
            }
            argument = this.w.get("timeout");
            if (argument != null) {
                argument.setValue("0");
            }
            object = this.a(attachingConnector);
            return object;
        }
        catch (IOException iOException) {
            throw new ExecutionException(DebugProcessImpl.processIOException(iOException, DebuggerBundle.getAddressDisplayName((RemoteConnection)this.m)), (Throwable)iOException);
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            throw new ExecutionException(DebugProcessImpl.processError(illegalConnectorArgumentsException), (Throwable)illegalConnectorArgumentsException);
        }
        finally {
            this.w = null;
        }
    }

    private VirtualMachine a(String string, ListeningConnector listeningConnector) throws CantRunException, IOException, IllegalConnectorArgumentsException {
        Connector.Argument argument;
        Connector.Argument argument2;
        long l2 = E ^ 0x6156FB59B798L;
        if (string == null) {
            throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
        }
        Connector.Argument argument3 = argument2 = this.m.isUseSockets() ? this.w.get("port") : this.w.get("name");
        if (argument2 != null) {
            argument2.setValue(string);
            if (string.length() == 0 || string.equals("0")) {
                argument = new EmptyConnectorArgument("argForUniqueness");
                this.w.put(((EmptyConnectorArgument)argument).name(), argument);
            }
        }
        if ((argument = this.w.get("timeout")) != null) {
            argument.setValue("0");
        }
        try {
            String string2 = listeningConnector.startListening(this.w);
            String string3 = StringUtil.substringAfterLast((String)string2, (String)":");
            if (string3 != null) {
                string2 = string3;
            }
            this.m.setAddress(string2);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
            VirtualMachine virtualMachine = listeningConnector.accept(this.w);
            return virtualMachine;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CantRunException(illegalArgumentException.getLocalizedMessage());
        }
        finally {
            if (this.w != null) {
                try {
                    listeningConnector.stopListening(this.w);
                }
                catch (IllegalConnectorArgumentsException | IllegalArgumentException exception) {}
            }
        }
    }

    private VirtualMachine a(AttachingConnector attachingConnector) throws IOException, IllegalConnectorArgumentsException, CantRunException {
        ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
        try {
            return attachingConnector.attach(this.w);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CantRunException(illegalArgumentException.getLocalizedMessage());
        }
    }

    public void showStatusText(String text2) {
        this.a.cancelAllRequests();
        this.a.addRequest(() -> {
            if (!this.y.isDisposed()) {
                StatusBarUtil.setStatusBarInfo((Project)this.y, (String)text2);
            }
        }, 50);
    }

    @NotNull
    public static Connector findConnector(boolean useSockets, boolean listen) throws ExecutionException {
        long l2 = E ^ 0x2F2B6CE9EECL;
        if (listen) {
            Connector connector = DebugProcessImpl.findConnector(useSockets ? s : u);
            if (connector == null) {
                DebugProcessImpl.a(5);
            }
            return connector;
        }
        Connector connector = DebugProcessImpl.findConnector(useSockets ? q : i);
        if (connector == null) {
            DebugProcessImpl.a(6);
        }
        return connector;
    }

    @NotNull
    public static Connector findConnector(String connectorName) throws ExecutionException {
        VirtualMachineManager virtualMachineManager;
        long l2 = E ^ 0x3EB35310FA33L;
        try {
            virtualMachineManager = Bootstrap.virtualMachineManager();
        }
        catch (Error error) {
            throw new ExecutionException(DebuggerBundle.message((String)"debugger.jdi.bootstrap.error", (Object[])new Object[]{error.getClass().getName() + " : " + error.getLocalizedMessage()}));
        }
        Connector connector2 = (Connector)StreamEx.of(virtualMachineManager.allConnectors()).findFirst(connector -> connectorName.equals(connector.name())).orElseThrow(() -> {
            long l2 = E ^ 0xBD75E2E2C4AL;
            return new CantRunException(DebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{connectorName}));
        });
        if (connector2 == null) {
            DebugProcessImpl.a(7);
        }
        return connector2;
    }

    private void a(VirtualMachine virtualMachine) {
        long l2 = E ^ 0x7FE3D5D8448AL;
        String string = virtualMachine.version();
        if ("1.4.0".equals(string)) {
            DebuggerInvocationUtil.swingInvokeLater(this.y, () -> {
                long l2 = E ^ 0x329502412156L;
                Messages.showMessageDialog((Project)this.y, (String)DebuggerBundle.message((String)"warning.jdk140.unstable", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"title.jdk140.unstable", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            });
        }
        if (this.getSession().getAlternativeJre() == null) {
            Sdk sdk3 = this.getSession().getRunJre();
            JavaVersion javaVersion = JavaVersion.tryParse((String)string);
            if (javaVersion != null && (sdk3 == null || sdk3.getSdkType() instanceof JavaSdkType) && !DebugProcessImpl.a(sdk3, javaVersion)) {
                Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> DebugProcessImpl.a(sdk, javaVersion)).findFirst().ifPresent(sdk2 -> {
                    long l2 = E ^ 0x155BCBEAB360L;
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"message.remote.jre.version.mismatch", (Object[])new Object[]{string, sdk3 != null ? sdk3.getVersionString() : "unknown", sdk2.getName()}), MessageType.INFO).notify(this.y);
                    this.getSession().setAlternativeJre((Sdk)sdk2);
                });
            }
        }
    }

    private static boolean a(@Nullable Sdk sdk, @NotNull JavaVersion javaVersion) {
        if (javaVersion == null) {
            DebugProcessImpl.a(8);
        }
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType) {
            String string = sdk.getVersionString();
            return string != null && javaVersion.equals((Object)JavaVersion.tryParse((String)string));
        }
        return false;
    }

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.addListener((EventListener)evaluationListener);
    }

    public void removeEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.removeListener((EventListener)evaluationListener);
    }

    public void addDebugProcessListener(DebugProcessListener listener) {
        this.myDebugProcessDispatcher.addListener((EventListener)listener);
    }

    public void removeDebugProcessListener(DebugProcessListener listener) {
        this.myDebugProcessDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener processListener) {
        List<ProcessListener> list2 = this.d;
        synchronized (list2) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().addProcessListener(processListener);
            } else {
                this.d.add(processListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener processListener) {
        List<ProcessListener> list2 = this.d;
        synchronized (list2) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().removeProcessListener(processListener);
            } else {
                this.d.remove(processListener);
            }
        }
    }

    public RemoteConnection getConnection() {
        return this.m;
    }

    public ExecutionResult getExecutionResult() {
        return this.c;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.y;
        if (project2 == null) {
            DebugProcessImpl.a(9);
        }
        return project2;
    }

    public boolean canRedefineClasses() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.x;
        return virtualMachineProxyImpl != null && virtualMachineProxyImpl.canRedefineClasses();
    }

    public boolean canWatchFieldModification() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.x;
        return virtualMachineProxyImpl != null && virtualMachineProxyImpl.canWatchFieldModification();
    }

    public boolean isInInitialState() {
        return this.myState.get() == State.INITIAL;
    }

    public boolean isAttached() {
        return this.myState.get() == State.ATTACHED;
    }

    public boolean isDetached() {
        return this.myState.get() == State.DETACHED;
    }

    public boolean isDetaching() {
        return this.myState.get() == State.DETACHING;
    }

    public RequestManagerImpl getRequestsManager() {
        return this.r;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        long l2 = E ^ 0xF3A4CB5B44CL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.x;
        if (virtualMachineProxyImpl == null) {
            if (this.isInInitialState()) {
                throw new IllegalStateException("Virtual machine is not initialized yet");
            }
            throw new VMDisconnectedException();
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl2 = virtualMachineProxyImpl;
        if (virtualMachineProxyImpl2 == null) {
            DebugProcessImpl.a(10);
        }
        return virtualMachineProxyImpl2;
    }

    public void appendPositionManager(PositionManager positionManager) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager.appendPositionManager(positionManager);
    }

    public void setRunToCursorBreakpoint(@Nullable RunToCursorBreakpoint breakpoint) {
        this.v = breakpoint;
    }

    public void cancelRunToCursorBreakpoint() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RunToCursorBreakpoint runToCursorBreakpoint = this.v;
        if (runToCursorBreakpoint != null) {
            this.setRunToCursorBreakpoint(null);
            this.getRequestsManager().deleteRequest(runToCursorBreakpoint);
            if (runToCursorBreakpoint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().enableBreakpoints(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcess(boolean closedByUser) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myState.compareAndSet(State.INITIAL, State.DETACHING) || this.myState.compareAndSet(State.ATTACHED, State.DETACHING)) {
            try {
                this.getManagerThread().close();
            }
            finally {
                VirtualMachineProxyImpl virtualMachineProxyImpl = this.x;
                this.x = null;
                this.myPositionManager = CompoundPositionManager.EMPTY;
                this.myReturnValueWatcher = null;
                this.f.clear();
                this.b.clear();
                DebuggerUtils.cleanupAfterProcessFinish((DebugProcess)this);
                this.myState.compareAndSet(State.DETACHING, State.DETACHED);
                try {
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processDetached((DebugProcess)this, closedByUser);
                }
                finally {
                    if (virtualMachineProxyImpl != null) {
                        try {
                            virtualMachineProxyImpl.dispose();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.o.up();
                }
            }
        }
    }

    private static String e(String string) {
        int n2 = 90;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i10 = 0; i10 < string.length(); i10 += 90) {
            stringBuilder.append(string, i10, Math.min(i10 + 90, string.length())).append('\n');
        }
        return stringBuilder.toString();
    }

    public static String processError(Exception e10) {
        String string;
        long l2 = E ^ 0x5821FC17FB1AL;
        if (e10 instanceof VMStartException) {
            VMStartException vMStartException = (VMStartException)e10;
            string = vMStartException.getLocalizedMessage();
        } else if (e10 instanceof IllegalConnectorArgumentsException) {
            IllegalConnectorArgumentsException illegalConnectorArgumentsException = (IllegalConnectorArgumentsException)e10;
            List<String> list2 = illegalConnectorArgumentsException.argumentNames();
            string = DebugProcessImpl.e(DebuggerBundle.message((String)"error.invalid.argument", (Object[])new Object[]{list2.size()}) + ": " + illegalConnectorArgumentsException.getLocalizedMessage()) + list2;
            k.debug((Throwable)illegalConnectorArgumentsException);
        } else if (e10 instanceof CantRunException) {
            string = e10.getLocalizedMessage();
        } else if (e10 instanceof VMDisconnectedException) {
            string = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
        } else if (e10 instanceof IOException) {
            string = DebugProcessImpl.processIOException((IOException)e10, null);
        } else if (e10 instanceof ExecutionException) {
            string = e10.getLocalizedMessage();
        } else {
            string = DebuggerBundle.message((String)"error.exception.while.connecting", (Object[])new Object[]{e10.getClass().getName(), e10.getLocalizedMessage()});
            k.debug((Throwable)e10);
        }
        return string;
    }

    @NotNull
    public static String processIOException(@NotNull IOException e10, @Nullable String address) {
        long l2 = E ^ 0x6EA74C4AABEFL;
        if (e10 == null) {
            DebugProcessImpl.a(11);
        }
        if (e10 instanceof UnknownHostException) {
            String string = DebuggerBundle.message((String)"error.unknown.host", (Object[])new Object[0]) + (address != null ? " (" + address + ")" : "") + ":\n" + e10.getLocalizedMessage();
            if (string == null) {
                DebugProcessImpl.a(12);
            }
            return string;
        }
        Throwable throwable = e10.getCause();
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            String string = throwable.getCause().getLocalizedMessage();
            if (string == null) {
                DebugProcessImpl.a(13);
            }
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (address != null) {
            stringBuilder.append(DebuggerBundle.message((String)"error.cannot.open.debugger.port", (Object[])new Object[0]));
            stringBuilder.append(" (").append(address).append("): ");
        }
        stringBuilder.append(e10.getClass().getName()).append(" ");
        if (!StringUtil.isEmpty((String)e10.getLocalizedMessage())) {
            stringBuilder.append('\"').append(e10.getLocalizedMessage()).append('\"');
        }
        if (throwable != null && !StringUtil.isEmpty((String)throwable.getLocalizedMessage())) {
            stringBuilder.append(" (").append(throwable.getLocalizedMessage()).append(')');
        }
        k.debug((Throwable)e10);
        String string = stringBuilder.toString();
        if (string == null) {
            DebugProcessImpl.a(14);
        }
        return string;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.r.setFilterThread(null);
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.t;
    }

    private static int a(SuspendContext suspendContext) {
        if (suspendContext.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread()) {
            return 1;
        }
        return 0;
    }

    public void waitFor() {
        k.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.o.waitFor();
    }

    public void waitFor(long timeout) {
        k.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.o.waitFor(timeout);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(15);
        }
        if (objRef == null) {
            DebugProcessImpl.a(16);
        }
        if (method == null) {
            DebugProcessImpl.a(17);
        }
        if (args == null) {
            DebugProcessImpl.a(18);
        }
        return this.invokeInstanceMethod(evaluationContext, objRef, method, args, 0);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args, final int invocationOptions) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(19);
        }
        if (objRef == null) {
            DebugProcessImpl.a(20);
        }
        if (method == null) {
            DebugProcessImpl.a(21);
        }
        if (args == null) {
            DebugProcessImpl.a(22);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, args){
            private static final long c = lb.a(-8409834135452599214L, -6886346174039148140L, MethodHandles.lookup().lookupClass()).a(193035783890485L);

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                long l2 = c ^ 0x791534E26283L;
                if (k.isDebugEnabled()) {
                    k.debug("Invoking " + objRef.type().name() + "." + method.name());
                }
                return objRef.invokeMethod(threadReference, method, args, invokePolicy | invocationOptions);
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    private static ThreadReference a(EvaluationContext evaluationContext) throws EvaluateException {
        ThreadReferenceProxy threadReferenceProxy = evaluationContext.getSuspendContext().getThread();
        if (threadReferenceProxy == null) {
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        return threadReferenceProxy.getThreadReference();
    }

    public Value invokeMethod(EvaluationContext evaluationContext, ClassType classType, Method method, List<? extends Value> args) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, args, 0, false);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, boolean internalEvaluate) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(23);
        }
        if (classType == null) {
            DebugProcessImpl.a(24);
        }
        if (method == null) {
            DebugProcessImpl.a(25);
        }
        if (args == null) {
            DebugProcessImpl.a(26);
        }
        return this.invokeMethod(evaluationContext, classType, method, args, 0, internalEvaluate);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, final int extraInvocationOptions, boolean internalEvaluate) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(27);
        }
        if (classType == null) {
            DebugProcessImpl.a(28);
        }
        if (method == null) {
            DebugProcessImpl.a(29);
        }
        if (args == null) {
            DebugProcessImpl.a(30);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, args){
            private static final long c = lb.a(4467298320966969192L, -562063780751235070L, MethodHandles.lookup().lookupClass()).a(212152116201937L);

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                long l2 = c ^ 0x747AA59636C1L;
                if (k.isDebugEnabled()) {
                    k.debug("Invoking " + classType.name() + "." + method.name());
                }
                return classType.invokeMethod(threadReference, method, args, invokePolicy | extraInvocationOptions);
            }
        }.start((EvaluationContextImpl)evaluationContext, internalEvaluate);
    }

    public Value invokeMethod(EvaluationContext evaluationContext, final InterfaceType interfaceType, Method method, List<? extends Value> args) throws EvaluateException {
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, args){
            private static final long c = lb.a(5330614192604975217L, -4636789984329236031L, MethodHandles.lookup().lookupClass()).a(261605465775822L);

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                long l2 = c ^ 0x1D59D213F01FL;
                if (k.isDebugEnabled()) {
                    k.debug("Invoking " + interfaceType.name() + "." + method.name());
                }
                try {
                    return interfaceType.invokeMethod(threadReference, method, args, invokePolicy);
                }
                catch (LinkageError linkageError) {
                    throw new IllegalStateException("Interface method invocation is not supported in JVM " + SystemInfo.JAVA_VERSION + ". Use JVM 1.8.0_45 or higher to run " + ApplicationNamesInfo.getInstance().getFullProductName());
                }
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    public ArrayReference newInstance(ArrayType arrayType, int dimension) throws EvaluateException {
        try {
            return arrayType.newInstance(dimension);
        }
        catch (Exception exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(31);
        }
        if (classType == null) {
            DebugProcessImpl.a(32);
        }
        if (method == null) {
            DebugProcessImpl.a(33);
        }
        if (args == null) {
            DebugProcessImpl.a(34);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        InvokeCommand<ObjectReference> invokeCommand = new InvokeCommand<ObjectReference>(method, args){
            private static final long c = lb.a(-6388336065080761463L, -1805901186477128776L, MethodHandles.lookup().lookupClass()).a(123420619986946L);

            @Override
            protected ObjectReference invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                long l2 = c ^ 0x6353ED0EE6AAL;
                if (k.isDebugEnabled()) {
                    k.debug("New instance " + classType.name() + "." + method.name());
                }
                return classType.newInstance(threadReference, method, args, invokePolicy);
            }
        };
        return (ObjectReference)invokeCommand.start((EvaluationContextImpl)evaluationContext, false);
    }

    public void clearCashes(int suspendPolicy) {
        if (!this.isAttached()) {
            return;
        }
        switch (suspendPolicy) {
            case 2: {
                this.getVirtualMachineProxy().clearCaches();
                break;
            }
            case 1: {
                this.getVirtualMachineProxy().clearCaches();
            }
        }
    }

    protected void beforeSuspend(SuspendContextImpl suspendContext) {
        this.clearCashes(suspendContext.getSuspendPolicy());
    }

    private void a(SuspendContextImpl suspendContextImpl, Method method, boolean bl2) {
        long l2 = E ^ 0x725FAAD38050L;
        if (k.isDebugEnabled()) {
            k.debug("before invocation in  thread " + suspendContextImpl.getThread().name() + " method " + (method == null ? "null" : method.name()));
        }
        if (!bl2) {
            if (method != null) {
                this.showStatusText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{DebuggerUtilsEx.methodName(method)}));
            } else {
                this.showStatusText(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            }
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, boolean bl2) {
        long l2 = E ^ 0x511798D38AD1L;
        if (k.isDebugEnabled()) {
            k.debug("after invocation in  thread " + suspendContextImpl.getThread().name());
        }
        if (!bl2) {
            this.showStatusText("");
        }
    }

    public ReferenceType findClass(@Nullable EvaluationContext evaluationContext, String className, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ReferenceType referenceType = null;
            Object object = this.getVirtualMachineProxy().classesByName(className).iterator();
            while (object.hasNext()) {
                ReferenceType referenceType2 = object.next();
                if (!referenceType2.isPrepared() || !DebugProcessImpl.a(classLoader, referenceType2)) continue;
                referenceType = referenceType2;
                break;
            }
            if (referenceType == null && evaluationContext != null && ((EvaluationContextImpl)(object = (EvaluationContextImpl)evaluationContext)).isAutoLoadClasses()) {
                return this.loadClass((EvaluationContextImpl)object, className, classLoader);
            }
            return referenceType;
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    private static boolean a(ClassLoaderReference classLoaderReference, ReferenceType referenceType) {
        return classLoaderReference == null || classLoaderReference.equals(referenceType.classLoader()) || classLoaderReference.visibleClasses().contains(referenceType);
    }

    private static String b(String string) {
        long l2 = E ^ 0x215FCCE5CE8FL;
        if (string.indexOf(91) == -1) {
            return string;
        }
        int n2 = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)'[', (int)n2);
        String string2 = JVMNameUtil.getPrimitiveSignature(string);
        if (string2 != null) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append('L');
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String qName, ClassLoaderReference classLoader) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
        long l2 = E ^ 0x3BB16972FA3AL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        qName = DebugProcessImpl.b(qName);
        ReferenceType referenceType = null;
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachineProxy();
        ClassType classType = (ClassType)ContainerUtil.getFirstItem(virtualMachineProxyImpl.classesByName("java.lang.Class"));
        if (classType != null) {
            Method method;
            ArrayList<Value> arrayList = new ArrayList<Value>();
            arrayList.add(virtualMachineProxyImpl.mirrorOf(qName));
            if (classLoader != null) {
                method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                arrayList.add(virtualMachineProxyImpl.mirrorOf(true));
                arrayList.add(classLoader);
            } else {
                method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            }
            Value value = this.invokeMethod((EvaluationContext)evaluationContext, classType, method, arrayList);
            if (value instanceof ClassObjectReference) {
                referenceType = ((ClassObjectReference)value).reflectedType();
            }
        }
        return referenceType;
    }

    public void logThreads() {
        long l2 = E ^ 0x76A14EE4D2DEL;
        if (k.isDebugEnabled()) {
            try {
                Collection<ThreadReferenceProxyImpl> collection = this.getVirtualMachineProxy().allThreads();
                for (ThreadReferenceProxyImpl threadReferenceProxyImpl : collection) {
                    k.debug("Thread name=" + threadReferenceProxyImpl.name() + " suspendCount()=" + threadReferenceProxyImpl.getSuspendCount());
                }
            }
            catch (Exception exception) {
                k.debug((Throwable)exception);
            }
        }
    }

    public void onHotSwapFinished() {
        this.getPositionManager().clearCache();
        StackCapturingLineBreakpoint.clearCaches(this);
    }

    @NotNull
    public SuspendManager getSuspendManager() {
        SuspendManagerImpl suspendManagerImpl = this.n;
        if (suspendManagerImpl == null) {
            DebugProcessImpl.a(35);
        }
        return suspendManagerImpl;
    }

    @NotNull
    public CompoundPositionManager getPositionManager() {
        CompoundPositionManager compoundPositionManager = this.myPositionManager;
        if (compoundPositionManager == null) {
            DebugProcessImpl.a(36);
        }
        return compoundPositionManager;
    }

    public void stop(boolean forceTerminate) {
        this.h.set(true);
        this.c();
        this.getManagerThread().terminateAndInvoke(this.createStopCommand(forceTerminate), ApplicationManager.getApplication().isUnitTestMode() ? 0 : 3000);
    }

    @NotNull
    public StopCommand createStopCommand(boolean forceTerminate) {
        StopCommand stopCommand = new StopCommand(forceTerminate);
        if (stopCommand == null) {
            DebugProcessImpl.a(37);
        }
        return stopCommand;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        long l2 = E ^ 0x225805F7E787L;
        k.assertTrue(this.mySession != null, (Object)"Accessing debug session before its initialization");
        GlobalSearchScope globalSearchScope = this.mySession.getSearchScope();
        if (globalSearchScope == null) {
            DebugProcessImpl.a(38);
        }
        return globalSearchScope;
    }

    public void reattach(final DebugEnvironment environment) {
        if (!this.h.get()) {
            this.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    DebugProcessImpl.this.closeProcess(false);
                    this.a();
                }

                @Override
                protected void commandCancelled() {
                    this.a();
                }

                private void a() {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.y, () -> {
                        ((XDebugSessionImpl)DebugProcessImpl.this.getXdebugProcess().getSession()).reset();
                        DebugProcessImpl.this.myState.set(State.INITIAL);
                        DebugProcessImpl.this.m = environment.getRemoteConnection();
                        DebugProcessImpl.this.getManagerThread().restartIfNeeded();
                        DebugProcessImpl.this.a(environment);
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExecutionResult attachVirtualMachine(DebugEnvironment environment, DebuggerSession session) throws ExecutionException {
        ExecutionResult executionResult;
        this.mySession = session;
        this.o.down();
        ApplicationManager.getApplication().assertIsDispatchThread();
        k.assertTrue(this.isInInitialState());
        this.m = environment.getRemoteConnection();
        this.a(environment);
        try {
            List<ProcessListener> list2 = this.d;
            synchronized (list2) {
                this.c = executionResult = environment.createExecutionResult();
                if (executionResult == null) {
                    this.e();
                    return null;
                }
                for (ProcessListener processListener : this.d) {
                    executionResult.getProcessHandler().addProcessListener(processListener);
                }
                this.d.clear();
                if (this.j.length() > 0) {
                    this.c(this.j.toString());
                    this.j.setLength(0);
                }
            }
        }
        catch (ExecutionException executionException) {
            this.e();
            throw executionException;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return executionResult;
        }
        return executionResult;
    }

    private void e() {
        if (this.e.compareAndSet(false, true)) {
            this.stop(false);
        }
    }

    private void a(DebugEnvironment debugEnvironment) {
        final String string = debugEnvironment.getSessionName();
        final long l2 = debugEnvironment.getPollTimeout();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void connectorIsReady() {
                atomicBoolean.set(true);
                semaphore.up();
                DebugProcessImpl.this.myDebugProcessDispatcher.removeListener((EventListener)((Object)this));
            }
        });
        DebuggerManagerEx.getInstanceEx(this.y).getBreakpointManager().reloadBreakpoints();
        this.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                VirtualMachine virtualMachine = null;
                try {
                    long l22 = System.currentTimeMillis();
                    while (true) {
                        try {
                            virtualMachine = DebugProcessImpl.this.b();
                        }
                        catch (ExecutionException executionException) {
                            Object object;
                            if (l2 > 0L && !DebugProcessImpl.this.m.isServerMode() && executionException.getCause() instanceof IOException) {
                                object = this;
                                synchronized (object) {
                                    try {
                                        this.wait(500L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        break;
                                    }
                                }
                            }
                            object = DebugProcessImpl.this.getProcessHandler();
                            boolean bl2 = object != null && (object.isProcessTerminating() || object.isProcessTerminated());
                            DebugProcessImpl.this.e();
                            DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.y, () -> {
                                if (DebugProcessImpl.this.c != null && !bl2 || !atomicBoolean.get()) {
                                    ExecutionUtil.handleExecutionError((Project)DebugProcessImpl.this.y, (String)ToolWindowId.DEBUG, (String)string, (Throwable)executionException);
                                }
                            });
                            break;
                            if (System.currentTimeMillis() - l22 < l2) continue;
                        }
                        break;
                    }
                }
                finally {
                    semaphore.up();
                }
                if (virtualMachine != null) {
                    final VirtualMachine virtualMachine2 = virtualMachine;
                    DebugProcessImpl.this.a(() -> DebugProcessImpl.this.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            try {
                                DebugProcessImpl.this.commitVM(virtualMachine2);
                            }
                            catch (VMDisconnectedException vMDisconnectedException) {
                                DebugProcessImpl.this.e();
                            }
                        }
                    }));
                } else {
                    DebugProcessImpl.this.e();
                }
            }

            @Override
            protected void commandCancelled() {
                try {
                    super.commandCancelled();
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
    }

    private void a(final Runnable runnable) {
        class MyProcessAdapter
        extends ProcessAdapter {
            private boolean a = false;
            private static final long b = lb.a(2569618623473598028L, -150872851877131723L, MethodHandles.lookup().lookupClass()).a(21368207698675L);

            MyProcessAdapter() {
            }

            public synchronized void run() {
                if (!this.a) {
                    this.a = true;
                    runnable.run();
                }
                DebugProcessImpl.this.removeProcessListener((ProcessListener)this);
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    MyProcessAdapter.a(0);
                }
                this.run();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = b ^ 0x34B752F75681L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/DebugProcessImpl$1MyProcessAdapter", "startNotified"));
            }
        }
        MyProcessAdapter myProcessAdapter = new MyProcessAdapter();
        this.addProcessListener((ProcessListener)myProcessAdapter);
        if (this.c != null && this.c.getProcessHandler().isStartNotified()) {
            myProcessAdapter.run();
        }
    }

    public boolean isPausePressed() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.x;
        return virtualMachineProxyImpl != null && virtualMachineProxyImpl.isPausePressed();
    }

    @NotNull
    public DebuggerCommandImpl createPauseCommand() {
        PauseCommand pauseCommand = new PauseCommand();
        if (pauseCommand == null) {
            DebugProcessImpl.a(39);
        }
        return pauseCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext) {
        ResumeCommand resumeCommand = this.createResumeCommand(suspendContext, PrioritizedTask.Priority.HIGH);
        if (resumeCommand == null) {
            DebugProcessImpl.a(40);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext, final PrioritizedTask.Priority priority) {
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        ResumeCommand resumeCommand = new ResumeCommand(suspendContext){

            @Override
            public void contextAction() {
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, null);
                if (DebugProcessImpl.this.myReturnValueWatcher != null) {
                    DebugProcessImpl.this.myReturnValueWatcher.clear();
                }
                super.contextAction();
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return priority;
            }
        };
        if (resumeCommand == null) {
            DebugProcessImpl.a(41);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        ResumeCommand resumeCommand = this.createStepOverCommand(suspendContext, ignoreBreakpoints, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.a(42);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        StepOverCommand stepOverCommand = new StepOverCommand(suspendContext, ignoreBreakpoints, stepSize);
        if (stepOverCommand == null) {
            DebugProcessImpl.a(43);
        }
        return stepOverCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext) {
        ResumeCommand resumeCommand = this.createStepOutCommand(suspendContext, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.a(44);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
        StepOutCommand stepOutCommand = new StepOutCommand(suspendContext, stepSize);
        if (stepOutCommand == null) {
            DebugProcessImpl.a(45);
        }
        return stepOutCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter) {
        ResumeCommand resumeCommand = this.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.a(46);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter, int stepSize) {
        StepIntoCommand stepIntoCommand = new StepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
        if (stepIntoCommand == null) {
            DebugProcessImpl.a(47);
        }
        return stepIntoCommand;
    }

    @NotNull
    public ResumeCommand createRunToCursorCommand(SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) throws EvaluateException {
        RunToCursorCommand runToCursorCommand;
        long l2 = E ^ 0x6F9631F2F1BAL;
        if (position == null) {
            DebugProcessImpl.a(48);
        }
        if ((runToCursorCommand = new RunToCursorCommand(suspendContext, position, ignoreBreakpoints)).f == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.y).findFile(position.getFile());
            throw new EvaluateException(DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{psiFile != null ? psiFile.getName() : "<No File>", position.getLine()}), null);
        }
        RunToCursorCommand runToCursorCommand2 = runToCursorCommand;
        if (runToCursorCommand2 == null) {
            DebugProcessImpl.a(49);
        }
        return runToCursorCommand2;
    }

    @NotNull
    public DebuggerCommandImpl createFreezeThreadCommand(ThreadReferenceProxyImpl thread) {
        FreezeThreadCommand freezeThreadCommand = new FreezeThreadCommand(thread);
        if (freezeThreadCommand == null) {
            DebugProcessImpl.a(50);
        }
        return freezeThreadCommand;
    }

    @NotNull
    public SuspendContextCommandImpl createResumeThreadCommand(SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            DebugProcessImpl.a(51);
        }
        ResumeThreadCommand resumeThreadCommand = new ResumeThreadCommand(suspendContext, thread);
        if (resumeThreadCommand == null) {
            DebugProcessImpl.a(52);
        }
        return resumeThreadCommand;
    }

    @NotNull
    public SuspendContextCommandImpl createPopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl stackFrame) {
        PopFrameCommand popFrameCommand = new PopFrameCommand(context, stackFrame);
        if (popFrameCommand == null) {
            DebugProcessImpl.a(53);
        }
        return popFrameCommand;
    }

    @NotNull
    public DebuggerContextImpl getDebuggerContext() {
        DebuggerContextImpl debuggerContextImpl = this.mySession.getContextManager().getContext();
        if (debuggerContextImpl == null) {
            DebugProcessImpl.a(54);
        }
        return debuggerContextImpl;
    }

    public void setXDebugProcess(JavaDebugProcess XDebugProcess2) {
        this.l = XDebugProcess2;
    }

    @Nullable
    public JavaDebugProcess getXdebugProcess() {
        return this.l;
    }

    public boolean areBreakpointsMuted() {
        XDebugSession xDebugSession = this.mySession.getXDebugSession();
        return xDebugSession != null && xDebugSession.areBreakpointsMuted();
    }

    public DebuggerSession getSession() {
        return this.mySession;
    }

    static boolean isResumeOnlyCurrentThread() {
        return DebuggerSettings.getInstance().RESUME_ONLY_CURRENT_THREAD;
    }

    public boolean isEvaluationPossible() {
        return this.getSuspendManager().getPausedContext() != null;
    }

    public void startWatchingMethodReturn(ThreadReferenceProxyImpl thread) {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.enable(thread.getThreadReference());
        }
    }

    void stopWatchingMethodReturn() {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.disable();
        }
    }

    static {
        E = lb.a(6668489985798543454L, 7103169702428155092L, MethodHandles.lookup().lookupClass()).a(142203783117777L);
        long l2 = E ^ 0x5BA6A5839CB9L;
        k = Logger.getInstance((String)"#com.intellij.debugger.engine.DebugProcessImpl");
        String string = System.getProperty("idea.debugger.trace");
        int n2 = 0;
        if (!StringUtil.isEmpty((String)string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("SENDS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 1;
                    continue;
                }
                if ("RAW_SENDS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x1000000;
                    continue;
                }
                if ("RECEIVES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 2;
                    continue;
                }
                if ("RAW_RECEIVES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x2000000;
                    continue;
                }
                if ("EVENTS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 4;
                    continue;
                }
                if ("REFTYPES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 8;
                    continue;
                }
                if ("OBJREFS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x10;
                    continue;
                }
                if ("ALL".compareToIgnoreCase(string2) != 0) continue;
                n2 |= 0xFFFFFF;
            }
        }
        g = n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = E ^ 0x234A243C7C05L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 51: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 51: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objRef";
                break;
            }
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilters";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findConnector";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachineProxy";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processIOException";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendManager";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionManager";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createStopCommand";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createPauseCommand";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createResumeCommand";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepOverCommand";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepOutCommand";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepIntoCommand";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunToCursorCommand";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createFreezeThreadCommand";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createResumeThreadCommand";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopFrameCommand";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerContext";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "versionMatch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processIOException";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeInstanceMethod";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createRunToCursorCommand";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createResumeThreadCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 51: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PopFrameCommand
    extends DebuggerContextCommandImpl {
        private final StackFrameProxyImpl i;
        private static final long j = lb.a(3395850749592914402L, -379659887175227870L, MethodHandles.lookup().lookupClass()).a(179673194983371L);

        PopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl frameProxy) {
            super(context, frameProxy.threadProxy());
            this.i = frameProxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                PopFrameCommand.c(0);
            }
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.i.threadProxy();
            try {
                if (!DebugProcessImpl.this.getSuspendManager().isSuspended(threadReferenceProxyImpl)) {
                    this.notifyCancelled();
                    return;
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.notifyCancelled();
                return;
            }
            if (!suspendContext.suspends(threadReferenceProxyImpl)) {
                suspendContext.postponeCommand(this);
                return;
            }
            if (this.i.isBottom()) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.y, () -> {
                    long l2 = j ^ 0x360ED3259EF0L;
                    Messages.showMessageDialog((Project)DebugProcessImpl.this.y, (String)DebuggerBundle.message((String)"error.pop.bottom.stackframe", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon());
                });
                return;
            }
            try {
                threadReferenceProxyImpl.popFrames(this.i);
            }
            catch (EvaluateException evaluateException) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.y, () -> {
                    long l2 = j ^ 0x48AF72530E88L;
                    Messages.showMessageDialog((Project)DebugProcessImpl.this.y, (String)DebuggerBundle.message((String)"error.pop.stackframe", (Object[])new Object[]{evaluateException.getLocalizedMessage()}), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon());
                });
                k.info((Throwable)evaluateException);
            }
            finally {
                DebugProcessImpl.this.getSuspendManager().popFrame(suspendContext);
            }
        }

        private static /* synthetic */ void c(int n2) {
            long l2 = j ^ 0x6E750E083E41L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$PopFrameCommand", "threadAction"));
        }
    }

    private class FreezeThreadCommand
    extends DebuggerCommandImpl {
        private final ThreadReferenceProxyImpl c;

        FreezeThreadCommand(ThreadReferenceProxyImpl thread) {
            this.c = thread;
        }

        @Override
        protected void action() {
            SuspendManager suspendManager = DebugProcessImpl.this.getSuspendManager();
            if (!suspendManager.isFrozen(this.c)) {
                suspendManager.freezeThread(this.c);
                SuspendContextImpl suspendContextImpl = DebugProcessImpl.this.n.pushSuspendContext(1, 0);
                suspendContextImpl.setThread(this.c.getThreadReference());
                ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
            }
        }
    }

    private class ResumeThreadCommand
    extends SuspendContextCommandImpl {
        private final ThreadReferenceProxyImpl e;
        private static final long f = lb.a(-7351341112178374144L, 1239577915118261348L, MethodHandles.lookup().lookupClass()).a(46902648096909L);

        ResumeThreadCommand(@NotNull SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
            if (thread == null) {
                ResumeThreadCommand.b(0);
            }
            super(suspendContext);
            this.e = thread;
        }

        @Override
        public void contextAction() {
            Set<SuspendContextImpl> set = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), this.e);
            for (SuspendContextImpl suspendContextImpl : set) {
                if (suspendContextImpl.getSuspendPolicy() == 1 && suspendContextImpl.getThread() == this.e) {
                    DebugProcessImpl.this.getSession().getXDebugSession().sessionResumed();
                    DebugProcessImpl.this.getManagerThread().invoke(DebugProcessImpl.this.createResumeCommand(suspendContextImpl));
                    continue;
                }
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContextImpl, this.e);
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = f ^ 0x688E8E4A619CL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/debugger/engine/DebugProcessImpl$ResumeThreadCommand", "<init>"));
        }
    }

    private class PauseCommand
    extends DebuggerCommandImpl {
        PauseCommand() {
        }

        @Override
        public void action() {
            if (!DebugProcessImpl.this.isAttached() || DebugProcessImpl.this.getVirtualMachineProxy().isPausePressed()) {
                return;
            }
            DebugProcessImpl.this.logThreads();
            DebugProcessImpl.this.getVirtualMachineProxy().suspend();
            DebugProcessImpl.this.logThreads();
            SuspendContextImpl suspendContextImpl = DebugProcessImpl.this.n.pushSuspendContext(2, 0);
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
        }
    }

    public abstract class ResumeCommand
    extends SuspendContextCommandImpl {
        @Nullable
        protected final ThreadReferenceProxyImpl myContextThread;
        private static final long i = lb.a(-7462721183022709948L, -3677515204079805978L, MethodHandles.lookup().lookupClass()).a(188677731434115L);

        public ResumeCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
            ThreadReferenceProxyImpl threadReferenceProxyImpl = DebugProcessImpl.this.getDebuggerContext().getThreadProxy();
            this.myContextThread = threadReferenceProxyImpl != null ? threadReferenceProxyImpl : (suspendContext != null ? suspendContext.getThread() : null);
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        public void contextAction() {
            long l2 = i ^ 0x364C406C4896L;
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.process.resumed", (Object[])new Object[0]));
            this.resumeAction();
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).resumed((SuspendContext)this.getSuspendContext());
        }

        protected void resumeAction() {
            DebugProcessImpl.this.getSuspendManager().resume(this.getSuspendContext());
        }

        @Nullable
        public ThreadReferenceProxyImpl getContextThread() {
            return this.myContextThread;
        }

        protected void applyThreadFilter(ThreadReferenceProxy thread) {
            if (this.getSuspendContext().getSuspendPolicy() == 2) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.getProject()).getBreakpointManager();
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, thread.getThreadReference());
            }
        }
    }

    private abstract class StepCommand
    extends ResumeCommand {
        StepCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        protected void resumeAction() {
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            if (suspendContextImpl != null && (suspendContextImpl.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread())) {
                DebugProcessImpl.this.p.startWatching(this.myContextThread);
            }
            if (suspendContextImpl != null && DebugProcessImpl.isResumeOnlyCurrentThread() && suspendContextImpl.getSuspendPolicy() == 2 && this.myContextThread != null) {
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContextImpl, this.myContextThread);
            } else {
                super.resumeAction();
            }
        }
    }

    private class RunToCursorCommand
    extends StepCommand {
        private final RunToCursorBreakpoint f;
        private final boolean e;
        private static final long g = lb.a(-6673698314362639308L, 5323040273916924950L, MethodHandles.lookup().lookupClass()).a(262325985363150L);

        private RunToCursorCommand(@NotNull SuspendContextImpl suspendContext, XSourcePosition position, boolean ignoreBreakpoints) {
            if (position == null) {
                RunToCursorCommand.b(0);
            }
            super(suspendContext);
            this.e = ignoreBreakpoints;
            this.f = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.y).getBreakpointManager().addRunToCursorBreakpoint(position, ignoreBreakpoints);
        }

        @Override
        public void contextAction() {
            long l2 = g ^ 0x30B05396184BL;
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.run.to.cursor", (Object[])new Object[0]));
            DebugProcessImpl.this.cancelRunToCursorBreakpoint();
            if (this.f == null) {
                return;
            }
            if (this.e) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.y).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            this.applyThreadFilter(this.getContextThread());
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            this.f.setSuspendPolicy(suspendContextImpl.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
            DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
            this.f.createRequest(debugProcessImpl);
            DebugProcessImpl.this.setRunToCursorBreakpoint(this.f);
            if (debugProcessImpl.getRequestsManager().getWarning(this.f) == null) {
                super.contextAction();
            } else {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.y, () -> {
                    long l2 = g ^ 0xDA5DCDB4338L;
                    Messages.showErrorDialog((String)DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{this.f.getSourcePosition().getFile().getName(), this.f.getLineIndex() + 1}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
                    DebuggerSession debuggerSession = debugProcessImpl.getSession();
                    debuggerSession.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(debuggerSession, suspendContextImpl), DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null);
                });
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = g ^ 0x6C416D0B2B7EL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/DebugProcessImpl$RunToCursorCommand", "<init>"));
        }
    }

    public class StepOverCommand
    extends StepCommand {
        private final boolean f;
        private final int e;
        private static final long g = lb.a(8461576700803951554L, -1224330998903828871L, MethodHandles.lookup().lookupClass()).a(138771446315574L);

        public StepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
            super(suspendContext);
            this.f = ignoreBreakpoints;
            this.e = stepSize;
        }

        protected int getStepSize() {
            return 2;
        }

        @NotNull
        protected String getStatusText() {
            long l2 = g ^ 0x4249EDCA346L;
            String string = DebuggerBundle.message((String)"status.step.over", (Object[])new Object[0]);
            if (string == null) {
                StepOverCommand.b(0);
            }
            return string;
        }

        @NotNull
        protected RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread) {
            RequestHint requestHint = new RequestHint(stepThread, suspendContext, 2);
            requestHint.setRestoreBreakpoints(this.f);
            requestHint.setIgnoreFilters(this.f || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            RequestHint requestHint2 = requestHint;
            if (requestHint2 == null) {
                StepOverCommand.b(1);
            }
            return requestHint2;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(this.getStatusText());
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = this.getHint(suspendContextImpl, threadReferenceProxyImpl);
            this.applyThreadFilter(threadReferenceProxyImpl);
            DebugProcessImpl.this.startWatchingMethodReturn(threadReferenceProxyImpl);
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.e, this.getStepSize(), requestHint);
            if (this.f) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.y).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            super.contextAction();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = g ^ 0x4BA7DAC2197EL;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/engine/DebugProcessImpl$StepOverCommand";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHint";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class StepIntoCommand
    extends StepCommand {
        private final boolean h;
        private final MethodFilter f;
        @Nullable
        private final StepIntoBreakpoint e;
        private final int g;
        private static final long j = lb.a(-7782489068470823729L, 8006412238661105722L, MethodHandles.lookup().lookupClass()).a(124409636629561L);

        StepIntoCommand(SuspendContextImpl suspendContext, @Nullable boolean ignoreFilters, MethodFilter methodFilter, int stepSize) {
            super(suspendContext);
            this.h = ignoreFilters || methodFilter != null;
            this.f = methodFilter;
            this.e = methodFilter instanceof BreakpointStepMethodFilter ? DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.y).getBreakpointManager().addStepIntoBreakpoint((BreakpointStepMethodFilter)methodFilter) : null;
            this.g = stepSize;
        }

        @Override
        public void contextAction() {
            long l2 = j ^ 0x6EFF242917A3L;
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.into", (Object[])new Object[0]));
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = this.f != null ? new RequestHint(threadReferenceProxyImpl, suspendContextImpl, this.f) : new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 1);
            requestHint.setResetIgnoreFilters(this.f != null && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            if (this.h) {
                try {
                    DebugProcessImpl.this.mySession.setIgnoreStepFiltersFlag(threadReferenceProxyImpl.frameCount());
                }
                catch (EvaluateException evaluateException) {
                    k.info((Throwable)evaluateException);
                }
            }
            requestHint.setIgnoreFilters(this.h || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(threadReferenceProxyImpl);
            if (this.e != null) {
                this.e.setSuspendPolicy(suspendContextImpl.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
                this.e.createRequest(suspendContextImpl.getDebugProcess());
                this.e.setRequestHint(requestHint);
                DebugProcessImpl.this.setRunToCursorBreakpoint(this.e);
            }
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.g, 1, requestHint);
            super.contextAction();
        }
    }

    private class StepOutCommand
    extends StepCommand {
        private final int e;
        private static final long f = lb.a(5649468659211246582L, -1298010646745118181L, MethodHandles.lookup().lookupClass()).a(105613502025748L);

        StepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
            super(suspendContext);
            this.e = stepSize;
        }

        @Override
        public void contextAction() {
            long l2 = f ^ 0x15278C821877L;
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.out", (Object[])new Object[0]));
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 3);
            requestHint.setIgnoreFilters(DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(threadReferenceProxyImpl);
            DebugProcessImpl.this.startWatchingMethodReturn(threadReferenceProxyImpl);
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.e, 3, requestHint);
            super.contextAction();
        }
    }

    protected class StopCommand
    extends DebuggerCommandImpl {
        private final boolean c;

        public StopCommand(boolean isTerminateTargetVM) {
            this.c = isTerminateTargetVM;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        protected void action() {
            if (DebugProcessImpl.this.isAttached()) {
                VirtualMachineProxyImpl virtualMachineProxyImpl = DebugProcessImpl.this.getVirtualMachineProxy();
                if (!virtualMachineProxyImpl.canBeModified()) {
                    DebugProcessImpl.this.closeProcess(false);
                    return;
                }
                if (this.c) {
                    virtualMachineProxyImpl.exit(-1);
                } else {
                    try {
                        virtualMachineProxyImpl.resume();
                    }
                    finally {
                        virtualMachineProxyImpl.dispose();
                    }
                }
            } else {
                try {
                    DebugProcessImpl.this.c();
                }
                finally {
                    DebugProcessImpl.this.closeProcess(true);
                }
            }
        }
    }

    private abstract class InvokeCommand<E extends Value> {
        private final Method b;
        private final List<Value> a;
        private static final long d = lb.a(-3351052660698642490L, -3742465671308595452L, MethodHandles.lookup().lookupClass()).a(37634869314346L);

        protected InvokeCommand(@NotNull Method method, List<? extends Value> args) {
            if (method == null) {
                InvokeCommand.a(0);
            }
            if (args == null) {
                InvokeCommand.a(1);
            }
            this.b = method;
            this.a = new ArrayList<Value>(args);
        }

        public String toString() {
            long l2 = d ^ 0x64912C3C62ACL;
            return "INVOKE: " + super.toString();
        }

        protected abstract E invokeMethod(int var1, Method var2, List<? extends Value> var3) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;

        E start(EvaluationContextImpl evaluationContext, boolean internalEvaluate) throws EvaluateException {
            while (true) {
                try {
                    return this.startInternal(evaluationContext, internalEvaluate);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    ReferenceType referenceType = null;
                    try {
                        if (!evaluationContext.isAutoLoadClasses()) continue;
                        referenceType = DebugProcessImpl.this.loadClass(evaluationContext, classNotLoadedException.className(), evaluationContext.getClassLoader());
                        continue;
                    }
                    catch (Exception exception) {
                        referenceType = null;
                    }
                    if (referenceType != null) continue;
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
                }
                break;
            }
        }

        E startInternal(EvaluationContextImpl evaluationContext, boolean internalEvaluate) throws EvaluateException, ClassNotLoadedException {
            Iterator<SuspendContextImpl> iterator;
            long l2 = d ^ 0x78D1594FA29AL;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            SuspendContextImpl suspendContextImpl = evaluationContext.getSuspendContext();
            SuspendManagerUtil.assertSuspendContext(suspendContextImpl);
            ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
            if (SuspendManagerUtil.isEvaluating(DebugProcessImpl.this.getSuspendManager(), threadReferenceProxyImpl)) {
                throw EvaluateExceptionUtil.NESTED_EVALUATION_ERROR;
            }
            if (!suspendContextImpl.suspends(threadReferenceProxyImpl)) {
                throw EvaluateExceptionUtil.THREAD_WAS_RESUMED;
            }
            Set<SuspendContextImpl> set = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), threadReferenceProxyImpl);
            ThreadReference threadReference = threadReferenceProxyImpl.getThreadReference();
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationStarted(suspendContextImpl);
            DebugProcessImpl.this.a(suspendContextImpl, this.b, internalEvaluate);
            Object object = null;
            try {
                for (Object object2 : set) {
                    ThreadReferenceProxyImpl object3 = object2.getThread();
                    if (object3 == threadReferenceProxyImpl) continue;
                    if (k.isDebugEnabled()) {
                        k.debug("Resuming " + threadReferenceProxyImpl + " that is paused by " + object3);
                    }
                    k.assertTrue(object3 == null || !threadReference.equals(object3.getThreadReference()));
                    DebugProcessImpl.this.getSuspendManager().resumeThread((SuspendContextImpl)((Object)object2), threadReferenceProxyImpl);
                }
                object = SuspendManagerUtil.prepareForResume(suspendContextImpl);
                suspendContextImpl.setIsEvaluating(evaluationContext);
                DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                iterator = this.a(suspendContextImpl);
            }
            catch (IncompatibleThreadStateException | InternalException | InvalidTypeException | InvocationException | ObjectCollectedException | UnsupportedOperationException exception) {
                try {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                }
                catch (Throwable throwable) {
                    suspendContextImpl.setIsEvaluating(null);
                    if (object != null) {
                        SuspendManagerUtil.restoreAfterResume(suspendContextImpl, object);
                    }
                    for (SuspendContextImpl suspendContextImpl2 : DebugProcessImpl.this.n.getEventContexts()) {
                        if (!set.contains((Object)suspendContextImpl2) || suspendContextImpl2.isEvaluating() || suspendContextImpl2.suspends(threadReferenceProxyImpl)) continue;
                        DebugProcessImpl.this.n.suspendThread(suspendContextImpl2, threadReferenceProxyImpl);
                    }
                    k.debug("getVirtualMachine().clearCaches()");
                    DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                    DebugProcessImpl.this.a(suspendContextImpl, internalEvaluate);
                    ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContextImpl);
                    throw throwable;
                }
            }
            suspendContextImpl.setIsEvaluating(null);
            if (object != null) {
                SuspendManagerUtil.restoreAfterResume(suspendContextImpl, object);
            }
            for (SuspendContextImpl suspendContextImpl3 : DebugProcessImpl.this.n.getEventContexts()) {
                if (!set.contains((Object)suspendContextImpl3) || suspendContextImpl3.isEvaluating() || suspendContextImpl3.suspends(threadReferenceProxyImpl)) continue;
                DebugProcessImpl.this.n.suspendThread(suspendContextImpl3, threadReferenceProxyImpl);
            }
            k.debug("getVirtualMachine().clearCaches()");
            DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
            DebugProcessImpl.this.a(suspendContextImpl, internalEvaluate);
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContextImpl);
            return (E)iterator;
        }

        private E a(SuspendContextImpl suspendContextImpl) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
            long l2 = d ^ 0x415435218562L;
            int n2 = DebugProcessImpl.a(suspendContextImpl);
            Exception[] exceptionArray = new Exception[1];
            Value[] valueArray = new Value[1];
            DebugProcessImpl.this.getManagerThread().startLongProcessAndFork(() -> {
                long l2 = d ^ 0x533E81EA4950L;
                ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                try {
                    try {
                        Mirror mirror;
                        int n3;
                        if (k.isDebugEnabled()) {
                            VirtualMachineProxyImpl virtualMachineProxyImpl = DebugProcessImpl.this.getVirtualMachineProxy();
                            virtualMachineProxyImpl.logThreads();
                            k.debug("Invoke in " + threadReferenceProxyImpl.name());
                            this.a(threadReferenceProxyImpl, suspendContextImpl);
                        }
                        if (this.b.isVarArgs() && (n3 = this.b.argumentTypeNames().size() - 1) >= 0 && this.a.size() > n3) {
                            List<Object> list2;
                            Value value2 = this.a.get(n3);
                            if (this.a.size() == n3 + 1) {
                                if (value2 instanceof ArrayReference && ((ArrayType)(mirror = (ArrayReference)value2).referenceType()).componentType() instanceof InterfaceType && (list2 = this.b.argumentTypeNames()).size() > n3 && ((String)list2.get(n3)).startsWith("java.lang.Object")) {
                                    this.a.remove(n3);
                                    this.a.addAll(mirror.getValues());
                                }
                            } else if (value2 == null) {
                                int n4 = this.a.size();
                                list2 = this.b.argumentTypes();
                                int n5 = list2.size();
                                ArrayType arrayType = (ArrayType)list2.get(list2.size() - 1);
                                int n6 = n4 - n5 + 1;
                                ArrayReference arrayReference = arrayType.newInstance(n6);
                                arrayReference.setValues(0, this.a, n5 - 1, n6);
                                this.a.set(n5 - 1, arrayReference);
                                this.a.subList(n5, n4).clear();
                            }
                        }
                        for (Value value2 : this.a) {
                            if (!(value2 instanceof ArrayReference)) continue;
                            mirror = value2.type();
                            while (mirror instanceof ArrayType) {
                                mirror = ((ArrayType)mirror).componentType();
                            }
                        }
                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                            StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::disableCollection);
                        }
                        if ((g & 1) != 0) {
                            this.a.forEach(Object::toString);
                        }
                        if ((g & 1) != 0) {
                            StreamEx.of(this.a).findAny(ThreadReference.class::isInstance).ifPresent(value -> {
                                long l2 = d ^ 0x384D47E3925CL;
                                System.err.println("[JDI: workaround for invocation of " + this.b + "]");
                                this.b.virtualMachine().setDebugTraceMode(g & 0xFFFFFFFE);
                            });
                        }
                        valueArray[0] = this.invokeMethod(n2, this.b, this.a);
                    }
                    finally {
                        if ((g & 1) != 0) {
                            this.b.virtualMachine().setDebugTraceMode(g);
                        }
                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                            StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::enableCollection);
                        }
                    }
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            });
            if (exceptionArray[0] != null) {
                if (exceptionArray[0] instanceof InvocationException) {
                    throw (InvocationException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof ClassNotLoadedException) {
                    throw (ClassNotLoadedException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof IncompatibleThreadStateException) {
                    throw (IncompatibleThreadStateException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof InvalidTypeException) {
                    throw (InvalidTypeException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)exceptionArray[0];
                }
                k.error("Unexpected exception", new Throwable().initCause(exceptionArray[0]));
            }
            return (E)valueArray[0];
        }

        private void a(ThreadReferenceProxyImpl threadReferenceProxyImpl, SuspendContextImpl suspendContextImpl) {
            k.assertTrue(suspendContextImpl.isEvaluating());
            try {
                boolean bl2 = threadReferenceProxyImpl.isSuspended();
                k.assertTrue(bl2, (Object)threadReferenceProxyImpl);
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = d ^ 0x74E72B0EC475L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "args";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/DebugProcessImpl$InvokeCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL;
        public static final /* enum */ State ATTACHED;
        public static final /* enum */ State DETACHING;
        public static final /* enum */ State DETACHED;
        private static final /* synthetic */ State[] a;

        public static State[] values() {
            return (State[])a.clone();
        }

        public static State valueOf(String name2) {
            return Enum.valueOf(State.class, name2);
        }

        static {
            long l2 = lb.a(2703746980736467912L, 4188377326452225970L, MethodHandles.lookup().lookupClass()).a(731906858030L) ^ 0x53DF43442A58L;
            INITIAL = new State();
            ATTACHED = new State();
            DETACHING = new State();
            DETACHED = new State();
            a = new State[]{INITIAL, ATTACHED, DETACHING, DETACHED};
        }
    }
}

