/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Location;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ContextUtil {
    public static final Key<Boolean> IS_JSP_IMPLICIT;
    private static final Logger a;

    @Nullable
    public static SourcePosition getSourcePosition(@Nullable StackFrameContext context) {
        if (context == null) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)context.getDebugProcess();
        if (debugProcessImpl == null) {
            return null;
        }
        StackFrameProxy stackFrameProxy = context.getFrameProxy();
        if (stackFrameProxy == null) {
            return null;
        }
        Location location = null;
        try {
            location = stackFrameProxy.location();
        }
        catch (Throwable throwable) {
            a.debug(throwable);
        }
        if (location == null) {
            return null;
        }
        return debugProcessImpl.getPositionManager().getSourcePosition(location);
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context) {
        return ContextUtil.getContextElement(context, ContextUtil.getSourcePosition(context));
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context, SourcePosition position) {
        if (a.isDebugEnabled()) {
            SourcePosition sourcePosition = ContextUtil.getSourcePosition(context);
            a.assertTrue(Comparing.equal((Object)sourcePosition, (Object)position));
        }
        return (PsiElement)ReadAction.compute(() -> {
            PsiElement psiElement = ContextUtil.getContextElement(position);
            if (psiElement == null) {
                return null;
            }
            if (psiElement.getLanguage().getAssociatedFileType() != DefaultCodeFragmentFactory.getInstance().getFileType()) {
                return psiElement;
            }
            StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)context.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return psiElement;
            }
            try {
                PsiStatement[] psiStatementArray;
                LocalVariableProxyImpl localVariableProxyImpl2;
                List<LocalVariableProxyImpl> list2 = stackFrameProxyImpl.visibleVariables();
                PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getResolveHelper();
                StringBuilder stringBuilder = null;
                for (LocalVariableProxyImpl localVariableProxyImpl2 : list2) {
                    psiStatementArray = localVariableProxyImpl2.name();
                    if (psiResolveHelper.resolveReferencedVariable((String)psiStatementArray, psiElement) != null) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder("{");
                    }
                    stringBuilder.append(localVariableProxyImpl2.getVariable().typeName()).append(" ").append((String)psiStatementArray).append(";");
                }
                if (stringBuilder == null) {
                    return psiElement;
                }
                stringBuilder.append('}');
                PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)psiElement.getProject());
                localVariableProxyImpl2 = psiElementFactory.createCodeBlockFromText(stringBuilder.toString(), psiElement);
                for (PsiStatement psiStatement : psiStatementArray = localVariableProxyImpl2.getStatements()) {
                    PsiElement[] psiElementArray;
                    if (!(psiStatement instanceof PsiDeclarationStatement)) continue;
                    PsiDeclarationStatement psiDeclarationStatement = (PsiDeclarationStatement)psiStatement;
                    for (PsiElement psiElement2 : psiElementArray = psiDeclarationStatement.getDeclaredElements()) {
                        psiElement2.putUserData(IS_JSP_IMPLICIT, (Object)Boolean.TRUE);
                    }
                }
                return localVariableProxyImpl2;
            }
            catch (EvaluateException | IncorrectOperationException throwable) {
                return psiElement;
            }
        });
    }

    @Nullable
    public static PsiElement getContextElement(@Nullable SourcePosition position) {
        return position == null ? null : position.getElementAt();
    }

    public static boolean isJspImplicit(PsiElement element) {
        return Boolean.TRUE.equals(element.getUserData(IS_JSP_IMPLICIT));
    }

    static {
        long l2 = lb.a(7565906177877030323L, 3068945809595868875L, MethodHandles.lookup().lookupClass()).a(93054058559235L) ^ 0x641648D3F402L;
        IS_JSP_IMPLICIT = new Key("JspImplicit");
        a = Logger.getInstance((String)"#com.intellij.debugger.impl.PositionUtil");
    }
}

