/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import b.a.lb;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;

public class JavaWithRuntimeCastSurrounder
extends JavaExpressionSurrounder {
    private static final long a = lb.a(6167438829066986547L, 4229371244990019288L, MethodHandles.lookup().lookupClass()).a(116925676732991L);

    public String getTemplateDescription() {
        long l2 = a ^ 0xF80DC99C1E9L;
        return CodeInsightBundle.message((String)"surround.with.runtime.type.template", (Object[])new Object[0]);
    }

    public boolean isApplicable(PsiExpression expr) {
        if (!expr.isPhysical()) {
            return false;
        }
        PsiFile psiFile = expr.getContainingFile();
        if (!(psiFile instanceof PsiCodeFragment)) {
            return false;
        }
        if (!DefaultCodeFragmentFactory.isDebuggerFile(psiFile)) {
            return false;
        }
        return RuntimeTypeEvaluator.isSubtypeable(expr);
    }

    public TextRange surroundExpression(Project project2, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        long l2 = a ^ 0x56BF5C7E6D67L;
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null) {
            ProgressWindow progressWindow = new ProgressWindow(true, expr.getProject());
            SurroundWithCastWorker surroundWithCastWorker = new SurroundWithCastWorker(editor, expr, debuggerContextImpl, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            debuggerContextImpl.getDebugProcess().getManagerThread().startProgress(surroundWithCastWorker, progressWindow);
        }
        return null;
    }

    private static class SurroundWithCastWorker
    extends RuntimeTypeEvaluator {
        private final Editor j;
        private static final long k = lb.a(1239834479095122330L, 2275805633807057410L, MethodHandles.lookup().lookupClass()).a(201913229671311L);

        SurroundWithCastWorker(Editor editor, PsiExpression expression, DebuggerContextImpl context, ProgressIndicator indicator) {
            super(editor, (PsiElement)expression, context, indicator);
            this.j = editor;
        }

        @Override
        protected void typeCalculationFinished(@Nullable PsiType type) {
            if (type == null) {
                return;
            }
            this.hold();
            Project project2 = this.myElement.getProject();
            DebuggerInvocationUtil.invokeLater(project2, () -> {
                long l2 = k ^ 0x1B9653F614F5L;
                WriteCommandAction.writeCommandAction((Project)project2).withName(CodeInsightBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0])).run(() -> {
                    long l2 = k ^ 0x9BF91F4C34EL;
                    try {
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)this.myElement.getProject());
                        PsiParenthesizedExpression psiParenthesizedExpression = (PsiParenthesizedExpression)psiElementFactory.createExpressionFromText("((" + type.getCanonicalText() + ")expr)", null);
                        ((PsiTypeCastExpression)psiParenthesizedExpression.getExpression()).getOperand().replace(this.myElement);
                        psiParenthesizedExpression = (PsiParenthesizedExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)psiParenthesizedExpression);
                        PsiExpression psiExpression = (PsiExpression)this.myElement.replace((PsiElement)psiParenthesizedExpression);
                        TextRange textRange = psiExpression.getTextRange();
                        this.j.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                        this.j.getCaretModel().moveToOffset(textRange.getEndOffset());
                        this.j.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                    }
                    finally {
                        this.release();
                    }
                });
            }, this.myProgressIndicator.getModalityState());
        }
    }
}

