/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.VMDisconnectedException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopFrameAction
extends DebuggerAction
implements DumbAware {
    private static final Logger b;
    private static final long c;

    public void actionPerformed(@NotNull AnActionEvent e10) {
        long l2 = c ^ 0x50E3D97546F5L;
        if (e10 == null) {
            PopFrameAction.b(0);
        }
        final Project project2 = (Project)e10.getData(CommonDataKeys.PROJECT);
        final JavaStackFrame javaStackFrame = PopFrameAction.getStackFrame(e10);
        if (javaStackFrame == null || javaStackFrame.getStackFrameProxy().isBottom()) {
            return;
        }
        try {
            final DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(e10.getDataContext());
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            debugProcessImpl.getSession().setSteppingThrough(javaStackFrame.getStackFrameProxy().threadProxy());
            if (PopFrameAction.evaluateFinallyBlocks(project2, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), javaStackFrame, new XDebuggerEvaluator.XEvaluationCallback(){
                private static final long a = lb.a(-7977950039194245614L, -2192069681197442402L, MethodHandles.lookup().lookupClass()).a(229722220040834L);

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        1.a(0);
                    }
                    PopFrameAction.a(debugProcessImpl, debuggerContextImpl, javaStackFrame);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    long l2 = a ^ 0x76C1F5C850DBL;
                    if (errorMessage == null) {
                        1.a(1);
                    }
                    PopFrameAction.showError(project2, DebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}), UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")));
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0x7E9BC74B937BL;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/PopFrameAction$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            })) {
                return;
            }
            PopFrameAction.a(debugProcessImpl, debuggerContextImpl, javaStackFrame);
        }
        catch (NativeMethodException nativeMethodException) {
            Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.native.method.exception", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidStackFrameException | VMDisconnectedException runtimeException) {
            // empty catch block
        }
    }

    static boolean evaluateFinallyBlocks(Project project2, String title, JavaStackFrame stackFrame, XDebuggerEvaluator.XEvaluationCallback callback) {
        List<PsiStatement> list2;
        long l2 = c ^ 0x415339E869DBL;
        if (!"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !(list2 = PopFrameAction.a(project2, stackFrame.getDescriptor().getSourcePosition())).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (PsiStatement psiStatement : list2) {
                stringBuilder.append("\n").append(psiStatement.getText());
            }
            if ("EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME)) {
                PopFrameAction.a(project2, stackFrame, stringBuilder, callback);
                return true;
            }
            int n2 = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)(DebuggerBundle.message((String)"warning.finally.block.detected", (Object[])new Object[0]) + stringBuilder)).project(project2)).icon(Messages.getWarningIcon())).yesText(DebuggerBundle.message((String)"button.execute.finally", (Object[])new Object[0]))).noText(DebuggerBundle.message((String)"button.drop.anyway", (Object[])new Object[0]))).cancelText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0])).doNotAsk(new DialogWrapper.DoNotAskOption(){
                private static final long a = lb.a(-2481040453944752155L, 7348392686112286255L, MethodHandles.lookup().lookupClass()).a(237892815762402L);

                public boolean isToBeShown() {
                    long l2 = a ^ 0x1DCDBA58AD8DL;
                    return !"EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME);
                }

                public void setToBeShown(boolean value, int exitCode) {
                    long l2 = a ^ 0x7C098223C49EL;
                    DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME = !value ? (exitCode == 0 ? "EvaluateFinallyAlways" : "EvaluateFinallyNever") : "EvaluateFinallyAsk";
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    long l2 = a ^ 0x5BFB634F191EL;
                    String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                    if (string == null) {
                        2.a(0);
                    }
                    return string;
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x2FB40C737A84L;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PopFrameAction$2", "getDoNotShowMessage"));
                }
            })).show();
            switch (n2) {
                case 2: {
                    return true;
                }
                case 1: {
                    break;
                }
                case 0: {
                    PopFrameAction.a(project2, stackFrame, stringBuilder, callback);
                    return true;
                }
            }
        }
        return false;
    }

    private static void a(DebugProcessImpl debugProcessImpl, DebuggerContextImpl debuggerContextImpl, JavaStackFrame javaStackFrame) {
        debugProcessImpl.getManagerThread().schedule(debugProcessImpl.createPopFrameCommand(debuggerContextImpl, javaStackFrame.getStackFrameProxy()));
    }

    private static void a(Project project2, JavaStackFrame javaStackFrame, StringBuilder stringBuilder, XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback) {
        long l2 = c ^ 0x2EE964A5199EL;
        XDebuggerEvaluator xDebuggerEvaluator = javaStackFrame.getEvaluator();
        if (xDebuggerEvaluator != null) {
            xDebuggerEvaluator.evaluate((XExpression)XExpressionImpl.fromText((String)stringBuilder.toString(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT), xEvaluationCallback, javaStackFrame.getSourcePosition());
        } else {
            Messages.showMessageDialog((Project)project2, (String)XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
    }

    static void showError(Project project2, String message, String title) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)message, (String)title, (Icon)Messages.getErrorIcon()), ModalityState.any());
    }

    private static List<PsiStatement> a(Project project2, @Nullable SourcePosition sourcePosition) {
        long l2 = c ^ 0x30F24FEBAC41L;
        if (sourcePosition == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiStatement> arrayList = new ArrayList<PsiStatement>();
        PsiElement psiElement = sourcePosition.getFile().findElementAt(sourcePosition.getOffset());
        PsiTryStatement psiTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiTryStatement.class);
        while (psiTryStatement != null) {
            PsiElementFactory psiElementFactory;
            PsiResourceList psiResourceList = psiTryStatement.getResourceList();
            if (psiResourceList != null) {
                psiElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                for (PsiResourceListElement psiResourceListElement : psiResourceList) {
                    String string = PopFrameAction.a(psiResourceListElement);
                    if (string == null) continue;
                    arrayList.add(psiElementFactory.createStatementFromText("if (" + string + " != null) " + string + ".close();", (PsiElement)psiTryStatement));
                }
            }
            if ((psiElementFactory = psiTryStatement.getFinallyBlock()) != null) {
                ContainerUtil.addAll(arrayList, (Object[])psiElementFactory.getStatements());
            }
            psiTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)psiTryStatement, PsiTryStatement.class);
        }
        return arrayList;
    }

    private static String a(PsiResourceListElement psiResourceListElement) {
        long l2 = c ^ 0x23CB81059892L;
        if (psiResourceListElement instanceof PsiResourceVariable) {
            return ((PsiResourceVariable)psiResourceListElement).getName();
        }
        if (psiResourceListElement instanceof PsiResourceExpression) {
            return ((PsiResourceExpression)psiResourceListElement).getExpression().getText();
        }
        b.error("Unknown PsiResourceListElement type: " + psiResourceListElement.getClass());
        return null;
    }

    static JavaStackFrame getStackFrame(AnActionEvent e10) {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = PopFrameAction.c(e10);
        if (stackFrameDescriptorImpl != null) {
            return new JavaStackFrame(stackFrameDescriptorImpl, false);
        }
        return PopFrameAction.a(e10);
    }

    static StackFrameProxyImpl getStackFrameProxy(AnActionEvent e10) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = PopFrameAction.getSelectedNode(e10.getDataContext());
        if (debuggerTreeNodeImpl != null) {
            NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
            if (nodeDescriptorImpl instanceof StackFrameDescriptorImpl) {
                return ((StackFrameDescriptorImpl)nodeDescriptorImpl).getFrameProxy();
            }
        } else {
            JavaStackFrame javaStackFrame = PopFrameAction.a(e10);
            if (javaStackFrame != null) {
                return javaStackFrame.getStackFrameProxy();
            }
        }
        return null;
    }

    @Nullable
    private static StackFrameDescriptorImpl c(AnActionEvent anActionEvent) {
        NodeDescriptorImpl nodeDescriptorImpl;
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = PopFrameAction.getSelectedNode(anActionEvent.getDataContext());
        if (debuggerTreeNodeImpl != null && (nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor()) instanceof StackFrameDescriptorImpl) {
            return (StackFrameDescriptorImpl)nodeDescriptorImpl;
        }
        return null;
    }

    @Nullable
    private static JavaStackFrame a(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 != null) {
            XStackFrame xStackFrame;
            XDebugSession xDebugSession = (XDebugSession)anActionEvent.getData(XDebugSession.DATA_KEY);
            if (xDebugSession == null) {
                xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
            }
            if (xDebugSession != null && (xStackFrame = xDebugSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
                return (JavaStackFrame)xStackFrame;
            }
        }
        return null;
    }

    private static boolean b(AnActionEvent anActionEvent) {
        Object object;
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = PopFrameAction.getSelectedNode(anActionEvent.getDataContext());
        if (debuggerTreeNodeImpl != null && debuggerTreeNodeImpl.getDescriptor() instanceof StackFrameDescriptorImpl && (object = debuggerTreeNodeImpl.getParent()) != null) {
            return ((ThreadDescriptorImpl)((DebuggerTreeNodeImpl)object).getDescriptor()).isAtBreakpoint();
        }
        object = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
        SuspendContextImpl suspendContextImpl = ((DebuggerContextImpl)object).getSuspendContext();
        return suspendContextImpl != null && ((DebuggerContextImpl)object).getThreadProxy() == suspendContextImpl.getThread();
    }

    public void update(@NotNull AnActionEvent e10) {
        long l2 = c ^ 0x5A4F822AECBBL;
        if (e10 == null) {
            PopFrameAction.b(1);
        }
        boolean bl2 = false;
        StackFrameProxyImpl stackFrameProxyImpl = PopFrameAction.getStackFrameProxy(e10);
        if (stackFrameProxyImpl != null && !stackFrameProxyImpl.isBottom()) {
            bl2 = stackFrameProxyImpl.getVirtualMachine().canPopFrames();
        }
        if ((ActionPlaces.isMainMenuOrActionSearch((String)e10.getPlace()) || "DebuggerToolbar".equals(e10.getPlace())) && DebuggerUtilsEx.isInJavaSession(e10)) {
            e10.getPresentation().setEnabled(bl2);
        } else {
            e10.getPresentation().setVisible(bl2);
        }
    }

    static {
        c = lb.a(-21499888187725494L, -6918370387335018859L, MethodHandles.lookup().lookupClass()).a(132416107105896L);
        b = Logger.getInstance(PopFrameAction.class);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        long l2 = c ^ 0x1DA53BE8BC7EL;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/PopFrameAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

