/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import b.a.lb;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessedModulesTable
extends JPanel {
    private JBTable a;
    private MyTableModel c;
    private int[] b;
    private static final long d = lb.a(-6626257807233673176L, 2054979367201517672L, MethodHandles.lookup().lookupClass()).a(233739511616945L);

    public ProcessedModulesTable(Project project2) {
        long l2 = d ^ 0xB86AC5AFD5BL;
        super(new BorderLayout());
        this.a = null;
        this.c = null;
        this.b = null;
        this.c = new MyTableModel(project2);
        this.a = new JBTable((TableModel)this.c);
        this.a.getEmptyText().setText("No modules configured");
        this.a.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.a.setAutoResizeMode(3);
        this.a.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.a.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.c.DIRNAME_COLUMN_INDEX);
        String string = "Generated Sources Directory Name";
        tableColumn.setHeaderValue("Generated Sources Directory Name");
        JTableHeader jTableHeader = this.a.getTableHeader();
        FontMetrics fontMetrics = jTableHeader.getFontMetrics(jTableHeader.getFont());
        int n2 = fontMetrics.stringWidth("Generated Sources Directory Name") + 12;
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2 + 20);
        tableColumn.setCellRenderer(new MyElementColumnCellRenderer());
        TableColumn tableColumn2 = tableColumnModel.getColumn(this.c.ELEMENT_COLUMN_INDEX);
        tableColumn2.setHeaderValue("Module");
        tableColumn2.setCellRenderer(new MyElementColumnCellRenderer());
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.a).disableUpDownActions().setPreferredSize((Dimension)JBUI.size((int)100, (int)155)).createPanel();
        this.add((Component)jPanel, "Center");
        SpeedSearchBase<JBTable> speedSearchBase = new SpeedSearchBase<JBTable>(this.a){
            private static final long a = lb.a(-1678912847865533037L, -9126705350112921767L, MethodHandles.lookup().lookupClass()).a(272575401261420L);

            public int getSelectedIndex() {
                return ProcessedModulesTable.this.a.getSelectedRow();
            }

            protected int convertIndexToModel(int viewIndex) {
                return ProcessedModulesTable.this.a.convertRowIndexToModel(viewIndex);
            }

            @NotNull
            public Object[] getAllElements() {
                int n2 = ProcessedModulesTable.this.c.getRowCount();
                Object[] objectArray = new Object[n2];
                for (int i10 = 0; i10 < n2; ++i10) {
                    objectArray[i10] = ProcessedModulesTable.this.c.getModuleAt(i10);
                }
                if (objectArray == null) {
                    1.a(0);
                }
                return objectArray;
            }

            public String getElementText(Object element) {
                long l2 = a ^ 0x55B3E8FA83F0L;
                return ((Module)element).getName() + " (" + FileUtil.toSystemDependentName((String)((Module)element).getModuleFilePath()) + ")";
            }

            public void selectElement(Object element, String selectedText) {
                int n2 = ProcessedModulesTable.this.c.getRowCount();
                for (int i10 = 0; i10 < n2; ++i10) {
                    if (!element.equals(ProcessedModulesTable.this.c.getModuleAt(i10))) continue;
                    int n3 = ProcessedModulesTable.this.a.convertRowIndexToView(i10);
                    ProcessedModulesTable.this.a.getSelectionModel().setSelectionInterval(n3, n3);
                    TableUtil.scrollSelectionToVisible((JTable)ProcessedModulesTable.this.a);
                    break;
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xA0A43513223L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/options/ProcessedModulesTable$1", "getAllElements"));
            }
        };
        speedSearchBase.setComparator(new SpeedSearchComparator(false));
    }

    public void refresh() {
        this.c.fireTableDataChanged();
    }

    public void refresh(Module element) {
        int n2 = this.c.getElementRow(element);
        if (n2 >= 0) {
            this.c.fireTableRowsUpdated(n2, n2);
        }
    }

    public void saveSelection() {
        this.b = this.a.getSelectedRows();
    }

    public void restoreSelection() {
        if (this.b != null) {
            TableUtil.selectRows((JTable)this.a, (int[])this.b);
            this.b = null;
        }
    }

    public void addModule(Module element, String dirName) {
        this.c.addElement(element, dirName);
        this.a(this.c.getRowCount() - 1);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.a, true));
    }

    public void removeModule(Module element) {
        int n2 = this.c.getElementRow(element);
        if (n2 < 0) {
            return;
        }
        boolean bl2 = this.a.getSelectionModel().isSelectedIndex(n2);
        this.c.removeElement(element);
        if (bl2) {
            int n3 = this.c.getRowCount();
            if (n3 > 0) {
                this.a(n2 % n3);
            } else {
                this.a.getSelectionModel().clearSelection();
            }
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.a, true));
    }

    public void removeAllElements() {
        this.c.removeAllElements();
        this.a.getSelectionModel().clearSelection();
    }

    private void a(int n2) {
        this.a.getSelectionModel().setSelectionInterval(n2, n2);
        this.a.scrollRectToVisible(this.a.getCellRect(n2, 0, true));
    }

    @Nullable
    public Module getSelectedElement() {
        int n2 = this.getSelectedElementRow();
        return n2 < 0 ? null : this.c.getModuleAt(n2);
    }

    public int getSelectedElementRow() {
        return this.a.getSelectedRow();
    }

    public List<Module> getSelectedElements() {
        int[] nArray;
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int n2 : nArray = this.a.getSelectedRows()) {
            if (n2 < 0) continue;
            arrayList.add(this.c.getModuleAt(n2));
        }
        return arrayList;
    }

    public void selectElements(Collection<? extends Module> elements) {
        if (elements.size() == 0) {
            this.a.clearSelection();
            return;
        }
        int[] nArray = this.a(elements);
        TableUtil.selectRows((JTable)this.a, (int[])nArray);
        TableUtil.scrollSelectionToVisible((JTable)this.a);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.a, true));
    }

    private int[] a(Collection<? extends Module> collection) {
        int[] nArray = new int[collection.size()];
        int n2 = 0;
        for (Module module2 : collection) {
            nArray[n2++] = this.c.getElementRow(module2);
        }
        return nArray;
    }

    public List<Pair<Module, String>> getAllModules() {
        int n2 = this.c.getRowCount();
        ArrayList<Pair<Module, String>> arrayList = new ArrayList<Pair<Module, String>>();
        for (int i10 = 0; i10 < n2; ++i10) {
            Module module2 = this.c.getModuleAt(i10);
            arrayList.add((Pair<Module, String>)Pair.create((Object)module2, (Object)this.c.getGenDirName(module2)));
        }
        return arrayList;
    }

    public void sort(Comparator<? super Module> comparator2) {
        this.c.sort(comparator2);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.a.setRowSelectionAllowed(enabled);
        this.c.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor tableCellEditor = this.a.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    public JComponent getComponent() {
        return this.a;
    }

    public void clear() {
        this.c.clear();
    }

    public int getElementCount() {
        return this.c.getRowCount();
    }

    public Module getElementAt(int row) {
        return this.c.getModuleAt(row);
    }

    private class MyElementColumnCellRenderer
    extends DefaultTableCellRenderer {
        private static final long a = lb.a(-1518646719335614152L, -3826644050962173322L, MethodHandles.lookup().lookupClass()).a(202223814531898L);

        private MyElementColumnCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component;
            long l2 = a ^ 0x2732FF90F839L;
            Color color = UIUtil.getTableFocusCellBackground();
            Module module2 = value instanceof Module ? (Module)value : null;
            try {
                UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
                component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (module2 != null) {
                    this.setText(module2.getName() + " (" + FileUtil.toSystemDependentName((String)module2.getModuleFilePath()) + ")");
                }
                if (component instanceof JLabel) {
                    ((JLabel)component).setBorder(noFocusBorder);
                }
            }
            finally {
                UIManager.put("Table.focusCellBackground", color);
            }
            component.setEnabled(ProcessedModulesTable.this.isEnabled());
            if (component instanceof JLabel) {
                Icon icon = module2 != null ? ModuleType.get((Module)module2).getIcon() : null;
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(icon);
                jLabel.setDisabledIcon(icon);
            }
            component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            return component;
        }
    }

    private final class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<Module> c = new ArrayList<Module>();
        private final Map<Module, String> b = new HashMap<Module, String>();
        public final int ELEMENT_COLUMN_INDEX = 0;
        public final int DIRNAME_COLUMN_INDEX = 1;
        private final Project a;
        private static final long d = lb.a(8262830258445592572L, 3123395602835509174L, MethodHandles.lookup().lookupClass()).a(117468517892259L);

        private MyTableModel(Project project2) {
            this.a = project2;
        }

        public void sort(Comparator<? super Module> comparator2) {
            Collections.sort(this.c, comparator2);
            this.fireTableDataChanged();
        }

        public List<Module> getAllModules() {
            return Collections.unmodifiableList(this.c);
        }

        public Module getModuleAt(int index) {
            return this.c.get(index);
        }

        public String getGenDirName(Module module2) {
            return this.b.get(module2);
        }

        void addElement(Module module2, String dirName) {
            this.c.add(module2);
            if (dirName != null && dirName.length() > 0) {
                this.b.put(module2, dirName);
            }
            int n2 = this.c.size() - 1;
            this.fireTableRowsInserted(n2, n2);
        }

        public void addRow() {
            long l2 = d ^ 0x6E055D7FD1C3L;
            HashSet<Module> hashSet = new HashSet<Module>(Arrays.asList(ModuleManager.getInstance((Project)this.a).getModules()));
            hashSet.removeAll(this.getAllModules());
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog((Component)ProcessedModulesTable.this, new ArrayList<Module>(hashSet), "ChooseModule");
            if (chooseModulesDialog.showAndGet()) {
                List list2 = chooseModulesDialog.getChosenElements();
                for (Module module2 : list2) {
                    this.addElement(module2, null);
                }
            }
        }

        public void removeRow(int idx) {
            Module module2 = this.c.remove(idx);
            this.b.remove(module2);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void removeElement(Module element) {
            boolean bl2 = this.c.remove(element);
            if (bl2) {
                this.b.remove(element);
                this.fireTableDataChanged();
            }
        }

        public int getElementRow(Module element) {
            return this.c.indexOf(element);
        }

        public void removeAllElements() {
            this.c.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.c.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            Module module2 = this.c.get(rowIndex);
            if (columnIndex == 0) {
                return module2;
            }
            if (columnIndex == 1) {
                return this.b.get(module2);
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                Module module2 = this.c.get(rowIndex);
                if (value != null) {
                    String string = FileUtil.toSystemIndependentName((String)((String)value));
                    while (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    if (string.length() > 0) {
                        this.b.put(module2, string);
                    } else {
                        this.b.remove(module2);
                    }
                } else {
                    this.b.remove(module2);
                }
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return String.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!ProcessedModulesTable.this.isEnabled()) {
                return false;
            }
            return columnIndex == 1;
        }

        public void clear() {
            this.c.clear();
            this.b.clear();
            this.fireTableDataChanged();
        }
    }
}

