/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import b.a.lb;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    private static final Logger a;
    private static final long b;

    public static String quotePath(String path) {
        long l2 = b ^ 0x3C3FF3C18FC5L;
        if (path != null && path.indexOf(32) != -1) {
            path = path.replaceAll("\\\\", "\\\\\\\\");
            path = '\"' + path + '\"';
        }
        return path;
    }

    public static void refreshIOFiles(@NotNull Collection<File> files) {
        if (files == null) {
            CompilerUtil.a(0);
        }
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files);
        }
    }

    public static void refreshIODirectories(@NotNull Collection<File> files) {
        if (files == null) {
            CompilerUtil.a(1);
        }
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files, false, true, null);
        }
    }

    public static void refreshOutputRoots(@NotNull Collection<String> outputRoots) {
        if (outputRoots == null) {
            CompilerUtil.a(2);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        HashSet hashSet = ContainerUtil.newHashSet();
        for (String string : outputRoots) {
            FileAttributes fileAttributes = FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)string));
            VirtualFile virtualFile = localFileSystem.findFileByPath(string);
            if (fileAttributes != null && virtualFile == null) {
                VirtualFile virtualFile2 = localFileSystem.refreshAndFindFileByPath(PathUtil.getParentPath((String)string));
                if (virtualFile2 == null || !hashSet.add(virtualFile2)) continue;
                virtualFile2.getChildren();
                continue;
            }
            if ((fileAttributes != null || virtualFile == null) && (fileAttributes == null || fileAttributes.isDirectory() == virtualFile.isDirectory())) continue;
            hashSet.add(virtualFile);
        }
        if (!hashSet.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, (Collection)hashSet);
        }
    }

    public static void refreshIOFile(File file) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runInContext(CompileContext context, String title, ThrowableRunnable<T> action) throws T {
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        if (title != null) {
            progressIndicator.pushState();
            progressIndicator.setText(title);
        }
        try {
            action.run();
        }
        finally {
            if (title != null) {
                progressIndicator.popState();
            }
        }
    }

    public static void logDuration(String activityName, long duration) {
        long l2 = b ^ 0x30891FEA2453L;
        a.info(activityName + " took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }

    static {
        b = lb.a(-7753957088381191822L, 5378164720891596695L, MethodHandles.lookup().lookupClass()).a(153395568053092L);
        long l2 = b ^ 0xC90D97DA7CDL;
        a = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerUtil");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x1B79D5A95657L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputRoots";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/CompilerUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshIOFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshIODirectories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshOutputRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

