/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import b.a.lb;
import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.server.BuildManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;

public abstract class CompilerReferenceServiceBase<Reader extends CompilerReferenceReader<?>>
implements CompilerReferenceService,
ModificationTracker {
    private static final Logger a;
    protected final Set<FileType> myFileTypes;
    protected final DirtyScopeHolder myDirtyScopeHolder;
    protected final ProjectFileIndex myProjectFileIndex;
    protected final LongAdder myCompilationCount = new LongAdder();
    protected final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    protected final Lock myReadDataLock = this.myLock.readLock();
    protected final Lock myOpenCloseLock = this.myLock.writeLock();
    protected final Project myProject;
    protected final CompilerReferenceReaderFactory<? extends Reader> myReaderFactory;
    protected int myActiveBuilds = 0;
    protected volatile Reader myReader;
    private static final long b;

    public CompilerReferenceServiceBase(Project project2, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager, CompilerReferenceReaderFactory<? extends Reader> readerFactory, BiConsumer<MessageBusConnection, Set<String>> compilationAffectedModulesSubscription) {
        this.myProject = project2;
        this.myReaderFactory = readerFactory;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.myFileTypes = Stream.of(LanguageCompilerRefAdapter.INSTANCES).flatMap(languageCompilerRefAdapter -> languageCompilerRefAdapter.getFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(this, fileDocumentManager, psiDocumentManager, compilationAffectedModulesSubscription);
    }

    public void projectOpened() {
        if (CompilerReferenceService.isEnabled()) {
            this.myDirtyScopeHolder.installVFSListener();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean bl2;
                    boolean bl3;
                    File file = BuildManager.getInstance().getProjectSystemDirectory(this.myProject);
                    boolean bl4 = bl3 = file != null && CompilerReferenceIndex.exists((File)file) && !CompilerReferenceIndex.versionDiffers((File)file, (int)this.myReaderFactory.expectedIndexVersion());
                    if (bl3) {
                        CompileScope compileScope = compilerManager.createProjectCompileScope(this.myProject);
                        bl2 = compilerManager.isUpToDate(compileScope);
                    } else {
                        bl2 = false;
                    }
                    CompilerReferenceServiceBase.executeOnBuildThread(() -> {
                        if (bl2) {
                            this.openReaderIfNeed(IndexOpenReason.UP_TO_DATE_CACHE);
                        } else {
                            this.markAsOutdated(bl3);
                        }
                    });
                });
            }
            Disposer.register((Disposable)this.myProject, () -> this.closeReaderIfNeed(IndexCloseReason.PROJECT_CLOSED));
        }
    }

    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement element) {
        long l2 = b ^ 0x60E39212E703L;
        if (element == null) {
            CompilerReferenceServiceBase.a(0);
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    CompilerReferenceServiceBase.a(46);
                }
                return CachedValueProvider.Result.create((Object)this.buildScopeWithoutReferences(this.getReferentFileIds(element)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        catch (RuntimeException runtimeException) {
            return (GlobalSearchScope)this.onException(runtimeException, "scope without code references");
        }
    }

    @Nullable
    public GlobalSearchScope getScopeWithoutImplicitToStringCodeReferences(@NotNull PsiElement aClass) {
        long l2 = b ^ 0x22D85A5F4525L;
        if (aClass == null) {
            CompilerReferenceServiceBase.a(1);
        }
        if (!this.isServiceEnabledFor(aClass)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
                if (aClass == null) {
                    CompilerReferenceServiceBase.a(45);
                }
                return CachedValueProvider.Result.create((Object)this.buildScopeWithoutReferences(this.getReferentFileIdsViaImplicitToString(aClass)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        catch (RuntimeException runtimeException) {
            return (GlobalSearchScope)this.onException(runtimeException, "scope without implicit toString references");
        }
    }

    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (aClass == null) {
            CompilerReferenceServiceBase.a(2);
        }
        if (searchScope == null) {
            CompilerReferenceServiceBase.a(3);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.a(4);
        }
        return this.getHierarchyInfo(aClass, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (functionalInterface == null) {
            CompilerReferenceServiceBase.a(5);
        }
        if (searchScope == null) {
            CompilerReferenceServiceBase.a(6);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.a(7);
        }
        return this.getHierarchyInfo(functionalInterface, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Nullable
    public Integer getCompileTimeOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        long l2 = b ^ 0x1BB8111D5B16L;
        if (element == null) {
            CompilerReferenceServiceBase.a(8);
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (Integer)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    CompilerReferenceServiceBase.a(43);
                }
                return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(bl2 -> {
                    if (element == null) {
                        CompilerReferenceServiceBase.a(44);
                    }
                    return this.calculateOccurrenceCount(element, (boolean)bl2);
                }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            })).get(isConstructorSuggestion);
        }
        catch (RuntimeException runtimeException) {
            return (Integer)this.onException(runtimeException, "weighting for completion");
        }
    }

    protected Integer calculateOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            CompilerReferenceServiceBase.a(9);
        }
        LanguageCompilerRefAdapter languageCompilerRefAdapter = null;
        if (isConstructorSuggestion && ((languageCompilerRefAdapter = (LanguageCompilerRefAdapter)ReadAction.compute(() -> {
            if (element == null) {
                CompilerReferenceServiceBase.a(42);
            }
            return LanguageCompilerRefAdapter.findAdapter(element);
        })) == null || !languageCompilerRefAdapter.isClass(element))) {
            return null;
        }
        CompilerElementInfo compilerElementInfo = this.asCompilerElements(element, false, false);
        if (compilerElementInfo == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Integer n2 = null;
                return n2;
            }
            if (isConstructorSuggestion) {
                int n3 = 0;
                for (PsiElement psiElement : languageCompilerRefAdapter.getInstantiableConstructors(element)) {
                    CompilerRef compilerRef = languageCompilerRefAdapter.asCompilerRef(psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
                    if (compilerRef == null) continue;
                    n3 += ((CompilerReferenceReader)this.myReader).getOccurrenceCount(compilerRef);
                }
                Integer n4 = ((CompilerReferenceReader)this.myReader).getAnonymousCount((CompilerRef.CompilerClassHierarchyElementDef)compilerElementInfo.searchElements[0], compilerElementInfo.place == ElementPlace.SRC);
                Integer n5 = n4 == null ? n3 : n3 + n4;
                return n5;
            }
            Integer n6 = ((CompilerReferenceReader)this.myReader).getOccurrenceCount(compilerElementInfo.searchElements[0]);
            return n6;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected CompilerHierarchyInfoImpl getHierarchyInfo(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        long l2 = b ^ 0x68E2DF9B8A4EL;
        if (aClass == null) {
            CompilerReferenceServiceBase.a(10);
        }
        if (searchScope == null) {
            CompilerReferenceServiceBase.a(11);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.a(12);
        }
        if (searchType == null) {
            CompilerReferenceServiceBase.a(13);
        }
        if (!this.isServiceEnabledFor((PsiElement)aClass) || searchScope == LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map map2 = (Map)ReadAction.compute(() -> {
                if (aClass == null) {
                    CompilerReferenceServiceBase.a(37);
                }
                if (searchType == null) {
                    CompilerReferenceServiceBase.a(38);
                }
                if (searchFileType == null) {
                    CompilerReferenceServiceBase.a(39);
                }
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
                    if (aClass == null) {
                        CompilerReferenceServiceBase.a(40);
                    }
                    return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(hierarchySearchKey -> {
                        if (aClass == null) {
                            CompilerReferenceServiceBase.a(41);
                        }
                        return this.calculateDirectInheritors(aClass, ((HierarchySearchKey)hierarchySearchKey).a, ((HierarchySearchKey)hierarchySearchKey).b);
                    }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
                })).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (map2 == null) {
                return null;
            }
            GlobalSearchScope globalSearchScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> {
                if (aClass == null) {
                    CompilerReferenceServiceBase.a(36);
                }
                return ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex);
            })) {
                globalSearchScope = globalSearchScope.union((SearchScope)LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(map2, aClass, globalSearchScope, searchScope, this.myProject, searchFileType, searchType);
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (RuntimeException runtimeException) {
            return (CompilerHierarchyInfoImpl)this.onException(runtimeException, "hierarchy");
        }
    }

    protected boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isActive()) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return psiFile != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(psiFile);
    }

    public boolean isActive() {
        return this.myReader != null && CompilerReferenceService.isEnabled();
    }

    protected Map<VirtualFile, SearchId[]> calculateDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        SearchScope searchScope;
        if (aClass == null) {
            CompilerReferenceServiceBase.a(14);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.a(15);
        }
        if (searchType == null) {
            CompilerReferenceServiceBase.a(16);
        }
        if (!((searchScope = aClass.getUseScope()) instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerElementInfo compilerElementInfo = this.asCompilerElements((PsiElement)aClass, false, true);
        if (compilerElementInfo == null) {
            return null;
        }
        CompilerRef compilerRef = compilerElementInfo.searchElements[0];
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Map<VirtualFile, SearchId[]> map2 = null;
                return map2;
            }
            Map<VirtualFile, SearchId[]> map3 = ((CompilerReferenceReader)this.myReader).getDirectInheritors(compilerRef, (GlobalSearchScope)searchScope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map3;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected GlobalSearchScope buildScopeWithoutReferences(@Nullable TIntHashSet referentFileIds) {
        if (referentFileIds == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(referentFileIds, this.myProjectFileIndex).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myDirtyScopeHolder.getDirtyScope())), (FileType[])this.myFileTypes.toArray(FileType.EMPTY_ARRAY));
    }

    @Nullable
    protected TIntHashSet getReferentFileIds(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.a(17);
        }
        return this.getReferentFileIds(element, true, (compilerRef, elementPlace) -> ((CompilerReferenceReader)this.myReader).findReferentFileIds(compilerRef, elementPlace == ElementPlace.SRC));
    }

    @Nullable
    protected TIntHashSet getReferentFileIdsViaImplicitToString(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.a(18);
        }
        return this.getReferentFileIds(element, false, (compilerRef, elementPlace) -> ((CompilerReferenceReader)this.myReader).findFileIdsWithImplicitToString(compilerRef));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TIntHashSet getReferentFileIds(@NotNull PsiElement element, boolean buildHierarchyForLibraryElements, @NotNull ReferentFileSearcher referentFileSearcher) {
        CompilerElementInfo compilerElementInfo;
        if (element == null) {
            CompilerReferenceServiceBase.a(19);
        }
        if (referentFileSearcher == null) {
            CompilerReferenceServiceBase.a(20);
        }
        if ((compilerElementInfo = this.asCompilerElements(element, buildHierarchyForLibraryElements, true)) == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                TIntHashSet tIntHashSet = null;
                return tIntHashSet;
            }
            TIntHashSet tIntHashSet = new TIntHashSet();
            for (TIntHashSet tIntHashSet2 : compilerElementInfo.searchElements) {
                TIntHashSet tIntHashSet3;
                block14: {
                    try {
                        tIntHashSet3 = referentFileSearcher.findReferentFiles((CompilerRef)tIntHashSet2, compilerElementInfo.place);
                        if (tIntHashSet3 != null) break block14;
                        TIntHashSet tIntHashSet4 = null;
                        return tIntHashSet4;
                    }
                    catch (StorageException storageException) {
                        throw new RuntimeException(storageException);
                    }
                }
                tIntHashSet.addAll(tIntHashSet3.toArray());
            }
            TIntHashSet tIntHashSet5 = tIntHashSet;
            return tIntHashSet5;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements, boolean checkNotDirty) {
        if (psiElement == null) {
            CompilerReferenceServiceBase.a(21);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (virtualFile == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace elementPlace = ElementPlace.get(virtualFile, this.myProjectFileIndex);
            if (checkNotDirty && (elementPlace == null || elementPlace == ElementPlace.SRC && this.myDirtyScopeHolder.contains(virtualFile))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageCompilerRefAdapter languageCompilerRefAdapter = LanguageCompilerRefAdapter.findAdapter(virtualFile);
            if (languageCompilerRefAdapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            CompilerRef compilerRef = languageCompilerRefAdapter.asCompilerRef(psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
            if (compilerRef == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (elementPlace == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                List<CompilerRef> list2 = languageCompilerRefAdapter.getHierarchyRestrictedToLibraryScope(compilerRef, psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator(), LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
                CompilerRef[] compilerRefArray = new CompilerRef[list2.size() + 1];
                compilerRefArray[0] = compilerRef;
                int n2 = 1;
                for (CompilerRef compilerRef2 : list2) {
                    compilerRefArray[n2++] = compilerRef2;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(elementPlace, compilerRefArray);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(elementPlace, compilerRef);
            return compilerElementInfo;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    protected void closeReaderIfNeed(IndexCloseReason reason) {
        this.myOpenCloseLock.lock();
        try {
            if (reason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.myActiveBuilds;
                this.myDirtyScopeHolder.compilerActivityStarted();
            }
            if (this.myReader != null) {
                ((CompilerReferenceReader)this.myReader).close(reason == IndexCloseReason.AN_EXCEPTION);
                this.myReader = null;
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    protected void openReaderIfNeed(IndexOpenReason reason) {
        long l2 = b ^ 0x1C4B75789CB0L;
        this.myCompilationCount.increment();
        this.myOpenCloseLock.lock();
        try {
            try {
                switch (reason) {
                    case UP_TO_DATE_CACHE: {
                        this.myDirtyScopeHolder.upToDateChecked(true);
                        break;
                    }
                    case COMPILATION_FINISHED: {
                        this.myDirtyScopeHolder.compilerActivityFinished();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                --this.myActiveBuilds;
                throw runtimeException;
            }
            if (--this.myActiveBuilds == 0 && this.myProject.isOpen()) {
                this.myReader = this.myReaderFactory.create(this.myProject);
                a.info("backward reference index reader " + (this.myReader == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    protected void markAsOutdated(boolean decrementBuildCount) {
        this.myOpenCloseLock.lock();
        try {
            if (decrementBuildCount) {
                --this.myActiveBuilds;
            }
            this.myDirtyScopeHolder.upToDateChecked(false);
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    public ProjectFileIndex getFileIndex() {
        return this.myProjectFileIndex;
    }

    public Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected static void executeOnBuildThread(Runnable compilationFinished) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.a(22);
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        TIntHashSet tIntHashSet = this.getReferentFileIds(element);
        if (tIntHashSet == null) {
            return null;
        }
        THashSet tHashSet = new THashSet();
        tIntHashSet.forEach(arg_0 -> this.a(fileBasedIndex, (Set)tHashSet, arg_0));
        return tHashSet;
    }

    @NotNull
    DirtyScopeHolder getDirtyScopeHolder() {
        DirtyScopeHolder dirtyScopeHolder = this.myDirtyScopeHolder;
        if (dirtyScopeHolder == null) {
            CompilerReferenceServiceBase.a(23);
        }
        return dirtyScopeHolder;
    }

    public Set<Module> getAllDirtyModulesForTest() {
        return this.myDirtyScopeHolder.getAllDirtyModulesForTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.a(24);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            TIntHashSet tIntHashSet = this.getReferentFileIds(element);
            DirtyScopeTestInfo dirtyScopeTestInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(tIntHashSet, dirtyScopeTestInfo, this.myProject);
            return compilerReferenceFindUsagesTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            CompilerReferenceServiceBase.a(25);
        }
        if (scope == null) {
            CompilerReferenceServiceBase.a(26);
        }
        if (fileType == null) {
            CompilerReferenceServiceBase.a(27);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl compilerHierarchyInfoImpl = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
            DirtyScopeTestInfo dirtyScopeTestInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(compilerHierarchyInfoImpl, dirtyScopeTestInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            CompilerReferenceServiceBase.a(28);
        }
        if (scope == null) {
            CompilerReferenceServiceBase.a(29);
        }
        if (fileType == null) {
            CompilerReferenceServiceBase.a(30);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl compilerHierarchyInfoImpl = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
            DirtyScopeTestInfo dirtyScopeTestInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(compilerHierarchyInfoImpl, dirtyScopeTestInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected <T> T onException(@NotNull Exception e10, @NotNull String actionName) {
        Throwable throwable;
        long l2 = b ^ 0x6078206B9001L;
        if (e10 == null) {
            CompilerReferenceServiceBase.a(31);
        }
        if (actionName == null) {
            CompilerReferenceServiceBase.a(32);
        }
        if (e10 instanceof ControlFlowException) {
            throw (RuntimeException)e10;
        }
        a.error("an exception during " + actionName + " calculation", (Throwable)e10);
        Throwable throwable2 = throwable = e10 instanceof RuntimeException ? e10.getCause() : e10;
        if (CompilerReferenceServiceBase.requireIndexRebuild(throwable)) {
            this.closeReaderIfNeed(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    protected static TIntHashSet intersection(@NotNull TIntHashSet set1, @NotNull TIntHashSet set2) {
        if (set1 == null) {
            CompilerReferenceServiceBase.a(33);
        }
        if (set2 == null) {
            CompilerReferenceServiceBase.a(34);
        }
        TIntHashSet tIntHashSet = (TIntHashSet)set1.clone();
        tIntHashSet.retainAll(set2.toArray());
        TIntHashSet tIntHashSet2 = tIntHashSet;
        if (tIntHashSet2 == null) {
            CompilerReferenceServiceBase.a(35);
        }
        return tIntHashSet2;
    }

    protected static boolean requireIndexRebuild(@Nullable Throwable exception) {
        return exception instanceof StorageException || exception instanceof IOException;
    }

    private /* synthetic */ boolean a(FileBasedIndex fileBasedIndex, Set set, int n2) {
        VirtualFile virtualFile = fileBasedIndex.findFileById(this.myProject, n2);
        assert (virtualFile != null);
        set.add(virtualFile);
        return true;
    }

    static {
        b = lb.a(-1478728309184493155L, -4895430072071974566L, MethodHandles.lookup().lookupClass()).a(83703577772394L);
        a = Logger.getInstance(CompilerReferenceServiceBase.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x357DD0C2628CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 23: 
            case 35: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 14: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFileType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterface";
                break;
            }
            case 13: 
            case 16: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referentFileSearcher";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeHolder";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithoutCodeReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithoutImplicitToStringCodeReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeOccurrenceCount";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateOccurrenceCount";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyInfo";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectInheritors";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFileIds";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFileIdsViaImplicitToString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFiles";
                break;
            }
            case 23: 
            case 35: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestFindUsages";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTestHierarchy";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunExpressions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onException";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHierarchyInfo$12";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHierarchyInfo$11";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateOccurrenceCount$8";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompileTimeOccurrenceCount$7";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScopeWithoutImplicitToStringCodeReferences$5";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScopeWithoutCodeReferences$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface ReferentFileSearcher {
        @Nullable
        public TIntHashSet findReferentFiles(@NotNull CompilerRef var1, @NotNull ElementPlace var2) throws StorageException;
    }

    protected static final class IndexOpenReason
    extends Enum<IndexOpenReason> {
        public static final /* enum */ IndexOpenReason COMPILATION_FINISHED;
        public static final /* enum */ IndexOpenReason UP_TO_DATE_CACHE;
        private static final /* synthetic */ IndexOpenReason[] a;

        public static IndexOpenReason[] values() {
            return (IndexOpenReason[])a.clone();
        }

        public static IndexOpenReason valueOf(String name2) {
            return Enum.valueOf(IndexOpenReason.class, name2);
        }

        static {
            long l2 = lb.a(-4853440477632655366L, 764576727552988009L, MethodHandles.lookup().lookupClass()).a(94394448500530L) ^ 0x7F6127C2D41CL;
            COMPILATION_FINISHED = new IndexOpenReason();
            UP_TO_DATE_CACHE = new IndexOpenReason();
            a = new IndexOpenReason[]{COMPILATION_FINISHED, UP_TO_DATE_CACHE};
        }
    }

    protected static final class IndexCloseReason
    extends Enum<IndexCloseReason> {
        public static final /* enum */ IndexCloseReason AN_EXCEPTION;
        public static final /* enum */ IndexCloseReason COMPILATION_STARTED;
        public static final /* enum */ IndexCloseReason PROJECT_CLOSED;
        private static final /* synthetic */ IndexCloseReason[] a;

        public static IndexCloseReason[] values() {
            return (IndexCloseReason[])a.clone();
        }

        public static IndexCloseReason valueOf(String name2) {
            return Enum.valueOf(IndexCloseReason.class, name2);
        }

        static {
            long l2 = lb.a(2424514963490079275L, -993793994501585741L, MethodHandles.lookup().lookupClass()).a(58145915106599L) ^ 0x7861D7B01032L;
            AN_EXCEPTION = new IndexCloseReason();
            COMPILATION_STARTED = new IndexCloseReason();
            PROJECT_CLOSED = new IndexCloseReason();
            a = new IndexCloseReason[]{AN_EXCEPTION, COMPILATION_STARTED, PROJECT_CLOSED};
        }
    }

    protected static class HierarchySearchKey {
        private final CompilerHierarchySearchType b;
        private final FileType a;

        public HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.b = searchType;
            this.a = searchFileType;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            HierarchySearchKey hierarchySearchKey = (HierarchySearchKey)o2;
            return this.b == hierarchySearchKey.b && this.a == hierarchySearchKey.a;
        }

        public int hashCode() {
            return 31 * this.b.hashCode() + this.a.hashCode();
        }
    }

    protected static class CompilerElementInfo {
        public final ElementPlace place;
        public final CompilerRef[] searchElements;

        public CompilerElementInfo(ElementPlace place, CompilerRef ... searchElements) {
            this.place = place;
            this.searchElements = searchElements;
        }
    }

    protected static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final TIntHashSet b;
        private final ProjectFileIndex a;
        private static final long c = lb.a(-813889141383649776L, -7309998845080201358L, MethodHandles.lookup().lookupClass()).a(97473407972119L);

        public ScopeWithoutReferencesOnCompilation(TIntHashSet ids, ProjectFileIndex index) {
            this.b = ids;
            this.a = index;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ScopeWithoutReferencesOnCompilation.a(0);
            }
            return file instanceof VirtualFileWithId && this.a.isInSourceContent(file) && !this.b.contains(((VirtualFileWithId)file).getId());
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ScopeWithoutReferencesOnCompilation.a(1);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x6300E9328E12L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase$ScopeWithoutReferencesOnCompilation";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class ElementPlace
    extends Enum<ElementPlace> {
        public static final /* enum */ ElementPlace SRC;
        public static final /* enum */ ElementPlace LIB;
        private static final /* synthetic */ ElementPlace[] a;

        public static ElementPlace[] values() {
            return (ElementPlace[])a.clone();
        }

        public static ElementPlace valueOf(String name2) {
            return Enum.valueOf(ElementPlace.class, name2);
        }

        public static ElementPlace get(VirtualFile file, ProjectFileIndex index) {
            if (file == null) {
                return null;
            }
            return index.isInSourceContent(file) ? SRC : (index.isInLibrarySource(file) || index.isInLibraryClasses(file) ? LIB : null);
        }

        static {
            long l2 = lb.a(-7668373011904288746L, -4161542317868020033L, MethodHandles.lookup().lookupClass()).a(36964988807346L) ^ 0x4992ADC7053AL;
            SRC = new ElementPlace();
            LIB = new ElementPlace();
            a = new ElementPlace[]{SRC, LIB};
        }
    }
}

