/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompilerIOUtil {
    private static final ThreadLocal<byte[]> a = ThreadLocal.withInitial(() -> new byte[1024]);

    private CompilerIOUtil() {
    }

    public static String readString(DataInput stream2) throws IOException {
        int n2 = stream2.readInt();
        if (n2 == -1) {
            return null;
        }
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        byte[] byArray = a.get();
        while (n3 < n2) {
            int n4 = Math.min((n2 - n3) * 2, byArray.length);
            stream2.readFully(byArray, 0, n4);
            for (int i10 = 0; i10 < n4; i10 += 2) {
                cArray[n3++] = (char)((byArray[i10] << 8) + (byArray[i10 + 1] & 0xFF));
            }
        }
        return new String(cArray);
    }

    public static void writeString(String s2, DataOutput stream2) throws IOException {
        if (s2 == null) {
            stream2.writeInt(-1);
            return;
        }
        int n2 = s2.length();
        stream2.writeInt(n2);
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        byte[] byArray = a.get();
        while (n3 < n2) {
            int n4 = Math.min((n2 - n3) * 2, byArray.length);
            for (int i10 = 0; i10 < n4; i10 += 2) {
                char c10 = s2.charAt(n3++);
                byArray[i10] = (byte)(c10 >>> 8 & 0xFF);
                byArray[i10 + 1] = (byte)(c10 & 0xFF);
            }
            stream2.write(byArray, 0, n4);
        }
    }
}

