/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.plugins.grails.service.GrailsExecutorHolder;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationListener;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;

public final class GrailsApplicationManager
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(GrailsApplicationManager.class);
    private final SimpleModificationTracker myModificationTracker;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectFileIndex myFileIndex;
    private final AtomicReference<Map<VirtualFile, GrailsApplication>> myApplicationsRef;

    public GrailsApplicationManager(@NotNull Project project, @NotNull ProjectFileIndex index) {
        if (project == null) {
            GrailsApplicationManager.$$$reportNull$$$0(0);
        }
        if (index == null) {
            GrailsApplicationManager.$$$reportNull$$$0(1);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        this.myApplicationsRef = new AtomicReference(Collections.emptyMap());
        this.myProject = project;
        this.myFileIndex = index;
    }

    public long getModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    public boolean hasApplications() {
        return !this.getApplicationMap().isEmpty();
    }

    @NotNull
    public Collection<GrailsApplication> getApplications() {
        Collection<GrailsApplication> collection = this.getApplicationMap().values();
        if (collection == null) {
            GrailsApplicationManager.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Map<VirtualFile, GrailsApplication> getApplicationMap() {
        Map<VirtualFile, GrailsApplication> map2 = this.myApplicationsRef.get();
        if (map2 == null) {
            GrailsApplicationManager.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @Nullable
    @Contract(value="null -> null")
    public GrailsApplication findApplication(@Nullable VirtualFile file) {
        if (file == null || !this.hasApplications()) {
            return null;
        }
        for (VirtualFile currentFile = this.myFileIndex.getContentRootForFile(file); currentFile != null; currentFile = currentFile.getParent()) {
            GrailsApplication application = this.getApplicationByRoot(currentFile);
            if (application != null) {
                return application;
            }
            if (currentFile.equals(this.myProject.getBaseDir())) break;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public GrailsApplication getApplicationByRoot(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        return this.getApplicationMap().get(root);
    }

    @NotNull
    public Future<?> queueUpdate() {
        if (LOG.isTraceEnabled()) {
            LOG.debug("Update queued from ", new Throwable());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Update queued from " + new Throwable().getStackTrace()[2]);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(() -> this.doUpdate());
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                GrailsApplicationManager.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(this::doUpdate).expireWhen(() -> this.myProject.isDisposed()).submit((Executor)GrailsExecutorHolder.ourExecutorService);
        if (cancellablePromise == null) {
            GrailsApplicationManager.$$$reportNull$$$0(5);
        }
        return cancellablePromise;
    }

    private void doUpdate() {
        Map<VirtualFile, GrailsApplication> map2;
        Map<VirtualFile, GrailsApplication> oldMap = this.myApplicationsRef.get();
        if (oldMap.equals(map2 = this.doGetApplications())) {
            return;
        }
        if (this.myApplicationsRef.compareAndSet(oldMap, map2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Grails applications recomputed");
                LOG.debug(map2.values().toString());
            }
            oldMap.values().forEach(GrailsApplication::invalidate);
            this.myModificationTracker.incModificationCount();
            ((GrailsApplicationListener)this.myProject.getMessageBus().syncPublisher(GrailsApplicationListener.TOPIC)).applicationsRecomputed();
        } else {
            LOG.warn("Some thread already updated values");
        }
    }

    @NotNull
    private Map<VirtualFile, GrailsApplication> doGetApplications() {
        ProgressManager.checkCanceled();
        Collection appRoots = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"grails-app", (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        if (appRoots.isEmpty()) {
            Map<VirtualFile, GrailsApplication> map2 = Collections.emptyMap();
            if (map2 == null) {
                GrailsApplicationManager.$$$reportNull$$$0(6);
            }
            return map2;
        }
        HashMap result2 = ContainerUtil.newHashMap();
        for (VirtualFile appRoot : appRoots) {
            GrailsApplication application;
            if (!appRoot.isDirectory()) continue;
            ProgressManager.checkCanceled();
            VirtualFile root = appRoot.getParent();
            if (root == null || !root.isDirectory() || (application = GrailsApplicationProvider.createGrailsApplication(this.myProject, root)) == null) continue;
            result2.put(root, application);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            GrailsApplicationManager.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @NotNull
    public static GrailsApplicationManager getInstance(@NotNull Project project) {
        if (project == null) {
            GrailsApplicationManager.$$$reportNull$$$0(8);
        }
        GrailsApplicationManager grailsApplicationManager = (GrailsApplicationManager)ServiceManager.getService((Project)project, GrailsApplicationManager.class);
        if (grailsApplicationManager == null) {
            GrailsApplicationManager.$$$reportNull$$$0(9);
        }
        return grailsApplicationManager;
    }

    @Nullable
    @Contract(value="null -> null")
    public static GrailsApplication findApplication(@Nullable PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            return null;
        }
        VirtualFile file = element instanceof PsiFile ? ((PsiFile)element).getOriginalFile().getVirtualFile() : (element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : ((psiFile = element.getContainingFile()) == null ? null : psiFile.getOriginalFile().getVirtualFile()));
        return GrailsApplicationManager.getInstance(element.getProject()).findApplication(file);
    }

    @Nullable
    @Contract(value="null -> null")
    public static OldGrailsApplication findApplication(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        for (GrailsApplication application : GrailsApplicationManager.getInstance(module.getProject()).getApplications()) {
            if (!(application instanceof OldGrailsApplication) || !((OldGrailsApplication)application).getModule().equals(module)) continue;
            return (OldGrailsApplication)application;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/structure/GrailsApplicationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/structure/GrailsApplicationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "queueUpdate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetApplications";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

