/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.spring.InjectedSpringBeanProvider;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class SpringBeanReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SpringBeanReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters == null) {
            SpringBeanReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SpringBeanReferenceSearcher.$$$reportNull$$$0(1);
        }
        PsiElement element = queryParameters.getElementToSearch();
        SearchScope scope2 = queryParameters.getEffectiveSearchScope();
        if (!(scope2 instanceof GlobalSearchScope)) {
            return;
        }
        CommonSpringBean bean = SpringBeanUtils.getInstance().findBean(element);
        if (bean == null) {
            return;
        }
        String name = bean.getBeanName();
        if (name == null) {
            return;
        }
        Project project = element.getProject();
        GlobalSearchScope originalScope = (GlobalSearchScope)scope2;
        GlobalSearchScope dirScope = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile appRoot;
            if (!originalScope.isSearchInModuleContent(module) || (appRoot = GrailsFramework.getInstance().findAppRoot(module)) == null) continue;
            dirScope = SpringBeanReferenceSearcher.unionWithDir(dirScope, project, appRoot.findChild("grails-app"));
            dirScope = SpringBeanReferenceSearcher.unionWithDir(dirScope, project, appRoot.findChild("test"));
        }
        if (dirScope == null) {
            return;
        }
        for (Module module : GroovyShortNamesCache.getGroovyShortNamesCache((Project)project).getFieldsByName(name, originalScope.intersectWith(dirScope))) {
            SpringBeanPointer pointer = InjectedSpringBeanProvider.getInjectedBean((PsiVariable)module);
            if (pointer == null || !bean.equals(pointer.getSpringBean())) continue;
            ReferencesSearch.search((PsiElement)module).forEach(consumer);
        }
    }

    @Nullable
    private static GlobalSearchScope unionWithDir(@Nullable GlobalSearchScope scope2, Project project, @Nullable VirtualFile dir) {
        if (dir == null) {
            return scope2;
        }
        GlobalSearchScope s2 = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)dir, (boolean)true);
        return scope2 == null ? s2 : scope2.uniteWith(s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/grails/spring/SpringBeanReferenceSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

