/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;

public class GrailsArtifactRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GrailsArtifactRenameProcessor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrClassDefinition)) {
            return false;
        }
        return GrailsArtifact.getType((PsiClass)element) != null;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Module module;
        if (element == null) {
            GrailsArtifactRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            GrailsArtifactRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            GrailsArtifactRenameProcessor.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        String qname = aClass.getQualifiedName();
        if (qname == null) {
            return;
        }
        GrailsArtifact artifact = GrailsArtifact.getType(aClass);
        assert (artifact != null);
        if (!newName.endsWith(artifact.suffix)) {
            return;
        }
        String oldName = aClass.getName();
        for (PsiClass psiClass : GrailsTestUtils.getTestsForArtifact(aClass, true)) {
            String name = psiClass.getName();
            if (!name.startsWith(oldName)) continue;
            allRenames.put((PsiElement)psiClass, newName + name.substring(oldName.length()));
        }
        GlobalSearchScope scope2 = GlobalSearchScope.moduleScope((Module)module).intersectWith(GlobalSearchScopes.projectTestScope((Project)module.getProject()));
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)element.getProject());
        for (String suffix : new String[]{"Test", "Tests", "Spec", "Specification"}) {
            for (PsiClass psiClass : facade.findClasses(qname + suffix, scope2)) {
                allRenames.put((PsiElement)psiClass, newName + suffix);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/GrailsArtifactRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

