/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.create;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrMethodImpl;

public class RelationsCreationsProvider {
    private static final Logger LOG = Logger.getInstance(RelationsCreationsProvider.class);
    private final String newNodeTypeText;
    private final GrTypeDefinition typeDefinition;
    private final Project myProject;
    @NotNull
    private final String enteredName;
    private final GroovyPsiElementFactory factory;

    public RelationsCreationsProvider(String newNodeTypeText, GrTypeDefinition typeDefinition, Project project, @NotNull String enteredName) {
        if (enteredName == null) {
            RelationsCreationsProvider.$$$reportNull$$$0(0);
        }
        this.newNodeTypeText = newNodeTypeText;
        this.typeDefinition = typeDefinition;
        this.myProject = project;
        this.enteredName = enteredName;
        this.factory = GroovyPsiElementFactory.getInstance((Project)this.myProject);
    }

    @NotNull
    public String getEnteredName() {
        String string = this.enteredName;
        if (string == null) {
            RelationsCreationsProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void createHasManyRelation() {
        GrField hasManyField = (GrField)this.typeDefinition.findFieldByName("hasMany", true);
        if (hasManyField == null) {
            this.addNewRelationNode(DomainClassRelationsInfo.Relation.HAS_MANY, null, "[" + this.getEnteredName() + ":" + this.newNodeTypeText + "]");
        } else {
            assert (hasManyField.getInitializerGroovy() instanceof GrListOrMap);
            GrExpression initializerGroovy = hasManyField.getInitializerGroovy();
            assert (initializerGroovy instanceof GrListOrMap);
            GrListOrMap belongsToList = (GrListOrMap)initializerGroovy;
            GrNamedArgument[] namedArguments = belongsToList.getNamedArguments();
            StringBuilder newInitializerText = new StringBuilder();
            newInitializerText.append("[");
            for (int i2 = 0; i2 < namedArguments.length; ++i2) {
                GrNamedArgument namedArgument = namedArguments[i2];
                GrExpression initializer = namedArgument.getExpression();
                GrArgumentLabel argumentLabel = namedArgument.getLabel();
                assert (argumentLabel != null);
                newInitializerText.append(argumentLabel.getText());
                newInitializerText.append(": ");
                newInitializerText.append(initializer.getText());
                if (i2 == namedArguments.length - 1) continue;
                newInitializerText.append(", ");
            }
            newInitializerText.append(", ");
            newInitializerText.append(this.getEnteredName());
            newInitializerText.append(": ");
            newInitializerText.append(this.newNodeTypeText);
            newInitializerText.append("]");
            this.addNewRelationNode(DomainClassRelationsInfo.Relation.HAS_MANY, hasManyField, newInitializerText.toString());
        }
    }

    public void createBelongsToRelation() {
        GrField belongsToField = (GrField)this.typeDefinition.findFieldByName("belongsTo", true);
        if (belongsToField == null) {
            this.addNewRelationNode(DomainClassRelationsInfo.Relation.BELONGS_TO, null, "[" + this.newNodeTypeText + "]");
        } else if (!(belongsToField.getInitializerGroovy() instanceof GrListOrMap)) {
            GrExpression initializerGroovy = belongsToField.getInitializerGroovy();
            assert (initializerGroovy != null);
            String newInitializerText = "[" + initializerGroovy.getText() + ", " + this.newNodeTypeText + "]";
            this.addNewRelationNode(DomainClassRelationsInfo.Relation.BELONGS_TO, belongsToField, newInitializerText);
        } else {
            GrExpression initializerGroovy = belongsToField.getInitializerGroovy();
            assert (initializerGroovy instanceof GrListOrMap);
            GrListOrMap belongsToList = (GrListOrMap)initializerGroovy;
            GrExpression[] belongsToListInitializers = belongsToList.getInitializers();
            String newInitializerText = "[";
            for (int i2 = 0; i2 < belongsToListInitializers.length; ++i2) {
                GrExpression initializer = belongsToListInitializers[i2];
                newInitializerText = newInitializerText + initializer.getText();
                if (i2 == belongsToListInitializers.length - 1) continue;
                newInitializerText = newInitializerText + ", ";
            }
            newInitializerText = newInitializerText + ", " + this.newNodeTypeText;
            newInitializerText = newInitializerText + "]";
            this.addNewRelationNode(DomainClassRelationsInfo.Relation.BELONGS_TO, belongsToField, newInitializerText);
        }
    }

    private void addNewRelationNode(DomainClassRelationsInfo.Relation relationType, GrField oldRelationField, String newInitializerText) {
        if (oldRelationField != null) assert (this.typeDefinition.getBody() == oldRelationField.getParent().getParent());
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
            GrVariableDeclaration treeRelationField = null;
            GrVariableDeclaration treeBelongsToField = null;
            if (DomainClassRelationsInfo.Relation.BELONGS_TO == relationType) {
                treeBelongsToField = this.createRelationFieldDefinition("belongsTo", newInitializerText);
                treeBelongsToField = this.addRelationFieldToPsi(oldRelationField, treeBelongsToField);
                treeRelationField = this.addSimpleVarDeclaration(this.factory.createSimpleVariableDeclaration(this.getEnteredName(), this.newNodeTypeText), (PsiElement)treeBelongsToField);
            } else if (DomainClassRelationsInfo.Relation.HAS_MANY == relationType) {
                treeRelationField = this.createRelationFieldDefinition("hasMany", newInitializerText);
                treeRelationField = this.addRelationFieldToPsi(oldRelationField, treeRelationField);
            } else if (DomainClassRelationsInfo.Relation.STRONG == relationType) {
                GrVariableDeclaration newStrongRelation = this.factory.createSimpleVariableDeclaration(this.enteredName, this.newNodeTypeText);
                treeRelationField = this.addSimpleVarDeclaration(newStrongRelation, this.getAppropriateAnchor());
            }
            if (treeRelationField != null) {
                JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)treeRelationField);
            }
            if (treeBelongsToField != null) {
                JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)treeBelongsToField);
            }
        });
    }

    private GrVariableDeclaration addSimpleVarDeclaration(GrVariableDeclaration simpleVarDef, PsiElement anchor) {
        try {
            return (GrVariableDeclaration)this.typeDefinition.addBefore((PsiElement)simpleVarDef, anchor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private GrVariableDeclaration addRelationFieldToPsi(GrField oldRelationNode, GrVariableDeclaration newBelongsToVarDef) {
        if (oldRelationNode != null) {
            this.typeDefinition.getBody().removeVariable((GrVariable)oldRelationNode);
        }
        PsiElement anchor = this.getAppropriateAnchor();
        try {
            return (GrVariableDeclaration)this.typeDefinition.addBefore((PsiElement)newBelongsToVarDef, anchor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiElement getAppropriateAnchor() {
        PsiElement lastBodyChild;
        GrField[] fields = this.typeDefinition.getFields();
        if (fields.length > 0) {
            GrField field = fields[fields.length - 1];
            assert (field != null);
            lastBodyChild = field.getParent();
        } else {
            PsiMethod[] methods = this.typeDefinition.getMethods();
            lastBodyChild = this.typeDefinition.getBody().getLastChild();
            for (PsiMethod method : methods) {
                if (!(method instanceof GrMethodImpl)) continue;
                lastBodyChild = method;
                break;
            }
        }
        return lastBodyChild;
    }

    private GrVariableDeclaration createRelationFieldDefinition(String name, String initializerText) {
        GrExpression newInitializer = this.factory.createExpressionFromText((CharSequence)initializerText);
        return this.factory.createFieldDeclaration(new String[]{"static"}, name, newInitializer, null);
    }

    public boolean canCreateBelongsToRelation() {
        GrField[] fields;
        for (GrField field : fields = this.typeDefinition.getFields()) {
            PsiType fieldType = field.getType();
            if (fieldType instanceof PsiClassType && this.newNodeTypeText.equals(((PsiClassType)fieldType).getClassName())) {
                return false;
            }
            if (!this.checkForExistingHasManyRelation(field)) continue;
            return false;
        }
        GrVariable belongsTo = (GrVariable)this.typeDefinition.findFieldByName("belongsTo", true);
        if (belongsTo == null) {
            return true;
        }
        GrExpression list = belongsTo.getInitializerGroovy();
        if (list instanceof GrListOrMap) {
            GrExpression[] initializers;
            GrListOrMap initsList = (GrListOrMap)list;
            for (GrExpression expression : initializers = initsList.getInitializers()) {
                if (!this.newNodeTypeText.equals(expression.getText())) continue;
                return false;
            }
        } else if (list instanceof GrReferenceExpression) {
            GrReferenceExpression initializer = (GrReferenceExpression)list;
            if (this.newNodeTypeText.equals(initializer.getReferenceName())) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkForExistingHasManyRelation(GrField field) {
        HashMap<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges = new HashMap<DomainClassNode, List<DomainClassRelationsInfo>>();
        if (DomainClassUtils.isHasManyField(field)) {
            DomainClassUtils.buildHasManySourcesToOutEdgesMap(sourcesToOutEdges, field);
            Collection outEdges = sourcesToOutEdges.values();
            List relationsInfoList = ContainerUtil.flatten(outEdges);
            for (DomainClassRelationsInfo domainClassRelationsInfo : relationsInfoList) {
                if (!this.newNodeTypeText.equals(domainClassRelationsInfo.getTarget().getTypeDefinition().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canCreateHasManyRelation() {
        GrNamedArgument[] arguments;
        GrField hasManyField = (GrField)this.typeDefinition.findFieldByName("hasMany", true);
        if (hasManyField == null) {
            return true;
        }
        GrExpression map2 = hasManyField.getInitializerGroovy();
        assert (map2 instanceof GrListOrMap);
        GrListOrMap namesMap = (GrListOrMap)map2;
        for (GrNamedArgument argument : arguments = namesMap.getNamedArguments()) {
            GrArgumentLabel argumentLabel = argument.getLabel();
            GrExpression type = argument.getExpression();
            assert (argumentLabel != null);
            if (!(type instanceof GrReferenceExpression)) {
                return false;
            }
            if (this.newNodeTypeText.equals(((GrReferenceExpression)type).getReferenceName())) {
                return false;
            }
            if (!this.enteredName.equals(argumentLabel.getText())) continue;
            return false;
        }
        return true;
    }

    public boolean canCreateStrongRelation() {
        GrField[] fields;
        for (GrField field : fields = this.typeDefinition.getFields()) {
            if (this.enteredName.equals(field.getName())) {
                return false;
            }
            if (!this.checkForExistingHasManyRelation(field)) continue;
            return false;
        }
        return true;
    }

    public void createStrongRelation() {
        this.addNewRelationNode(DomainClassRelationsInfo.Relation.STRONG, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enteredName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/perspectives/create/RelationsCreationsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/perspectives/create/RelationsCreationsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnteredName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

