/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.feature.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.feature.forge.FFeature;
import org.jetbrains.plugins.grails.feature.forge.FProfile;
import org.jetbrains.plugins.grails.feature.forge.FVersion;
import org.jetbrains.plugins.grails.feature.forge.GrailsForgeModuleBuilder;
import org.jetbrains.plugins.grails.feature.forge.ImplKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u001a\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002\u001a\f\u0010\u0014\u001a\u00020\u000b*\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "downloadAndExtract", "", "serviceUrl", "", "name", "params", "where", "getForgeVersions", "", "Lorg/jetbrains/plugins/grails/feature/forge/FVersion;", "getJson", "Lcom/google/gson/JsonElement;", "url", "asForgeFeature", "Lorg/jetbrains/plugins/grails/feature/forge/FFeature;", "Lcom/google/gson/JsonObject;", "asForgeProfile", "Lorg/jetbrains/plugins/grails/feature/forge/FProfile;", "asForgeVersion", "intellij.groovy.grails"})
public final class ImplKt {
    private static final Logger LOG;

    private static final JsonElement getJson(String url) {
        Object object = HttpRequests.request((String)url).productNameAsUserAgent().accept("application/json").connect((HttpRequests.RequestProcessor)getJson.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"HttpRequests.request(url\u2026r().parse(jsonReader)\n  }");
        return (JsonElement)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<FVersion> getForgeVersions(@NotNull String serviceUrl) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)serviceUrl, (String)"serviceUrl");
        try {
            void var3_4;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            JsonArray jsonArray = ImplKt.getJson(serviceUrl + "/appData").getAsJsonArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"getJson(\"$serviceUrl/appData\").asJsonArray");
            Iterable iterable = $receiver$iv = (Iterable)jsonArray;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                JsonObject jsonObject = v1.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.asJsonObject");
                FVersion fVersion = ImplKt.asForgeVersion(jsonObject);
                collection.add(fVersion);
            }
            list = (List)var3_4;
        }
        catch (Throwable e) {
            LOG.info(e);
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final FVersion asForgeVersion(@NotNull JsonObject $receiver) {
        void var3_6;
        Collection<FProfile> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        FVersion fVersion;
        JsonElement jsonElement = $receiver.get("version");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"this[\"version\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this[\"version\"].asString");
        JsonElement jsonElement2 = $receiver.get("profiles");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"this[\"profiles\"]");
        JsonArray jsonArray = jsonElement2.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"this[\"profiles\"].asJsonArray");
        Iterable iterable = (Iterable)jsonArray;
        String string2 = string;
        FVersion fVersion2 = fVersion;
        FVersion fVersion3 = fVersion;
        void var2_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsonElement jsonElement3 = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            JsonObject jsonObject = v5.getAsJsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.asJsonObject");
            FProfile fProfile = ImplKt.asForgeProfile(jsonObject);
            collection.add(fProfile);
        }
        collection = (List)var3_6;
        fVersion2(string2, (List<FProfile>)collection);
        return fVersion3;
    }

    /*
     * WARNING - void declaration
     */
    private static final FProfile asForgeProfile(@NotNull JsonObject $receiver) {
        void var3_7;
        Collection<FFeature> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        FProfile fProfile;
        JsonElement jsonElement = $receiver.get("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"this[\"name\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this[\"name\"].asString");
        JsonElement jsonElement2 = $receiver.get("description");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"this[\"description\"]");
        String string2 = jsonElement2.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this[\"description\"].asString");
        JsonElement jsonElement3 = $receiver.get("features");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"this[\"features\"]");
        JsonArray jsonArray = jsonElement3.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"this[\"features\"].asJsonArray");
        Iterable iterable = (Iterable)jsonArray;
        String string3 = string2;
        String string4 = string;
        FProfile fProfile2 = fProfile;
        FProfile fProfile3 = fProfile;
        void var2_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsonElement jsonElement4 = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            void v7 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
            JsonObject jsonObject = v7.getAsJsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.asJsonObject");
            FFeature fFeature = ImplKt.asForgeFeature(jsonObject);
            collection.add(fFeature);
        }
        collection = (List)var3_7;
        fProfile2(string4, string3, (List<FFeature>)collection);
        return fProfile3;
    }

    private static final FFeature asForgeFeature(@NotNull JsonObject $receiver) {
        JsonElement jsonElement = $receiver.get("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"this[\"name\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this[\"name\"].asString");
        JsonElement jsonElement2 = $receiver.get("description");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"this[\"description\"]");
        String string2 = jsonElement2.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this[\"description\"].asString");
        JsonElement jsonElement3 = $receiver.get("required");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"this[\"required\"]");
        boolean bl = jsonElement3.getAsBoolean();
        JsonElement jsonElement4 = $receiver.get("defaultFeature");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"this[\"defaultFeature\"]");
        return new FFeature(string, string2, bl, jsonElement4.getAsBoolean());
    }

    public static final void downloadAndExtract(@NotNull String serviceUrl, @NotNull String name, @NotNull String params, @NotNull String where) {
        Intrinsics.checkParameterIsNotNull((Object)serviceUrl, (String)"serviceUrl");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)where, (String)"where");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        File file = FileUtil.createTempDirectory((String)"grails-application-forge", (String)".tmp", (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtil.createTempDirec\u2026ion-forge\", \".tmp\", true)");
        File tempDir = file;
        File file2 = FileUtil.createTempFile((File)tempDir, (String)name, (String)"downloaded", (boolean)true, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempFile(\u2026\"downloaded\", true, true)");
        File tempFile = file2;
        String downloadUrl = serviceUrl + '/' + name + ".zip?" + params;
        LOG.debug("Starting download: " + downloadUrl);
        HttpRequests.request((String)downloadUrl).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Unit>(tempFile, indicator){
            final /* synthetic */ File $tempFile;
            final /* synthetic */ ProgressIndicator $indicator;

            public final void process(@NotNull HttpRequests.Request request) {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                request.saveToFile(this.$tempFile, this.$indicator);
            }
            {
                this.$tempFile = file;
                this.$indicator = progressIndicator;
            }
        });
        LOG.debug("Download completed, extracting to: " + tempDir);
        ProgressIndicator progressIndicator = indicator;
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"indicator");
        progressIndicator.setText("Extracting...");
        ZipUtil.extract((File)tempFile, (File)tempDir, null);
        File destination = new File(where);
        LOG.debug("Extracting completed, copying to: " + destination);
        FileUtil.copyDir((File)new File(tempDir, name), (File)destination);
        LOG.debug("Copying completed, refreshing " + destination);
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)destination), false, true, null);
        LOG.debug("Refreshing completed");
    }

    static {
        Logger logger = Logger.getInstance(GrailsForgeModuleBuilder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

