/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import icons.JetgroovyIcons;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;

public class GrailsPluginNameCompletionContributor
extends CompletionContributor {
    private static final String[] SCOPES = new String[]{"build", "compile", "runtime", "test", "provided"};
    public static final Pattern DEPENDENCY_FORMAT = Pattern.compile("([^:]*):([^:]*)(?::([^:]*))?");
    private static final ElementPattern<? extends PsiElement> PATTERN = PsiJavaPatterns.psiElement().withParent((ElementPattern)GroovyPatterns.stringLiteral().withParent((ElementPattern)PsiJavaPatterns.psiElement(GrArgumentList.class).withParent((ElementPattern)GroovyPatterns.methodCall().withMethodName((ElementPattern)StandardPatterns.string().oneOf(SCOPES)).withParent((ElementPattern)PsiJavaPatterns.psiElement(GrClosableBlock.class).withParent((ElementPattern)GroovyPatterns.methodCall().withMethodName("plugins").withParent((ElementPattern)PsiJavaPatterns.psiElement(GrClosableBlock.class).withParent((ElementPattern)GroovyPatterns.groovyAssignmentExpression().operation(GroovyTokenTypes.mASSIGN).left((ElementPattern)PsiJavaPatterns.psiElement().withText("grails.project.dependency.resolution")).inFile((ElementPattern)PlatformPatterns.psiFile().withName("BuildConfig.groovy")))))))));
    private static final ElementPattern<? extends PsiElement> PATTERN_GSTRING = PsiJavaPatterns.psiElement((IElementType)GroovyTokenTypes.mGSTRING_CONTENT).withParent((ElementPattern)PsiJavaPatterns.psiElement((IElementType)GroovyElementTypes.GSTRING_CONTENT).withParent((ElementPattern)PsiJavaPatterns.psiElement(GrStringImpl.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(GrArgumentList.class).withParent((ElementPattern)GroovyPatterns.methodCall().withMethodName((ElementPattern)StandardPatterns.string().oneOf(SCOPES)).withParent((ElementPattern)PsiJavaPatterns.psiElement(GrClosableBlock.class).withParent((ElementPattern)GroovyPatterns.methodCall().withMethodName("plugins").withParent((ElementPattern)PsiJavaPatterns.psiElement(GrClosableBlock.class).withParent((ElementPattern)GroovyPatterns.groovyAssignmentExpression().operation(GroovyTokenTypes.mASSIGN).left((ElementPattern)PsiJavaPatterns.psiElement().withText("grails.project.dependency.resolution")).inFile((ElementPattern)PlatformPatterns.psiFile().withName("BuildConfig.groovy"))))))))));

    public GrailsPluginNameCompletionContributor() {
        GrailsPluginNameCompletionProvider provider = new GrailsPluginNameCompletionProvider();
        this.extend(CompletionType.BASIC, PATTERN, provider);
        this.extend(CompletionType.BASIC, PATTERN_GSTRING, provider);
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            GrailsPluginNameCompletionContributor.$$$reportNull$$$0(0);
        }
        CharSequence text = context.getEditor().getDocument().getCharsSequence();
        for (int i2 = context.getEditor().getCaretModel().getOffset(); i2 < context.getReplacementOffset(); ++i2) {
            if (text.charAt(i2) != ':') continue;
            context.setReplacementOffset(i2);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/config/GrailsPluginNameCompletionContributor", "duringCompletion"));
    }

    private static class GrailsPluginNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GrailsPluginNameCompletionProvider() {
        }

        private static void completePluginName(CompletionParameters parameters, CompletionResultSet result2) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)parameters.getOriginalFile());
            if (module != null) {
                List<MvcPluginDescriptor> plugins = MvcPluginUtil.loadPluginList(module);
                for (MvcPluginDescriptor plugin : plugins) {
                    result2.addElement((LookupElement)LookupElementBuilder.create((String)plugin.getName()).withIcon(JetgroovyIcons.Mvc.Groovy_mvc_plugin));
                }
            }
        }

        private static void completePluginVersion(CompletionParameters parameters, @NotNull String pluginName, CompletionResultSet result2) {
            Module module;
            if (pluginName == null) {
                GrailsPluginNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)parameters.getOriginalFile())) != null) {
                List<MvcPluginDescriptor> plugins = MvcPluginUtil.loadPluginList(module);
                MvcPluginDescriptor plugin = null;
                for (MvcPluginDescriptor p : plugins) {
                    if (!pluginName.equals(p.getName())) continue;
                    plugin = p;
                    break;
                }
                if (plugin != null) {
                    for (MvcPluginDescriptor.Release release : plugin.getReleases()) {
                        LookupElementBuilder lookupElement = LookupElementBuilder.create((String)release.getVersion()).withIcon(JetgroovyIcons.Mvc.Groovy_mvc_plugin);
                        if (release == plugin.getLastRelease()) {
                            lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)1.0);
                        }
                        result2.addElement((LookupElement)lookupElement);
                    }
                }
            }
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            TextRange range;
            PsiElement position;
            PsiElement element;
            if (parameters == null) {
                GrailsPluginNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (context == null) {
                GrailsPluginNameCompletionProvider.$$$reportNull$$$0(2);
            }
            if (result2 == null) {
                GrailsPluginNameCompletionProvider.$$$reportNull$$$0(3);
            }
            if ((element = (position = parameters.getPosition()).getParent()) instanceof GrStringContent) {
                element = element.getParent();
            }
            if (element instanceof GrLiteralImpl) {
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
                range = manipulator.getRangeInElement(element);
                assert (element.getTextRange().equals((Object)position.getTextRange()));
            } else if (element instanceof GrStringImpl) {
                range = new TextRange(0, position.getTextLength());
            } else {
                return;
            }
            String text = range.substring(position.getText());
            Matcher matcher = DEPENDENCY_FORMAT.matcher(text);
            if (!matcher.matches()) {
                return;
            }
            int offset = parameters.getOffset() - position.getTextOffset() - range.getStartOffset();
            if (offset >= matcher.start(2) && offset <= matcher.start(2) + matcher.group(2).length()) {
                GrailsPluginNameCompletionProvider.completePluginName(parameters, result2.withPrefixMatcher(text.substring(matcher.start(2), offset)));
            } else if (matcher.group(3) != null && offset >= matcher.start(3)) {
                GrailsPluginNameCompletionProvider.completePluginVersion(parameters, matcher.group(2), result2.withPrefixMatcher(text.substring(matcher.start(3), offset)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsPluginNameCompletionContributor$GrailsPluginNameCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "completePluginVersion";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

