/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;

public class GrailsAttachSourcesProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(GrailsAttachSourcesProvider.class);

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, PsiFile psiFile) {
        VirtualFile jar = GrailsAttachSourcesProvider.getJarByPsiFile((PsiFile)psiFile);
        if (jar == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        final Library library = GrailsAttachSourcesProvider.getLibraryFromOrderEntriesList(orderEntries);
        if (library == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        VirtualFile grailsHome = GrailsConfigUtils.getGrailsLibraryHome(files);
        if (grailsHome == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        String grailsVersion2 = GrailsConfigUtils.getGrailsVersion(files);
        if (StringUtil.isEmpty((String)grailsVersion2) || "1.4".compareTo(grailsVersion2) > 0) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        String jarNameWithoutExt = jar.getNameWithoutExtension();
        if (!jarNameWithoutExt.endsWith(grailsVersion2)) {
            LOG.warn("Grails JAR name don't end of version [jar:" + jar + ", version: " + grailsVersion2 + "]");
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        String pluginNameWith_ = StringUtil.trimEnd((String)jarNameWithoutExt, (String)grailsVersion2);
        if (!pluginNameWith_.endsWith("-")) {
            LOG.warn("Grails JAR name don't end of version [jar:" + jar + ", version: " + grailsVersion2 + "]");
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        String pluginName = StringUtil.trimEnd((String)pluginNameWith_, (String)"-").trim();
        final String sourceFileName = jarNameWithoutExt + "-sources.jar";
        ApplicationManager.getApplication().assertIsDispatchThread();
        grailsHome.refresh(false, false);
        final VirtualFile grailsHomeSrc = grailsHome.findChild("src");
        if (grailsHomeSrc == null) {
            LOG.warn("Grails home don't contains 'scr' folder");
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        grailsHomeSrc.refresh(false, false);
        VirtualFile srcFile = grailsHomeSrc.findChild(sourceFileName);
        if (srcFile != null) {
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
            if (jarRoot == null || ArrayUtil.contains((Object)jarRoot, (Object[])library.getFiles(OrderRootType.SOURCES))) {
                List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
                if (list == null) {
                    GrailsAttachSourcesProvider.$$$reportNull$$$0(7);
                }
                return list;
            }
            Set<AbstractAttachSourceProvider.AttachExistingSourceAction> set = Collections.singleton(new AbstractAttachSourceProvider.AttachExistingSourceAction((AbstractAttachSourceProvider)this, jarRoot, library, "Attache source from $GRAILS_HOME/src/"));
            if (set == null) {
                GrailsAttachSourcesProvider.$$$reportNull$$$0(8);
            }
            return set;
        }
        String url = "https://repo.grails.org/grails/libs-releases-local/org/grails/" + pluginName + '/' + grailsVersion2 + '/' + sourceFileName;
        Set<1> set = Collections.singleton(new AbstractAttachSourceProvider.DownloadSourcesAction(psiFile.getProject(), "Downloading Grails Sources", url){

            protected void storeFile(byte[] content) {
                try {
                    VirtualFile srcFile = grailsHomeSrc.createChildData((Object)this, sourceFileName);
                    srcFile.setBinaryContent(content);
                    GrailsAttachSourcesProvider.this.addSourceFile(JarFileSystem.getInstance().getJarRootForLocalFile(srcFile), library);
                }
                catch (IOException e) {
                    new Notification(this.myMessageGroupId, "IO Error", "Failed to save " + grailsHomeSrc.getPath() + '/' + sourceFileName, NotificationType.ERROR).notify(this.myProject);
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (set == null) {
            GrailsAttachSourcesProvider.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/GrailsAttachSourcesProvider", "getActions"));
    }
}

