/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.intellij.j2ee.webSphere.client.AppManagementWrapper;
import com.intellij.j2ee.webSphere.client.WebSphereClientException;
import com.intellij.j2ee.webSphere.client.WebSphereClientExceptionSeverity;
import java.io.File;
import java.util.Hashtable;
import java.util.List;

public class AppManagementWrapperImpl
implements AppManagementWrapper {
    private final AdminClient myClient;
    private final AppManagement myAppManagement;
    private final boolean myHasAutoUpload;

    public AppManagementWrapperImpl(AdminClient client, AppManagement appManagement, boolean hasAutoUpload) {
        this.myClient = client;
        this.myAppManagement = appManagement;
        this.myHasAutoUpload = hasAutoUpload;
    }

    public void installApplication(String localEarPath, String appName, String cellName, String nodeName, String serverName, boolean uploadEar, boolean deployEJBs) throws WebSphereClientException {
        try {
            String earPath;
            Hashtable properties = this.createProperties(cellName, nodeName, serverName, deployEJBs);
            if (this.myHasAutoUpload || !uploadEar) {
                properties.put("archive.upload", uploadEar);
                earPath = localEarPath;
            } else {
                properties.put("DeleteSourceEar", Boolean.TRUE);
                earPath = this.uploadEar(localEarPath);
            }
            if (this.checkIfAppExists(appName)) {
                this.myAppManagement.redeployApplication(earPath, appName, properties, null);
            } else {
                this.myAppManagement.installApplication(earPath, appName, properties, null);
            }
        }
        catch (AdminException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    private String uploadEar(String localEarPath) throws AdminException {
        FileTransferClient fileTransferClient = FileTransferFactory.getFileTransferClient((AdminClient)this.myClient);
        File ear = new File(localEarPath);
        String fileName = ear.getName();
        try {
            fileTransferClient.uploadFile(ear, fileName);
        }
        catch (TransferFailedException e) {
            throw new AdminException((Throwable)e);
        }
        return fileTransferClient.getServerStagingLocation() + "/" + fileName;
    }

    private Hashtable createProperties(String cellName, String nodeName, String serverName, boolean deployEJBs) {
        Hashtable<String, String> module2Server = new Hashtable<String, String>();
        module2Server.put("*", "WebSphere:cell=" + cellName + ",node=" + nodeName + ",server=" + serverName);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("cell.name", cellName);
        properties.put("moduleToServer", module2Server);
        if (deployEJBs) {
            properties.put("deployejb", Boolean.TRUE);
            Hashtable<String, Boolean> deployOptions = new Hashtable<String, Boolean>();
            deployOptions.put("deployejb.validate", Boolean.TRUE);
            properties.put("deployejb.options", deployOptions);
        }
        return properties;
    }

    public void startApplication(String appName) throws WebSphereClientException {
        try {
            this.myAppManagement.startApplication(appName, new Hashtable(), null);
        }
        catch (AdminException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public void uninstallApplication(String appName) throws WebSphereClientException {
        try {
            this.myAppManagement.uninstallApplication(appName, new Hashtable(), null);
        }
        catch (AdminException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public List getApplicationInfo(String appName) throws WebSphereClientException {
        try {
            return this.myAppManagement.getApplicationInfo(appName, new Hashtable(), null);
        }
        catch (AdminException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public boolean checkIfAppExists(String appName) throws WebSphereClientException {
        try {
            return this.myAppManagement.checkIfAppExists(appName, new Hashtable(), null);
        }
        catch (AdminException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }
}

