/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.ide.TypePresentationService;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=JamElementDelegatingPresentationProvider.class)
public class JamPomTarget
extends DelegatePsiTarget
implements PsiDeclaredTarget,
PomRenameableTarget<JamPomTarget> {
    private final JamElement myElement;
    private final JamStringAttributeElement myNameAttr;

    public JamPomTarget(JamElement element, JamStringAttributeElement nameAttr) {
        super((PsiElement)ObjectUtils.assertNotNull((Object)nameAttr.getPsiElement()));
        this.myElement = element;
        this.myNameAttr = nameAttr;
    }

    @NotNull
    public String getName() {
        String value = this.myNameAttr.getStringValue();
        if (value == null) {
            throw new AssertionError((Object)("Null name for " + this.myElement + "; " + this.myElement.getClass()));
        }
        String string = value;
        if (string == null) {
            JamPomTarget.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JamPomTarget setName(@NotNull String newName) {
        if (newName == null) {
            JamPomTarget.$$$reportNull$$$0(1);
        }
        this.myNameAttr.setStringValue(newName);
        return this;
    }

    public JamElement getJamElement() {
        return this.myElement;
    }

    @Nullable
    public TextRange getNameIdentifierRange() {
        PsiLiteral psiLiteral = this.myNameAttr.getPsiLiteral();
        return psiLiteral == null ? null : ElementManipulators.getValueTextRange((PsiElement)psiLiteral);
    }

    public boolean isWritable() {
        return this.getNavigationElement().isWritable();
    }

    public JamStringAttributeElement getNameAttr() {
        return this.myNameAttr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/JamPomTarget";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/JamPomTarget";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JamElementDelegatingPresentationProvider
    extends PresentationProvider<JamPomTarget> {
        @Nullable
        public Icon getIcon(JamPomTarget target) {
            return TypePresentationService.getService().getIcon((Object)target.getJamElement());
        }

        @Nullable
        public String getTypeName(JamPomTarget target) {
            return TypePresentationService.getService().getTypeName((Object)target.getJamElement());
        }
    }
}

