/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.action;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.cloud.DownloadedResourceManager;
import com.intellij.javaee.openshift.cloud.OS3CloudConfiguration;
import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OS3Util;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.view.OS3TreeStructure;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeAction;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UploadResourceAction
extends ServersTreeAction<ServersTreeNode> {
    private static final Logger LOG = Logger.getInstance(UploadResourceAction.class);

    public UploadResourceAction() {
        super(OSBundle.getText("OS3.action.uploadResource.title", new Object[0]), OSBundle.getText("OS3.action.uploadResource.description", new Object[0]), AllIcons.Actions.MoveUp);
    }

    protected Class<ServersTreeNode> getTargetNodeClass() {
        return ServersTreeNode.class;
    }

    protected boolean isVisible4(ServersTreeNode node) {
        if (!super.isVisible4(node)) {
            return false;
        }
        RemoteServer<?> server = this.getServer(node);
        if (server == null) {
            return false;
        }
        return ObjectUtils.tryCast((Object)server.getConfiguration(), OS3CloudConfiguration.class) != null;
    }

    private RemoteServer<?> getServer(ServersTreeNode node) {
        ServersTreeStructure.RemoteServerNode serverNode = (ServersTreeStructure.RemoteServerNode)ObjectUtils.tryCast((Object)node, ServersTreeStructure.RemoteServerNode.class);
        if (serverNode == null) {
            OS3TreeStructure.OS3DeploymentNode deploymentNode = (OS3TreeStructure.OS3DeploymentNode)((Object)ObjectUtils.tryCast((Object)node, OS3TreeStructure.OS3DeploymentNode.class));
            if (deploymentNode == null) {
                return null;
            }
            serverNode = deploymentNode.getServerNode();
        }
        return serverNode.getServer();
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, @NotNull AnActionEvent e, ServersTreeNode node) {
        if (content == null) {
            UploadResourceAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            UploadResourceAction.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        new Case(content.getProject(), this.getServer(node), e.getDataContext()).perform();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "content";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/openshift/cloud/action/UploadResourceAction";
        objectArray[2] = "doActionPerformed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Case {
        private final Project myProject;
        private final RemoteServer<?> myServer;
        private final DataContext myContext;

        Case(Project project, RemoteServer<?> server, DataContext dataContext) {
            this.myProject = project;
            this.myServer = server;
            this.myContext = dataContext;
        }

        public void perform() {
            List files = ContainerUtil.mapNotNull(DownloadedResourceManager.getInstance(this.myProject).getPaths(), path -> LocalFileSystem.getInstance().findFileByPath(path));
            if (files.isEmpty()) {
                this.chooseAndUpload();
            } else {
                ListPopup popup = this.createPopup(files);
                popup.showInBestPositionFor(this.myContext);
            }
        }

        private void chooseAndUpload() {
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"json");
            FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(chooserDescriptor, this.myProject, null);
            VirtualFile file = (VirtualFile)ArrayUtil.getFirstElement((Object[])fileChooser.choose(this.myProject, new VirtualFile[0]));
            if (file == null) {
                return;
            }
            this.upload(file);
        }

        public void upload(final VirtualFile file) {
            ServerConnection connection = ServerConnectionManager.getInstance().getConnection(this.myServer);
            if (connection == null) {
                return;
            }
            connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

                public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                    if (serverRuntimeInstance == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        String descriptor = VfsUtilCore.loadText((VirtualFile)file);
                        ((OS3ServerRuntimeInstance)serverRuntimeInstance).uploadDescriptor(descriptor);
                    }
                    catch (IOException ex) {
                        LOG.info((Throwable)ex);
                    }
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "serverRuntimeInstance";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/javaee/openshift/cloud/action/UploadResourceAction$Case$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "connected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public ListPopup createPopup(List<VirtualFile> files) {
            ArrayList<VirtualFile> items = new ArrayList<VirtualFile>();
            items.add(null);
            items.addAll(files);
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>("Upload resource descriptor", items){

                public Icon getIconFor(VirtualFile value) {
                    return null;
                }

                @NotNull
                public String getTextFor(VirtualFile value) {
                    String string = value != null ? OS3Util.getRelativeToProjectPath(myProject, VfsUtilCore.virtualToIoFile((VirtualFile)value)) : "Create...";
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (selectedValue == null) {
                            this.chooseAndUpload();
                        } else {
                            this.upload(selectedValue);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/action/UploadResourceAction$Case$2", "getTextFor"));
                }
            });
        }
    }
}

