/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.ManifestTemplateModifier;
import com.springsource.bundlor.util.SimpleParserLogger;
import com.springsource.util.common.StringUtils;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParserFactory;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OsgiProfileManifestTemplateModifier
implements ManifestTemplateModifier {
    private static final String SYSTEM_PACKAGE_IMPORT_VERSION = "0";
    private static final String VERSION = "version";
    private static final String EXCLUDED_IMPORTS = "Excluded-Imports";
    private static final String IMPORT_TEMPLATE = "Import-Template";
    private static final String SYSTEM_PACKAGES = "org.osgi.framework.system.packages";
    private static final String BOOTDELEGATION = "org.osgi.framework.bootdelegation";
    private final List<HeaderDeclaration> systemPackages;
    private final List<HeaderDeclaration> bootDelegation;

    public OsgiProfileManifestTemplateModifier(Properties properties) {
        this.systemPackages = this.parseTemplate(properties.getProperty(SYSTEM_PACKAGES));
        for (HeaderDeclaration headerDeclaration : this.systemPackages) {
            headerDeclaration.getAttributes().put(VERSION, SYSTEM_PACKAGE_IMPORT_VERSION);
        }
        this.bootDelegation = this.parseTemplate(properties.getProperty(BOOTDELEGATION));
    }

    @Override
    public void modify(ManifestContents manifestTemplate) {
        String newValue;
        List<HeaderDeclaration> existingHeaders;
        if (this.systemPackages.size() != 0) {
            existingHeaders = this.parseTemplate(manifestTemplate.getMainAttributes().get(IMPORT_TEMPLATE));
            newValue = this.createValueString(existingHeaders, this.systemPackages);
            manifestTemplate.getMainAttributes().put(IMPORT_TEMPLATE, newValue);
        }
        if (this.bootDelegation.size() != 0) {
            existingHeaders = this.parseTemplate(manifestTemplate.getMainAttributes().get(EXCLUDED_IMPORTS));
            newValue = this.createValueString(existingHeaders, this.bootDelegation);
            manifestTemplate.getMainAttributes().put(EXCLUDED_IMPORTS, newValue);
        }
    }

    private String createValueString(List<HeaderDeclaration> existingHeaders, List<HeaderDeclaration> additionalHeaders) {
        ArrayList<HeaderDeclaration> allHeaders = new ArrayList<HeaderDeclaration>(existingHeaders.size() + additionalHeaders.size());
        allHeaders.addAll(existingHeaders);
        allHeaders.addAll(additionalHeaders);
        StringBuilder sb = new StringBuilder();
        Iterator i = allHeaders.iterator();
        while (i.hasNext()) {
            this.writeHeader((HeaderDeclaration)i.next(), sb);
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private void writeHeader(HeaderDeclaration header, StringBuilder sb) {
        sb.append(header.getNames().get(0));
        this.writeMap(header.getAttributes(), sb, "=");
        this.writeMap(header.getDirectives(), sb, ":=");
    }

    private void writeMap(Map<String, String> map, StringBuilder sb, String delimiter) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(";").append(entry.getKey()).append(delimiter).append("\"").append(entry.getValue()).append("\"");
        }
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            return HeaderParserFactory.newHeaderParser(new SimpleParserLogger()).parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }
}

