/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support;

import com.springsource.bundlor.support.ManifestMerger;
import com.springsource.bundlor.support.PartialManifestResolver;
import com.springsource.bundlor.support.partialmanifest.ReadablePartialManifest;
import com.springsource.bundlor.util.SimpleManifestContents;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardManifestMerger
implements ManifestMerger {
    private final PartialManifestResolver partialManifestResolver;

    public StandardManifestMerger(PartialManifestResolver partialManifestResolver) {
        this.partialManifestResolver = partialManifestResolver;
    }

    @Override
    public ManifestContents merge(ManifestContents existingManifest, ManifestContents manifestTemplate, ManifestContents contributedManifest, ReadablePartialManifest partialManifest, List<String> templateOnlyHeaderNames) {
        SimpleManifestContents manifest = new SimpleManifestContents();
        this.mergeManifests(manifest, existingManifest);
        this.mergeManifests(manifest, manifestTemplate);
        this.mergeManifests(manifest, contributedManifest);
        BundleManifest resolved = this.partialManifestResolver.resolve(manifestTemplate, partialManifest);
        this.mergeManifests(manifest, this.toManifestContents(resolved));
        this.removeTemplateOnlyHeaders(manifest, templateOnlyHeaderNames);
        return manifest;
    }

    private void mergeManifests(ManifestContents base, ManifestContents add) {
        base.getMainAttributes().putAll(add.getMainAttributes());
        for (String sectionName : add.getSectionNames()) {
            base.getAttributesForSection(sectionName).putAll(add.getAttributesForSection(sectionName));
        }
    }

    private ManifestContents toManifestContents(BundleManifest bundleManifest) {
        Dictionary<String, String> headers = bundleManifest.toDictionary();
        SimpleManifestContents manifest = new SimpleManifestContents(headers.get("Manifest-Version"));
        Map<String, String> attributes = manifest.getMainAttributes();
        Enumeration<String> headerNames = headers.keys();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            attributes.put(headerName, headers.get(headerName));
        }
        return manifest;
    }

    private void removeTemplateOnlyHeaders(ManifestContents manifest, List<String> names) {
        for (String name : names) {
            manifest.getMainAttributes().remove(name);
        }
    }
}

