/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.shared;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.shared.BidiFormatterBase;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import java.util.HashMap;

public class SafeHtmlBidiFormatter
extends BidiFormatterBase {
    private static Factory factory = new Factory();
    private static HashMap<String, SafeHtml> cachedSafeHtmlValues = null;

    public static SafeHtmlBidiFormatter getInstance(boolean rtlContext) {
        return SafeHtmlBidiFormatter.getInstance(rtlContext, false);
    }

    public static SafeHtmlBidiFormatter getInstance(boolean rtlContext, boolean alwaysSpan) {
        return SafeHtmlBidiFormatter.getInstance(rtlContext ? HasDirection.Direction.RTL : HasDirection.Direction.LTR, alwaysSpan);
    }

    public static SafeHtmlBidiFormatter getInstance(HasDirection.Direction contextDir) {
        return SafeHtmlBidiFormatter.getInstance(contextDir, false);
    }

    public static SafeHtmlBidiFormatter getInstance(HasDirection.Direction contextDir, boolean alwaysSpan) {
        return (SafeHtmlBidiFormatter)factory.getInstance(contextDir, alwaysSpan);
    }

    public static SafeHtmlBidiFormatter getInstanceForCurrentLocale() {
        return SafeHtmlBidiFormatter.getInstanceForCurrentLocale(false);
    }

    public static SafeHtmlBidiFormatter getInstanceForCurrentLocale(boolean alwaysSpan) {
        return SafeHtmlBidiFormatter.getInstance(LocaleInfo.getCurrentLocale().isRTL(), alwaysSpan);
    }

    private SafeHtmlBidiFormatter(HasDirection.Direction contextDir, boolean alwaysSpan) {
        super(contextDir, alwaysSpan);
    }

    public SafeHtml dirAttr(SafeHtml html) {
        return this.cachedSafeHtml(this.dirAttrBase(html.asString(), true));
    }

    public SafeHtml dirAttr(String str) {
        return this.cachedSafeHtml(this.dirAttrBase(str, false));
    }

    public SafeHtml endEdge() {
        return this.cachedSafeHtml(this.endEdgeBase());
    }

    public HasDirection.Direction estimateDirection(SafeHtml html) {
        return this.estimateDirection(html.asString(), true);
    }

    public SafeHtml knownDirAttr(HasDirection.Direction dir) {
        return this.cachedSafeHtml(this.knownDirAttrBase(dir));
    }

    public SafeHtml mark() {
        return this.cachedSafeHtml(this.markBase());
    }

    public SafeHtml markAfter(SafeHtml html) {
        return this.cachedSafeHtml(this.markAfterBase(html.asString(), true));
    }

    public SafeHtml markAfter(String str) {
        return this.cachedSafeHtml(this.markAfterBase(str, false));
    }

    public SafeHtml spanWrap(SafeHtml html) {
        return this.spanWrap(html, true);
    }

    public SafeHtml spanWrap(SafeHtml html, boolean dirReset) {
        return SafeHtmlUtils.fromTrustedString(this.spanWrapBase(html.asString(), true, dirReset));
    }

    public SafeHtml spanWrap(String str) {
        return this.spanWrap(str, true);
    }

    public SafeHtml spanWrap(String str, boolean dirReset) {
        return SafeHtmlUtils.fromTrustedString(this.spanWrapBase(str, false, dirReset));
    }

    public SafeHtml spanWrapWithKnownDir(HasDirection.Direction dir, SafeHtml html) {
        return this.spanWrapWithKnownDir(dir, html, true);
    }

    public SafeHtml spanWrapWithKnownDir(HasDirection.Direction dir, SafeHtml html, boolean dirReset) {
        return SafeHtmlUtils.fromTrustedString(this.spanWrapWithKnownDirBase(dir, html.asString(), true, dirReset));
    }

    public SafeHtml spanWrapWithKnownDir(HasDirection.Direction dir, String str) {
        return this.spanWrapWithKnownDir(dir, str, true);
    }

    public SafeHtml spanWrapWithKnownDir(HasDirection.Direction dir, String str, boolean dirReset) {
        return SafeHtmlUtils.fromTrustedString(this.spanWrapWithKnownDirBase(dir, str, false, dirReset));
    }

    public SafeHtml startEdge() {
        return this.cachedSafeHtml(this.startEdgeBase());
    }

    public SafeHtml unicodeWrap(SafeHtml html) {
        return this.unicodeWrap(html, true);
    }

    public SafeHtml unicodeWrap(SafeHtml html, boolean dirReset) {
        return SafeHtmlUtils.fromTrustedString(this.unicodeWrapBase(html.asString(), true, dirReset));
    }

    public SafeHtml unicodeWrap(String str) {
        return this.unicodeWrap(str, true);
    }

    public SafeHtml unicodeWrap(String str, boolean dirReset) {
        return SafeHtmlUtils.fromString(this.unicodeWrapBase(str, false, dirReset));
    }

    public SafeHtml unicodeWrapWithKnownDir(HasDirection.Direction dir, SafeHtml html) {
        return this.unicodeWrapWithKnownDir(dir, html, true);
    }

    public SafeHtml unicodeWrapWithKnownDir(HasDirection.Direction dir, SafeHtml html, boolean dirReset) {
        return SafeHtmlUtils.fromTrustedString(this.unicodeWrapWithKnownDirBase(dir, html.asString(), true, dirReset));
    }

    public SafeHtml unicodeWrapWithKnownDir(HasDirection.Direction dir, String str) {
        return this.unicodeWrapWithKnownDir(dir, str, true);
    }

    public SafeHtml unicodeWrapWithKnownDir(HasDirection.Direction dir, String str, boolean dirReset) {
        return SafeHtmlUtils.fromString(this.unicodeWrapWithKnownDirBase(dir, str, false, dirReset));
    }

    private SafeHtml cachedSafeHtml(String str) {
        SafeHtml entry;
        if (cachedSafeHtmlValues == null) {
            cachedSafeHtmlValues = new HashMap();
        }
        if ((entry = cachedSafeHtmlValues.get(str)) == null) {
            entry = SafeHtmlUtils.fromString(str);
            cachedSafeHtmlValues.put(str, entry);
        }
        return entry;
    }

    static class Factory
    extends BidiFormatterBase.Factory<SafeHtmlBidiFormatter> {
        Factory() {
        }

        @Override
        public SafeHtmlBidiFormatter createInstance(HasDirection.Direction contextDir, boolean alwaysSpan) {
            return new SafeHtmlBidiFormatter(contextDir, alwaysSpan);
        }
    }
}

