/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntUnionPredicate;

public class NumberFormatter {
    private ArrayList<UnicodeString> formatTokens;
    private ArrayList<UnicodeString> punctuationTokens;
    private boolean startsWithPunctuation;
    private static final IntPredicateProxy alphanumeric = IntUnionPredicate.makeUnion(Categories.getCategory("N"), Categories.getCategory("L"));

    public void prepare(String format) {
        if (format.isEmpty()) {
            format = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        UnicodeString uFormat = StringView.tidy(format);
        int len = uFormat.length32();
        int i = 0;
        boolean first = true;
        this.startsWithPunctuation = true;
        while (i < len) {
            int c = uFormat.codePointAt(i);
            int t = i;
            while (NumberFormatter.isLetterOrDigit(c) && ++i != len) {
                c = uFormat.codePointAt(i);
            }
            if (i > t) {
                UnicodeString tok = uFormat.substring(t, i);
                this.formatTokens.add(tok);
                if (first) {
                    this.punctuationTokens.add(BMPString.of("."));
                    this.startsWithPunctuation = false;
                    first = false;
                }
            }
            if (i == len) break;
            t = i;
            c = uFormat.codePointAt(i);
            while (!NumberFormatter.isLetterOrDigit(c)) {
                first = false;
                if (++i == len) break;
                c = uFormat.codePointAt(i);
            }
            if (i <= t) continue;
            UnicodeString sep = uFormat.substring(t, i);
            this.punctuationTokens.add(sep);
        }
        if (this.formatTokens.isEmpty()) {
            this.formatTokens.add(BMPString.of("1"));
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    public static boolean isLetterOrDigit(int c) {
        if (c <= 127) {
            return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122;
        }
        return alphanumeric.test(c);
    }

    public UnicodeString format(List<Object> numbers, int groupSize, String groupSeparator, String letterValue, String ordinal, Numberer numberer) {
        UnicodeBuilder sb = new UnicodeBuilder(32);
        int num = 0;
        int tok = 0;
        if (this.startsWithPunctuation) {
            sb.accept(this.punctuationTokens.get(tok));
        }
        while (num < numbers.size()) {
            String s;
            Object o;
            if (num > 0) {
                if (tok == 0 && this.startsWithPunctuation) {
                    sb.append(".");
                } else {
                    sb.accept(this.punctuationTokens.get(tok));
                }
            }
            if ((o = numbers.get(num++)) instanceof Long) {
                long nr = (Long)o;
                RegularGroupFormatter rgf = new RegularGroupFormatter(groupSize, groupSeparator, EmptyUnicodeString.getInstance());
                s = numberer.format(nr, this.formatTokens.get(tok), rgf, letterValue, ordinal);
            } else if (o instanceof BigInteger) {
                RegularGroupFormatter rgf = new RegularGroupFormatter(groupSize, groupSeparator, EmptyUnicodeString.getInstance());
                s = rgf.format(o.toString());
                s = this.translateDigits(s, this.formatTokens.get(tok));
            } else {
                s = o.toString();
            }
            sb.append(s);
            if (++tok != this.formatTokens.size()) continue;
            --tok;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            sb.accept(this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return sb.toUnicodeString();
    }

    private String translateDigits(String in, UnicodeString picture) {
        if (picture.length() == 0L) {
            return in;
        }
        int formchar = picture.codePointAt(0L);
        int digitValue = Alphanumeric.getDigitValue(formchar);
        if (digitValue >= 0) {
            int zero = formchar - digitValue;
            if (zero == 48) {
                return in;
            }
            int[] digits = new int[10];
            for (int z = 0; z <= 9; ++z) {
                digits[z] = zero + z;
            }
            StringBuilder sb = new StringBuilder(128);
            for (int i = 0; i < in.length(); ++i) {
                char c = in.charAt(i);
                if (c >= '0' && c <= '9') {
                    sb.appendCodePoint(digits[c - 48]);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return in;
    }
}

