/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.inspection.TypeScriptConfigJsonFixBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptConfigEnableOptionFix
extends TypeScriptConfigJsonFixBase {
    @NotNull
    private final String myLibName;
    @NotNull
    private final JsonSchemaType myType;
    @NotNull
    private final String myValueToUse;

    public TypeScriptConfigEnableOptionFix(@NotNull String optionName, @NotNull JsonSchemaType type, @NotNull String defaultValue) {
        if (optionName == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(0);
        }
        if (type == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(1);
        }
        if (defaultValue == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(2);
        }
        this.myLibName = optionName;
        this.myType = type;
        this.myValueToUse = defaultValue;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("typescript.config.inspection.config.options.fix", this.myLibName + ": " + this.getValueToUse());
        if (string == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, TypeScriptConfig config2) {
        JsonObject compilerOptionsValue;
        if (project == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(5);
        }
        if ((compilerOptionsValue = this.getOrCreateCompilerOptionsObject(element, config2)) == null) {
            return;
        }
        JsonProperty property = compilerOptionsValue.findProperty(this.myLibName);
        if (property != null) {
            JsonValue value = property.getValue();
            if (value != null) {
                JsonElementGenerator generator = new JsonElementGenerator(project);
                value.replace((PsiElement)generator.createValue(this.getValueToUse()));
            }
        } else {
            JsonValidationError.MissingPropertyIssueData data = new JsonValidationError.MissingPropertyIssueData(this.myLibName, this.myType, this.myType == JsonSchemaType._string ? this.myValueToUse : Boolean.valueOf(this.myValueToUse), 0);
            TypeScriptConfigEnableOptionFix.createProperty(project, (PsiElement)compilerOptionsValue, data);
        }
    }

    @NotNull
    private String getValueToUse() {
        String string = this.myType == JsonSchemaType._string ? StringUtil.wrapWithDoubleQuote((String)this.myValueToUse) : this.myValueToUse;
        if (string == null) {
            TypeScriptConfigEnableOptionFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptConfigEnableOptionFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigEnableOptionFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueToUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

