/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGoToDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceElement == null) {
            return null;
        }
        Project project = editor.getProject();
        return TypeScriptGoToDeclarationHandler.getResultsFromService(project, sourceElement, editor);
    }

    public static PsiElement @Nullable [] getResultsFromService(@Nullable Project project, @NotNull PsiElement originalElement, @Nullable Editor editor) {
        if (originalElement == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(0);
        }
        if (project == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(originalElement.getProject())) {
            return null;
        }
        VirtualFile virtualFile = originalElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(project, virtualFile);
        if (service == null || !service.checkCanUseService()) {
            return null;
        }
        if (service.isAcceptablePlaceForNavigation(originalElement)) {
            return TypeScriptLanguageServiceUtil.getNavigationFromService(project, editor != null ? editor.getDocument() : null, originalElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getResultsFromService"));
    }
}

