/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSVariableStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSVariableElementType
extends JSStubElementType<JSVariableStub<JSVariable>, JSVariable> {
    public JSVariableElementType() {
        super("VARIABLE");
    }

    public JSVariableElementType(@NonNls String debugName) {
        super(debugName);
    }

    @NotNull
    public JSVariableStub<JSVariable> createStub(@NotNull JSVariable psi, StubElement parentStub) {
        if (psi == null) {
            JSVariableElementType.$$$reportNull$$$0(0);
        }
        return new JSVariableStubImpl(psi, parentStub, this);
    }

    public boolean shouldCreateStub(ASTNode node) {
        return JSVariableElementType.shouldCreateStubForVariable(node);
    }

    @Override
    public PsiElement construct(ASTNode node) {
        return new JSVariableImpl(node);
    }

    @NotNull
    public JSVariableStub<JSVariable> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSVariableElementType.$$$reportNull$$$0(1);
        }
        return new JSVariableStubImpl(dataStream, parentStub, (IStubElementType)this);
    }

    @Override
    public boolean shouldIndexSymbol(@NotNull JSVariable psi) {
        if (psi == null) {
            JSVariableElementType.$$$reportNull$$$0(2);
        }
        return !psi.isLocal();
    }

    public static boolean shouldCreateStubForVariable(@NotNull ASTNode node) {
        ASTNode parent;
        if (node == null) {
            JSVariableElementType.$$$reportNull$$$0(3);
        }
        if ((parent = node.getTreeParent()) == null || parent.getElementType() != JSStubElementTypes.VAR_STATEMENT) {
            return true;
        }
        boolean insideFunction = false;
        while (parent != null) {
            IElementType type = parent.getElementType();
            if (JSElementTypes.FUNCTIONS.contains(type)) {
                ASTNode docComment = node.findChildByType(JSStubElementTypes.DOC_COMMENT);
                if (docComment == null) {
                    docComment = node.getTreeParent().findChildByType(JSStubElementTypes.DOC_COMMENT);
                }
                if (docComment != null && docComment.getFirstChildNode() != null) {
                    return true;
                }
                insideFunction = true;
                break;
            }
            if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type)) {
                return true;
            }
            parent = parent.getTreeParent();
        }
        if (!insideFunction && !JSVariableBaseImpl.hasBlockScope(node)) {
            return true;
        }
        ASTNode initializer = JSTreeUtil.getInitializerNode(node);
        return initializer != null && !JSSymbolUtil.typeMayBeInlined(initializer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/types/JSVariableElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldIndexSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCreateStubForVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

