/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSTypeKeyTypeImpl
extends JSLiteralKeyTypeBaseImpl {
    @NotNull
    private final Collection<PsiElement> myKeySourceElements;
    private final boolean myOptional;

    public JSTypeKeyTypeImpl(@NotNull String literal, @NotNull List<JSRecordType> ownerTypes, @NotNull JSTypeSource source2) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(0);
        }
        if (ownerTypes == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(1);
        }
        if (source2 == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(2);
        }
        super(literal, source2);
        List signatures = ContainerUtil.mapNotNull(ownerTypes, t -> t.findPropertySignature(literal));
        this.myKeySourceElements = signatures.stream().flatMap(s -> s.getMemberSource().getAllSourceElements().stream()).distinct().collect(Collectors.toList());
        this.myOptional = signatures.size() > 0 && ContainerUtil.and((Iterable)signatures, el -> el.isOptional());
    }

    public JSTypeKeyTypeImpl(@NotNull String literal, @NotNull JSRecordType ownerType, @NotNull JSTypeSource source2) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(3);
        }
        if (ownerType == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(4);
        }
        if (source2 == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(5);
        }
        super(literal, source2);
        JSRecordType.PropertySignature signature = ownerType.findPropertySignature(literal);
        this.myKeySourceElements = signature == null ? ContainerUtil.emptyList() : signature.getMemberSource().getAllSourceElements();
        this.myOptional = signature != null && signature.isOptional();
    }

    public JSTypeKeyTypeImpl(@NotNull String literal, @NotNull Collection<PsiElement> elements, @NotNull JSTypeSource source2) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(7);
        }
        if (source2 == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(8);
        }
        super(literal, source2);
        this.myKeySourceElements = elements;
        this.myOptional = false;
    }

    public JSTypeKeyTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(9);
        }
        if (inputStream == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(10);
        }
        super(source2, inputStream);
        this.myKeySourceElements = ContainerUtil.emptyList();
        this.myOptional = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(11);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myOptional, outputStream);
    }

    @Override
    @NotNull
    protected JSLiteralKeyTypeBaseImpl createInstance(@NotNull String literal, @NotNull JSTypeSource source2) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(12);
        }
        if (source2 == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(13);
        }
        return new JSTypeKeyTypeImpl(literal, this.myKeySourceElements, source2);
    }

    @Override
    @NotNull
    public String getTypeParserPrefix() {
        return "#literalkey";
    }

    @Override
    public ResolveResult[] resolveKey() {
        if (this.myKeySourceElements.size() == 1) {
            return new ResolveResult[]{new JSResolveResult((PsiElement)ContainerUtil.getFirstItem(this.myKeySourceElements))};
        }
        if (this.myKeySourceElements.size() == 0) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return (ResolveResult[])this.myKeySourceElements.stream().map(e -> new JSResolveResult((PsiElement)new TypeScriptMergedTypeImplicitElementImpl(this.getLiteral(), null, (PsiElement)e, false, false, true, JSRecordType.MemberSourceKind.TypeKey))).toArray(ResolveResult[]::new);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(super.hashCodeImpl(), JSTypeHashCodeUtil.getHashCode(this.myKeySourceElements), this.myOptional);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(14);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myKeySourceElements.equals(((JSTypeKeyTypeImpl)type).myKeySourceElements) && this.myOptional == ((JSTypeKeyTypeImpl)type).myOptional;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @NotNull
    public Collection<PsiElement> getKeySourceElements() {
        Collection<PsiElement> collection = this.myKeySourceElements;
        if (collection == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerTypes";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeKeyTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeKeyTypeImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeySourceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

