/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import java.lang.invoke.StringConcatFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBaseTypesIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"JS.base.types.index");
    private static final String STATIC_SUFFIX = "\u0001s";
    private static final String UNKNOWN_CONTEXT_SUFFIX = "\u0001u";
    private static final String LOCAL_NS_SUFFIX = "\u0001l";
    private static final int VERSION = 1;

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    public int getVersion() {
        return super.getVersion() + 1;
    }

    @NotNull
    public static String serializeHierarchyElement(@NotNull JSQualifiedName qualifiedName, @NotNull JSContext jsContext) {
        if (qualifiedName == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(1);
        }
        if (jsContext == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(2);
        }
        Object text = qualifiedName.getQualifiedName();
        if (jsContext == JSContext.STATIC) {
            text = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", STATIC_SUFFIX}, (String)text);
        }
        if (jsContext == JSContext.UNKNOWN) {
            text = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", UNKNOWN_CONTEXT_SUFFIX}, (String)text);
        }
        Object object = text;
        if (object == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public static String getHierarchyIndexKey(@NotNull JSNamespace ns) {
        if (ns == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(4);
        }
        Object key = JSBaseTypesIndex.getNameWithGenericArguments(ns);
        if (ns.isLocal()) {
            key = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", LOCAL_NS_SUFFIX}, (String)key);
        }
        String string = key;
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getNameWithGenericArguments(@NotNull JSNamespace ns) {
        if (ns == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(6);
        }
        String string = ns instanceof JSTypeWithOuterGenerics || ns.getQualifiedName() == null ? ns.getTypeText(JSType.TypeTextFormat.SIMPLE) : ns.getQualifiedName().getQualifiedName();
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getHierarchyIndexKey(@NotNull String serializedType) {
        Object key;
        JSType jsType2;
        if (serializedType == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(8);
        }
        boolean isLocal = serializedType.contains(LOCAL_NS_SUFFIX);
        int indexOfSpecialChar = serializedType.indexOf(1);
        if (indexOfSpecialChar >= 0) {
            serializedType = serializedType.substring(0, indexOfSpecialChar);
        }
        String qName = (jsType2 = JSTypeParser.createType(serializedType, JSTypeSource.EXPLICITLY_DECLARED)) != null ? JSTypeUtils.getQualifiedNameMatchingType(jsType2, false) : null;
        Object object = key = qName != null ? qName : serializedType;
        if (isLocal) {
            key = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", LOCAL_NS_SUFFIX}, (String)key);
        }
        String string = key;
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String serializeHierarchyElement(@NotNull JSNamespace ns) {
        if (ns == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(10);
        }
        StringBuilder text = new StringBuilder(ns.getTypeText(JSType.TypeTextFormat.SIMPLE));
        if (ns.getJSContext() == JSContext.STATIC) {
            text.append(STATIC_SUFFIX);
        }
        if (ns.getJSContext() == JSContext.UNKNOWN) {
            text.append(UNKNOWN_CONTEXT_SUFFIX);
        }
        if (ns.isLocal()) {
            text.append(LOCAL_NS_SUFFIX);
        }
        String string = text.toString();
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static JSType deserializeHierarchyElement(@NotNull Project project, @NotNull String serializedType, @Nullable PsiFile file2) {
        if (project == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(12);
        }
        if (serializedType == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(13);
        }
        boolean isLocal = false;
        if (serializedType.endsWith(LOCAL_NS_SUFFIX)) {
            isLocal = true;
            serializedType = StringUtil.trimEnd((String)serializedType, (String)LOCAL_NS_SUFFIX);
        }
        JSContext jsContext = JSContext.INSTANCE;
        if (serializedType.endsWith(STATIC_SUFFIX)) {
            jsContext = JSContext.STATIC;
            serializedType = StringUtil.trimEnd((String)serializedType, (String)STATIC_SUFFIX);
        }
        if (serializedType.endsWith(UNKNOWN_CONTEXT_SUFFIX)) {
            jsContext = JSContext.UNKNOWN;
            serializedType = StringUtil.trimEnd((String)serializedType, (String)UNKNOWN_CONTEXT_SUFFIX);
        }
        JSType type = JSTypeParser.createType(project, serializedType, JSTypeSourceFactory.createTypeSource((PsiElement)file2, true));
        JSGenericTypeImpl genericType = null;
        if (type instanceof JSGenericTypeImpl) {
            genericType = (JSGenericTypeImpl)type;
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (!(type instanceof JSNamedType)) {
            return genericType;
        }
        JSNamedType ns = (JSNamedType)type;
        if (jsContext == ns.getJSContext() && !isLocal) {
            return genericType != null ? genericType : type;
        }
        type = JSNamedTypeFactory.createNamespace(ns.getQualifiedName(), type.getSource(), JSTypeContext.fromJSContext(jsContext, false), isLocal);
        if (genericType != null) {
            type = new JSGenericTypeImpl(genericType.getSource(), type, genericType.getArguments());
        }
        return type;
    }

    public static boolean areTypesRelevant(@NotNull JSNamespace namespace, @NotNull String serializedType, @NotNull PsiFile serializedTypeFile) {
        PsiFile namespaceScope;
        JSType type;
        if (namespace == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(14);
        }
        if (serializedType == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(15);
        }
        if (serializedTypeFile == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(16);
        }
        if ((type = JSBaseTypesIndex.deserializeHierarchyElement(serializedTypeFile.getProject(), serializedType, null)) == null) {
            return false;
        }
        JSNamespace nsFromSerialized = JSTypeUtils.getNamespaceMatchingType(type, false);
        if (nsFromSerialized == null) {
            return false;
        }
        if (namespace.getJSContext() != nsFromSerialized.getJSContext() && namespace.getJSContext() != JSContext.UNKNOWN && nsFromSerialized.getJSContext() != JSContext.UNKNOWN) {
            return false;
        }
        if (nsFromSerialized.isLocal() && (namespaceScope = namespace.getSource().getScope()) != null && !namespaceScope.equals(serializedTypeFile)) {
            return false;
        }
        return JSBaseTypesIndex.getNameWithGenericArguments(namespace).equals(JSBaseTypesIndex.getNameWithGenericArguments(nsFromSerialized));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedTypeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex";
                break;
            }
            case 3: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeHierarchyElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyIndexKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithGenericArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serializeHierarchyElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyIndexKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithGenericArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeHierarchyElement";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areTypesRelevant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

