/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSCopyWithStrictTransformer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerBase;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSRestType;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadOrRestType;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyTypeofType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeUtils {
    private static final Set<String> PROMISE_LIKE_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Promise", "PromiseLike"});
    public static final int MAX_ALIASES_TO_UNWRAP = 10;

    @Nullable
    public static PsiElement getScopeInOriginalTree(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeUtils.$$$reportNull$$$0(0);
        }
        if (scope instanceof ImplicitJSVariableImpl) {
            return scope;
        }
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
        if (originalElement != null) {
            return originalElement;
        }
        PsiElement someElementAtOriginalTree = scope.getContainingFile().getOriginalFile().findElementAt(scope.getTextRange().getStartOffset());
        return someElementAtOriginalTree;
    }

    private JSTypeUtils() {
    }

    public static String transformActionScriptSpecificTypesIntoEcma(String type) {
        if ("int".equals(type) || "uint".equals(type)) {
            type = "Number";
        }
        return type;
    }

    public static boolean isInstanceType(@Nullable JSType type) {
        return type instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.INSTANCE && !((JSNamespace)type).isDeclaration();
    }

    public static boolean isInstanceOrPrototype(@Nullable JSType type) {
        return (type = JSTypeUtils.getValuableType(type)) instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.INSTANCE;
    }

    public static boolean isNewPropertiesDefinitionAllowed(@Nullable JSType type, boolean allowResolve) {
        if (type == null) {
            return true;
        }
        if (allowResolve) {
            type = type.substitute();
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSAnyType || type instanceof JSObjectType || type instanceof JSArrayType || type instanceof JSTupleType || type instanceof JSPrimitiveFunctionType || type instanceof JSFunctionTypeImpl || JSTypeUtils.isMapType(type)) {
            return true;
        }
        if (!type.isSourceStrict()) {
            return true;
        }
        if (JSTypeUtils.isInstanceType(type)) {
            return false;
        }
        if (type instanceof JSFreshObjectLiteralType) {
            return true;
        }
        return !(type instanceof JSRecordType) || !type.isJavaScript() || !(type.getSourceElement() instanceof PsiComment) && !(type.getSourceElement() instanceof JSImplicitElement);
    }

    public static boolean isStrictType(@Nullable JSType type) {
        if (type instanceof JSDecoratedType) {
            type = ((JSDecoratedType)type).getOriginalType();
        }
        return JSTypeUtils.isRestrictiveType(type) && type.isSourceStrict();
    }

    @Contract(value="null -> false")
    public static boolean isRestrictiveType(@Nullable JSType type) {
        return type != null && !(type instanceof JSAnyType) && (!(type instanceof JSUnionType) || !((JSUnionType)type).isAnyType()) && !(type instanceof JSObjectType);
    }

    public static boolean isNullOrAny(@Nullable JSType type) {
        return type == null || type instanceof JSAnyType;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String serializeType(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JSTypeSerializer.TYPE_SERIALIZER.write(type, builder);
        return builder.toString();
    }

    @Deprecated
    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSTypeUtils.$$$reportNull$$$0(1);
        }
        return JSTypeParser.createType(typeString, source2);
    }

    @Contract(value="null -> false")
    public static boolean isArrayLikeType(@Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSArrayType || type instanceof JSGenericTypeImpl && JSArrayType.isGenericArray((JSGenericTypeImpl)type) || type instanceof JSTupleType) {
            return true;
        }
        if (!(type instanceof JSGenericParameterImpl)) {
            return false;
        }
        JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
        return constraintType != null && JSTypeUtils.isIterableCollectionType(constraintType);
    }

    public static boolean isIterableCollectionType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(2);
        }
        if (JSTypeUtils.isIndexableType(type)) {
            return true;
        }
        if (JSNamedType.isNamedTypeWithNames(type, JSCommonTypeNames.TYPED_ARRAY_NAMES)) {
            return true;
        }
        if (JSNamedType.isNamedTypeWithName(type, "IArguments")) {
            return true;
        }
        return type.asRecordType().hasProperty("[Symbol.iterator]");
    }

    public static boolean isIndexableType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(3);
        }
        return JSTypeUtils.getIndexableComponentType(type, false, true) != null;
    }

    public static boolean isMapType(@NotNull JSType type) {
        JSType baseType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(4);
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getArguments().size() == 2 && (baseType = ((JSGenericTypeImpl)type).getType()) instanceof JSNamedType) {
            String typeText = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE);
            return "Array".equals(typeText) || "Object".equals(typeText) || "Map".equals(typeText) || "WeakMap".equals(typeText);
        }
        return false;
    }

    public static boolean isExactlyPromiseLikeType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) == null) {
            return false;
        }
        return JSTypeUtils.isPromiseNamedType(type);
    }

    public static boolean isPromiseNamedType(@NotNull JSType type) {
        String qualifiedName;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(5);
        }
        return "Promise".equals(qualifiedName = JSTypeUtils.getQualifiedNameMatchingType(type, false)) || "PromiseLike".equals(qualifiedName);
    }

    public static boolean isPromiseLikeType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isExactlyPromiseLikeType(type = type.substitute())) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType(((JSGenericTypeImpl)type).getType())) {
            return true;
        }
        return type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(type1 -> type1 instanceof JSAnyType && !type1.isSourceStrict() || JSTypeUtils.isPromiseLikeType(type1));
    }

    @NotNull
    public static JSType wrapInPromiseType(@NotNull JSType jsType2, @NotNull JSTypeSource typeSource) {
        if (jsType2 == null) {
            JSTypeUtils.$$$reportNull$$$0(6);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(7);
        }
        JSType promiseType = JSNamedTypeFactory.createExplicitlyDeclaredType("Promise", typeSource.getSourceElement());
        return new JSGenericTypeImpl(typeSource, promiseType, jsType2);
    }

    @Nullable
    public static JSType getPromiseComponentTypeOrNull(@NotNull JSType type) {
        JSType promiseArg;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(8);
        }
        if ((promiseArg = JSTypeUtils.getIfGenericPromise(type)) != null) {
            return promiseArg;
        }
        JSTypeSubstitutor externalSubstitutor = JSTypeSubstitutor.EMPTY;
        if (type instanceof JSGenericTypeImpl) {
            externalSubstitutor = JSTypeUtils.getSubstitutorFromType((JSGenericTypeImpl)type);
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (JSTypeUtils.isPromiseOrPromiseLike(type)) {
            return null;
        }
        return JSTypeUtils.processPromiseInHierarchy(type, externalSubstitutor);
    }

    @Nullable
    private static JSType processPromiseInHierarchy(@NotNull JSType type, @NotNull JSTypeSubstitutor externalSubstitutor) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(9);
        }
        if (externalSubstitutor == null) {
            JSTypeUtils.$$$reportNull$$$0(10);
        }
        if (!(type instanceof JSResolvableType)) {
            return null;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        for (JSClass aClass : info.getDeclarationsOfType(JSClass.class)) {
            Ref result2 = Ref.create(null);
            JSClassUtils.JSClassHierarchyProcessor processor = (aClass1, typeSubstitutor, fromImplements, isStatic, depth) -> {
                JSType jsType2 = aClass1.getJSType();
                if (JSTypeUtils.isPromiseOrPromiseLike(jsType2)) {
                    JSType genericType;
                    JSType promiseType;
                    if (aClass1 instanceof TypeScriptTypeParameterListOwner) {
                        jsType2 = JSTypeUtils.createNotSubstitutedGenericType((TypeScriptTypeParameterListOwner)((Object)aClass1), jsType2);
                    }
                    if ((promiseType = JSTypeUtils.getIfGenericPromise(genericType = JSTypeUtils.applyGenericArguments(jsType2, typeSubstitutor))) != null) {
                        result2.set((Object)promiseType);
                        return false;
                    }
                }
                return true;
            };
            JSClassUtils.processClassesInHierarchy(aClass, true, processor, (Condition<? super JSClass>)Conditions.alwaysTrue(), externalSubstitutor);
            if (result2.isNull()) continue;
            return (JSType)result2.get();
        }
        return null;
    }

    @NotNull
    public static JSGenericTypeImpl createNotSubstitutedGenericType(@NotNull TypeScriptTypeParameterListOwner aClass1, @NotNull JSType jsType2) {
        if (aClass1 == null) {
            JSTypeUtils.$$$reportNull$$$0(11);
        }
        if (jsType2 == null) {
            JSTypeUtils.$$$reportNull$$$0(12);
        }
        return new JSGenericTypeImpl(jsType2.getSource(), jsType2, ContainerUtil.map((Object[])aClass1.getTypeParameters(), p -> {
            TypeScriptType typeConstraint = p.getTypeConstraint();
            JSType type = typeConstraint == null ? null : typeConstraint.getJSType();
            return new JSGenericParameterImpl(p.getGenericId(), JSTypeSourceFactory.createTypeSource((PsiElement)p, true), JSGenericParameterType.JSGenericState.NON, type);
        }));
    }

    @NotNull
    private static JSTypeSubstitutor getSubstitutorFromType(@NotNull JSGenericTypeImpl type) {
        JSType inner;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(13);
        }
        if (!((inner = type.getType()) instanceof JSResolvableType)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSTypeUtils.$$$reportNull$$$0(14);
            }
            return jSTypeSubstitutor;
        }
        for (TypeScriptTypeParameterListOwner owner : ((JSResolvableType)inner).resolveType().getDeclarationsOfType(TypeScriptTypeParameterListOwner.class)) {
            JSTypeSubstitutor typeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
            if (typeSubstitutor == null || typeSubstitutor.isEmpty()) continue;
            JSTypeSubstitutor jSTypeSubstitutor = typeSubstitutor;
            if (jSTypeSubstitutor == null) {
                JSTypeUtils.$$$reportNull$$$0(15);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSTypeUtils.$$$reportNull$$$0(16);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    private static JSType getIfGenericPromise(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(17);
        }
        if (!(type instanceof JSGenericTypeImpl)) {
            return null;
        }
        return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, JSTypeUtils::isPromiseOrPromiseLike, true);
    }

    private static boolean isPromiseOrPromiseLike(JSType el) {
        return JSNamedType.isNamedTypeWithNames(el, PROMISE_LIKE_NAMES);
    }

    public static JSType getIndexableComponentType(@Nullable JSType type) {
        return JSTypeUtils.getIndexableComponentType(type, true, true);
    }

    @Nullable
    public static JSType getIndexableComponentType(@Nullable JSType type, boolean includeIndexers, boolean unwrapAsyncPromise) {
        if ((type = JSTypeUtils.unwrapType(type)) instanceof JSArrayType) {
            return (JSType)ObjectUtils.coalesce((Object)((JSArrayType)type).getType(), (Object)JSAnyType.getWithLanguage(type.getSource().getLanguage(), false));
        }
        if (type instanceof JSTupleType) {
            return JSTypeUtils.getIndexableComponentType(((JSTupleType)type).toArrayType(true), false, unwrapAsyncPromise);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, true, t -> JSTypeUtils.isSingleGenericComponentType(t, unwrapAsyncPromise));
        }
        if (type instanceof JSRecordType && includeIndexers) {
            JSRecordType recordType = (JSRecordType)type;
            JSRecordType.IndexSignature indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (indexer == null) {
                indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
            }
            if (indexer != null) {
                return indexer.getMemberType();
            }
        } else if (type instanceof JSSpreadType) {
            return ((JSSpreadType)((Object)type)).getComponentType();
        }
        return null;
    }

    @Nullable
    public static JSType getSingleGenericArgTypeFromGenericType(@NotNull JSGenericTypeImpl genericType, @NotNull Predicate<? super JSType> acceptType, boolean traverseClassHierarchy) {
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(18);
        }
        if (acceptType == null) {
            JSTypeUtils.$$$reportNull$$$0(19);
        }
        return JSTypeUtils.getSingleGenericArgTypeFromGenericType(genericType, traverseClassHierarchy, baseType -> acceptType.test((JSType)baseType) ? Function.identity() : null);
    }

    @Nullable
    public static JSType getSingleGenericArgTypeFromGenericType(@NotNull JSGenericTypeImpl genericType, boolean traverseClassHierarchy, @NotNull Function<JSType, @Nullable Function<JSType, JSType>> acceptAndAdjustType) {
        JSType baseType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(20);
        }
        if (acceptAndAdjustType == null) {
            JSTypeUtils.$$$reportNull$$$0(21);
        }
        if (!((baseType = genericType.getType()) instanceof JSNamedType)) {
            return null;
        }
        List<JSType> genericArguments = genericType.getArguments();
        if (genericArguments.isEmpty()) {
            return null;
        }
        Function<JSType, JSType> typeAdjuster = acceptAndAdjustType.apply(baseType);
        if (typeAdjuster != null) {
            JSType genericArg = JSTypeUtils.isNewKindGenerator(baseType) ? (JSType)ContainerUtil.getFirstItem(genericArguments) : (genericArguments.size() == 1 || !baseType.isTypeScript() ? genericArguments.get(genericArguments.size() - 1) : null);
            return typeAdjuster.apply(genericArg);
        }
        if (!traverseClassHierarchy) {
            return null;
        }
        if (!(baseType instanceof JSResolvableType)) {
            return null;
        }
        JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)baseType).resolveType();
        Collection<JSClass> classes = resolvedTypeInfo.getDeclarationsOfType(JSClass.class);
        if (classes.isEmpty()) {
            return null;
        }
        JSType result2 = null;
        for (JSClass aClass : classes) {
            JSType genericArgTypeCandidate = JSTypeUtils.getSingleGenericArgTypeFromClassHierarchy(aClass, genericArguments, acceptAndAdjustType);
            if (result2 == null) {
                result2 = genericArgTypeCandidate;
                continue;
            }
            if (result2.isEquivalentTo(genericArgTypeCandidate, null, false)) continue;
            return null;
        }
        return result2;
    }

    @Nullable
    private static JSType getSingleGenericArgTypeFromClassHierarchy(@NotNull JSClass sourceElement, @NotNull List<JSType> genericArguments, @NotNull Function<JSType, @Nullable Function<JSType, JSType>> acceptAndAdjustType) {
        if (sourceElement == null) {
            JSTypeUtils.$$$reportNull$$$0(22);
        }
        if (genericArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(23);
        }
        if (acceptAndAdjustType == null) {
            JSTypeUtils.$$$reportNull$$$0(24);
        }
        JSTypeSubstitutor typeArguments = sourceElement instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)sourceElement), genericArguments) : JSTypeSubstitutor.EMPTY;
        Ref indexerType = new Ref();
        JSClassUtils.processClassesInHierarchy(sourceElement, true, (klass, typeSubstitutor, fromImplements, fromStaticContext, depth) -> {
            if (sourceElement == null) {
                JSTypeUtils.$$$reportNull$$$0(134);
            }
            if (acceptAndAdjustType == null) {
                JSTypeUtils.$$$reportNull$$$0(135);
            }
            if (!(klass instanceof TypeScriptTypeParameterListOwner) || klass == sourceElement) {
                return true;
            }
            String qualifiedName = klass.getQualifiedName();
            if (qualifiedName == null) {
                return true;
            }
            JSType type = klass.getJSType();
            Function typeAdjuster = (Function)acceptAndAdjustType.apply(type);
            if (typeAdjuster != null) {
                TypeScriptTypeParameter[] parameters = ((TypeScriptTypeParameterListOwner)((Object)klass)).getTypeParameters();
                if (parameters.length == 0) {
                    return true;
                }
                List<JSType> generics = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters);
                if (generics.size() == 0) {
                    return true;
                }
                indexerType.set((Object)((JSType)typeAdjuster.apply(JSTypeUtils.applyGenericArguments(generics.get(0), typeSubstitutor))));
                return false;
            }
            return true;
        }, (Condition<? super JSClass>)Conditions.alwaysTrue(), typeArguments);
        return (JSType)indexerType.get();
    }

    private static boolean isNewKindGenerator(JSType type) {
        if (!(type instanceof JSTypeImpl)) {
            return false;
        }
        String typeText = type.getResolvedTypeText();
        return "AsyncGenerator".equals(typeText) || "Generator".equals(typeText);
    }

    @Nullable
    public static Function<JSType, JSType> isSingleGenericComponentType(@NotNull JSType baseType, boolean unwrapAsyncPromise) {
        String s;
        if (baseType == null) {
            JSTypeUtils.$$$reportNull$$$0(25);
        }
        switch (s = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE)) {
            case "Vector": 
            case "Array": 
            case "Object": 
            case "ReadonlyArray": 
            case "ArrayLike": 
            case "Iterable": 
            case "Iterator": 
            case "Generator": 
            case "IterableIterator": 
            case "Set": 
            case "WeakSet": {
                return Function.identity();
            }
            case "AsyncIterable": 
            case "AsyncIterator": 
            case "AsyncGenerator": 
            case "AsyncIterableIterator": {
                return unwrapAsyncPromise ? Function.identity() : genericArg -> genericArg != null ? JSTypeUtils.wrapInPromiseType(genericArg, genericArg.getSource()) : null;
            }
        }
        return null;
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(26);
        }
        return JSTypeUtils.getIterableComponentType(type, true, true, true);
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type, boolean allowAsyncIterable, boolean allowNonAsyncIterable, boolean unwrapAsyncPromise) {
        JSType realType;
        JSType componentType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(27);
        }
        if ((componentType = JSTypeUtils.getIndexableComponentType(realType = type.substitute(), false, unwrapAsyncPromise)) == null) {
            JSType genericType;
            JSRecordType recordType = realType.asRecordType();
            JSType jSType = genericType = allowNonAsyncIterable ? JSTypeUtils.getIteratorComponentType(recordType) : null;
            if (genericType != null) {
                return genericType;
            }
            JSType jSType2 = genericType = allowAsyncIterable ? JSTypeUtils.getAsyncIteratorComponentType(recordType) : null;
            if (genericType != null) {
                return genericType;
            }
            return JSTypeUtils.getIndexableComponentType(realType, true, unwrapAsyncPromise);
        }
        return componentType;
    }

    @Nullable
    public static JSType getIteratorComponentType(JSRecordType recordType) {
        return JSTypeUtils.getCustomIteratorComponentType(recordType, "[Symbol.iterator]", "Iterator", "IterableIterator", "Generator");
    }

    @Nullable
    private static JSType getAsyncIteratorComponentType(JSRecordType recordType) {
        JSType type = JSTypeUtils.getCustomIteratorComponentType(recordType, "[Symbol.asyncIterator]", "AsyncIterator", "AsyncIterableIterator", "AsyncGenerator");
        return type != null ? JSTypeUtils.wrapInPromiseType(type, type.getSource()) : null;
    }

    @Nullable
    private static JSType getCustomIteratorComponentType(JSRecordType recordType, String iteratorSymbol, String ... iteratorClassNames) {
        JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature(iteratorSymbol);
        if (propertySignature == null) {
            return null;
        }
        JSType iteratorType = propertySignature.getJSType();
        if (iteratorType instanceof JSRecordType) {
            iteratorType = new JSApplyCallType(iteratorType, iteratorType.getSource()).substitute();
        }
        if (iteratorType instanceof JSFunctionTypeImpl) {
            iteratorType = ((JSFunctionTypeImpl)iteratorType).getReturnType();
        }
        if (iteratorType instanceof JSFunctionReturnWrapperType) {
            iteratorType = iteratorType.substitute();
        }
        if (iteratorType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)iteratorType;
            String typeName = JSTypeUtils.getQualifiedNameMatchingType(iteratorType, false);
            if (ArrayUtil.contains((String)typeName, (String[])iteratorClassNames)) {
                return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return null;
    }

    public static boolean typeCanBeAssignedWithoutCoercion(@NotNull JSType lOpType, @Nullable JSType rOpType) {
        if (lOpType == null) {
            JSTypeUtils.$$$reportNull$$$0(28);
        }
        if (lOpType instanceof JSNumberType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSNumberType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSIntType || lOpType instanceof JSUintType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSObjectType) {
            return true;
        }
        if (lOpType instanceof JSSpecialNamedTypeImpl || lOpType instanceof JSUndefinedType || lOpType instanceof JSNullType || lOpType instanceof JSVoidType) {
            return lOpType.isEquivalentTo(rOpType, null);
        }
        if (lOpType instanceof JSUnionType) {
            boolean anyTypeCanBeAssignedWithoutCoercion = false;
            for (JSType lOpTypePart : ((JSUnionType)lOpType).getTypes()) {
                anyTypeCanBeAssignedWithoutCoercion |= JSTypeUtils.typeCanBeAssignedWithoutCoercion(lOpTypePart, rOpType);
            }
            return anyTypeCanBeAssignedWithoutCoercion;
        }
        return rOpType != null && !(rOpType instanceof JSAnyType) && !(rOpType instanceof JSObjectType) && !(rOpType instanceof JSUndefinedType) && !(rOpType instanceof JSNullType) && !(rOpType instanceof JSVoidType);
    }

    @NotNull
    public static String getTypeMatchingNamespace(@NotNull Project project, @NotNull String type) {
        JSType jsType2;
        if (project == null) {
            JSTypeUtils.$$$reportNull$$$0(29);
        }
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(30);
        }
        if ((jsType2 = JSTypeParser.createType(project, type, JSTypeSource.EMPTY_TS)) == null) {
            String string = type;
            if (string == null) {
                JSTypeUtils.$$$reportNull$$$0(31);
            }
            return string;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(jsType2, false);
        String string = qName != null ? qName : type;
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    public static String getQualifiedNameMatchingType(@NotNull JSType type, boolean resolved) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(33);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSTypeWithOuterGenerics) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSTypeWithOuterGenerics)type).getOriginalType(), resolved);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSGenericTypeImpl)type).getType(), resolved);
        }
        if (type instanceof JSArrayType && !((JSArrayType)type).isPrimitive()) {
            return ((JSArrayType)type).getTypeName();
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            return null;
        }
        if (type instanceof JSStringType || TypeScriptTypeRelations.isPatternLiteralType(type)) {
            return "String";
        }
        if (type instanceof JSNumberType) {
            return "Number";
        }
        if (type instanceof JSBigIntType) {
            return "BigInt";
        }
        if (type instanceof JSBooleanType || type instanceof TypeScriptTypePredicateTypeImpl) {
            return "Boolean";
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getQualifiedNameMatchingType(constraintType, resolved);
        }
        if (type instanceof JSFunctionTypeImpl) {
            return JSTypeUtils.getFunctionTypeName(type.getSource().getScope(), false);
        }
        if (type instanceof JSTupleType) {
            return "Array";
        }
        if (type instanceof JSNamedType) {
            String text = type.getTypeText(resolved ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE);
            return StringUtil.replace((String)text, (String)"prototype.", (String)"");
        }
        if (type instanceof TypeScriptGenericThisTypeImpl) {
            JSType ownerType = ((TypeScriptGenericThisTypeImpl)type).getOwnerType();
            return ownerType == null ? null : JSTypeUtils.getQualifiedNameMatchingType(ownerType, resolved);
        }
        return null;
    }

    @NotNull
    public static String getFunctionTypeName(@Nullable PsiFile scope, boolean newable) {
        TypeScriptConfig config2;
        TypeScriptConfig typeScriptConfig = config2 = scope == null ? null : TypeScriptConfigUtil.getConfigForPsiFile(scope);
        return config2 == null || !config2.strictBindCallApply() ? "Function" : (newable ? "NewableFunction" : "CallableFunction");
    }

    @Nullable
    public static JSNamespace getNamespaceMatchingType(@NotNull JSType type, boolean forcedExplicitlyDeclared) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(34);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(((JSGenericTypeImpl)type).getType(), forcedExplicitlyDeclared);
            if (namespace != null) {
                JSTypeSubstitutor typeSubstitutor;
                PsiElement sourceElement = type.getSource().getSourceElement();
                JSQualifiedName name = namespace.getQualifiedName();
                if (sourceElement != null && name != null && !(typeSubstitutor = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(type, name, sourceElement)).isEmpty()) {
                    return new JSTypeWithOuterGenerics(namespace, typeSubstitutor);
                }
            }
            return namespace;
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getNamespaceMatchingType(constraintType, forcedExplicitlyDeclared);
        }
        if (type instanceof JSNamespace) {
            JSNamespace providedNamespace;
            JSClassExpression classExpression;
            if (type instanceof JSClassExpressionType && (classExpression = ((JSClassExpressionType)type).findAssociatedExpression()) != null && (providedNamespace = JSNamedTypeFactory.buildProvidedNamespace(classExpression, forcedExplicitlyDeclared || type.isSourceStrict())) != null) {
                return providedNamespace.copyWithTypeContext(((JSClassExpressionType)type).getTypeContext());
            }
            return (JSNamespace)(forcedExplicitlyDeclared ? type.copyWithStrict(true) : type);
        }
        return null;
    }

    public static boolean hasFunctionType(@NotNull JSType _type, boolean includeConstructorSignatures, @Nullable PsiElement context) {
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(35);
        }
        return JSTypeUtils.getFunctionType(_type, includeConstructorSignatures, context).findAny().isPresent();
    }

    @NotNull
    public static Stream<JSType> getFunctionType(@Nullable JSType _type, boolean includeConstructorSignatures, @Nullable PsiElement context) {
        if (_type == null) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(36);
            }
            return stream;
        }
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context);
        Stream<JSType> stream = _type.getFunctionTypes(processingContext, includeConstructorSignatures);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(37);
        }
        return stream;
    }

    @Nullable
    public static Stream<JSType> getMergedUnionSignatureType(@NotNull List<List<JSType>> overloadPacks) {
        if (overloadPacks == null) {
            JSTypeUtils.$$$reportNull$$$0(38);
        }
        int indexWithOverloads = -1;
        for (int i2 = 0; i2 < overloadPacks.size(); ++i2) {
            List<JSType> overloadPack = overloadPacks.get(i2);
            if (overloadPack.size() > 1) {
                if (indexWithOverloads != -1) {
                    return null;
                }
                indexWithOverloads = i2;
            }
            if (!overloadPack.isEmpty() && !overloadPack.stream().anyMatch(f -> !(f instanceof JSFunctionType))) continue;
            return null;
        }
        List<JSType> masterList = overloadPacks.get(indexWithOverloads == -1 ? 0 : indexWithOverloads);
        List<JSType> results = new ArrayList<JSType>(masterList);
        for (List<JSType> pack : overloadPacks) {
            if (pack == masterList) continue;
            assert (pack.size() == 1);
            JSType signature = pack.get(0);
            if (!(signature instanceof JSFunctionType)) {
                return null;
            }
            if (((JSFunctionType)signature).hasGenericArguments() && results.stream().anyMatch(f -> !(f instanceof JSFunctionType) || !((JSFunctionType)f).hasGenericArguments())) {
                return null;
            }
            results = ContainerUtil.map(results, sig -> JSTypeUtils.combineSignaturesOfUnionMembers((JSFunctionType)sig, (JSFunctionType)signature));
        }
        return results.stream();
    }

    @NotNull
    private static JSType combineSignaturesOfUnionMembers(@NotNull JSFunctionType left, @NotNull JSFunctionType right) {
        if (left == null) {
            JSTypeUtils.$$$reportNull$$$0(39);
        }
        if (right == null) {
            JSTypeUtils.$$$reportNull$$$0(40);
        }
        List<JSParameterTypeDecorator> leftParameters = left.getParameters();
        List<JSParameterTypeDecorator> rightParameters = right.getParameters();
        JSFunctionType longest = leftParameters.size() >= rightParameters.size() ? left : right;
        List<JSParameterTypeDecorator> longestParameters = longest == left ? leftParameters : rightParameters;
        List<JSParameterTypeDecorator> shorterParameters = longest == right ? leftParameters : rightParameters;
        JSFunctionType shorter = longest == left ? right : left;
        int longestCount = longestParameters.size();
        boolean eitherHasEffectiveRest = JSTypeUtils.hasEffectiveRestParameter(left) || JSTypeUtils.hasEffectiveRestParameter(right);
        boolean needsExtraRestElement = eitherHasEffectiveRest && !JSTypeUtils.hasEffectiveRestParameter(longest);
        int size = longestCount + (needsExtraRestElement ? 1 : 0);
        ArrayList<JSParameterTypeDecoratorImpl> params = new ArrayList<JSParameterTypeDecoratorImpl>(size);
        JSTypeSource typeSource = left.getSource();
        for (int i2 = 0; i2 < longestCount; ++i2) {
            String rightName;
            JSParameterTypeDecorator longestParamType = longestParameters.get(i2);
            JSParameterTypeDecorator shorterParamType = shorterParameters.size() > i2 ? shorterParameters.get(i2) : (JSTypeUtils.hasEffectiveRestParameter(shorter) ? shorterParameters.get(shorterParameters.size() - 1) : null);
            JSType unionParamType = shorterParamType == null ? longestParamType.getSimpleType() : JSCompositeTypeFactory.createIntersectionType(Arrays.asList(longestParamType.getSimpleType(), shorterParamType.getSimpleType()), typeSource);
            boolean isRestParam = eitherHasEffectiveRest && !needsExtraRestElement && i2 == longestCount - 1;
            boolean isOptional = i2 >= JSTypeUtils.getMinArgumentCount(longest) && i2 >= JSTypeUtils.getMinArgumentCount(shorter);
            String leftName = leftParameters.size() > i2 ? leftParameters.get(i2).getName() : null;
            String string = rightName = rightParameters.size() > i2 ? rightParameters.get(i2).getName() : null;
            Object paramName = leftName != null && (Objects.equals(leftName, rightName) || rightName == null) ? leftName : (leftName == null && rightName != null ? rightName : "arg" + i2);
            params.add(new JSParameterTypeDecoratorImpl((String)paramName, unionParamType, isOptional, isRestParam, false));
        }
        if (needsExtraRestElement) {
            params.add(new JSParameterTypeDecoratorImpl(JSTypeUtils.typeOrAny(shorterParameters.get(shorterParameters.size() - 1).getSimpleType(), typeSource), false, true, false));
        }
        return new TypeScriptJSFunctionTypeImpl(typeSource, left instanceof TypeScriptJSFunctionTypeImpl ? ((TypeScriptJSFunctionTypeImpl)left).getGenericDeclarations() : ContainerUtil.emptyList(), params, left.getThisType(), JSCompositeTypeFactory.createUnionType(typeSource, left.getReturnType(), right.getReturnType()));
    }

    @NotNull
    private static JSType typeOrAny(@Nullable JSType unionParamType, @NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSTypeUtils.$$$reportNull$$$0(41);
        }
        JSType jSType = unionParamType == null ? JSAnyType.get(source2) : unionParamType;
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    private static int getMinArgumentCount(JSFunctionType type) {
        int i2 = 0;
        for (JSParameterTypeDecorator parameter : type.getParameters()) {
            if (parameter.isRest() || parameter.isOptional()) {
                return i2;
            }
            ++i2;
        }
        return i2;
    }

    private static boolean hasEffectiveRestParameter(JSFunctionType left) {
        return left.getParameters().stream().anyMatch(p -> p.isRest());
    }

    @NotNull
    public static Stream<JSType> collectValidConstituents(JSUnionOrIntersectionType compositeType, boolean strict) {
        Stream<JSType> stream = compositeType.getTypes().stream().filter(el -> strict || !JSTypeUtils.isNullOrUndefinedType(el)).filter(el -> el != null);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(43);
        }
        return stream;
    }

    @NotNull
    public static Stream<JSType> mergeWithMixins(@NotNull List<JSType> originalTypes) {
        if (originalTypes == null) {
            JSTypeUtils.$$$reportNull$$$0(44);
        }
        SmartList functionTypes = new SmartList();
        SmartList mixinReturnTypes = new SmartList();
        SmartList nonFunctionTypes = new SmartList();
        for (JSType type : originalTypes) {
            if (type instanceof JSFunctionType) {
                JSFunctionType functionType = (JSFunctionType)type;
                if (ES6ReferenceListImpl.isMixinConstructor(functionType)) {
                    ContainerUtil.addIfNotNull((Collection)mixinReturnTypes, (Object)functionType.getReturnType());
                    continue;
                }
                functionTypes.add(functionType);
                continue;
            }
            nonFunctionTypes.add(type);
        }
        if (mixinReturnTypes.size() == 0 || functionTypes.size() == 0) {
            Stream<JSType> stream = originalTypes.stream();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(45);
            }
            return stream;
        }
        Stream<JSType> functionWithMixin = functionTypes.stream().map(arg_0 -> JSTypeUtils.lambda$mergeWithMixins$13((List)mixinReturnTypes, arg_0));
        Stream<JSType> stream = Stream.concat(nonFunctionTypes.stream(), functionWithMixin);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(46);
        }
        return stream;
    }

    @NotNull
    public static Collection<TypeScriptInterface> getTypeScriptInterfaceInJavaScriptContext(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(47);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (sourceElement == null || qName == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeUtils.$$$reportNull$$$0(48);
            }
            return list2;
        }
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveTypeName(qName, sourceElement);
        List list3 = ContainerUtil.mapNotNull(result2.getElements(), TypeScriptUtil.TYPESCRIPT_INTERFACE_FILTER);
        if (list3 == null) {
            JSTypeUtils.$$$reportNull$$$0(49);
        }
        return list3;
    }

    public static boolean hasAnyTypeOrNotStrictType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(50);
        }
        if (type instanceof JSAnyType || !type.isSourceStrict()) {
            return true;
        }
        Ref ref = Ref.create();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)el -> {
            if (el instanceof JSAnyType || !el.isSourceStrict()) {
                ref.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }), type, false, true, true);
        return !ref.isNull();
    }

    @Nullable
    public static JSType getReturnType(@NotNull JSType startFunction, @NotNull JSCallItem callItem) {
        if (startFunction == null) {
            JSTypeUtils.$$$reportNull$$$0(51);
        }
        if (callItem == null) {
            JSTypeUtils.$$$reportNull$$$0(52);
        }
        boolean includeConstructors = callItem.isNewExpression();
        List candidates = JSTypeUtils.getFunctionType(startFunction, includeConstructors, callItem.getPsiContext()).collect(Collectors.toList());
        JSTypeSignatureChooser chooser = new JSTypeSignatureChooser(callItem);
        return chooser.resolveOverloadsReturnTypeWithApplying(candidates);
    }

    @Nullable
    public static JSType getNewOrReturnType(@Nullable JSType rawType) {
        if (rawType instanceof JSFunctionType) {
            JSFunctionType functionType = (JSFunctionType)rawType;
            return functionType.getReturnType();
        }
        return rawType;
    }

    public static boolean hasTypeArguments(@NotNull JSCallItem callItem) {
        if (callItem == null) {
            JSTypeUtils.$$$reportNull$$$0(53);
        }
        return callItem.getTypeArguments().length > 0;
    }

    @NotNull
    public static List<JSType> chooseOverloadFunctionTypes(@NotNull List<? extends JSType> candidates, @NotNull JSCallItem callItem, boolean applyGenerics) {
        if (candidates == null) {
            JSTypeUtils.$$$reportNull$$$0(54);
        }
        if (callItem == null) {
            JSTypeUtils.$$$reportNull$$$0(55);
        }
        List<JSType> list2 = new JSTypeSignatureChooser(callItem).resolveOverloadsWithApplying(candidates, applyGenerics);
        if (list2 == null) {
            JSTypeUtils.$$$reportNull$$$0(56);
        }
        return list2;
    }

    public static JSType applyJSGenericsForType(@NotNull List<JSType> generics, @NotNull JSType type, @NotNull PsiFile scope, @Nullable JSType resultType) {
        List<String> genericParameters;
        if (generics == null) {
            JSTypeUtils.$$$reportNull$$$0(57);
        }
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(58);
        }
        if (scope == null) {
            JSTypeUtils.$$$reportNull$$$0(59);
        }
        List<String> list2 = genericParameters = type instanceof JSNamedType ? JSGenericsIndex.findGenericParameters(type.getResolvedTypeText(), scope) : null;
        if (genericParameters != null && genericParameters.size() == generics.size()) {
            JSTypeSubstitutorImpl map = new JSTypeSubstitutorImpl(ContainerUtil.newHashMap(genericParameters, generics));
            resultType = JSTypeUtils.applyGenericArguments(resultType, map);
        }
        return resultType;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType getValuableType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type, true);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType getValuableType(@Nullable JSType type, boolean expandDecorators) {
        if (type == null) {
            return null;
        }
        JSType expanded = type.substitute();
        return expandDecorators ? JSTypeUtils.unwrapDecorations(expanded) : expanded;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType unwrapDecorations(@Nullable JSType type) {
        if (type instanceof JSDecoratedTypeImpl) {
            return ((JSDecoratedTypeImpl)type).getType();
        }
        return type;
    }

    @Deprecated
    @Contract(value="!null -> !null")
    public static JSType resolveType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null && type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return type.substitute();
        }
        return type;
    }

    public static boolean areArgumentsAssignable(@NotNull List<JSParameterTypeDecorator> parameters, @Nullable List<JSParameterTypeDecorator> arguments, @Nullable ProcessingContext processingContext, boolean functionAssignment, boolean jsDocFunctionAssignment, boolean typescript) {
        if (parameters == null) {
            JSTypeUtils.$$$reportNull$$$0(60);
        }
        if (arguments == null) {
            return parameters.isEmpty();
        }
        arguments = JSTypeUtils.expandByTupleTypes(arguments);
        parameters = JSTypeUtils.expandByTupleTypes(parameters);
        if (typescript && !functionAssignment) {
            int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
            int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
            int argumentSize = arguments.size();
            if (min > argumentSize || argumentSize > max) {
                return false;
            }
        }
        Iterator<JSParameterTypeDecorator> paramIterator = parameters.iterator();
        Iterator<JSParameterTypeDecorator> argIterator = arguments.iterator();
        Ref paramRestType = null;
        Ref argRestType = null;
        boolean remainingArgumentsAreOptional = false;
        boolean remainingParametersAreOptional = false;
        int paramIndex = -1;
        int argIndex = -1;
        while (paramIterator.hasNext() || argIterator.hasNext()) {
            JSType argument;
            boolean isParameterRest;
            JSType parameter;
            JSParameterTypeDecorator parameterTypeDecorator = null;
            boolean hasParameter = true;
            if (paramIterator.hasNext()) {
                parameterTypeDecorator = paramIterator.next();
                ++paramIndex;
                parameter = parameterTypeDecorator.getSimpleType();
            } else if (paramRestType != null) {
                parameter = (JSType)paramRestType.get();
            } else {
                parameter = null;
                hasParameter = false;
            }
            boolean bl = isParameterRest = parameterTypeDecorator != null && parameterTypeDecorator.isRest();
            if (isParameterRest) {
                paramRestType = Ref.create((Object)parameter);
                remainingParametersAreOptional = true;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isOptional()) {
                remainingParametersAreOptional = true;
            }
            JSParameterTypeDecorator argumentTypeDecorator = null;
            boolean hasArgument = true;
            if (argIterator.hasNext()) {
                argumentTypeDecorator = argIterator.next();
                argument = JSTypeUtils.getArgumentType(argumentTypeDecorator, isParameterRest);
                ++argIndex;
            } else if (argRestType != null) {
                argument = (JSType)argRestType.get();
            } else {
                hasArgument = false;
                argument = null;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isRest()) {
                argRestType = Ref.create((Object)argument);
                remainingArgumentsAreOptional = true;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isOptional()) {
                remainingArgumentsAreOptional = true;
            }
            if (!hasParameter) {
                return remainingArgumentsAreOptional;
            }
            JSType parameterRestTuple = JSTypeUtils.getRawRestParameterType((Ref<JSType>)paramRestType);
            JSType restTuple = JSTypeUtils.getRawRestParameterType((Ref<JSType>)argRestType);
            JSTupleType argRestTuple = restTuple instanceof JSTupleType ? (JSTupleType)restTuple : null;
            int tupleIndex = -argIndex + paramIndex;
            if (parameterTypeDecorator != null && parameterTypeDecorator.isRest()) {
                if (JSTypeUtils.matchRestTuples(processingContext, argIterator, argRestTuple, parameterRestTuple, tupleIndex, parameter, argumentTypeDecorator, argument)) {
                    continue;
                }
            } else if (argRestTuple != null && argRestTuple.hasTypeByIndex(tupleIndex)) {
                boolean result2 = JSTypeUtils.isAssignableType(parameter, argRestTuple.getTypeByIndex(tupleIndex), processingContext);
                if (result2) continue;
                return false;
            }
            if (!hasArgument) {
                return remainingParametersAreOptional || functionAssignment;
            }
            if (JSTypeUtils.isAssignableType(parameter, argument, processingContext) || functionAssignment && !jsDocFunctionAssignment && JSTypeUtils.isAssignableType(argument, parameter, processingContext)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static JSType getRawRestParameterType(@Nullable Ref<JSType> paramRestType) {
        JSType type;
        JSType jSType = type = paramRestType == null ? null : (JSType)paramRestType.get();
        if (type == null) {
            return null;
        }
        if (type instanceof JSRestTypeImpl) {
            return ((JSRestTypeImpl)type).getIterableType();
        }
        return new JSArrayTypeImpl(type, type.getSource());
    }

    @Nullable
    private static JSType getArgumentType(@NotNull JSParameterTypeDecorator argumentTypeDecorator, boolean isParameterRest) {
        JSType argument;
        if (argumentTypeDecorator == null) {
            JSTypeUtils.$$$reportNull$$$0(61);
        }
        if ((argument = argumentTypeDecorator.getSimpleType()) instanceof JSSimpleRecordTypeImpl && argument.getSourceElement() instanceof JSDestructuringObject) {
            Collection<JSRecordType.PropertySignature> properties2 = ((JSSimpleRecordTypeImpl)argument).getProperties();
            StreamEx newProperties = StreamEx.of(properties2).map(el -> new JSRecordTypeImpl.PropertySignatureImpl(el.getMemberName(), el.getJSType(), true, true, el.getMemberSource()));
            return new JSSimpleRecordTypeImpl(argument.getSource(), newProperties.toList());
        }
        if (argument instanceof JSSpreadType && isParameterRest) {
            argument = ((JSSpreadType)((Object)argument)).getComponentType();
        }
        return argument;
    }

    private static boolean matchRestTuples(@Nullable ProcessingContext processingContext, @NotNull Iterator<? extends JSParameterTypeDecorator> argIterator, @Nullable JSTupleType argRestTuple, @Nullable JSType paramRestType, int tupleOffset, @Nullable JSType parameter, @Nullable JSParameterTypeDecorator argumentTypeDecorator, @Nullable JSType argument) {
        JSTypeSource source2;
        if (argIterator == null) {
            JSTypeUtils.$$$reportNull$$$0(62);
        }
        if (paramRestType == null) {
            return false;
        }
        ArrayList<JSType> argumentTypes = new ArrayList<JSType>();
        if (argRestTuple != null) {
            if (argRestTuple.hasTypeByIndex(tupleOffset)) {
                argumentTypes.add(argRestTuple.getTypeByIndex(tupleOffset));
            }
            if (parameter instanceof JSRestTypeImpl) {
                List<JSType> types2 = argRestTuple.getTypes();
                for (int i2 = tupleOffset + 1; i2 < types2.size(); ++i2) {
                    argumentTypes.add(types2.get(i2));
                }
            }
        } else if (argument != null) {
            argumentTypes.add(argument);
        }
        JSTypeSource jSTypeSource = source2 = argument != null ? argument.getSource() : paramRestType.getSource();
        if (argumentTypeDecorator != null && argumentTypeDecorator.isRest() && argumentTypes.size() == 1) {
            return JSTypeUtils.isAssignableType(paramRestType, new JSArrayTypeImpl(JSTypeUtils.widenLiteralTypes((JSType)argumentTypes.get(0)), source2), processingContext);
        }
        int firstOptional = argumentTypeDecorator != null && argumentTypeDecorator.isOptional() ? 0 : -1;
        int i3 = -1;
        while (argIterator.hasNext()) {
            JSType type;
            ++i3;
            JSParameterTypeDecorator nextDecorator = argIterator.next();
            if (nextDecorator == null) continue;
            if (firstOptional == -1 && nextDecorator.isOptional()) {
                firstOptional = i3;
            }
            argumentTypes.add((type = nextDecorator.getInferredType()) != null && nextDecorator.isRest() ? new JSSpreadTypeImpl(type.getSource(), type) : type);
        }
        return JSTypeUtils.isAssignableType(paramRestType, JSCompositeTypeFactory.createTupleType(source2, argumentTypes, true, firstOptional, false), processingContext);
    }

    @NotNull
    private static List<JSParameterTypeDecorator> expandByTupleTypes(@NotNull List<JSParameterTypeDecorator> parameters) {
        JSParameterTypeDecorator lastItem;
        if (parameters == null) {
            JSTypeUtils.$$$reportNull$$$0(63);
        }
        if ((lastItem = (JSParameterTypeDecorator)ContainerUtil.getLastItem(parameters)) == null) {
            List<JSParameterTypeDecorator> list2 = parameters;
            if (list2 == null) {
                JSTypeUtils.$$$reportNull$$$0(64);
            }
            return list2;
        }
        JSType type = lastItem.getSimpleType();
        if (!(type instanceof JSSpreadOrRestType)) {
            List<JSParameterTypeDecorator> list3 = parameters;
            if (list3 == null) {
                JSTypeUtils.$$$reportNull$$$0(65);
            }
            return list3;
        }
        JSType innerType = ((JSSpreadOrRestType)((Object)type)).getInnerType();
        if (!(innerType instanceof JSTupleType)) {
            List<JSParameterTypeDecorator> list4 = parameters;
            if (list4 == null) {
                JSTypeUtils.$$$reportNull$$$0(66);
            }
            return list4;
        }
        int maxLength = ((JSTupleType)innerType).getMaxLength();
        if (type instanceof JSRestType && maxLength == Integer.MAX_VALUE) {
            List<JSParameterTypeDecorator> list5 = parameters;
            if (list5 == null) {
                JSTypeUtils.$$$reportNull$$$0(67);
            }
            return list5;
        }
        ArrayList<JSParameterTypeDecorator> expanded = new ArrayList<JSParameterTypeDecorator>(parameters.size());
        expanded.addAll(parameters);
        expanded.remove(expanded.size() - 1);
        if (maxLength != Integer.MAX_VALUE) {
            for (int i2 = 0; i2 < maxLength; ++i2) {
                expanded.add(new JSParameterTypeDecoratorImpl(((JSTupleType)innerType).getTypeByIndex(i2), i2 >= ((JSTupleType)innerType).getOptionalStart(), false, false));
            }
        } else {
            List<JSType> types2 = ((JSTupleType)innerType).getTypes();
            for (int i3 = 0; i3 < types2.size(); ++i3) {
                JSType jsType2 = types2.get(i3);
                expanded.add(new JSParameterTypeDecoratorImpl(jsType2 instanceof JSSpreadType ? ((JSSpreadType)((Object)jsType2)).getComponentType() : jsType2, false, i3 == types2.size() - 1, false));
            }
        }
        ArrayList<JSParameterTypeDecorator> arrayList = expanded;
        if (arrayList == null) {
            JSTypeUtils.$$$reportNull$$$0(68);
        }
        return arrayList;
    }

    @Nullable
    public static Predicate<JSType> getGenericArgumentsConditionForSubstitution(@NotNull JSType startType) {
        if (startType == null) {
            JSTypeUtils.$$$reportNull$$$0(69);
        }
        final Ref evaluateAllGenerics = Ref.create((Object)false);
        final ArrayList genericIds = new ArrayList();
        startType.accept(new JSRecursiveTypeVisitor(false){

            @Override
            public void visitJSType(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((Boolean)evaluateAllGenerics.get()).booleanValue()) {
                    return;
                }
                if (type instanceof JSTypeWithOuterGenerics || type instanceof JSClassExpressionType || type instanceof JSTypeImpl && (!type.isTypeScript() || ((JSTypeImpl)type).resolveType().isLocal())) {
                    evaluateAllGenerics.set((Object)true);
                } else if (type instanceof TypeScriptGenericThisTypeImpl) {
                    genericIds.add(((TypeScriptGenericThisTypeImpl)type).getGenericId());
                } else if (type instanceof JSGenericParameterImpl) {
                    genericIds.add(((JSGenericParameterImpl)type).getGenericId());
                } else if (type instanceof JSCodeBasedType) {
                    genericIds.addAll(ContainerUtil.map(JSTypeUtils.findAllTypeParameters((JSCodeBasedType)type), TypeScriptGenericOrMappedTypeParameter::getGenericId));
                }
                super.visitJSType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils$1", "visitJSType"));
            }
        });
        if (((Boolean)evaluateAllGenerics.get()).booleanValue()) {
            return x -> true;
        }
        if (!genericIds.isEmpty()) {
            return x -> x instanceof TypeScriptGenericThisTypeImpl ? genericIds.contains(((TypeScriptGenericThisTypeImpl)x).getGenericId()) : x instanceof JSGenericParameterImpl && genericIds.contains(((JSGenericParameterImpl)x).getGenericId());
        }
        return null;
    }

    @Contract(value="!null, _, _, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType initialType, final @Nullable JSTypeSubstitutor typeArguments, boolean call, final @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (initialType == null || typeArguments == null || typeArguments.isEmpty()) {
            return initialType;
        }
        PsiElement element = initialType.getSource().getSourceElement();
        final ProcessingContext context = JSTypeComparingContextService.setCallEnvironment(JSTypeComparingContextService.createProcessingContextWithCache(element), call);
        return initialType.transformTypeHierarchy(new JSRecursiveExpandTransformer(true){

            @Override
            protected boolean isIgnored(@NotNull JSType appliedType) {
                if (appliedType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return appliedType instanceof JSSpecialNamedTypeImpl || appliedType instanceof JSAnyType || appliedType instanceof TypeScriptNeverJSTypeImpl;
            }

            @Override
            @NotNull
            protected JSType expand(@NotNull JSType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                JSType jSType = JSTypeUtils.expandForTypeSubstitutor(type, typeArguments);
                if (jSType == null) {
                    2.$$$reportNull$$$0(2);
                }
                return jSType;
            }

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (type instanceof JSGenericTypeImpl) {
                    boolean applyForArguments = this.shouldApplyForArguments(type);
                    JSType jSType = applyForArguments ? type : JSTypeBaseImpl.getSelfNoTransformationType();
                    if (jSType == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return jSType;
                }
                if (type instanceof JSTypeWithOuterGenerics) {
                    JSTypeWithOuterGenerics remappedType = JSTypeUtils.concatGenericsToJSGenericTypeIfNestedLocal((JSTypeWithOuterGenerics)type, typeArguments);
                    JSType jSType = remappedType.isEquivalentTo(type, context, false) ? JSTypeBaseImpl.getSelfNoTransformationType() : remappedType;
                    if (jSType == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return jSType;
                }
                if (type instanceof TypeScriptGenericThisTypeImpl && typeArguments.containsId(((TypeScriptGenericThisTypeImpl)type).getGenericId())) {
                    JSType substitutionType = typeArguments.get(((TypeScriptGenericThisTypeImpl)type).getGenericId());
                    boolean useSelf = substitutionType == null || substitutionType instanceof TypeScriptGenericThisTypeImpl && type.getResolvedTypeId().equals(substitutionType.getResolvedTypeId());
                    JSType jSType = useSelf ? JSTypeBaseImpl.getSelfNoTransformationType() : substitutionType;
                    if (jSType == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    return jSType;
                }
                if (type instanceof JSGenericParameterImpl) {
                    JSType jsType2 = typeArguments.get(((JSGenericParameterImpl)type).getGenericId());
                    if (jsType2 != null) {
                        JSType afterProcess = this.processGenericParameter((JSGenericParameterImpl)type, jsType2);
                        JSType jSType = afterProcess == type ? JSTypeBaseImpl.getSelfNoTransformationType() : afterProcess;
                        if (jSType == null) {
                            2.$$$reportNull$$$0(7);
                        }
                        return jSType;
                    }
                } else if (type instanceof JSTypeImpl && type.isTypeScript()) {
                    JSResolvedTypeInfo resolvedType = ((JSResolvableType)type).resolveType();
                    if (resolvedType.isLocal()) {
                        return new JSTypeWithOuterGenerics(type, typeArguments);
                    }
                } else if (type instanceof JSTypeImpl) {
                    JSType jsType3 = typeArguments.get(new JSTypeSubstitutor.StringGenericId(type.getTypeText()));
                    if (jsType3 != null) {
                        if (jsType3.isTypeScript()) {
                            JSType jSType = type;
                            if (jSType == null) {
                                2.$$$reportNull$$$0(8);
                            }
                            return jSType;
                        }
                        JSType jSType = jsType3 == type ? JSTypeBaseImpl.getSelfNoTransformationType() : jsType3;
                        if (jSType == null) {
                            2.$$$reportNull$$$0(9);
                        }
                        return jSType;
                    }
                } else if (type instanceof JSClassExpressionType) {
                    return new JSTypeWithOuterGenerics(type, typeArguments);
                }
                JSType jSType = type;
                if (jSType == null) {
                    2.$$$reportNull$$$0(10);
                }
                return jSType;
            }

            @NotNull
            private JSType processGenericParameter(@NotNull JSGenericParameterImpl currentType, @NotNull JSType replacement) {
                JSType newConstraint;
                if (currentType == null) {
                    2.$$$reportNull$$$0(11);
                }
                if (replacement == null) {
                    2.$$$reportNull$$$0(12);
                }
                JSType oldConstraint = currentType.getConstraintType();
                if (report != null && oldConstraint != null && !(newConstraint = JSTypeUtils.applyCompositeMapping(oldConstraint, this)).isDirectlyAssignableType(replacement, context)) {
                    PsiElement sourceElement = currentType.getSource().getSourceElement();
                    TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptPropertySignature.class});
                    if (!(propertySignature != null && propertySignature.isOptional() || newConstraint instanceof JSKeyofType)) {
                        report.error(JavaScriptBundle.message("typescript.validation.cannot.find.best.common.type", new Object[0]));
                    }
                    JSType jSType = newConstraint;
                    if (jSType == null) {
                        2.$$$reportNull$$$0(13);
                    }
                    return jSType;
                }
                JSType jSType = replacement instanceof JSGenericParameterImpl && replacement != currentType && replacement.getResolvedTypeId().equals(currentType.getResolvedTypeId()) ? currentType : replacement;
                if (jSType == null) {
                    2.$$$reportNull$$$0(14);
                }
                return jSType;
            }

            public boolean shouldApplyForArguments(@NotNull JSType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(15);
                }
                JSResolvedTypeId ownId = type.getResolvedTypeId();
                return typeArguments.types().stream().noneMatch(subst -> subst != null && Objects.equals(ownId, subst.getResolvedTypeId()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "appliedType";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils$2";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentType";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "replacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expand";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                    case 13: 
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processGenericParameter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isIgnored";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "expand";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "processGenericParameter";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldApplyForArguments";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean needsExpandingForTypeSubstitutor(@NotNull JSCodeBasedType type, @NotNull Condition<? super TypeScriptTypeParameter> condition) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(70);
        }
        if (condition == null) {
            JSTypeUtils.$$$reportNull$$$0(71);
        }
        return ContainerUtil.exists(JSTypeUtils.findAllTypeParameters(type), condition);
    }

    @NotNull
    private static Collection<TypeScriptTypeParameter> findAllTypeParameters(@NotNull JSCodeBasedType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(72);
        }
        PsiElement sourceElement = type.getSourceElement();
        TypeScriptTypeParameterListOwner parent = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, TypeScriptTypeParameterListOwner.class, (boolean)false);
        ArrayList<TypeScriptTypeParameter> result2 = new ArrayList<TypeScriptTypeParameter>();
        while (parent != null) {
            ContainerUtil.addAll(result2, (Object[])parent.getTypeParameters());
            parent = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getContextOfType((PsiElement)parent, (Class[])new Class[]{TypeScriptTypeParameterListOwner.class});
        }
        ArrayList<TypeScriptTypeParameter> arrayList = result2;
        if (arrayList == null) {
            JSTypeUtils.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    public static JSType expandForTypeSubstitutor(@NotNull JSType type, JSTypeSubstitutor typeArguments) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(74);
        }
        return type instanceof JSCodeBasedType && JSTypeUtils.needsExpandingForTypeSubstitutor((JSCodeBasedType)type, (Condition<? super TypeScriptTypeParameter>)((Condition)el -> typeArguments.containsId(el.getGenericId()))) ? type.substitute() : type;
    }

    @NotNull
    private static JSTypeWithOuterGenerics concatGenericsToJSGenericTypeIfNestedLocal(@NotNull JSTypeWithOuterGenerics genericType, @NotNull JSTypeSubstitutor typeArguments) {
        JSType jsType2;
        JSResolvedTypeInfo resolvedType;
        JSType innerType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(75);
        }
        if (typeArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(76);
        }
        if ((innerType = genericType.getType()) instanceof JSResolvableType && (resolvedType = ((JSResolvableType)innerType).resolveType()).isLocal() && (jsType2 = typeArguments.get(new JSTypeSubstitutor.StringGenericId(innerType.getTypeText()))) == null) {
            JSTypeSubstitutor newOuterArguments = typeArguments;
            JSTypeSubstitutor outerArguments = genericType.getOuterArguments();
            if (!outerArguments.isEmpty() && (newOuterArguments = JSTypeSubstitutorImpl.combine(newOuterArguments, outerArguments)) == outerArguments) {
                JSTypeWithOuterGenerics jSTypeWithOuterGenerics = genericType;
                if (jSTypeWithOuterGenerics == null) {
                    JSTypeUtils.$$$reportNull$$$0(77);
                }
                return jSTypeWithOuterGenerics;
            }
            return new JSTypeWithOuterGenerics(innerType, newOuterArguments);
        }
        JSTypeWithOuterGenerics jSTypeWithOuterGenerics = genericType;
        if (jSTypeWithOuterGenerics == null) {
            JSTypeUtils.$$$reportNull$$$0(78);
        }
        return jSTypeWithOuterGenerics;
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable JSTypeSubstitutor typeArguments) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, null);
    }

    @Nullable
    @Contract(value="_,!null, _ -> !null")
    public static JSType addJSGenericParameters(@NotNull Project project, @Nullable JSType _type, @NotNull @NotNull Map<@NotNull String, @Nullable String> genericParameters) {
        if (project == null) {
            JSTypeUtils.$$$reportNull$$$0(79);
        }
        if (genericParameters == null) {
            JSTypeUtils.$$$reportNull$$$0(80);
        }
        if (_type == null || genericParameters.isEmpty()) {
            return _type;
        }
        return JSTypeUtils.applyCompositeMapping(_type, (com.intellij.util.Function<? super JSType, ? extends JSType>)((com.intellij.util.Function)type -> {
            if (type instanceof JSTypeImpl && genericParameters.containsKey(type.getTypeText())) {
                String typeConstraintString = (String)genericParameters.get(type.getTypeText());
                JSType typeConstraint = typeConstraintString != null ? new JSTypeParser(project, typeConstraintString, type.getSource()).parse() : null;
                JSTypeBaseImpl result2 = new JSGenericParameterImpl(type.getTypeText(), type.getSource(), typeConstraint);
                if (((JSTypeImpl)type).getJSContext() == JSContext.STATIC) {
                    result2 = new JSApplyTypeofType(result2, result2.getSource());
                }
                return result2;
            }
            return type;
        }));
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyCompositeMapping(@Nullable JSType type, @NotNull com.intellij.util.Function<? super JSType, ? extends JSType> f) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(81);
        }
        return JSTypeUtils.transformTypeHierarchySafe(type, f);
    }

    public static boolean hasForeignGenericParameter(@Nullable JSType startType) {
        if (startType == null) {
            return false;
        }
        if (startType instanceof JSGenericParameterImpl) {
            return true;
        }
        return JSTypeUtils.hasForeignGenericParameter(startType, new HashSet());
    }

    public static boolean hasForeignGenericParameter(@NotNull JSType startType, @NotNull Set<? extends JSTypeSubstitutor.JSTypeGenericId> startIgnoredIds) {
        if (startType == null) {
            JSTypeUtils.$$$reportNull$$$0(82);
        }
        if (startIgnoredIds == null) {
            JSTypeUtils.$$$reportNull$$$0(83);
        }
        final Ref result2 = Ref.create();
        final HashSet<? extends JSTypeSubstitutor.JSTypeGenericId> ignoredIds = new HashSet<JSTypeSubstitutor.JSTypeGenericId>(startIgnoredIds);
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(false){

            @Override
            public void visitJSType(@NotNull JSType currentType) {
                boolean hasNewIgnored;
                if (currentType == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!result2.isNull()) {
                    return;
                }
                if (currentType instanceof JSGenericParameterImpl && !ignoredIds.contains(((JSGenericParameterImpl)currentType).getGenericId())) {
                    result2.set((Object)Boolean.TRUE);
                    return;
                }
                Set newIgnoredIds = currentType instanceof JSTypeWithGenericParameters ? ((JSTypeWithGenericParameters)((Object)currentType)).getGenericIds() : Collections.emptySet();
                boolean bl = hasNewIgnored = !newIgnoredIds.isEmpty();
                if (hasNewIgnored) {
                    ignoredIds.addAll(newIgnoredIds);
                }
                super.visitJSType(currentType);
                if (hasNewIgnored) {
                    ignoredIds.removeAll(newIgnoredIds);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentType", "com/intellij/lang/javascript/psi/JSTypeUtils$3", "visitJSType"));
            }
        };
        visitor.visitJSType(startType);
        return !result2.isNull();
    }

    public static boolean hasTypes(@Nullable JSType type, Class<?> ... typeClasses) {
        if (typeClasses == null) {
            JSTypeUtils.$$$reportNull$$$0(84);
        }
        return JSTypeUtils.hasTypes(type, (? super JSType t) -> {
            for (Class typeClass : typeClasses) {
                if (!typeClass.isInstance(t)) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean hasTypes(@Nullable JSType type, final @NotNull Predicate<? super JSType> condition) {
        if (condition == null) {
            JSTypeUtils.$$$reportNull$$$0(85);
        }
        if (type == null) {
            return false;
        }
        if (condition.test(type)) {
            return true;
        }
        final Ref result2 = Ref.create();
        type.acceptChildren(new JSRecursiveTypeVisitor(false){

            @Override
            public void visitJSType(@NotNull JSType typeToVisit) {
                if (typeToVisit == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!result2.isNull()) {
                    return;
                }
                if (condition.test(typeToVisit)) {
                    result2.set((Object)Boolean.TRUE);
                    return;
                }
                super.visitJSType(typeToVisit);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeToVisit", "com/intellij/lang/javascript/psi/JSTypeUtils$4", "visitJSType"));
            }
        });
        return !result2.isNull();
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrictRecursive(@Nullable JSType type, boolean strict) {
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy(new JSCopyWithStrictTransformer(strict));
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrict(@Nullable JSType type, boolean strict) {
        if (type == null) {
            return null;
        }
        return type.copyWithStrict(strict);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static JSType copyWithLanguageOfContext(@Nullable JSType jsType2, @NotNull PsiElement context) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(86);
        }
        return JSTypeUtils.copyWithLanguageRecursive(jsType2, JSTypeSourceFactory.getSourceLanguage(context));
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static JSType copyWithLanguageRecursive(@Nullable JSType jsType2, @NotNull JSTypeSource.SourceLanguage language) {
        if (language == null) {
            JSTypeUtils.$$$reportNull$$$0(87);
        }
        return JSTypeBaseImpl.copyWithLanguageRecursive(jsType2, language);
    }

    @NotNull
    public static List<JSType> addPossibleOption(@NotNull Set<? extends JSType> types2, @NotNull JSType newOption) {
        if (types2 == null) {
            JSTypeUtils.$$$reportNull$$$0(88);
        }
        if (newOption == null) {
            JSTypeUtils.$$$reportNull$$$0(89);
        }
        int typesCount = 0;
        JSTypeSource optionSource = newOption.getSource();
        List typesToAdd = newOption instanceof JSUnionType && !optionSource.isStrict() ? ContainerUtil.map(((JSUnionType)newOption).getTypes(), t -> JSTypeUtils.copyWithStrict(t, false)) : Collections.singletonList(newOption);
        SmartList result2 = new SmartList();
        if (types2.isEmpty()) {
            result2.addAll(typesToAdd);
            SmartList smartList = result2;
            if (smartList == null) {
                JSTypeUtils.$$$reportNull$$$0(90);
            }
            return smartList;
        }
        for (JSType typeToAdd : typesToAdd) {
            if (types2.contains(typeToAdd)) continue;
            if (!newOption.isTypeScript() && typesCount > 5) {
                JSAnyType anyType = JSAnyType.getWithLanguage(optionSource.getLanguage(), false);
                if (types2.contains(anyType)) continue;
                result2.add(anyType);
                break;
            }
            result2.add(typeToAdd);
            ++typesCount;
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(91);
        }
        return smartList;
    }

    public static boolean processExpandedType(JSTypeProcessor processor, JSType type, @NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(92);
        }
        return JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)type1 -> {
            processor.process((JSType)type1, context);
            return true;
        }), type, true, false, false);
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(93);
        }
        return JSTypeUtils.processExpandedType(processor, type, false, true, true);
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type, boolean completeSubstitute, boolean recurse, boolean processOnlyFinalType) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(94);
        }
        return JSTypeUtils.processExpandedType(processor, type, completeSubstitute, recurse, processOnlyFinalType, null);
    }

    private static Set<JSResolvedTypeId> getOrCreateProcessingSet(@NotNull JSType type, @Nullable Set<JSResolvedTypeId> processedTypeIds) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(95);
        }
        if (processedTypeIds != null) {
            return processedTypeIds;
        }
        HashSet<JSResolvedTypeId> set = new HashSet<JSResolvedTypeId>();
        set.add(type.getResolvedTypeId());
        return set;
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type, boolean completeSubstitute, boolean recurse, boolean processOnlyFinalType, @Nullable Set<JSResolvedTypeId> processedTypeIds) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(96);
        }
        if (type != null && processedTypeIds != null && !processedTypeIds.add(type.getResolvedTypeId())) {
            return false;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            boolean isStrictTypeScript = JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionOrIntersectionType)type);
            if (isStrictTypeScript && completeSubstitute) {
                JSType resolveUnionType = type.substitute();
                if (resolveUnionType == type) {
                    resolveUnionType = type.asRecordType();
                }
                processor.process((Object)resolveUnionType);
            } else {
                processedTypeIds = JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds);
                List types2 = ((JSUnionOrIntersectionType)type).getTypes();
                if (type instanceof JSIntersectionType && type.getSourceElement() instanceof JSObjectLiteralExpression) {
                    types2 = ContainerUtil.reverse(types2);
                }
                for (JSType jsType2 : types2) {
                    if (!processOnlyFinalType) {
                        processor.process((Object)jsType2);
                    }
                    if (!recurse) continue;
                    JSTypeUtils.processExpandedType(processor, jsType2, completeSubstitute, true, processOnlyFinalType, processedTypeIds);
                }
            }
            return false;
        }
        if (type instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeSource typeSource = type.getSource();
            if (typeSource.isStrict() && type.resolveClass() == null && (typedefValue = ((JSTypeImpl)type).getJSTypedef()) != null || (typedefValue = ((JSTypeImpl)type).resolveType().getAliasedType()) != null) {
                JSType expanded;
                if (typeSource.isTypeScript() && typeSource.getSourceElement() instanceof TypeScriptSingleType && (expanded = JSTypeImpl.expandDefaultGenericsForSingleType(type, ContainerUtil.emptyList(), ((JSTypeImpl)type).resolveType().getDeclarations())) instanceof JSGenericTypeImpl) {
                    typedefValue = expanded.substitute();
                }
                if (!processOnlyFinalType) {
                    processor.process((Object)typedefValue);
                }
                if (!recurse) {
                    return true;
                }
                return JSTypeUtils.processExpandedType(processor, typedefValue, completeSubstitute, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
        } else {
            JSType newType = type;
            if (!(!(type instanceof JSEvaluableType) && !(type instanceof JSTypeWithIncompleteSubstitution) || type instanceof JSEvaluableOnlyType && type.isJavaScript())) {
                JSType jSType = newType = completeSubstitute ? JSTypeWithIncompleteSubstitution.substituteCompletely(type) : type.substitute();
            }
            if (type != (newType = JSTypeUtils.unwrapType(newType))) {
                if (!processOnlyFinalType) {
                    processor.process((Object)newType);
                }
                if (recurse) {
                    JSTypeUtils.processExpandedType(processor, newType, completeSubstitute, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
                }
                return false;
            }
        }
        if (processOnlyFinalType) {
            processor.process((Object)type);
        }
        return true;
    }

    public static boolean areTypesCompatible(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext processingContext, @Nullable PsiElement psiContext) {
        boolean eq;
        JSType substitute;
        if (type1 == null) {
            type1 = JSAnyType.get(psiContext, false);
        }
        if (type2 == null) {
            type2 = JSAnyType.get(psiContext, false);
        }
        if (type1 instanceof JSCodeBasedType && (substitute = type1.substitute()) != type1) {
            return JSTypeUtils.areTypesCompatible(substitute, type2, processingContext, psiContext);
        }
        if (type2 instanceof JSCodeBasedType && (substitute = type2.substitute()) != type2) {
            return JSTypeUtils.areTypesCompatible(type1, substitute, processingContext, psiContext);
        }
        if (type1 instanceof JSStringLiteralTypeImpl) {
            return type2 instanceof JSStringType;
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return type1 instanceof JSStringType;
        }
        if (type1 instanceof JSArrayType && !((JSArrayType)type1).isPrimitive()) {
            if (type2 instanceof JSArrayType && ((JSArrayType)type2).isPrimitive()) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type2)) {
                return true;
            }
        }
        if (type2 instanceof JSArrayType && !((JSArrayType)type2).isPrimitive()) {
            if (type1 instanceof JSArrayType && ((JSArrayType)type1).isPrimitive()) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type1)) {
                return true;
            }
        }
        if (eq = type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (psiContext != null && !DialectDetector.isActionScript(psiContext)) {
            return type1.isDirectlyAssignableType(type2, processingContext) && type2.isDirectlyAssignableType(type1, processingContext);
        }
        return false;
    }

    @Nullable
    public static JSType getTypeOfElement(@Nullable PsiElement element) {
        if (element instanceof TypeScriptPropertySignature && ((TypeScriptPropertySignature)element).isOptional() && ((TypeScriptPropertySignature)element).getJSType() != null) {
            return TypeScriptTypeGuard.wrapWithUndefined(((TypeScriptPropertySignature)element).getJSType(), null);
        }
        if (element instanceof JSClass) {
            return ((JSClass)element).getStaticJSType();
        }
        if (element instanceof JSTypeOwner) {
            return ((JSTypeOwner)element).getJSType();
        }
        if (element instanceof JSImplicitElement) {
            return JSTypeParser.createType(element.getProject(), ((JSImplicitElement)element).getTypeString(), JSTypeSourceFactory.createTypeSource(element, true));
        }
        if (element instanceof JSFunction && ((JSFunction)element).isGetProperty()) {
            return ((JSFunction)element).getReturnType();
        }
        return null;
    }

    public static boolean isActionScriptVectorType(@Nullable JSType type) {
        if (type == null || type.getSource().isTypeScript()) {
            return false;
        }
        return "Vector".equals(JSTypeUtils.getQualifiedNameMatchingType(type, false));
    }

    @NotNull
    public static String defaultValueOfType(@Nullable JSType retType) {
        if (retType == null) {
            return "undefined";
        }
        String string = retType.getDefaultValue();
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(97);
        }
        return string;
    }

    @Deprecated
    @NonNls
    public static String defaultValueOfType(@NonNls String retType) {
        if (retType == null) {
            return "null";
        }
        switch (retType) {
            case "int": 
            case "uint": 
            case "Number": {
                return "0";
            }
            case "Boolean": {
                return "false";
            }
            case "String": {
                return "\"\"";
            }
        }
        return "null";
    }

    @Nullable
    public static List<JSType> getGenericTypeArguments(@Nullable JSType type) {
        JSType constraintType;
        if (type instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)type).getArguments();
        }
        if (type instanceof JSTupleType) {
            return JSTypeUtils.getGenericTypeArguments(((JSTupleType)type).toArrayType(true));
        }
        if (type instanceof JSArrayType) {
            JSType jsType2 = (JSType)ObjectUtils.coalesce((Object)((JSArrayType)type).getType(), (Object)JSAnyType.get(type.getSource().getSourceElement(), type.isSourceStrict()));
            return Collections.singletonList(jsType2);
        }
        if (type instanceof JSAliasTypeImpl) {
            return JSTypeUtils.getGenericTypeArguments(((JSAliasTypeImpl)type).getAlias());
        }
        if (type instanceof JSGenericParameterType && (constraintType = ((JSGenericParameterType)type).getConstraintType()) != null) {
            return JSTypeUtils.getGenericTypeArguments(constraintType);
        }
        return null;
    }

    @Contract(value="!null,_->!null")
    public static JSType expandEnumAndLiteralTypeByExpectedType(@Nullable JSType original, @Nullable JSType expectedType) {
        if (JSTypeUtils.containsLiteralTypes(expectedType) || JSTypeUtils.isEnumLiteralWithContextNumberOrString(original, expectedType)) {
            return original;
        }
        return JSTypeUtils.widenLiteralTypes(original, true);
    }

    private static boolean isEnumLiteralWithContextNumberOrString(@Nullable JSType expressionJSType, @Nullable JSType expectedType) {
        return JSTypeUtils.isEnumLiteral(expressionJSType) && (expectedType instanceof JSStringType || expectedType instanceof JSNumberType);
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralTypes(@Nullable JSType type) {
        JSType constraintType;
        if (JSTypeCastUtil.isTypeOperatorLikeType(type)) {
            return true;
        }
        if (type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null) {
            type = constraintType;
        }
        if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
            return true;
        }
        Ref hasLiteral = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (JSTypeUtils.isLiteralType(t, true)) {
                hasLiteral.set((Object)true);
                return false;
            }
            return true;
        }), type);
        return (Boolean)hasLiteral.get();
    }

    public static boolean isLiteralType(@Nullable JSType t, boolean expandTypeof) {
        JSType constraintType;
        if (t instanceof JSLiteralType) {
            return true;
        }
        if (t instanceof JSTemplateLiteralType) {
            return true;
        }
        if (t instanceof JSKeyofType) {
            return true;
        }
        if (JSTypeUtils.isEnumLiteral(t)) {
            return true;
        }
        if (t instanceof TypeScriptConditionalTypeJSTypeImpl && JSTypeUtils.hasForeignGenericParameter(t) && (JSTypeUtils.isLiteralType(((TypeScriptConditionalTypeJSTypeImpl)t).getTypeIfTrue(), false) || JSTypeUtils.isLiteralType(((TypeScriptConditionalTypeJSTypeImpl)t).getTypeIfFalse(), false))) {
            return true;
        }
        if (t instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)t).getConstraintType()) != null && JSTypeUtils.isLiteralType(constraintType, false)) {
            return true;
        }
        if (expandTypeof) {
            return JSTypeUtils.isLiteralType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(t), false);
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isEnumLiteral(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        return info.isEnumLiteral();
    }

    @Contract(value="null, _ -> false")
    public static boolean isStringOrStringUnion(@Nullable JSType type, boolean allowResolve) {
        if (type == null) {
            return false;
        }
        if (allowResolve) {
            type = type.substitute();
        }
        if (type instanceof JSStringType) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().allMatch(el -> JSTypeUtils.isStringOrStringUnion(el, allowResolve));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isLiteralOrCompositeWithLiteralType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isLiteralType(type, true)) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().anyMatch(el -> JSTypeUtils.isLiteralOrCompositeWithLiteralType(el));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralOrEnumOrPrimitiveTypes(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        Ref hasLiteralOrPrimitiveOrEnum = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            JSResolvedTypeInfo info;
            if (t instanceof JSStringType || t instanceof JSNumberType || t instanceof JSBooleanType || t instanceof JSBigIntType || JSTypeUtils.isLiteralType(t, true)) {
                hasLiteralOrPrimitiveOrEnum.set((Object)true);
            }
            if (t instanceof JSTypeImpl && (info = ((JSTypeImpl)t).resolveType()).isEnum()) {
                hasLiteralOrPrimitiveOrEnum.set((Object)true);
            }
            return true;
        }), type);
        return (Boolean)hasLiteralOrPrimitiveOrEnum.get();
    }

    @Nullable
    @Contract(value="!null->!null")
    public static JSType widenLiteralTypes(@Nullable JSType type) {
        return JSTypeUtils.widenLiteralTypes(type, false);
    }

    @Nullable
    @Contract(value="!null,_->!null")
    public static JSType widenLiteralTypes(@Nullable JSType type, boolean allowResolve) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSTypeWithWidening && ((JSTypeWithWidening)type).allowWidening()) {
            return ((JSTypeWithWidening)type).widen(allowResolve);
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)nested -> JSTypeUtils.widenLiteralTypes(nested, allowResolve)));
        }
        return type;
    }

    private static boolean isUnionTypeWithLiteralCandidate(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(98);
        }
        return type instanceof JSUnionType && JSTypeUtils.hasTypes(type, JSStringLiteralTypeImpl.class, JSNumberLiteralTypeImpl.class, JSBigIntLiteralTypeImpl.class, JSBooleanLiteralTypeImpl.class, JSTypeImpl.class);
    }

    @Contract(value="!null->!null")
    public static JSType getApparentType(@Nullable JSType type) {
        if ((type = JSTypeUtils.widenLiteralTypes(type)) instanceof JSNullType || type instanceof JSUndefinedType) {
            return JSAnyType.get(type.getSource());
        }
        if (type instanceof JSTypeofTypeImpl) {
            return JSWidenType.createWidening(type, null);
        }
        if (JSTypeUtils.hasTypes(type, JSUnionOrIntersectionType.class, JSTupleType.class)) {
            type = JSTypeUtils.simpleOptimizeNestedCompositeTypes(type);
        }
        return type;
    }

    @NotNull
    public static JSType simpleOptimizeNestedCompositeTypes(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(99);
        }
        JSCacheableTypeTransformerBase cacheableTransformation = new JSCacheableTypeTransformerBase(){

            @Override
            @NotNull
            public JSType fun(@NotNull JSType type) {
                JSType optimizeTypeIfComposite;
                if (type == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (type instanceof JSUnionOrIntersectionType && type != (optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(type, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE))) {
                    JSType jSType = optimizeTypeIfComposite.transformTypeHierarchy(this);
                    if (jSType == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                if (type instanceof JSTupleType) {
                    JSTupleType tupleType = (JSTupleType)type;
                    JSType jSType = JSCompositeTypeFactory.createTupleType(type.getSource(), ContainerUtil.map(tupleType.getTypes(), t -> t.transformTypeHierarchy(this)), tupleType.getNames(), !tupleType.allowWidening(), tupleType.getOptionalStart(), tupleType.isReadonly());
                    if (jSType == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    return jSType;
                }
                JSType jSType = type;
                if (jSType == null) {
                    5.$$$reportNull$$$0(3);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils$5";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        JSType jSType = type = type.transformTypeHierarchy((com.intellij.util.Function<? super JSType, ? extends JSType>)cacheableTransformation);
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(100);
        }
        return jSType;
    }

    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable DialectOptionHolder holder, boolean allowResolve) {
        boolean isTypeScript;
        if (type1 == null) {
            JSTypeUtils.$$$reportNull$$$0(101);
        }
        if (type2 == null) {
            JSTypeUtils.$$$reportNull$$$0(102);
        }
        JSTypeSource source2 = type1.getSource();
        boolean bl = isTypeScript = holder != null && holder.isTypeScript;
        if (!(!(type1 instanceof JSStringType) || !(type2 instanceof JSStringType) || isTypeScript && type1 instanceof JSStringLiteralTypeImpl && type2 instanceof JSStringLiteralTypeImpl)) {
            return JSNamedTypeFactory.createType("string", source2, ((JSStringType)type1).isStaticOrInstance());
        }
        if (isTypeScript) {
            return JSCompositeTypeImpl.getCommonType(type1, type2, null, allowResolve);
        }
        if (type1.isEquivalentTo(type2, null, allowResolve)) {
            return type1;
        }
        return JSAnyType.getWithLanguage(source2.getLanguage(), false);
    }

    @NotNull
    public static JSType replaceImplicitTypesWithAny(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(103);
        }
        JSType jSType = type.transformTypeHierarchy((com.intellij.util.Function<? super JSType, ? extends JSType>)((com.intellij.util.Function)jsType2 -> {
            JSType toProcess = JSTypeUtils.getValuableType(jsType2);
            if (jsType2 instanceof JSAnyType) {
                return jsType2;
            }
            if (!toProcess.isSourceStrict() && toProcess.isTypeScript()) {
                PsiElement sourceElement = toProcess.getSource().getSourceElement();
                return sourceElement != null ? JSAnyType.get(sourceElement, true) : JSAnyType.getWithLanguage(toProcess.getSource().getLanguage(), true);
            }
            return jsType2;
        }));
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(104);
        }
        return jSType;
    }

    public static boolean isAnyType(JSType expressionType) {
        return expressionType instanceof JSAnyType || expressionType instanceof JSUnionType && ((JSUnionType)expressionType).isAnyType() || expressionType instanceof JSCodeBasedType;
    }

    @Contract(value="!null->!null;null->null")
    public static JSType unwrapType(@Nullable JSType topOwnerType) {
        for (int i2 = 0; topOwnerType instanceof JSWrapperType && i2 < 10; ++i2) {
            topOwnerType = ((JSWrapperType)topOwnerType).getOriginalType();
        }
        return topOwnerType;
    }

    public static boolean isNullOrUndefinedType(@Nullable JSType type) {
        return type instanceof JSUndefinedType || type instanceof JSNullType;
    }

    public static boolean isSingleTypeAlias(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSTypeUtils.$$$reportNull$$$0(105);
        }
        return arrayType instanceof JSResolvableType && ((JSResolvableType)arrayType).resolveType().getDeclarationsOfType(TypeScriptTypeAlias.class).size() == 1;
    }

    public static boolean isAsyncIterable(@Nullable JSType type) {
        String typeName;
        boolean isAsyncIterable = false;
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (type instanceof JSNamedType && ("AsyncIterableIterator".equals(typeName = ((JSNamedType)type).getQualifiedName().getQualifiedName()) || "AsyncGenerator".equals(typeName))) {
            isAsyncIterable = true;
        }
        return isAsyncIterable;
    }

    public static void addAllUnionParts(@NotNull JSType jsType2, @NotNull @NotNull List<@NotNull JSType> allTypes) {
        if (jsType2 == null) {
            JSTypeUtils.$$$reportNull$$$0(106);
        }
        if (allTypes == null) {
            JSTypeUtils.$$$reportNull$$$0(107);
        }
        if (jsType2 instanceof JSUnionType) {
            allTypes.addAll(((JSUnionType)jsType2).getTypes());
        } else {
            allTypes.add(jsType2);
        }
    }

    @NotNull
    public static JSType getCommonType(@NotNull Collection<? extends TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        DialectOptionHolder holder;
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(108);
        }
        DialectOptionHolder dialectOptionHolder = holder = context == null ? null : DialectDetector.dialectOfElement(context);
        if (holder == null || !holder.isECMA4) {
            return JSTypeUtils.getTypeScriptCommonType(providers, context, allowResolve);
        }
        JSType commonType = null;
        for (TypeProvider typeProvider : providers) {
            JSType exprType = typeProvider.getType();
            if (!((commonType = commonType != null && exprType != null ? JSTypeUtils.getCommonType(commonType, exprType, holder, allowResolve) : exprType) instanceof JSAnyType)) continue;
            break;
        }
        if (commonType == null) {
            commonType = JSAnyType.get(context, false);
        }
        JSAnyType jSAnyType = commonType;
        if (jSAnyType == null) {
            JSTypeUtils.$$$reportNull$$$0(109);
        }
        return jSAnyType;
    }

    @NotNull
    public static JSType getTypeScriptCommonType(@NotNull Collection<? extends TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(110);
        }
        List<JSType> types2 = new ArrayList(providers.size());
        boolean hasStringType = false;
        for (TypeProvider typeProvider : providers) {
            JSType type = typeProvider.getType();
            if (type instanceof JSAnyType) {
                JSType jSType = type;
                if (jSType == null) {
                    JSTypeUtils.$$$reportNull$$$0(111);
                }
                return jSType;
            }
            types2.add(type);
            if (!(type instanceof JSStringType) || type instanceof JSStringLiteralTypeImpl) continue;
            hasStringType = true;
        }
        if (hasStringType) {
            types2 = ContainerUtil.filter(types2, el -> !(el instanceof JSStringLiteralTypeImpl));
        }
        JSTypeSource source2 = JSTypeSourceFactory.createTypeSource(context, true);
        JSType jSType = JSCompositeTypeImpl.getCommonType(types2, source2, allowResolve);
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(112);
        }
        return jSType;
    }

    private static boolean isAssignableType(@Nullable JSType thisType, @Nullable JSType elementType, ProcessingContext processingContext) {
        return thisType == null || thisType.isDirectlyAssignableType(elementType, processingContext);
    }

    public static List<JSParameterTypeDecorator> getParameterTypeDecorators(List<? extends JSType> parameters) {
        ArrayList<JSParameterTypeDecorator> decorators = new ArrayList<JSParameterTypeDecorator>(parameters.size());
        for (JSType jSType : parameters) {
            decorators.add(new JSParameterTypeDecoratorImpl(jSType, false, false, true));
        }
        return decorators;
    }

    @NotNull
    public static JSContext combineJSContexts(@NotNull JSContext f, @NotNull JSContext g) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(113);
        }
        if (g == null) {
            JSTypeUtils.$$$reportNull$$$0(114);
        }
        if (f == JSContext.STATIC && g == JSContext.STATIC) {
            JSContext jSContext = JSContext.STATIC;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(115);
            }
            return jSContext;
        }
        if (f == JSContext.INSTANCE || g == JSContext.INSTANCE) {
            JSContext jSContext = JSContext.INSTANCE;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(116);
            }
            return jSContext;
        }
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSTypeUtils.$$$reportNull$$$0(117);
        }
        return jSContext;
    }

    @NotNull
    public static Object getTypeInvalidationDependency() {
        Key key = PsiModificationTracker.MODIFICATION_COUNT;
        if (key == null) {
            JSTypeUtils.$$$reportNull$$$0(118);
        }
        return key;
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromProperties(@NotNull Project project, @NotNull Map<JSQualifiedName, String> properties2, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (project == null) {
            JSTypeUtils.$$$reportNull$$$0(119);
        }
        if (properties2 == null) {
            JSTypeUtils.$$$reportNull$$$0(120);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(121);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(122);
        }
        ArrayList<Pair> list2 = new ArrayList<Pair>(properties2.size());
        for (Map.Entry<JSQualifiedName, String> entry : properties2.entrySet()) {
            list2.add(Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return JSTypeUtils.buildRecordTypeFromQualifiedNames(project, list2, optional, typeSource);
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromQualifiedNames(@NotNull Project project, @NotNull Collection<? extends Pair<JSQualifiedName, String>> qualifiedNames, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (project == null) {
            JSTypeUtils.$$$reportNull$$$0(123);
        }
        if (qualifiedNames == null) {
            JSTypeUtils.$$$reportNull$$$0(124);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(125);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(126);
        }
        RecordTypeNode root = new RecordTypeNode();
        for (Pair<JSQualifiedName, String> pair : qualifiedNames) {
            List<String> components = ((JSQualifiedName)pair.getFirst()).toComponents();
            RecordTypeNode currentPath = root;
            for (int i2 = 0; i2 < components.size(); ++i2) {
                JSTypeParser parser2;
                JSParameterTypeDecorator decorator;
                String typeString;
                String component = components.get(i2);
                RecordTypeNode child = currentPath.myChildren.get(component);
                if (child == null) {
                    child = new RecordTypeNode();
                    child.myOptional = optional.contains(pair.getFirst());
                    currentPath.myChildren.put(component, child);
                }
                currentPath = child;
                if (i2 != components.size() - 1 || StringUtil.isEmpty((String)(typeString = (String)pair.getSecond())) || (decorator = (parser2 = new JSTypeParser(project, typeString, typeSource)).parseParameterType()) == null) continue;
                currentPath.myType = decorator.getSimpleType();
                currentPath.myOptional |= decorator.isOptional();
            }
        }
        return (JSRecordType)JSTypeUtils.buildTypeFromRecordTypeNode(root, typeSource);
    }

    @Nullable
    private static JSType buildTypeFromRecordTypeNode(@NotNull RecordTypeNode node, @NotNull JSTypeSource typeSource) {
        if (node == null) {
            JSTypeUtils.$$$reportNull$$$0(127);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(128);
        }
        if (node.myChildren.isEmpty()) {
            return node.myType;
        }
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> typeMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(node.myChildren.size());
        for (Map.Entry<String, RecordTypeNode> entry : node.myChildren.entrySet()) {
            RecordTypeNode childNode = entry.getValue();
            JSType type = JSTypeUtils.buildTypeFromRecordTypeNode(childNode, typeSource);
            typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(entry.getKey(), type, childNode.myOptional, false));
        }
        return new JSRecordTypeImpl(typeSource, typeMembers);
    }

    @NotNull
    public static Collection<JSImplicitElement> getImplicitMembersFromRecordType(@NotNull JSRecordType type, @Nullable JSQualifiedName namespace, @Nullable PsiElement parent) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(129);
        }
        SmartList elements = new SmartList();
        for (JSRecordType.TypeMember member : type.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, parent).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(namespace != null);
            JSType jsType2 = ((JSRecordType.PropertySignature)member).getJSType();
            if (jsType2 instanceof JSRecordType) {
                Collection<JSImplicitElement> childElements = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)jsType2, JSQualifiedNameImpl.create(name, namespace), parent);
                elements.addAll(childElements);
            }
            if (jsType2 != null) {
                builder.setTypeString(jsType2.getTypeText(JSType.TypeTextFormat.SIMPLE));
            }
            JSImplicitElementImpl element = new JSImplicitElementImpl(builder);
            elements.add((Object)element);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(130);
        }
        return smartList;
    }

    @Contract(value="!null,_ -> !null")
    public static JSType transformTypeHierarchySafe(@Nullable JSType type, @NotNull com.intellij.util.Function<? super JSType, ? extends JSType> transformation) {
        if (transformation == null) {
            JSTypeUtils.$$$reportNull$$$0(131);
        }
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy(transformation);
    }

    public static boolean isNeedWrapTypeForSerialization(@Nullable JSType type) {
        return type instanceof JSUnionOrIntersectionType || type instanceof JSFunctionTypeImpl || type instanceof JSKeyofType;
    }

    @Nullable
    public static PsiElement getLocalScopeFromSource(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            JSTypeUtils.$$$reportNull$$$0(132);
        }
        if (!namespace.isLocal()) {
            return null;
        }
        PsiElement sourceElement = namespace.getSource().getSourceElement();
        if (sourceElement instanceof PsiFile) {
            return sourceElement;
        }
        return sourceElement != null ? JSUseScopeProvider.getLexicalScopeOrFile(sourceElement) : null;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static JSType removeNullableComponents(@Nullable JSType jsType2) {
        if (jsType2 == null) {
            return null;
        }
        JSType optimized = JSCompositeTypeImpl.optimizeTypeIfComposite(jsType2, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        if (JSTypeUtils.isNullOrUndefinedType(optimized)) {
            return new TypeScriptNeverJSTypeImpl(optimized.getSource());
        }
        return optimized;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static JSType removeFalsyComponents(@Nullable JSType jsType2) {
        if (jsType2 == null) {
            return null;
        }
        JSType optimized = JSCompositeTypeImpl.optimizeTypeIfComposite(jsType2, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_FALSY);
        if (JSTypeCastUtil.isFalsy(optimized)) {
            return new TypeScriptNeverJSTypeImpl(optimized.getSource());
        }
        return optimized;
    }

    public static boolean isLocalOrFromSource(@NotNull JSNamespace namespace) {
        PsiElement sourceElement;
        if (namespace == null) {
            JSTypeUtils.$$$reportNull$$$0(133);
        }
        if (namespace.isLocal()) {
            return true;
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        return qualifiedName != null && qualifiedName.getParent() == null && (sourceElement = namespace.getSourceElement()) instanceof JSNamedElement && qualifiedName.getName().equals(((JSNamedElement)sourceElement).getName()) && JSUseScopeProvider.getLexicalScope(sourceElement) != null;
    }

    private static /* synthetic */ JSType lambda$mergeWithMixins$13(List mixinReturnTypes, JSFunctionType el) {
        JSType mixinType = JSCompositeTypeFactory.createIntersectionType(mixinReturnTypes, el.getSource());
        JSType newReturnType = JSCompositeTypeFactory.createIntersectionType(StreamEx.of((Object[])new JSType[]{mixinType, el.getReturnType()}).nonNull().toList(), el.getSource());
        return el.copyWithReturnType(newReturnType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 91: 
            case 97: 
            case 100: 
            case 104: 
            case 109: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 130: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 91: 
            case 97: 
            case 100: 
            case 104: 
            case 109: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 130: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 47: 
            case 50: 
            case 58: 
            case 70: 
            case 72: 
            case 74: 
            case 95: 
            case 98: 
            case 99: 
            case 103: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 12: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 7: 
            case 122: 
            case 126: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSubstitutor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass1";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 91: 
            case 97: 
            case 100: 
            case 104: 
            case 109: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 18: 
            case 20: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptType";
                break;
            }
            case 21: 
            case 24: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptAndAdjustType";
                break;
            }
            case 22: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 29: 
            case 79: 
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadPacks";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTypes";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFunction";
                break;
            }
            case 52: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypeDecorator";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argIterator";
                break;
            }
            case 69: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startType";
                break;
            }
            case 71: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
            case 81: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startIgnoredIds";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClasses";
                break;
            }
            case 86: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOption";
                break;
            }
            case 93: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTypes";
                break;
            }
            case 108: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 121: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optional";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 132: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorFromType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMatchingNamespace";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "typeOrAny";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValidConstituents";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithMixins";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseOverloadFunctionTypes";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "expandByTupleTypes";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTypeParameters";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleOption";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultValueOfType";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleOptimizeNestedCompositeTypes";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceImplicitTypesWithAny";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptCommonType";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "combineJSContexts";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInvalidationDependency";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitMembersFromRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeInOriginalTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIterableCollectionType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIndexableType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMapType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPromiseNamedType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapInPromiseType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPromiseComponentTypeOrNull";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processPromiseInHierarchy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNotSubstitutedGenericType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorFromType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 91: 
            case 97: 
            case 100: 
            case 104: 
            case 109: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 130: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIfGenericPromise";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSingleGenericArgTypeFromGenericType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSingleGenericArgTypeFromClassHierarchy";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSingleGenericComponentType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getIterableComponentType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "typeCanBeAssignedWithoutCoercion";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMatchingNamespace";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatchingType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMatchingType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasFunctionType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getMergedUnionSignatureType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "combineSignaturesOfUnionMembers";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "typeOrAny";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithMixins";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyTypeOrNotStrictType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverloadFunctionTypes";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "applyJSGenericsForType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "areArgumentsAssignable";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "matchRestTuples";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "expandByTupleTypes";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getGenericArgumentsConditionForSubstitution";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "needsExpandingForTypeSubstitutor";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findAllTypeParameters";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "expandForTypeSubstitutor";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addJSGenericParameters";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "applyCompositeMapping";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "hasForeignGenericParameter";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "hasTypes";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageOfContext";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageRecursive";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleOption";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processExpandedType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProcessingSet";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isUnionTypeWithLiteralCandidate";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "simpleOptimizeNestedCompositeTypes";
                break;
            }
            case 101: 
            case 102: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplicitTypesWithAny";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isSingleTypeAlias";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "addAllUnionParts";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptCommonType";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "combineJSContexts";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromProperties";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromQualifiedNames";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromRecordTypeNode";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitMembersFromRecordType";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchySafe";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getLocalScopeFromSource";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "isLocalOrFromSource";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSingleGenericArgTypeFromClassHierarchy$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 91: 
            case 97: 
            case 100: 
            case 104: 
            case 109: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 130: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecordTypeNode {
        Map<String, RecordTypeNode> myChildren = new LinkedHashMap<String, RecordTypeNode>();
        boolean myOptional;
        JSType myType;

        private RecordTypeNode() {
        }
    }

    public static interface TypeProvider {
        @Nullable
        public JSType getType();
    }
}

