/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JsDefinedInObject;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceExpressionInfo
implements ModuleReferenceInfo {
    @Nullable
    private final String myContextName;
    @Nullable
    private final String myParentName;
    @Nullable
    private final JSReferenceExpression myParent;
    @NotNull
    private final JSContext myContext;

    public JSModuleReferenceExpressionInfo(@NotNull JSReferenceExpression node) {
        String name;
        if (node == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(0);
        }
        this.myContextName = node.getReferenceName();
        PsiElement parent = JSModuleReferenceExpressionInfo.getParentElement(node);
        this.myContext = node.getParent() instanceof JSNewExpression ? JSContext.INSTANCE : JSContext.STATIC;
        String string = name = parent == null ? null : ((JSReferenceExpression)parent).getReferenceName();
        if (name == null || JsDefinedInObject.isPredefined(name, DialectDetector.dialectOfElement((PsiElement)node))) {
            this.myParent = null;
            this.myParentName = null;
            return;
        }
        this.myParentName = name;
        this.myParent = (JSReferenceExpression)parent;
    }

    @Nullable
    private static PsiElement getParentElement(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(1);
        }
        if (node.getParent() instanceof JSNewExpression) {
            PsiElement parentOverNewExpression = node.getParent().getParent();
            if (parentOverNewExpression instanceof JSReferenceExpression) {
                return parentOverNewExpression;
            }
        } else if (node.getParent() instanceof JSReferenceExpression) {
            return node.getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getResolvedParent() {
        JSReferenceExpression ref = this.myParent;
        List<PsiElement> list2 = ref == null ? ContainerUtil.emptyList() : JSResolveResult.toElements(ref.multiResolve(false));
        if (list2 == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public boolean isAcceptable(@NotNull PsiElement elementToImport) {
        if (elementToImport == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    @Nullable
    public String getContextName() {
        return this.myContextName;
    }

    @Override
    public boolean needHint() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement getParentRef() {
        return this.myParent;
    }

    @Override
    @NotNull
    public JSContext getContext() {
        JSContext jSContext = this.myContext;
        if (jSContext == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(4);
        }
        return jSContext;
    }

    @Override
    @Nullable
    public String getParentName() {
        return this.myParentName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

