/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptClassMemberModifiersStructure;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptExpressionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptFunctionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class TypeScriptStatementParser
extends ES6StatementParser<TypeScriptParser> {
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE = new TypeScriptClassMemberModifiersStructure();
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder -> {
        IElementType token = builder.getTokenType();
        return TypeScriptStatementParser.isPropertyNameStart(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    };

    protected TypeScriptStatementParser(TypeScriptParser parser2) {
        super(parser2);
    }

    @Override
    protected void doParseStatement() {
        IElementType firstToken = this.builder.getTokenType();
        IElementType lookahead = this.builder.lookAhead(1);
        if (firstToken == JSTokenTypes.ENUM_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseEnumNoMarker(marker);
            return;
        }
        if (firstToken == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.LPAR && this.builder.lookAhead(1) != JSTokenTypes.DOT) {
            this.parseES6ImportStatement();
            return;
        }
        if (firstToken == JSTokenTypes.EXPORT_KEYWORD && this.tryParseES6ExportStatement()) {
            return;
        }
        if (JSKeywordSets.MODULES.contains(firstToken) && (this.isIdentifierToken(lookahead) || JSTokenTypes.STRING_LITERALS.contains(lookahead)) || firstToken == JSTokenTypes.GLOBAL_KEYWORD && lookahead == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseModuleNoMarker(marker);
            return;
        }
        if (firstToken == JSTokenTypes.TYPE_KEYWORD && this.isIdentifierToken(lookahead)) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseTypeAlias(marker);
            return;
        }
        if (firstToken == JSTokenTypes.INTERFACE_KEYWORD && this.isIdentifierToken(lookahead)) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseInterfaceNoMarker(marker);
            return;
        }
        super.doParseStatement();
    }

    @Override
    protected boolean shouldParseTypeExports(IElementType type) {
        return type == JSTokenTypes.TYPE_KEYWORD;
    }

    @Override
    protected boolean shouldParseTypeImports(IElementType type) {
        return type == JSTokenTypes.TYPE_KEYWORD;
    }

    private void parseTypeAlias(PsiBuilder.Marker marker) {
        TypeScriptStatementParser.parseTypeAlias(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
    }

    public static void parseTypeAlias(PsiBuilder.Marker marker, PsiBuilder builder, ES6Parser parser2) {
        LOG.assertTrue(JSTokenTypes.TYPE_KEYWORD == builder.getTokenType());
        builder.advanceLexer();
        if (!parser2.isIdentifierToken(builder.getTokenType())) {
            builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return;
        }
        builder.advanceLexer();
        ((JSPsiTypeParser)parser2.getTypeParser()).tryParseTypeParameterList();
        ((JSPsiTypeParser)parser2.getTypeParser()).parseTypeAliasType();
        ((StatementParser)parser2.getStatementParser()).forceCheckForSemicolon();
        marker.done(JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected boolean isAcceptES6ExportImports() {
        return true;
    }

    @Override
    protected void parseES6ImportStatement() {
        if (this.isImportStatement()) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseImportStatementNoMarker(marker);
            return;
        }
        super.parseES6ImportStatement();
    }

    private boolean isImportStatement() {
        IElementType type = this.builder.lookAhead(1);
        int offset = 1;
        if (type == JSTokenTypes.TYPE_KEYWORD && JSTokenTypes.EQ != this.builder.lookAhead(offset + 1)) {
            ++offset;
        }
        return this.isIdentifierToken(this.builder.lookAhead(offset)) && this.builder.lookAhead(offset + 1) == JSTokenTypes.EQ;
    }

    @Override
    protected boolean tryParseES6ExportStatement() {
        IElementType lookAhead = this.builder.lookAhead(1);
        if (lookAhead == JSTokenTypes.EQ) {
            this.parseExportAssignment();
            return true;
        }
        if (lookAhead == JSTokenTypes.AS_KEYWORD) {
            PsiBuilder.Marker globalExport = this.builder.mark();
            this.parseGlobalModuleExportNoMarker(globalExport);
            return true;
        }
        return super.tryParseES6ExportStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseModuleNoMarker(PsiBuilder.Marker marker) {
        String methodsMustBeEmpty = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
        try {
            boolean nextLBrace;
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)"p");
            PsiBuilder.Marker markerBeforeKeyword = this.builder.mark();
            IElementType type = this.builder.getTokenType();
            boolean isGlobalModule = type == JSTokenTypes.GLOBAL_KEYWORD;
            LOG.assertTrue(isGlobalModule || JSKeywordSets.MODULES.contains(type));
            this.builder.advanceLexer();
            SmartList modules2 = new SmartList((Object)marker);
            boolean external = false;
            if (!isGlobalModule) {
                if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
                    ((TypeScriptParser)this.myJavaScriptParser).buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
                    external = true;
                } else if (!this.parseInternalModuleName(marker, markerBeforeKeyword, (SmartList<PsiBuilder.Marker>)modules2)) {
                    markerBeforeKeyword.drop();
                    return;
                }
            }
            markerBeforeKeyword.drop();
            boolean bl = nextLBrace = this.builder.getTokenType() == JSTokenTypes.LBRACE;
            if (!external || nextLBrace) {
                this.parseBlockOrFunctionBody(StatementParser.BlockType.PACKAGE_OR_CLASS_BODY);
            }
            if (external && !nextLBrace) {
                ((TypeScriptStatementParser)((TypeScriptParser)this.myJavaScriptParser).getStatementParser()).forceCheckForSemicolon();
            }
            ((PsiBuilder.Marker)modules2.get(modules2.size() - 1)).done(JSStubElementTypes.TYPESCRIPT_MODULE);
            for (int i2 = modules2.size() - 2; i2 >= 0; --i2) {
                ((PsiBuilder.Marker)modules2.get(i2)).done(TypeScriptStubElementTypes.IMPLICIT_MODULE);
            }
            ((PsiBuilder.Marker)modules2.get(0)).setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsMustBeEmpty);
        }
    }

    private boolean parseInternalModuleName(PsiBuilder.Marker marker, PsiBuilder.Marker markerBeforeKeyword, SmartList<PsiBuilder.Marker> modules2) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return false;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() == JSTokenTypes.DOT) {
            expr.done(JSElementTypes.REFERENCE_EXPRESSION);
            expr = expr.precede();
            this.builder.advanceLexer();
            modules2.add((Object)markerBeforeKeyword.precede());
            if (this.checkIdentifier()) continue;
        }
        expr.drop();
        return true;
    }

    private void parseImportStatementNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IMPORT_KEYWORD);
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.TYPE_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.EQ) {
            this.builder.advanceLexer();
        }
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.equal", new Object[0]));
            marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
            return;
        }
        this.builder.advanceLexer();
        PsiBuilder.Marker referenceMarker = this.builder.mark();
        IElementType referenceStartType = this.builder.getTokenType();
        if (!this.checkIdentifier()) {
            referenceMarker.drop();
            marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
            return;
        }
        if ((referenceStartType == JSTokenTypes.REQUIRE_KEYWORD || JSKeywordSets.MODULES.contains(referenceStartType)) && this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.builder.advanceLexer();
            if (!TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.STRING_LITERAL, "javascript.parser.message.expected.string.literal") || !TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen")) {
                referenceMarker.drop();
                marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
                return;
            }
            referenceMarker.done(TypeScriptStubElementTypes.EXTERNAL_MODULE_REFERENCE);
        } else {
            while (this.builder.getTokenType() == JSTokenTypes.DOT) {
                PsiBuilder.Marker precede = referenceMarker.precede();
                referenceMarker.done(TypeScriptStubElementTypes.ENTITY_NAME);
                referenceMarker = precede;
                this.builder.advanceLexer();
                if (this.checkIdentifier()) continue;
                referenceMarker.drop();
                marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
                return;
            }
            referenceMarker.done(TypeScriptStubElementTypes.ENTITY_NAME);
        }
        ((TypeScriptStatementParser)((TypeScriptParser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        marker.done(TypeScriptElementTypes.IMPORT_STATEMENT);
    }

    public static boolean isConstEnum(PsiBuilder builder) {
        return builder.getTokenType() == JSTokenTypes.CONST_KEYWORD && builder.lookAhead(1) == JSTokenTypes.ENUM_KEYWORD;
    }

    private void parseEnumNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.ENUM_KEYWORD);
        this.builder.advanceLexer();
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                marker.done(JSStubElementTypes.TYPESCRIPT_ENUM);
                return;
            }
        }
        if (!TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            marker.done(JSStubElementTypes.TYPESCRIPT_ENUM);
            return;
        }
        PsiBuilder.Marker varStatement = this.builder.mark();
        boolean isDeclarationEmpty = true;
        while (!this.builder.eof() && this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (TypeScriptStatementParser.isPropertyNameStart(this.builder.getTokenType())) {
                PsiBuilder.Marker var = this.builder.mark();
                ((TypeScriptExpressionParser)((TypeScriptParser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
                if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                    this.parseVariableInitializer(false);
                }
                var.done(TypeScriptStubElementTypes.TYPESCRIPT_ENUM_FIELD);
                var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                isDeclarationEmpty = false;
                if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
                this.builder.advanceLexer();
                continue;
            }
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            this.builder.advanceLexer();
            break;
        }
        if (isDeclarationEmpty) {
            varStatement.drop();
        } else {
            varStatement.done(this.getFieldStatementElementType());
            varStatement.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.trailingCommentsBinder((TokenSet)JSTokenTypes.END_OF_LINE_COMMENTS));
        }
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
        }
        TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        marker.done(JSStubElementTypes.TYPESCRIPT_ENUM);
    }

    private void parseGlobalModuleExportNoMarker(PsiBuilder.Marker globalExport) {
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        if (!TypeScriptStatementParser.checkMatches(this.builder, JSTokenTypes.NAMESPACE_KEYWORD, "javascript.parser.message.expected.namespace")) {
            globalExport.done(TypeScriptStubElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT);
            return;
        }
        this.checkIdentifier();
        this.checkForSemicolon();
        globalExport.done(TypeScriptStubElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT);
    }

    private void parseExportAssignment() {
        PsiBuilder.Marker exportAssignment = this.builder.mark();
        assert (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        this.builder.advanceLexer();
        assert (this.builder.getTokenType() == JSTokenTypes.EQ);
        this.builder.advanceLexer();
        ((TypeScriptExpressionParser)((TypeScriptParser)this.myJavaScriptParser).getExpressionParser()).parseAssignmentExpression(false);
        ((TypeScriptStatementParser)((TypeScriptParser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        exportAssignment.done(TypeScriptStubElementTypes.EXPORT_ASSIGNMENT);
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS.contains(tokenType)) {
            this.parseModuleNoMarker(marker);
            return true;
        }
        if (this.isGlobalModuleExport()) {
            this.parseGlobalModuleExportNoMarker(marker);
            return true;
        }
        if (tokenType == JSTokenTypes.ENUM_KEYWORD) {
            this.parseEnumNoMarker(marker);
            return true;
        }
        if (tokenType == JSTokenTypes.IMPORT_KEYWORD) {
            this.parseImportStatementNoMarker(marker);
            return true;
        }
        if (tokenType == JSTokenTypes.TYPE_KEYWORD) {
            this.parseTypeAlias(marker);
            return true;
        }
        return false;
    }

    public boolean isGlobalModuleExport() {
        return this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.AS_KEYWORD;
    }

    @Override
    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker block) {
        if (block == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(0);
        }
        TypeScriptStatementParser.parseInterface(block, this, (ES6Parser)this.myJavaScriptParser, this.builder);
    }

    public static void parseInterface(@NotNull PsiBuilder.Marker block, @NotNull StatementParser<?> statementParser, @NotNull ES6Parser<?, ?, ?, ? extends TypeScriptPsiTypeParser> parser2, @NotNull PsiBuilder builder) {
        if (block == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(1);
        }
        if (statementParser == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(2);
        }
        if (parser2 == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(JSTokenTypes.INTERFACE_KEYWORD == builder.getTokenType());
        builder.advanceLexer();
        IElementType startToken = builder.getTokenType();
        if (!parser2.isIdentifierToken(startToken)) {
            builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (!statementParser.canProceedClassParsing(startToken)) {
                block.done(JSStubElementTypes.TYPESCRIPT_INTERFACE);
                return;
            }
        } else {
            builder.advanceLexer();
        }
        ((TypeScriptPsiTypeParser)parser2.getTypeParser()).tryParseTypeParameterList();
        if (builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            ((ES6StatementParser)parser2.getStatementParser()).parseReferenceList((IElementType)JSStubElementTypes.DEFAULT_EXTENDS_LIST);
        } else if (builder.getTokenType() == JSTokenTypes.IMPLEMENTS_KEYWORD) {
            ((ES6StatementParser)parser2.getStatementParser()).parseReferenceList((IElementType)JSStubElementTypes.IMPLEMENTS_LIST);
        }
        ((TypeScriptPsiTypeParser)parser2.getTypeParser()).parseObjectType();
        block.done(JSStubElementTypes.TYPESCRIPT_INTERFACE);
        block.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        PsiBuilder.Marker classMember = this.builder.mark();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults = this.parseClassMemberModifiers();
        if (((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).isIndexSignatureProperty()) {
            ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseIndexSignatureNoMarker(classMember, true);
        } else {
            this.parseStandardClassMember(classMember, modifiersParseResults);
        }
    }

    @Override
    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseClassMemberModifiers() {
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = ((TypeScriptParser)this.myJavaScriptParser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
        if (enumSet == null) {
            TypeScriptStatementParser.$$$reportNull$$$0(5);
        }
        return enumSet;
    }

    protected static boolean isPropertyNameStart(IElementType t) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(t) || t == JSTokenTypes.STRING_LITERAL || t == JSTokenTypes.NUMERIC_LITERAL || t == JSTokenTypes.LBRACKET;
    }

    @Override
    protected IElementType getClassElementType() {
        return JSStubElementTypes.TYPESCRIPT_CLASS;
    }

    @Override
    protected IElementType getClassExpressionElementType() {
        return JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION;
    }

    @Override
    protected void parseES6ExportDefaultAssignmentBody() {
        if (this.builder.getTokenType() == JSTokenTypes.ABSTRACT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.CLASS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            boolean parsed = ((TypeScriptFunctionParser)((TypeScriptParser)this.myJavaScriptParser).getFunctionParser()).parseAttributesList();
            if (parsed) {
                this.parseClassNoMarker(marker, true, true);
            } else {
                marker.rollbackTo();
                super.parseES6ExportDefaultAssignmentBody();
            }
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.INTERFACE_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseInterfaceNoMarker(marker);
            return;
        }
        super.parseES6ExportDefaultAssignmentBody();
    }

    @Override
    protected boolean parseVarName(PsiBuilder.Marker var) {
        if (!JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.variable.name", new Object[0]));
            this.builder.advanceLexer();
            var.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXCL) {
            this.builder.advanceLexer();
        }
        return true;
    }

    @Override
    public IElementType getVariableElementType() {
        return TypeScriptStubElementTypes.TYPESCRIPT_VARIABLE;
    }

    @Override
    public IElementType getFieldElementType() {
        return TypeScriptStubElementTypes.TYPESCRIPT_FIELD;
    }

    @Override
    protected boolean isPossibleStartStatementModifier(IElementType token) {
        if (token == JSTokenTypes.ABSTRACT_KEYWORD) {
            IElementType type = this.builder.lookAhead(1);
            return type == null || type == JSTokenTypes.CLASS_KEYWORD || type == JSTokenTypes.TYPE_KEYWORD || type == JSTokenTypes.ENUM_KEYWORD || type == JSTokenTypes.INTERFACE_KEYWORD;
        }
        if (token == JSTokenTypes.OVERRIDE_KEYWORD || token == JSTokenTypes.READONLY_KEYWORD) {
            return false;
        }
        return super.isPossibleStartStatementModifier(token) || TypeScriptStatementParser.isConstEnum(this.builder);
    }

    @Override
    protected void checkMemberFunctionSuffix() {
    }

    @Override
    protected boolean isExportDefaultBinding() {
        return false;
    }

    @Override
    protected void parseMemberVariableName() {
        super.parseMemberVariableName();
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.QUEST || tokenType == JSTokenTypes.EXCL) {
            this.builder.advanceLexer();
        }
    }

    @Override
    protected boolean parserMemberFunctionName() {
        boolean result2 = super.parserMemberFunctionName();
        if (result2 && this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        return result2;
    }

    @Override
    protected boolean isPossibleMemberFunctionStart(IElementType lookahead) {
        if (lookahead == JSTokenTypes.QUEST) {
            lookahead = this.builder.lookAhead(2);
        }
        return super.isPossibleMemberFunctionStart(lookahead);
    }

    @Override
    protected boolean isPossibleClassName(IElementType firstElement, boolean mayOmitName) {
        return super.isPossibleClassName(firstElement, mayOmitName) && firstElement != JSTokenTypes.IMPLEMENTS_KEYWORD;
    }

    @Override
    public boolean canProceedClassParsing(IElementType elementType) {
        return super.canProceedClassParsing(elementType) || elementType == JSTokenTypes.IMPLEMENTS_KEYWORD;
    }

    @Override
    protected void parseMemberPropertyWithBrackets() {
        ((TypeScriptExpressionParser)((TypeScriptParser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
        if (this.builder.getTokenType() == JSTokenTypes.QUEST || this.builder.getTokenType() == JSTokenTypes.EXCL) {
            this.builder.advanceLexer();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptStatementParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptStatementParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassMemberModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseInterfaceNoMarker";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseInterface";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

