/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskRunAction;
import com.intellij.lang.javascript.buildTools.npm.NpmRunAnythingProvider;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.runAnything.JsbtRunAnythingProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmScriptRunAnythingProvider
extends JsbtRunAnythingProvider {
    @Nls
    private final String myPackageManagerName;

    NpmScriptRunAnythingProvider(@NotNull @Nls String packageManagerName) {
        if (packageManagerName == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(0);
        }
        this.myPackageManagerName = packageManagerName;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull JsbtTaskRunAction value) {
        if (value == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(1);
        }
        String string = NpmManager.getNpmCommandPresentableText(NodePackageRef.create(this.myPackageManagerName), NpmCommand.RUN_SCRIPT) + " " + StringUtil.join(value.getTaskSet().getTaskNames(), (String)" ");
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected JsbtApplicationService getService() {
        NpmScriptsService.NpmScriptsApplicationService npmScriptsApplicationService = NpmScriptsService.NpmScriptsApplicationService.getInstance();
        if (npmScriptsApplicationService == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(3);
        }
        return npmScriptsApplicationService;
    }

    @Nullable
    public Icon getIcon(@NotNull JsbtTaskRunAction value) {
        if (value == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(4);
        }
        return NpmRunAnythingProvider.getIcon(this.isYarn());
    }

    @Override
    @NotNull
    public Collection<JsbtTaskRunAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern2) {
        boolean matchNpmScriptName;
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(5);
        }
        if (pattern2 == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(6);
        }
        boolean matchCommandPrefix = this.hasCommandPrefix(pattern2);
        boolean bl = matchNpmScriptName = !StringUtil.isEmptyOrSpaces((String)pattern2) && this.isProjectPackageManager(dataContext);
        if (!matchCommandPrefix && !matchNpmScriptName) {
            List<JsbtTaskRunAction> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmScriptRunAnythingProvider.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<JsbtTaskRunAction> allValues = this.getAllValues(dataContext);
        List list3 = ContainerUtil.filter(allValues, action -> {
            if (matchCommandPrefix && this.getCommand((JsbtTaskRunAction)((Object)action)).startsWith(pattern2)) {
                return true;
            }
            String task = (String)ContainerUtil.getFirstItem(action.getTaskSet().getTaskNames());
            return matchNpmScriptName && task != null && task.startsWith(pattern2);
        });
        if (list3 == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(8);
        }
        return list3;
    }

    private boolean isProjectPackageManager(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(9);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        NodePackageRef pkgManagerRef = NpmManager.getInstance(project).getPackageRef();
        return NpmUtil.isYarnAlikePackageRef(pkgManagerRef) == this.isYarn();
    }

    @Override
    @NotNull
    protected List<JsbtFileStructure> getFileStructures(@NotNull Project project, @NotNull DataContext dataContext) {
        VirtualFile packageJson;
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(11);
        }
        if ((packageJson = NpmRunAnythingProvider.getPackageJson(project, dataContext)) == null) {
            List<JsbtFileStructure> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmScriptRunAnythingProvider.$$$reportNull$$$0(12);
            }
            return list2;
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)this.getBuildfileStructure(project, packageJson));
        if (list3 == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(13);
        }
        return list3;
    }

    @Override
    @Nullable
    protected JsbtFileStructure getBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) {
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(14);
        }
        if (buildfile == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(15);
        }
        try {
            return NpmScriptsService.getInstance(project).fetchBuildfileStructure(buildfile);
        }
        catch (JsbtTaskFetchException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getCompletionGroupTitle() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(17);
        }
        boolean yarn = this.isYarn();
        return new RunAnythingHelpItem(NpmScriptRunAnythingProvider.getHelpCommandPlaceholder(yarn), NpmScriptRunAnythingProvider.getCommandPrefix(yarn), this.getHelpDescription(), NpmRunAnythingProvider.getIcon(yarn));
    }

    @Override
    @Nullable
    public Icon getHelpIcon() {
        return NpmRunAnythingProvider.getIcon(this.isYarn());
    }

    @Override
    public boolean hasCommandPrefix(@NotNull String pattern2) {
        if (pattern2 == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(18);
        }
        return NpmRunAnythingProvider.hasPackageNamePrefix(pattern2, this.myPackageManagerName);
    }

    @Override
    @NotNull
    protected String getCommandPrefix() {
        return NpmScriptRunAnythingProvider.getCommandPrefix(this.isYarn());
    }

    @NotNull
    private static String getCommandPrefix(boolean yarn) {
        String string = NpmManager.getNpmPackagePresentableName(yarn);
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        return NpmScriptRunAnythingProvider.getHelpCommandPlaceholder(false);
    }

    @NotNull
    private static String getHelpCommandPlaceholder(boolean yarn) {
        String string = NpmScriptRunAnythingProvider.getCommandPrefix(yarn) + " run <script name>";
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHelpGroupTitle() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(22);
        }
        return string;
    }

    private boolean isYarn() {
        return NpmRunAnythingProvider.isYarn(this.myPackageManagerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptRunAnythingProvider";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptRunAnythingProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStructures";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandPrefix";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommandPlaceholder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommand";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpGroupTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManager";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileStructures";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBuildfileStructure";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasCommandPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

