/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

final class FileModificationsSettledDownTracker {
    private static final Logger LOG = Logger.getInstance(FileModificationsSettledDownTracker.class);
    private final String myFilePath;
    private final int myFileExistenceChecks;
    private final int myFileExistenceCheckIntervalMillis;
    private final int myFileModificationChecks;
    private final int myFileModificationCheckIntervalMillis;
    private final BooleanSupplier myValidCondition;
    private final Runnable myFileModificationsSettledDownCallback;
    private volatile long myLastModified;
    private volatile boolean myStopped;

    FileModificationsSettledDownTracker(@NotNull String filePath, int fileExistenceChecks, int fileExistenceCheckIntervalMillis, int fileModificationChecks, int fileModificationCheckIntervalMillis, @NotNull BooleanSupplier validCondition, @NotNull Runnable fileModificationsSettledDownCallback) {
        if (filePath == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(0);
        }
        if (validCondition == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(1);
        }
        if (fileModificationsSettledDownCallback == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(2);
        }
        this.myStopped = false;
        this.myFilePath = filePath;
        this.myFileExistenceChecks = fileExistenceChecks;
        this.myFileExistenceCheckIntervalMillis = fileExistenceCheckIntervalMillis;
        this.myFileModificationChecks = fileModificationChecks;
        this.myFileModificationCheckIntervalMillis = fileModificationCheckIntervalMillis;
        this.myValidCondition = validCondition;
        this.myFileModificationsSettledDownCallback = fileModificationsSettledDownCallback;
        this.checkFileExistence(0);
    }

    private void checkFileExistence(int checks) {
        if (checks >= this.myFileExistenceChecks) {
            LOG.info("Nonexistent " + this.myFilePath + ", done " + this.myFileExistenceChecks + " checks with " + this.myFileExistenceCheckIntervalMillis + " ms delay");
            return;
        }
        LOG.info("Checking for " + this.myFilePath);
        FileModificationsSettledDownTracker.scheduleOnPooledThread(() -> {
            if (!this.myStopped && !this.myValidCondition.getAsBoolean()) {
                return;
            }
            File file2 = new File(this.myFilePath);
            if (file2.exists()) {
                if (file2.isFile()) {
                    this.myLastModified = file2.lastModified();
                    this.checkFileModification(0);
                } else if (file2.isDirectory()) {
                    LOG.warn("Excepted file, but got directory: " + this.myFilePath);
                }
            } else {
                this.checkFileExistence(checks + 1);
            }
        }, this.myFileExistenceCheckIntervalMillis);
    }

    private void checkFileModification(int checks) {
        if (checks >= this.myFileModificationChecks) {
            LOG.info("Constantly modified " + this.myFilePath + ", done " + this.myFileModificationChecks + " checks with " + this.myFileModificationCheckIntervalMillis + " ms delay");
            return;
        }
        LOG.info("Checking for no modification " + this.myFilePath);
        FileModificationsSettledDownTracker.scheduleOnPooledThread(() -> {
            if (!this.myStopped && !this.myValidCondition.getAsBoolean()) {
                return;
            }
            File file2 = new File(this.myFilePath);
            if (file2.isFile()) {
                long lastModified = file2.lastModified();
                if (lastModified == this.myLastModified) {
                    this.myFileModificationsSettledDownCallback.run();
                } else {
                    this.myLastModified = lastModified;
                    this.checkFileModification(checks + 1);
                }
            } else {
                LOG.warn("Not a file " + this.myFilePath);
            }
        }, this.myFileModificationCheckIntervalMillis);
    }

    public void stop() {
        this.myStopped = true;
    }

    private static void scheduleOnPooledThread(@NotNull Runnable runnable, int delayMillis) {
        if (runnable == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(3);
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(runnable, (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validCondition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileModificationsSettledDownCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/jest/coverage/FileModificationsSettledDownTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleOnPooledThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

