/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageLevelGuesser
implements DirectoryProjectConfigurator {
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        if (project == null) {
            JSLanguageLevelGuesser.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            JSLanguageLevelGuesser.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            JSLanguageLevelGuesser.$$$reportNull$$$0(2);
        }
        JSLanguageLevelGuesser.configureProject(project, baseDir);
    }

    static void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            JSLanguageLevelGuesser.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            JSLanguageLevelGuesser.$$$reportNull$$$0(4);
        }
        JSLanguageLevel guessedLevel = null;
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(baseDir);
        if (packageJson != null) {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
            for (String dep : data.getAllDependencies()) {
                if ("react".equals(dep)) {
                    guessedLevel = JSLanguageLevel.getLevelForJSX();
                    continue;
                }
                if (!"flow-bin".equals(dep)) continue;
                guessedLevel = JSLanguageLevel.FLOW;
                break;
            }
        }
        if (guessedLevel != JSLanguageLevel.FLOW && baseDir.findChild(".flowconfig") != null) {
            guessedLevel = JSLanguageLevel.FLOW;
        }
        JSLanguageLevelGuesser.applyGuessedLanguageLevel(project, guessedLevel);
    }

    public static void applyGuessedLanguageLevel(@NotNull Project project, @Nullable JSLanguageLevel guessedLevel) {
        JSRootConfiguration rootConfiguration;
        if (project == null) {
            JSLanguageLevelGuesser.$$$reportNull$$$0(5);
        }
        if (guessedLevel != null && guessedLevel.isAtLeast((rootConfiguration = JSRootConfiguration.getInstance(project)).getLanguageLevel()) && guessedLevel != rootConfiguration.getLanguageLevel()) {
            rootConfiguration.storeLanguageLevelAndUpdateCaches(guessedLevel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/JSLanguageLevelGuesser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyGuessedLanguageLevel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

