/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileTask;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditRemoteFileAction
extends AnAction {
    public EditRemoteFileAction() {
        super(WDBundle.messagePointer("remote.edit.edit.action.title", new Object[0]), WDBundle.messagePointer("remote.edit.edit.action.description", new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            EditRemoteFileAction.$$$reportNull$$$0(0);
        }
        boolean enabled = EditRemoteFileAction.isEnabled(event);
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        DataContext dataContext = event.getDataContext();
        if ("RemoteHostPopup".equals(event.getPlace()) || "RemoteHostDialogPopup".equals(event.getPlace())) {
            ServerTreeNode[] serverTreeNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
            if (serverTreeNodes == null || serverTreeNodes.length != 1 || serverTreeNodes[0].getFileType() != org.apache.commons.vfs2.FileType.FILE) {
                return false;
            }
            Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(dataContext);
            return serverConfig != null;
        }
        Trinity<VirtualFile, WebServerConfig, DeploymentPathMapping> mappingTrinity = PublishActionUtil.findMappingForSingleFile(event, false, true);
        return mappingTrinity != null;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            EditRemoteFileAction.$$$reportNull$$$0(1);
        }
        if ("RemoteHostPopup".equals(event.getPlace()) || "RemoteHostDialogPopup".equals(event.getPlace())) {
            ServerTreeNode[] serverTreeNodes = (ServerTreeNode[])event.getData(WebDeploymentDataKeys.SERVER_NODES);
            if (serverTreeNodes == null || serverTreeNodes.length != 1) {
                return;
            }
            EditRemoteFileAction.editRemoteFile(event.getDataContext(), serverTreeNodes[0]);
        } else {
            Trinity<VirtualFile, WebServerConfig, DeploymentPathMapping> mappingTrinity = PublishActionUtil.findMappingForSingleFile(event, false, true);
            if (mappingTrinity == null) {
                return;
            }
            VirtualFile localFile = (VirtualFile)mappingTrinity.first;
            Project project = event.getProject();
            if (project == null || !EditRemoteFileAction.ensureFileTypeKnown(project, localFile.getName())) {
                return;
            }
            Deployable deployable = Deployable.create((WebServerConfig)mappingTrinity.second, project);
            WebServerConfig.RemotePath remotePath = ((DeploymentPathMapping)mappingTrinity.third).mapToDeployPath(localFile.getPath(), (Mappable)deployable);
            EditRemoteFileAction.editRemoteFile(deployable, project, null, remotePath, null, null);
        }
    }

    public static void editRemoteFile(DataContext context, ServerTreeNode node) {
        if (node == null || node.getFileType() != org.apache.commons.vfs2.FileType.FILE) {
            return;
        }
        Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        FileObject file = node.getFileObject();
        if (serverConfig == null || project == null || file == null) {
            return;
        }
        EditRemoteFileAction.editRemoteFile(serverConfig, project, file, null, node.getOpenRemoteConnection(), null);
    }

    public static void editRemoteFile(@NotNull Deployable serverConfig, @NotNull Project project, @NotNull FileObject file, @Nullable RemoteConnection connection, @Nullable String presentableServerName) {
        if (serverConfig == null) {
            EditRemoteFileAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            EditRemoteFileAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            EditRemoteFileAction.$$$reportNull$$$0(4);
        }
        EditRemoteFileAction.editRemoteFile(serverConfig, project, file, null, connection, presentableServerName);
    }

    public static void editRemoteFile(@NotNull Deployable serverConfig, @NotNull Project project, @Nullable FileObject file, @Nullable WebServerConfig.RemotePath remotePath, @Nullable RemoteConnection connection, @Nullable String presentableServerName) {
        if (serverConfig == null) {
            EditRemoteFileAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            EditRemoteFileAction.$$$reportNull$$$0(6);
        }
        new EditRemoteFileTask(true, project, serverConfig, file, remotePath, connection, presentableServerName).queue();
    }

    static boolean ensureFileTypeKnown(Project project, String fileName) {
        FileType fileType = FileTypeChooser.getKnownFileTypeOrAssociate((String)fileName);
        if (fileType == null) {
            return false;
        }
        if (fileType instanceof INativeFileType) {
            Messages.showInfoMessage((Project)project, (String)WDBundle.message("remote.edit.please.associate.0.with.some.file.type.in.settings.editor.file.types", fileName), (String)WDBundle.message("remote.edit.message.title", new Object[0]));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/EditRemoteFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "editRemoteFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

