/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Objects;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@Tag(value="mapping")
public class DeploymentPathMapping
implements Cloneable {
    @NonNls
    public static final String MAPPING_TAG = "mapping";
    @NonNls
    public static final String DEPLOY_PATH_ATTRIBUTE = "deploy";
    @NonNls
    public static final String WEB_PATH_ATTRIBUTE = "web";
    private static final Logger LOG = Logger.getInstance(DeploymentPathMapping.class);
    @NonNls
    private static final String NOMACROS = "nomacros://";
    private String myLocalPath;
    private String myDeployPath;
    private String myWebPath;

    @Attribute(value="local")
    public String getSerializedLocalPath() {
        return this.myLocalPath != null ? FileUtil.toSystemIndependentName((String)this.myLocalPath) : null;
    }

    public void setSerializedLocalPath(String localPath) {
        this.setLocalPath(localPath);
    }

    @Transient
    @NlsSafe
    public String getLocalPath() {
        return this.myLocalPath;
    }

    public void setLocalPath(String localPath) {
        this.myLocalPath = localPath;
    }

    public String getPresentableLocalPath() {
        return this.myLocalPath != null ? FileUtil.toSystemDependentName((String)this.myLocalPath) : null;
    }

    @Transient
    @NlsSafe
    public String getDeployPath() {
        return this.myDeployPath;
    }

    public void setDeployPath(String deployPath) {
        this.myDeployPath = deployPath;
    }

    @Attribute(value="deploy")
    public String getSerializedDeployPath() {
        return this.getDeployPath();
    }

    public void setSerializedDeployPath(String deployPath) {
        if (deployPath != null) {
            deployPath = StringUtil.trimStart((String)deployPath, (String)NOMACROS);
        }
        this.setDeployPath(deployPath);
    }

    @Attribute(value="web")
    public String getWebPath() {
        return this.myWebPath;
    }

    public void setWebPath(String webPath) {
        this.myWebPath = webPath;
    }

    public boolean isDegenerate() {
        return StringUtil.isEmpty((String)this.myLocalPath) && StringUtil.isEmpty((String)this.myDeployPath) && StringUtil.isEmpty((String)this.myWebPath);
    }

    public DeploymentPathMapping clone() {
        try {
            return (DeploymentPathMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)o;
        if (!Objects.equals(StringUtil.notNullize((String)this.myDeployPath), StringUtil.notNullize((String)mapping.myDeployPath))) {
            return false;
        }
        if (!Objects.equals(StringUtil.notNullize((String)this.myLocalPath), StringUtil.notNullize((String)mapping.myLocalPath))) {
            return false;
        }
        return Objects.equals(StringUtil.notNullize((String)this.myWebPath), StringUtil.notNullize((String)mapping.myWebPath));
    }

    public int hashCode() {
        int result = this.myLocalPath != null ? this.myLocalPath.hashCode() : 0;
        result = 31 * result + (this.myDeployPath != null ? this.myDeployPath.hashCode() : 0);
        result = 31 * result + (this.myWebPath != null ? this.myWebPath.hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "DeploymentPathMapping{localPath='" + this.myLocalPath + "', deployPath='" + this.myDeployPath + "', webPath='" + this.myWebPath + "'}";
    }

    public boolean isParentForLocalPath(String localPath, boolean strict) {
        if (!this.isLocalPathValid() || StringUtil.isEmpty((String)localPath)) {
            return false;
        }
        String remainder = this.getPathRemainderForLocal(localPath);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isChildForLocalPath(String localPath, boolean strict) {
        if (!this.isLocalPathValid()) {
            return false;
        }
        String remainder = DeploymentPathUtils.getPathRemainder(localPath, this.myLocalPath, SystemInfo.isFileSystemCaseSensitive);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    @Nullable
    public String getPathRemainderForLocal(String childLocalPath) {
        return DeploymentPathUtils.getPathRemainder(this.myLocalPath, childLocalPath, SystemInfo.isFileSystemCaseSensitive);
    }

    public boolean isParentForDeployPath(FileName deployPath, boolean strict, Mappable mappable) {
        String remainder = this.getPathRemainderForDeploy(deployPath, mappable);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isParentForDeployPath(WebServerConfig.RemotePath deployPath, boolean strict, Mappable mappable) {
        String remainder = this.getPathRemainderForDeploy(deployPath, mappable);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isChildForDeployPath(FileName deployPath, boolean strict, Mappable mappable) {
        String remainder;
        boolean isProtocolBased = mappable.getAccessType().isProtocolBased();
        if (!this.isDeployPathValid(isProtocolBased)) {
            return false;
        }
        if (isProtocolBased) {
            remainder = DeploymentPathUtils.getPathRemainder(deployPath.getPath(), this.myDeployPath, mappable.isCaseSensitive());
        } else {
            String fullDeployPath = mappable.getFullPath(this.myDeployPath);
            remainder = DeploymentPathUtils.getPathRemainder(DeploymentPathUtils.getLocalPath(deployPath), fullDeployPath, mappable.isCaseSensitive());
        }
        return remainder != null && (!strict || remainder.length() > 0);
    }

    @Nullable
    private String getPathRemainderForDeploy(FileName childDeployPath, Mappable mappable) {
        return DeploymentPathMapping.getPathRemainderForRemotePath(childDeployPath, mappable, this.myDeployPath);
    }

    public static String getPathRemainderForRemotePath(FileName childDeployPath, Mappable mappable, String remotePath) {
        boolean isProtocolBased = mappable.getAccessType().isProtocolBased();
        if (DeploymentPathMapping.validateDeployPath(remotePath, isProtocolBased) != null) {
            return null;
        }
        String fullPath = mappable.getFullPath(remotePath);
        if (isProtocolBased) {
            return DeploymentPathUtils.getPathRemainder(fullPath, childDeployPath.getPath(), mappable.isCaseSensitive());
        }
        return DeploymentPathUtils.getPathRemainder(fullPath, DeploymentPathUtils.getLocalPath(childDeployPath), mappable.isCaseSensitive());
    }

    @Nullable
    private String getPathRemainderForDeploy(WebServerConfig.RemotePath childDeployPath, Mappable mappable) {
        return DeploymentPathMapping.getPathRemainderForRemotePath(childDeployPath, mappable, this.myDeployPath);
    }

    public static String getPathRemainderForRemotePath(WebServerConfig.RemotePath childDeployPath, Mappable mappable, String remotePath) {
        boolean isProtocolBased = mappable.getAccessType().isProtocolBased();
        if (DeploymentPathMapping.validateDeployPath(remotePath, isProtocolBased) != null) {
            return null;
        }
        String fullPath = mappable.getFullPath(remotePath);
        return DeploymentPathUtils.getPathRemainder(fullPath, childDeployPath.path, mappable.isCaseSensitive());
    }

    public String mapToWebPath(String localPath) {
        LOG.assertTrue(this.isWebPathValid(), (Object)("web path is invalid for " + this));
        String remainder = this.getPathRemainderForLocal(localPath);
        return DeploymentPathUtils.join(this.myWebPath, remainder);
    }

    public String mapToWebPath(WebServerConfig.RemotePath remotePathPath, Mappable mappable) {
        LOG.assertTrue(this.isWebPathValid(), (Object)("web path is invalid for " + this));
        String remainder = this.getPathRemainderForDeploy(remotePathPath, mappable);
        return DeploymentPathUtils.join(this.myWebPath, remainder);
    }

    public WebServerConfig.RemotePath mapToDeployPath(FileObject local, Mappable mappable) {
        return this.mapToDeployPath(DeploymentPathUtils.getLocalPath(local), mappable);
    }

    public WebServerConfig.RemotePath mapToDeployPath(String localPath, Mappable mappable) {
        boolean isProtocolBased = mappable.getAccessType().isProtocolBased();
        LOG.assertTrue(this.isDeployPathValid(isProtocolBased), (Object)("deploy path is invalid for " + this));
        String remainder = StringUtil.notNullize((String)this.getPathRemainderForLocal(localPath));
        String fullDeployPath = mappable.getFullPath(this.myDeployPath);
        if (isProtocolBased) {
            return new WebServerConfig.RemotePath(DeploymentPathUtils.join(fullDeployPath, remainder));
        }
        String fullPath = DeploymentPathUtils.join(fullDeployPath, remainder);
        return new WebServerConfig.RemotePath(FileUtil.toSystemDependentName((String)fullPath));
    }

    public WebServerConfig.RemotePath getFullDeployPath(Mappable mappable) {
        boolean isProtocolBased = mappable.getAccessType().isProtocolBased();
        String fullPath = mappable.getFullPath(this.myDeployPath);
        if (isProtocolBased) {
            return new WebServerConfig.RemotePath(fullPath);
        }
        return new WebServerConfig.RemotePath(FileUtil.toSystemDependentName((String)fullPath));
    }

    public String mapToLocalPath(FileObject deploy, Mappable mappable) {
        return this.mapToLocalPath(deploy.getName(), mappable);
    }

    public FileObject mapToLocalFile(FileObject deploy, Mappable mappable) throws FileSystemException {
        return DeploymentPathUtils.getLocalFile(this.mapToLocalPath(deploy, mappable));
    }

    public String mapToLocalPath(FileName deployedFileName, Mappable mappable) {
        LOG.assertTrue(this.isLocalPathValid(), (Object)("local path is invalid for " + this));
        String remainder = this.getPathRemainderForDeploy(deployedFileName, mappable);
        if (remainder == null) {
            LOG.error("Empty remainder. Filename " + mappable.getPresentablePath(deployedFileName) + ", deploy path " + this.myDeployPath + ", server type " + mappable.getAccessType());
        }
        return DeploymentPathUtils.join(this.myLocalPath, remainder);
    }

    public String mapToLocalPath(WebServerConfig.RemotePath remotePath, Mappable mappable) {
        LOG.assertTrue(this.isLocalPathValid(), (Object)("local path is invalid for " + this));
        String remainder = this.getPathRemainderForDeploy(remotePath, mappable);
        return DeploymentPathUtils.join(this.myLocalPath, remainder);
    }

    public boolean isLocalPathValid() {
        return StringUtil.isNotEmpty((String)this.getLocalPath());
    }

    public boolean isWebPathValid() {
        return StringUtil.isNotEmpty((String)this.getWebPath());
    }

    public boolean isDeployPathValid(boolean isProtocolBased) {
        return DeploymentPathMapping.validateDeployPath(this.getDeployPath(), isProtocolBased) == null;
    }

    public boolean isEffectivelyEmpty(Project project) {
        String basePath;
        if (!StringUtil.isEmptyOrSpaces((String)this.getDeployPath())) {
            return false;
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.getWebPath()) && !"/".equals(this.getWebPath())) {
            return false;
        }
        return project == null || (basePath = project.getBasePath()) == null || basePath.equals(this.getLocalPath());
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateDeployPath(String path, boolean isProtocolBased) {
        if (StringUtil.isEmpty((String)path)) {
            return WDBundle.message("deploy.path.is.empty", "");
        }
        if (!isProtocolBased && SystemInfo.isWindows) {
            if (path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                return WDBundle.message("deploy.path.is.not.relative", path);
            }
            if (path.startsWith("\\\\")) {
                return WDBundle.message("unc.path.not.supported", path);
            }
        }
        return null;
    }

    public boolean isParentByDeployPath(DeploymentPathMapping mapping, boolean caseSensitive) {
        return DeploymentPathUtils.getPathRemainder(this.getDeployPath(), mapping.getDeployPath(), caseSensitive) != null;
    }

    @Nullable
    public String getPathRemainderForWeb(String childWebPath) {
        if (StringUtil.isEmpty((String)childWebPath)) {
            return null;
        }
        return DeploymentPathUtils.getPathRemainder(this.myWebPath, childWebPath, false);
    }

    public boolean isParentForWebPath(String webPath, boolean strict) {
        if (!this.isWebPathValid()) {
            return false;
        }
        String remainder = this.getPathRemainderForWeb(webPath);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isParentByWebPath(DeploymentPathMapping mapping) {
        return DeploymentPathUtils.getPathRemainder(this.getWebPath(), mapping.getWebPath(), false) != null;
    }

    public String mapWebToLocalPath(String webPath) {
        LOG.assertTrue(this.isLocalPathValid(), (Object)("local path is invalid for " + this));
        String remainder = this.getPathRemainderForWeb(webPath);
        return FileUtil.toSystemDependentName((String)DeploymentPathUtils.join(this.myLocalPath, remainder));
    }

    static String ensureRelative(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }
}

