/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="advancedOptions")
public class AdvancedOptionsConfig
implements Cloneable {
    public static final int UNBOUNDED = Integer.MAX_VALUE;
    public static final int DEFAULT_KEEP_ALIVE_TIMEOUT = 300000;
    @NonNls
    private static final String FILENAMES_ENCODING_PROPERTY = "com.jetbrains.plugins.webDeployment.filenames_encoding";
    @NonNls
    private static final String DISABLING_TLS_13_PROTOCOLS = "TLSv1,TLSv1.1,TLSv1.2";
    private boolean myShowHiddenFiles;
    private boolean myPassiveMode;
    private int myMaxConnections = Integer.MAX_VALUE;
    private AccurateTimestamps myAccurateTimestamps = AccurateTimestamps.ON_COPY;
    private boolean myCompatibilityMode = false;
    private DataChannelProtectionLevel myDataChannelProtectionLevel = DataChannelProtectionLevel.Default;
    private String myControlEncoding = System.getProperty("com.jetbrains.plugins.webDeployment.filenames_encoding", Charset.defaultCharset().name());
    private boolean myMuteSftpMessages = false;
    private boolean myForceListCommand = false;
    private int myKeepAliveTimeout = 300000;
    private JBFtpKeepAliveCommand myKeepAliveFtpCommand = JBFtpKeepAliveCommand.NOOP;
    private boolean myShareSslContext = false;
    private String myEnabledFtpsProtocols;

    @Attribute(value="showHiddenFiles")
    public boolean isShowHiddenFiles() {
        return this.myShowHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.myShowHiddenFiles = showHiddenFiles;
    }

    @Attribute(value="passiveMode")
    public boolean isPassiveMode() {
        return this.myPassiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.myPassiveMode = passiveMode;
    }

    @Attribute(value="maxConnections")
    public int getMaxConnections() {
        return this.myMaxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.myMaxConnections = maxConnections;
    }

    @Attribute(value="accurateTimestamps")
    public String getSerializedAccurateTimestamps() {
        return this.myAccurateTimestamps.name();
    }

    public void setSerializedAccurateTimestamps(String value) {
        try {
            this.myAccurateTimestamps = AccurateTimestamps.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            this.myAccurateTimestamps = AccurateTimestamps.ON_COPY;
        }
    }

    @Transient
    public AccurateTimestamps getAccurateTimestamps() {
        return this.myAccurateTimestamps;
    }

    public void setAccurateTimestamps(AccurateTimestamps value) {
        this.myAccurateTimestamps = value;
    }

    @Attribute(value="compatibilityMode")
    public boolean isCompatibilityMode() {
        return this.myCompatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.myCompatibilityMode = compatibilityMode;
    }

    @Attribute(value="dataProtectionLevel")
    public DataChannelProtectionLevel getDataChannelProtectionLevel() {
        return this.myDataChannelProtectionLevel;
    }

    public void setDataChannelProtectionLevel(DataChannelProtectionLevel dataChannelProtectionLevel) {
        this.myDataChannelProtectionLevel = dataChannelProtectionLevel;
    }

    @Attribute(value="controlEncoding")
    public String getControlEncoding() {
        return this.myControlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.myControlEncoding = controlEncoding;
    }

    @Attribute(value="muteSftpMessages")
    public boolean isMuteSftpMessages() {
        return this.myMuteSftpMessages;
    }

    public void setMuteSftpMessages(boolean muteSftpMessages) {
        this.myMuteSftpMessages = muteSftpMessages;
    }

    @Attribute(value="forceListCommand")
    public boolean isForceListCommand() {
        return this.myForceListCommand;
    }

    public void setForceListCommand(boolean forceListCommand) {
        this.myForceListCommand = forceListCommand;
    }

    @Attribute(value="keepAliveTimeout")
    public int getKeepAliveTimeout() {
        return this.myKeepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.myKeepAliveTimeout = keepAliveTimeout;
    }

    @Attribute(value="keepAliveCommand")
    public JBFtpKeepAliveCommand getKeepAliveFtpCommand() {
        return this.myKeepAliveFtpCommand;
    }

    public void setKeepAliveFtpCommand(JBFtpKeepAliveCommand keepAliveFtpCommand) {
        this.myKeepAliveFtpCommand = keepAliveFtpCommand;
    }

    @Attribute(value="shareSSLContext")
    public boolean isShareSslContext() {
        return this.myShareSslContext;
    }

    public void setShareSslContext(boolean shareSslContext) {
        this.myShareSslContext = shareSslContext;
    }

    @Attribute(value="enabledFtpsProtocols")
    public String getEnabledFtpsProtocols() {
        return this.myEnabledFtpsProtocols;
    }

    public void setEnabledFtpsProtocols(String enabledFtpsProtocols) {
        this.myEnabledFtpsProtocols = enabledFtpsProtocols;
    }

    public boolean isFtpsDisabledTls13() {
        return !StringUtil.isEmptyOrSpaces((String)this.myEnabledFtpsProtocols);
    }

    public void setFtpsDisabledTls13(boolean disabled) {
        this.myEnabledFtpsProtocols = disabled ? DISABLING_TLS_13_PROTOCOLS : null;
    }

    public AdvancedOptionsConfig clone() {
        try {
            return (AdvancedOptionsConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancedOptionsConfig that = (AdvancedOptionsConfig)o;
        if (this.myMaxConnections != that.myMaxConnections) {
            return false;
        }
        if (this.myPassiveMode != that.myPassiveMode) {
            return false;
        }
        if (this.myShowHiddenFiles != that.myShowHiddenFiles) {
            return false;
        }
        if (this.myAccurateTimestamps != that.myAccurateTimestamps) {
            return false;
        }
        if (this.myCompatibilityMode != that.myCompatibilityMode) {
            return false;
        }
        if (this.myDataChannelProtectionLevel != that.myDataChannelProtectionLevel) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myControlEncoding, (CharSequence)that.myControlEncoding)) {
            return false;
        }
        if (this.myMuteSftpMessages != that.myMuteSftpMessages) {
            return false;
        }
        if (this.myForceListCommand != that.myForceListCommand) {
            return false;
        }
        if (this.myKeepAliveTimeout != that.myKeepAliveTimeout) {
            return false;
        }
        if (this.myKeepAliveFtpCommand != that.myKeepAliveFtpCommand) {
            return false;
        }
        if (this.myShareSslContext != that.myShareSslContext) {
            return false;
        }
        return Objects.equals(this.myEnabledFtpsProtocols, that.myEnabledFtpsProtocols);
    }

    public int hashCode() {
        int result = this.myShowHiddenFiles ? 1 : 0;
        result = 31 * result + (this.myPassiveMode ? 1 : 0);
        result = 31 * result + (this.myCompatibilityMode ? 1 : 0);
        result = 31 * result + this.myAccurateTimestamps.hashCode();
        result = 31 * result + this.myMaxConnections;
        result = 31 * result + this.myDataChannelProtectionLevel.hashCode();
        result = 31 * result + (this.myControlEncoding != null ? this.myControlEncoding.hashCode() : 0);
        result = 31 * result + (this.myMuteSftpMessages ? 1 : 0);
        result = 31 * result + (this.myForceListCommand ? 1 : 0);
        result = 31 * result + this.myKeepAliveTimeout;
        result = 31 * result + this.myKeepAliveFtpCommand.hashCode();
        result = 31 * result + (this.myShareSslContext ? 1 : 0);
        result = 31 * result + (this.myEnabledFtpsProtocols != null ? this.myEnabledFtpsProtocols.hashCode() : 0);
        return result;
    }

    public static enum DataChannelProtectionLevel {
        Default{

            @Override
            public FtpsDataChannelProtectionLevel getValue() {
                return null;
            }

            @Override
            @NotNull
            public String getPresentableValue() {
                String string = WDBundle.message("ftps.data.channel.protection.level.default.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$DataChannelProtectionLevel$1", "getPresentableValue"));
            }
        }
        ,
        Clear{

            @Override
            public FtpsDataChannelProtectionLevel getValue() {
                return FtpsDataChannelProtectionLevel.C;
            }

            @Override
            @NotNull
            public String getPresentableValue() {
                String string = WDBundle.message("ftps.data.channel.protection.level.c.title", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$DataChannelProtectionLevel$2", "getPresentableValue"));
            }
        }
        ,
        Private{

            @Override
            public FtpsDataChannelProtectionLevel getValue() {
                return FtpsDataChannelProtectionLevel.P;
            }

            @Override
            @NotNull
            public String getPresentableValue() {
                String string = WDBundle.message("ftps.data.channel.protection.level.p.title", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$DataChannelProtectionLevel$3", "getPresentableValue"));
            }
        };


        @Nullable
        public abstract FtpsDataChannelProtectionLevel getValue();

        @NotNull
        public abstract String getPresentableValue();
    }

    public static enum AccurateTimestamps {
        NEVER(WDBundle.message("accurate.timestamps.option.NEVER", new Object[0])),
        ON_COPY(WDBundle.message("accurate.timestamps.option.ON_COPY", new Object[0])),
        ALWAYS(WDBundle.message("accurate.timestamps.option.ALWAYS", new Object[0]));

        @NotNull
        private final String myPresentableName;

        private AccurateTimestamps(String name) {
            if (name == null) {
                AccurateTimestamps.$$$reportNull$$$0(0);
            }
            this.myPresentableName = name;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                AccurateTimestamps.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$AccurateTimestamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$AccurateTimestamps";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

