/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class CidrDebuggerTypesHelper
implements CidrDebuggerTypesHelperBase {
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("Swift\\.(ImplicitlyUnwrapped)?Optional<(.*?)>");
    protected CidrDebugProcess myProcess;

    public CidrDebuggerTypesHelper(CidrDebugProcess process) {
        this.myProcess = process;
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project) {
        if (project == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(0);
        }
        if (sourcePosition == null) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document2 == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
        if (psiFile == null) {
            return null;
        }
        return CidrDebuggerTypesHelper.findContextElement(sourcePosition, document2, psiFile);
    }

    @Nullable
    private static PsiElement findContextElement(XSourcePosition sourcePosition, Document document2, PsiFile psiFile) {
        PsiElement element;
        int positionOffset = sourcePosition.getOffset();
        if (!DocumentUtil.isValidOffset((int)positionOffset, (Document)document2)) {
            return null;
        }
        int lineEndOffset = document2.getLineEndOffset(document2.getLineNumber(positionOffset));
        int offset = positionOffset;
        while ((element = psiFile.findElementAt(offset)) != null) {
            if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                return element;
            }
            offset = element.getTextRange().getEndOffset() + 1;
            if (offset < lineEndOffset) continue;
        }
        return psiFile.findElementAt(positionOffset);
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeSourcePositionAsync(@NotNull XSourcePosition position, @NotNull LLValue var, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(1);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(3);
        }
        CompletableFuture<XSourcePosition> completableFuture = CompletableFuture.supplyAsync(() -> (XSourcePosition)ReadAction.nonBlocking(() -> this.computeSourcePosition(position, var)).wrapProgress(indicator).executeSynchronously());
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @Nullable
    public XSourcePosition computeSourcePosition(XSourcePosition position, LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(resolved.getContainingFile().getVirtualFile(), resolved.getTextOffset());
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeSourcePositionAsync(@NotNull CidrMemberValue value, @NotNull ProgressIndicator indicator) {
        if (value == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(6);
        }
        CompletableFuture<XSourcePosition> completableFuture = CompletableFuture.supplyAsync(() -> (XSourcePosition)ReadAction.nonBlocking(() -> this.computeSourcePosition(value)).wrapProgress(indicator).executeSynchronously());
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Nullable
    public abstract XSourcePosition computeSourcePosition(@NotNull CidrMemberValue var1);

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeNearestUsageSourcePositionAsync(@NotNull XSourcePosition position, @NotNull LLValue var, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(8);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(10);
        }
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)ReadAction.nonBlocking(() -> this.computeNearestUsageSourcePosition(position, var)).wrapProgress(indicator).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @Nullable
    private XSourcePosition computeNearestUsageSourcePosition(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement resolved;
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(12);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(13);
        }
        if ((resolved = this.resolveToDeclaration(position, var)) == null) {
            return null;
        }
        PsiFile file = resolved.getContainingFile();
        if (file == null) {
            return null;
        }
        int positionLine = position.getLine();
        int bestLine = -1;
        XSourcePositionImpl bestPos = null;
        Collection usages = IdentifierHighlighterPass.getUsages((PsiElement)resolved, (PsiElement)file, (boolean)false);
        for (TextRange usage : usages) {
            int currLine;
            XSourcePositionImpl currPos = XSourcePositionImpl.createByOffset((VirtualFile)file.getVirtualFile(), (int)usage.getStartOffset());
            if (currPos == null || bestLine >= (currLine = currPos.getLine()) || currLine > positionLine) continue;
            bestLine = currLine;
            bestPos = currPos;
        }
        return bestPos;
    }

    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition position) {
        return CidrDebuggerTypesHelper.getContextElement(position, this.myProcess.getProject());
    }

    @Override
    @Nullable
    public abstract XSourcePosition resolveProperty(@NotNull CidrMemberValue var1, @Nullable String var2);

    @Override
    @NotNull
    public CompletableFuture<List<LLValue>> filterLocalVariables(@Nullable XSourcePosition position, @NotNull List<LLValue> vars, @NotNull Expirable expirable) {
        if (vars == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(14);
        }
        if (expirable == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(15);
        }
        CompletableFuture<List<LLValue>> completableFuture = CompletableFuture.completedFuture(ContainerUtil.filter(vars, value -> {
            if (position == null) {
                value.setValid(false);
                return true;
            }
            boolean[] resolved = new boolean[1];
            boolean[] special = new boolean[]{false};
            Computable calcVariableLineRunnable = () -> {
                DumbService dumbService = DumbService.getInstance((Project)this.myProcess.getProject());
                if (dumbService.isDumb()) {
                    special[0] = true;
                    dumbService.runWhenSmart(() -> {
                        if (!expirable.isExpired()) {
                            this.myProcess.getSession().rebuildViews();
                        }
                    });
                    return null;
                }
                PsiElement declarator = this.resolveToDeclaration(position, (LLValue)((Object)value));
                boolean bl = resolved[0] = declarator != null;
                if (declarator == null) {
                    Boolean thisSelfSupper = this.isImplicitContextVariable(position, (LLValue)((Object)value));
                    special[0] = thisSelfSupper != null ? thisSelfSupper : false;
                    return null;
                }
                PsiFile targetFile = declarator.getContainingFile();
                if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)position.getFile())) {
                    return null;
                }
                int endOffset = declarator.getTextRange().getEndOffset();
                Document document2 = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
                if (document2 == null) {
                    return null;
                }
                return document2.getLineNumber(endOffset);
            };
            CidrDebuggerUtil.ReadActionResult variableLine = CidrDebuggerUtil.runInReadActionWithRetries(calcVariableLineRunnable, () -> this.myProcess.getProject().isDisposed() || expirable.isExpired());
            value.setValid(special[0] || resolved[0] && variableLine.value != null && (Integer)variableLine.value < position.getLine());
            return !CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED || resolved[0] || special[0];
        }));
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue var) {
        PsiElement context2;
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(17);
        }
        if ((context2 = this.getContextElement(position)) == null) {
            return null;
        }
        PsiReference ref = this.createReferenceFromText(var, context2);
        if (ref == null) {
            return null;
        }
        try {
            PsiElement resolved = ref.resolve();
            if (resolved == null) {
                return null;
            }
            if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
                return null;
            }
            return resolved;
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    @Nullable
    protected abstract PsiReference createReferenceFromText(@NotNull LLValue var1, @NotNull PsiElement var2);

    @Nullable
    public abstract Boolean isImplicitContextVariable(@NotNull XSourcePosition var1, @NotNull LLValue var2);

    @Nullable
    public static String unwrapSwiftOptionalType(@NotNull String typeName) {
        Matcher m;
        if (typeName == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(18);
        }
        return (m = OPTIONAL_PATTERN.matcher(typeName)).matches() ? m.group(2) : null;
    }

    @NotNull
    public static String unwrapSwiftOptionalTypeIfNecessary(@NotNull String typeName) {
        if (typeName == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(19);
        }
        String string = StringUtil.notNullize((String)CidrDebuggerTypesHelper.unwrapSwiftOptionalType(typeName), (String)typeName);
        if (string == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirable";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSourcePositionAsync";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeNearestUsageSourcePositionAsync";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLocalVariables";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSwiftOptionalTypeIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePositionAsync";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeNearestUsageSourcePositionAsync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeNearestUsageSourcePosition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterLocalVariables";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveToDeclaration";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSwiftOptionalType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSwiftOptionalTypeIfNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

