/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.uml.core.actions.ChangeCreationEdgeMode;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.core.actions.MoveSelectionWrapper;
import com.intellij.uml.core.actions.UmlAddNodeAction;
import com.intellij.uml.core.actions.UmlCategorySwitcher;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.core.actions.scopes.UmlScopesActionGroup;
import com.intellij.uml.core.actions.visibility.UmlVisibilityActionGroup;
import com.intellij.uml.utils.DiagramBundle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UmlActions {
    @NotNull
    @NonNls
    private static final String FOCUS_TOP_NODE = "FOCUS_TOP_NODE";
    @NotNull
    @NonNls
    private static final String FOCUS_BOTTOM_NODE = "FOCUS_BOTTOM_NODE";
    @NotNull
    @NonNls
    private static final String FOCUS_LEFT_NODE = "FOCUS_LEFT_NODE";
    @NotNull
    @NonNls
    private static final String FOCUS_RIGHT_NODE = "FOCUS_RIGHT_NODE";
    @NotNull
    @NonNls
    private static final String DELETE_SELECTION = "DELETE_SELECTION";
    @NotNull
    @NonNls
    private static final String EDIT_NODE = "EDIT_NODE";
    @NotNull
    @NonNls
    private static final String ADD_NODE = "ADD_NODE";
    @NotNull
    private static final Map<String, MoveSelectionWrapper.Keys> MOVE_KEYS = new HashMap<String, MoveSelectionWrapper.Keys>();

    private UmlActions() {
    }

    public static void install(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        UmlActions.setupKeyBindingsForCommonActions(builder);
    }

    private static void setupKeyBindingsForCommonActions(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(1);
        }
        Graph2DView view = builder.getView();
        ActionMap actionMap = view.getCanvasComponent().getActionMap();
        InputMap inputMap = view.getCanvasComponent().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(113, 0, false), EDIT_NODE);
        UmlActions.setMoveActions(actionMap, builder, FOCUS_TOP_NODE, FOCUS_BOTTOM_NODE, FOCUS_LEFT_NODE, FOCUS_RIGHT_NODE);
        UmlActions.wrapDeleteAction(actionMap, builder);
        DiagramAddElementAction gotoAction = builder.getProvider().getExtras().getAddElementHandler();
        if (gotoAction != null) {
            UmlAddNodeAction addNodeAction = new UmlAddNodeAction(gotoAction, builder);
            actionMap.put(ADD_NODE, addNodeAction);
            inputMap.put(KeyStroke.getKeyStroke(32, 0, false), ADD_NODE);
        }
    }

    private static void setMoveActions(@NotNull ActionMap aMap, @NotNull DiagramBuilder builder, String ... actions) {
        if (aMap == null) {
            UmlActions.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(3);
        }
        if (actions == null) {
            UmlActions.$$$reportNull$$$0(4);
        }
        for (String actionName : actions) {
            Action action = aMap.get(actionName);
            if (!(action instanceof AbstractAction)) continue;
            aMap.put(actionName, new MoveSelectionWrapper(MOVE_KEYS.get(actionName), builder));
        }
    }

    private static void wrapDeleteAction(@NotNull ActionMap aMap, @NotNull DiagramBuilder builder) {
        if (aMap == null) {
            UmlActions.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(6);
        }
        aMap.put(DELETE_SELECTION, new DeleteSelectionWrapper((AbstractAction)aMap.get(DELETE_SELECTION), builder));
    }

    @NotNull
    public static DefaultActionGroup createToolbarActions(@NotNull DiagramBuilder builder) {
        DiagramScopeManager<?> scopeManager;
        UmlVisibilityActionGroup visibilityActionGroup;
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(7);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        DiagramProvider<?> provider = builder.getProvider();
        if (builder.getPresentationModel().allowChangeVisibleCategories()) {
            DiagramCategory[] categories;
            for (DiagramCategory category : categories = provider.getAllContentCategories()) {
                group.add((AnAction)new UmlCategorySwitcher(category, builder));
            }
        }
        if ((visibilityActionGroup = new UmlVisibilityActionGroup(builder)).getChildrenCount() > 0) {
            group.add((AnAction)visibilityActionGroup);
        }
        if ((scopeManager = builder.getDataModel().getScopeManager()) != null) {
            group.add((AnAction)new UmlScopesActionGroup(builder, scopeManager));
        }
        if (provider.getEdgeCreationPolicy() != null) {
            group.add((AnAction)new ChangeCreationEdgeMode());
        }
        group.addSeparator();
        if (builder.getDataModel().isDependencyDiagramSupported()) {
            group.add((AnAction)new UmlShowDependencies());
            group.add((AnAction)new Separator());
        }
        group.add((AnAction)UmlActions.getCommonToolbarActions());
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            UmlActions.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    @NotNull
    public static DefaultActionGroup getCommonToolbarActions() {
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("Diagram.DefaultGraphToolbar");
        if (defaultActionGroup == null) {
            UmlActions.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @NotNull
    public static DefaultActionGroup getCategoriesActions(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(10);
        }
        DiagramCategory[] categories = builder.getProvider().getAllContentCategories();
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup(DiagramBundle.messagePointer("show.categories.title", new Object[0]));
        for (DiagramCategory category : categories) {
            group.add((AnAction)new UmlCategorySwitcher(category, builder));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            UmlActions.$$$reportNull$$$0(11);
        }
        return defaultActionGroup;
    }

    public static void registerCustomShortcuts(@NotNull DiagramBuilder builder) {
        String[] actions;
        if (builder == null) {
            UmlActions.$$$reportNull$$$0(12);
        }
        JComponent canvas = builder.getView().getCanvasComponent();
        ActionManager actionManager = ActionManager.getInstance();
        for (String action : actions = new String[]{"Uml.CollapseNodes", "Uml.ExpandNodes", "Uml.NodeIntentions", "UML.ShowStructure", "UML.Find", "Uml.NewElement"}) {
            actionManager.getAction(action).registerCustomShortcutSet(canvas, (Disposable)builder);
        }
    }

    static {
        MOVE_KEYS.put(FOCUS_TOP_NODE, MoveSelectionWrapper.Keys.UP);
        MOVE_KEYS.put(FOCUS_BOTTOM_NODE, MoveSelectionWrapper.Keys.DOWN);
        MOVE_KEYS.put(FOCUS_LEFT_NODE, MoveSelectionWrapper.Keys.LEFT);
        MOVE_KEYS.put(FOCUS_RIGHT_NODE, MoveSelectionWrapper.Keys.RIGHT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonToolbarActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoriesActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupKeyBindingsForCommonActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMoveActions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapDeleteAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarActions";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCategoriesActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomShortcuts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

