/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramScopeManager<T> {
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile NamedScope myCurrentScope;

    public DiagramScopeManager(@NotNull Project project) {
        if (project == null) {
            DiagramScopeManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCurrentScope = this.fromScopeId(DiagramConfiguration.getInstance().defaultScope);
        if (this.myCurrentScope == null) {
            this.myCurrentScope = this.fromScopeId("All");
        }
    }

    public NamedScope @NotNull [] getScopes() {
        List allCustomScopes = CustomScopesAggregator.getAllCustomScopes((Project)this.myProject);
        allCustomScopes.addAll(Arrays.asList(NamedScopeManager.getInstance((Project)this.myProject).getEditableScopes()));
        NamedScope[] namedScopeArray = allCustomScopes.toArray(NamedScope.EMPTY_ARRAY);
        if (namedScopeArray == null) {
            DiagramScopeManager.$$$reportNull$$$0(1);
        }
        return namedScopeArray;
    }

    public abstract boolean contains(T var1);

    @Nullable
    public NamedScope getCurrentScope() {
        return this.myCurrentScope;
    }

    public void setCurrentScope(@Nullable NamedScope currentScope) {
        this.myCurrentScope = currentScope;
    }

    @Nullable
    public NamedScope fromScopeId(@NotNull String scopeId) {
        if (scopeId == null) {
            DiagramScopeManager.$$$reportNull$$$0(2);
        }
        for (NamedScope scope : this.getScopes()) {
            if (!scope.getScopeId().equals(scopeId)) continue;
            return scope;
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DiagramScopeManager.$$$reportNull$$$0(3);
        }
        return project;
    }

    public void setCurrentScope(@Nullable String scopeId) {
        for (NamedScope scope : this.getScopes()) {
            if (!scope.getScopeId().equals(scopeId)) continue;
            this.myCurrentScope = scope;
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramScopeManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramScopeManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromScopeId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

